/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.NamedMember;
import org.eclipse.jdt.internal.core.ResolvedSourceField;
import org.eclipse.jdt.internal.core.SourceFieldElementInfo;

public class SourceField
extends NamedMember
implements IField {
    protected SourceField(JavaElement parent, String name) {
        super(parent, name);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof SourceField)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public ASTNode findNode(org.eclipse.jdt.core.dom.CompilationUnit ast) {
        ASTNode node = super.findNode(ast);
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 72) {
            return node;
        }
        return node.getParent();
    }

    @Override
    public Object getConstant() throws JavaModelException {
        Object constant = null;
        SourceFieldElementInfo info = (SourceFieldElementInfo)this.getElementInfo();
        char[] constantSourceChars = info.initializationSource;
        if (constantSourceChars == null) {
            return null;
        }
        String constantSource = new String(constantSourceChars);
        String signature = info.getTypeSignature();
        try {
            if (signature.equals("I")) {
                constant = Integer.valueOf(constantSource);
            } else if (signature.equals("S")) {
                constant = Short.valueOf(constantSource);
            } else if (signature.equals("B")) {
                constant = Byte.valueOf(constantSource);
            } else if (signature.equals("Z")) {
                constant = Boolean.valueOf(constantSource);
            } else if (signature.equals("C")) {
                if (constantSourceChars.length != 3) {
                    return null;
                }
                constant = Character.valueOf(constantSourceChars[1]);
            } else if (signature.equals("D")) {
                constant = Double.valueOf(constantSource);
            } else if (signature.equals("F")) {
                constant = Float.valueOf(constantSource);
            } else if (signature.equals("J")) {
                int index;
                constant = constantSource.endsWith("L") || constantSource.endsWith("l") ? ((index = constantSource.lastIndexOf("L")) != -1 ? Long.valueOf(constantSource.substring(0, index)) : Long.valueOf(constantSource.substring(0, constantSource.lastIndexOf("l")))) : Long.valueOf(constantSource);
            } else if (signature.equals("QString;")) {
                constant = constantSource;
            } else if (signature.equals("Qjava.lang.String;")) {
                constant = constantSource;
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return constant;
    }

    @Override
    public int getElementType() {
        return 8;
    }

    @Override
    public String getKey() {
        try {
            return this.getKey(this, false);
        }
        catch (JavaModelException e) {
            return null;
        }
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '^';
    }

    @Override
    public JavaElement getPrimaryElement(boolean checkOwner) {
        CompilationUnit cu;
        if (checkOwner && (cu = (CompilationUnit)this.getAncestor(5)).isPrimary()) {
            return this;
        }
        JavaElement primaryParent = this.getParent().getPrimaryElement(false);
        return (JavaElement)((Object)((IType)((Object)primaryParent)).getField(this.name));
    }

    @Override
    public String getTypeSignature() throws JavaModelException {
        SourceFieldElementInfo info = (SourceFieldElementInfo)this.getElementInfo();
        return info.getTypeSignature();
    }

    @Override
    public boolean isEnumConstant() throws JavaModelException {
        return Flags.isEnum(this.getFlags());
    }

    @Override
    public boolean isResolved() {
        return false;
    }

    @Override
    public JavaElement resolved(Binding binding) {
        ResolvedSourceField resolvedHandle = new ResolvedSourceField(this.getParent(), this.name, new String(binding.computeUniqueKey()));
        resolvedHandle.occurrenceCount = this.occurrenceCount;
        return resolvedHandle;
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            this.toStringName(buffer);
            buffer.append(" (not open)");
        } else if (info == NO_INFO) {
            this.toStringName(buffer);
        } else {
            try {
                buffer.append(Signature.toString(this.getTypeSignature()));
                buffer.append(" ");
                this.toStringName(buffer);
            }
            catch (JavaModelException e) {
                buffer.append("<JavaModelException in toString of " + this.getElementName());
            }
        }
    }

    @Override
    public boolean isRecordComponent() throws JavaModelException {
        SourceFieldElementInfo info = (SourceFieldElementInfo)this.getElementInfo();
        return info.isRecordComponent;
    }
}

