/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObjectToInt;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.AbstractModule;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.IJavaElementRequestor;
import org.eclipse.jdt.internal.core.JavaElementRequestor;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.JavaProjectElementInfo;
import org.eclipse.jdt.internal.core.JrtPackageFragmentRoot;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SingleTypeRequestor;
import org.eclipse.jdt.internal.core.SourceModule;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.util.HashtableOfArrayToObject;
import org.eclipse.jdt.internal.core.util.Messages;
import org.eclipse.jdt.internal.core.util.Util;

public class NameLookup
implements SuffixConstants {
    private static IModuleDescription NO_MODULE = new SourceModule(null, "Not a module"){};
    public static final int ACCEPT_CLASSES = 2;
    public static final int ACCEPT_INTERFACES = 4;
    public static final int ACCEPT_ENUMS = 8;
    public static final int ACCEPT_RECORDS = 0x1000000;
    public static final int ACCEPT_ANNOTATIONS = 16;
    public static final int ACCEPT_ALL = 0x100001E;
    public static boolean VERBOSE = false;
    private static final IType[] NO_TYPES = new IType[0];
    protected IPackageFragmentRoot[] packageFragmentRoots;
    protected HashtableOfArrayToObject packageFragments;
    protected Map<IPackageFragmentRoot, IClasspathEntry> rootToResolvedEntries;
    protected Map<IPackageFragmentRoot, IModuleDescription> rootToModule;
    protected HashMap typesInWorkingCopies;
    public long timeSpentInSeekTypesInSourcePackage = 0L;
    public long timeSpentInSeekTypesInBinaryPackage = 0L;
    public long timeSpentInSeekPackageFragmentsWithModuleContext;
    public long timeSpentInSeekModuleAwarePartialPackageFragments;
    public long timeSpentInSeekPackageFragments;
    public long timeSpentInSeekModule;
    public long timeSpentInIsPackageWithModuleContext;
    public long timeSpentInSeekTypesInType;
    private JavaProject rootProject;

    public NameLookup(JavaProject rootProject, IPackageFragmentRoot[] packageFragmentRoots, HashtableOfArrayToObject packageFragments, ICompilationUnit[] workingCopies, Map rootToResolvedEntries) {
        this.rootProject = rootProject;
        long start = -1L;
        if (VERBOSE) {
            Util.verbose(" BUILDING NameLoopkup");
            Util.verbose(" -> pkg roots size: " + (packageFragmentRoots == null ? 0 : packageFragmentRoots.length));
            Util.verbose(" -> pkgs size: " + (packageFragments == null ? 0 : packageFragments.size()));
            Util.verbose(" -> working copy size: " + (workingCopies == null ? 0 : workingCopies.length));
            start = System.currentTimeMillis();
        }
        this.rootToModule = new HashMap<IPackageFragmentRoot, IModuleDescription>();
        this.packageFragmentRoots = packageFragmentRoots;
        if (workingCopies == null) {
            this.packageFragments = packageFragments;
        } else {
            try {
                this.packageFragments = (HashtableOfArrayToObject)packageFragments.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            this.typesInWorkingCopies = new HashMap();
            HashtableOfObjectToInt rootPositions = new HashtableOfObjectToInt();
            int length = packageFragmentRoots.length;
            for (int i = 0; i < length; ++i) {
                rootPositions.put(packageFragmentRoots[i], i);
            }
            for (ICompilationUnit workingCopy : workingCopies) {
                Object[] pkgName;
                Object existing;
                PackageFragment pkg = (PackageFragment)workingCopy.getParent();
                IPackageFragmentRoot root = (IPackageFragmentRoot)((Object)pkg.getParent());
                int rootPosition = rootPositions.get(root);
                if (rootPosition == -1) continue;
                HashMap<String, Object> typeMap = (HashMap<String, Object>)this.typesInWorkingCopies.get(pkg);
                if (typeMap == null) {
                    typeMap = new HashMap<String, Object>();
                    this.typesInWorkingCopies.put(pkg, typeMap);
                }
                try {
                    IType[] types = workingCopy.getTypes();
                    int typeLength = types.length;
                    if (typeLength == 0) {
                        String typeName = Util.getNameWithoutJavaLikeExtension(workingCopy.getElementName());
                        typeMap.put(typeName, NO_TYPES);
                    } else {
                        for (int j = 0; j < typeLength; ++j) {
                            IType type = types[j];
                            String typeName = type.getElementName();
                            Object existing2 = typeMap.get(typeName);
                            if (existing2 == null) {
                                typeMap.put(typeName, type);
                                continue;
                            }
                            if (existing2 instanceof IType) {
                                typeMap.put(typeName, new IType[]{(IType)existing2, type});
                                continue;
                            }
                            IType[] existingTypes = (IType[])existing2;
                            int existingTypeLength = existingTypes.length;
                            IType[] iTypeArray = existingTypes;
                            existingTypes = new IType[existingTypeLength + 1];
                            System.arraycopy(iTypeArray, 0, existingTypes, 0, existingTypeLength);
                            existingTypes[existingTypeLength] = type;
                            typeMap.put(typeName, existingTypes);
                        }
                    }
                }
                catch (JavaModelException types) {
                    // empty catch block
                }
                if ((existing = this.packageFragments.get(pkgName = pkg.names)) == null || existing == JavaProjectElementInfo.NO_ROOTS) {
                    this.packageFragments.put(pkgName, root);
                    JavaProjectElementInfo.addSuperPackageNames((String[])pkgName, this.packageFragments);
                    continue;
                }
                if (existing instanceof PackageFragmentRoot) {
                    IPackageFragmentRoot[] iPackageFragmentRootArray;
                    int exisitingPosition = rootPositions.get(existing);
                    if (rootPosition == exisitingPosition) continue;
                    if (exisitingPosition < rootPosition) {
                        IPackageFragmentRoot[] iPackageFragmentRootArray2 = new IPackageFragmentRoot[2];
                        iPackageFragmentRootArray2[0] = (PackageFragmentRoot)existing;
                        iPackageFragmentRootArray = iPackageFragmentRootArray2;
                        iPackageFragmentRootArray2[1] = root;
                    } else {
                        IPackageFragmentRoot[] iPackageFragmentRootArray3 = new IPackageFragmentRoot[2];
                        iPackageFragmentRootArray3[0] = root;
                        iPackageFragmentRootArray = iPackageFragmentRootArray3;
                        iPackageFragmentRootArray3[1] = (PackageFragmentRoot)existing;
                    }
                    this.packageFragments.put(pkgName, iPackageFragmentRootArray);
                    continue;
                }
                IPackageFragmentRoot[] roots = (IPackageFragmentRoot[])existing;
                int rootLength = roots.length;
                int insertionIndex = 0;
                for (int j = 0; j < rootLength; ++j) {
                    int existingPosition = rootPositions.get(roots[j]);
                    if (rootPosition > existingPosition) {
                        insertionIndex = j;
                        continue;
                    }
                    if (rootPosition == existingPosition) {
                        insertionIndex = -1;
                        break;
                    }
                    if (rootPosition < existingPosition) break;
                }
                if (insertionIndex == -1) continue;
                IPackageFragmentRoot[] newRoots = new IPackageFragmentRoot[rootLength + 1];
                System.arraycopy(roots, 0, newRoots, 0, insertionIndex);
                newRoots[insertionIndex] = root;
                System.arraycopy(roots, insertionIndex, newRoots, insertionIndex + 1, rootLength - insertionIndex);
                this.packageFragments.put(pkgName, newRoots);
            }
        }
        this.rootToResolvedEntries = rootToResolvedEntries;
        if (VERBOSE) {
            Util.verbose(" -> spent: " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    protected boolean acceptType(IType type, int acceptFlags, boolean isSourceType) {
        if (acceptFlags == 0 || acceptFlags == 0x100001E) {
            return true;
        }
        try {
            int kind = isSourceType ? TypeDeclaration.kind(((SourceTypeElementInfo)((SourceType)type).getElementInfo()).getModifiers()) : TypeDeclaration.kind(((IBinaryType)((BinaryType)type).getElementInfo()).getModifiers());
            switch (kind) {
                case 1: {
                    return (acceptFlags & 0x1000002) != 0;
                }
                case 2: {
                    return (acceptFlags & 4) != 0;
                }
                case 3: {
                    return (acceptFlags & 8) != 0;
                }
                case 5: {
                    return (acceptFlags & 0x1000000) != 0;
                }
            }
            return (acceptFlags & 0x10) != 0;
        }
        catch (JavaModelException npe) {
            return false;
        }
    }

    private void findAllTypes(String prefix, boolean partialMatch, int acceptFlags, IJavaElementRequestor requestor) {
        int count = this.packageFragmentRoots.length;
        for (int i = 0; i < count; ++i) {
            if (requestor.isCanceled()) {
                return;
            }
            IPackageFragmentRoot root = this.packageFragmentRoots[i];
            IJavaElement[] packages = null;
            try {
                packages = root.getChildren();
            }
            catch (JavaModelException npe) {
                continue;
            }
            if (packages == null) continue;
            int packageCount = packages.length;
            for (int j = 0; j < packageCount; ++j) {
                if (requestor.isCanceled()) {
                    return;
                }
                this.seekTypes(prefix, (IPackageFragment)packages[j], partialMatch, acceptFlags, requestor);
            }
        }
    }

    public ICompilationUnit findCompilationUnit(String qualifiedTypeName) {
        int pkgIndex;
        Object[] pkgName = CharOperation.NO_STRINGS;
        String cuName = qualifiedTypeName;
        int index = qualifiedTypeName.lastIndexOf(46);
        if (index != -1) {
            pkgName = Util.splitOn('.', qualifiedTypeName, 0, index);
            cuName = qualifiedTypeName.substring(index + 1);
        }
        if ((index = cuName.indexOf(36)) != -1) {
            cuName = cuName.substring(0, index);
        }
        if ((pkgIndex = this.packageFragments.getIndex(pkgName)) != -1) {
            Object value = this.packageFragments.valueTable[pkgIndex];
            pkgName = (String[])this.packageFragments.keyTable[pkgIndex];
            if (value instanceof PackageFragmentRoot) {
                return this.findCompilationUnit((String[])pkgName, cuName, (PackageFragmentRoot)value);
            }
            IPackageFragmentRoot[] roots = (IPackageFragmentRoot[])value;
            for (int i = 0; i < roots.length; ++i) {
                PackageFragmentRoot root = (PackageFragmentRoot)roots[i];
                ICompilationUnit cu = this.findCompilationUnit((String[])pkgName, cuName, root);
                if (cu == null) continue;
                return cu;
            }
        }
        return null;
    }

    private ICompilationUnit findCompilationUnit(String[] pkgName, String cuName, PackageFragmentRoot root) {
        if (!root.isArchive()) {
            PackageFragment pkg = root.getPackageFragment(pkgName);
            try {
                for (ICompilationUnit cu : pkg.getCompilationUnits()) {
                    if (!Util.equalsIgnoreJavaLikeExtension(cu.getElementName(), cuName)) continue;
                    return cu;
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return null;
    }

    public IPackageFragment findPackageFragment(IPath path) {
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException(Messages.path_mustBeAbsolute);
        }
        IResource possibleFragment = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (possibleFragment == null) {
            for (int i = 0; i < this.packageFragmentRoots.length; ++i) {
                IPath rootPath;
                IPackageFragmentRoot root = this.packageFragmentRoots[i];
                if (!root.isExternal() || !(rootPath = root.getPath()).isPrefixOf(path)) continue;
                String name = path.toOSString();
                name = name.substring(rootPath.toOSString().length() + 1, name.length());
                name = name.replace(File.separatorChar, '.');
                IJavaElement[] list = null;
                try {
                    list = root.getChildren();
                }
                catch (JavaModelException npe) {
                    continue;
                }
                int elementCount = list.length;
                for (int j = 0; j < elementCount; ++j) {
                    IPackageFragment packageFragment = (IPackageFragment)list[j];
                    if (!this.nameMatches(name, packageFragment, false)) continue;
                    return packageFragment;
                }
            }
        } else {
            IJavaElement fromFactory = JavaCore.create(possibleFragment);
            if (fromFactory == null) {
                return null;
            }
            switch (fromFactory.getElementType()) {
                case 4: {
                    return (IPackageFragment)fromFactory;
                }
                case 2: {
                    JavaProject project = (JavaProject)fromFactory;
                    try {
                        IClasspathEntry entry = project.getClasspathEntryFor(path);
                        if (entry != null) {
                            IPackageFragmentRoot root = project.getPackageFragmentRoot(project.getResource());
                            Object defaultPkgRoot = this.packageFragments.get(CharOperation.NO_STRINGS);
                            if (defaultPkgRoot == null) {
                                return null;
                            }
                            if (defaultPkgRoot instanceof PackageFragmentRoot && defaultPkgRoot.equals(root)) {
                                return ((PackageFragmentRoot)root).getPackageFragment(CharOperation.NO_STRINGS);
                            }
                            IPackageFragmentRoot[] roots = (IPackageFragmentRoot[])defaultPkgRoot;
                            for (int i = 0; i < roots.length; ++i) {
                                if (!roots[i].equals(root)) continue;
                                return ((PackageFragmentRoot)root).getPackageFragment(CharOperation.NO_STRINGS);
                            }
                        }
                    }
                    catch (JavaModelException e) {
                        return null;
                    }
                    return null;
                }
                case 3: {
                    return ((PackageFragmentRoot)fromFactory).getPackageFragment(CharOperation.NO_STRINGS);
                }
            }
        }
        return null;
    }

    public IPackageFragment[] findPackageFragments(String name, boolean partialMatch) {
        return this.findPackageFragments(name, partialMatch, false);
    }

    public IPackageFragment[] findPackageFragments(String name, boolean partialMatch, boolean patternMatch) {
        boolean hasPatternChars;
        boolean isStarPattern = name.equals("*");
        boolean bl = hasPatternChars = isStarPattern || patternMatch && (name.indexOf(42) >= 0 || name.indexOf(63) >= 0);
        if (partialMatch || hasPatternChars) {
            String[] splittedName = Util.splitOn('.', name, 0, name.length());
            IPackageFragment[] oneFragment = null;
            ArrayList<PackageFragment> pkgs = null;
            char[] lowercaseName = hasPatternChars && !isStarPattern ? name.toLowerCase().toCharArray() : null;
            Object[][] keys = this.packageFragments.keyTable;
            int length = keys.length;
            for (int i = 0; i < length; ++i) {
                boolean match;
                String[] pkgName = (String[])keys[i];
                if (pkgName == null) continue;
                boolean bl2 = isStarPattern || (hasPatternChars ? CharOperation.match(lowercaseName, Util.concatCompoundNameToCharArray(pkgName), false) : Util.startsWithIgnoreCase(pkgName, splittedName, partialMatch)) ? true : (match = false);
                if (!match) continue;
                Object value = this.packageFragments.valueTable[i];
                if (value instanceof PackageFragmentRoot) {
                    PackageFragment pkg = ((PackageFragmentRoot)value).getPackageFragment(pkgName);
                    if (oneFragment == null) {
                        oneFragment = new IPackageFragment[]{pkg};
                        continue;
                    }
                    if (pkgs == null) {
                        pkgs = new ArrayList<PackageFragment>();
                        pkgs.add((PackageFragment)oneFragment[0]);
                    }
                    pkgs.add(pkg);
                    continue;
                }
                IPackageFragmentRoot[] roots = (IPackageFragmentRoot[])value;
                int length2 = roots.length;
                for (int j = 0; j < length2; ++j) {
                    PackageFragmentRoot root = (PackageFragmentRoot)roots[j];
                    PackageFragment pkg = root.getPackageFragment(pkgName);
                    if (oneFragment == null) {
                        oneFragment = new IPackageFragment[]{pkg};
                        continue;
                    }
                    if (pkgs == null) {
                        pkgs = new ArrayList();
                        pkgs.add((PackageFragment)oneFragment[0]);
                    }
                    pkgs.add(pkg);
                }
            }
            if (pkgs == null) {
                return oneFragment;
            }
            int resultLength = pkgs.size();
            IPackageFragment[] result = new IPackageFragment[resultLength];
            pkgs.toArray(result);
            return result;
        }
        Object[] splittedName = Util.splitOn('.', name, 0, name.length());
        int pkgIndex = this.packageFragments.getIndex(splittedName);
        if (pkgIndex == -1) {
            return null;
        }
        Object value = this.packageFragments.valueTable[pkgIndex];
        String[] pkgName = (String[])this.packageFragments.keyTable[pkgIndex];
        if (value instanceof PackageFragmentRoot) {
            return new IPackageFragment[]{((PackageFragmentRoot)value).getPackageFragment(pkgName)};
        }
        IPackageFragmentRoot[] roots = (IPackageFragmentRoot[])value;
        IPackageFragment[] result = new IPackageFragment[roots.length];
        for (int i = 0; i < roots.length; ++i) {
            result[i] = ((PackageFragmentRoot)roots[i]).getPackageFragment(pkgName);
        }
        return result;
    }

    public IPackageFragmentRoot[] findPackageFragementRoots(String[] splittedName) {
        int pkgIndex = this.packageFragments.getIndex(splittedName);
        if (pkgIndex == -1) {
            return null;
        }
        Object value = this.packageFragments.valueTable[pkgIndex];
        if (value instanceof PackageFragmentRoot) {
            return new IPackageFragmentRoot[]{(PackageFragmentRoot)value};
        }
        return (IPackageFragmentRoot[])value;
    }

    private IType findSecondaryType(String packageName, String typeName, IJavaProject project, boolean waitForIndexes, IProgressMonitor monitor) {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        try {
            IType type;
            Map<String, IType> types;
            IJavaProject javaProject = project;
            Map<String, Map<String, IType>> secondaryTypePaths = manager.secondaryTypes(javaProject, waitForIndexes, monitor);
            if (secondaryTypePaths.size() > 0 && (types = secondaryTypePaths.get(packageName == null ? "" : packageName)) != null && types.size() > 0 && (type = types.get(typeName)) != null) {
                if (JavaModelManager.VERBOSE) {
                    Util.verbose("NameLookup FIND SECONDARY TYPES:");
                    Util.verbose(" -> pkg name: " + packageName);
                    Util.verbose(" -> type name: " + typeName);
                    Util.verbose(" -> project: " + project.getElementName());
                    Util.verbose(" -> type: " + type.getElementName());
                }
                return type;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return null;
    }

    public Answer findType(String typeName, String packageName, boolean partialMatch, int acceptFlags, boolean checkRestrictions, IPackageFragmentRoot[] moduleContext) {
        return this.findType(typeName, packageName, partialMatch, acceptFlags, true, false, checkRestrictions, null, moduleContext);
    }

    public Answer findType(String typeName, String packageName, boolean partialMatch, int acceptFlags, boolean checkRestrictions) {
        return this.findType(typeName, packageName, partialMatch, acceptFlags, true, false, checkRestrictions, null);
    }

    public Answer findType(String typeName, String packageName, boolean partialMatch, int acceptFlags, boolean considerSecondaryTypes, boolean waitForIndexes, boolean checkRestrictions, IProgressMonitor monitor) {
        return this.findType(typeName, packageName, partialMatch, acceptFlags, considerSecondaryTypes, waitForIndexes, checkRestrictions, monitor, null);
    }

    public Answer findType(String typeName, String packageName, boolean partialMatch, int acceptFlags, boolean considerSecondaryTypes, boolean waitForIndexes, boolean checkRestrictions, IProgressMonitor monitor, IPackageFragmentRoot[] moduleContext) {
        ICompilationUnit unit;
        if (packageName == null || packageName.length() == 0) {
            packageName = "";
        } else if (typeName.length() > 0 && ScannerHelper.isLowerCase(typeName.charAt(0)) && this.findPackageFragments(packageName + "." + typeName, false) != null) {
            return null;
        }
        JavaElementRequestor elementRequestor = new JavaElementRequestor();
        this.seekPackageFragments(packageName, false, elementRequestor, moduleContext);
        IPackageFragment[] packages = elementRequestor.getPackageFragments();
        IMember type = null;
        int length = packages.length;
        HashSet<IJavaProject> projects = null;
        IJavaProject javaProject = null;
        Answer suggestedAnswer = null;
        for (int i = 0; i < length; ++i) {
            type = this.findType(typeName, packages[i], partialMatch, acceptFlags, waitForIndexes, considerSecondaryTypes);
            if (type != null) {
                Answer answer;
                AccessRestriction accessRestriction = null;
                PackageFragmentRoot root = (PackageFragmentRoot)type.getAncestor(3);
                ClasspathEntry entry = (ClasspathEntry)this.rootToResolvedEntries.get(root);
                if (entry != null && checkRestrictions) {
                    accessRestriction = this.getViolatedRestriction(typeName, packageName, entry, accessRestriction);
                }
                if (!(answer = new Answer((IType)type, accessRestriction, entry, NameLookup.getModuleDescription(this.rootProject, root, this.rootToModule, this.rootToResolvedEntries::get))).ignoreIfBetter()) {
                    if (!answer.isBetter(suggestedAnswer)) continue;
                    return answer;
                }
                if (!answer.isBetter(suggestedAnswer)) continue;
                suggestedAnswer = answer;
                continue;
            }
            if (suggestedAnswer != null || !considerSecondaryTypes) continue;
            if (javaProject == null) {
                javaProject = packages[i].getJavaProject();
                continue;
            }
            if (projects == null) {
                if (javaProject.equals(packages[i].getJavaProject())) continue;
                projects = new HashSet<IJavaProject>(3);
                projects.add(javaProject);
                projects.add(packages[i].getJavaProject());
                continue;
            }
            projects.add(packages[i].getJavaProject());
        }
        if (suggestedAnswer != null) {
            return suggestedAnswer;
        }
        if (considerSecondaryTypes && javaProject != null) {
            if (projects == null) {
                type = this.findSecondaryType(packageName, typeName, javaProject, waitForIndexes, monitor);
            } else {
                Iterator allProjects = projects.iterator();
                while (type == null && allProjects.hasNext()) {
                    type = this.findSecondaryType(packageName, typeName, (IJavaProject)allProjects.next(), waitForIndexes, monitor);
                }
            }
        }
        if (type != null && (unit = type.getCompilationUnit()) != null && unit.isWorkingCopy()) {
            int typesLength;
            IType[] types = null;
            try {
                types = unit.getTypes();
            }
            catch (JavaModelException e) {
                return null;
            }
            boolean typeFound = false;
            int n = typesLength = types == null ? 0 : types.length;
            for (int i = 0; i < typesLength; ++i) {
                if (!types[i].getElementName().equals(typeName)) continue;
                typeFound = true;
                break;
            }
            if (!typeFound) {
                type = null;
            }
        }
        return type == null ? null : new Answer((IType)type, null, null);
    }

    public static IModule getModuleDescriptionInfo(IModuleDescription moduleDesc) {
        block4: {
            if (moduleDesc != null) {
                try {
                    if (moduleDesc instanceof AbstractModule.AutoModule) {
                        boolean nameFromManifest = ((AbstractModule.AutoModule)moduleDesc).isAutoNameFromManifest();
                        return IModule.createAutomatic(moduleDesc.getElementName().toCharArray(), nameFromManifest);
                    }
                    return ((AbstractModule)moduleDesc).getModuleInfo();
                }
                catch (JavaModelException e) {
                    if (e.isDoesNotExist()) break block4;
                    Util.log((Throwable)((Object)e));
                }
            }
        }
        return null;
    }

    static IModuleDescription getModuleDescription(JavaProject project, IPackageFragmentRoot root, Map<IPackageFragmentRoot, IModuleDescription> cache, Function<IPackageFragmentRoot, IClasspathEntry> rootToEntry) {
        IClasspathEntry classpathEntry2;
        IModuleDescription module = cache.get(root);
        if (module != null) {
            return module != NO_MODULE ? module : null;
        }
        if (!Objects.equals(project, root.getJavaProject()) && (classpathEntry2 = rootToEntry.apply(root)) instanceof ClasspathEntry && !((ClasspathEntry)classpathEntry2).isModular()) {
            cache.put(root, NO_MODULE);
            return null;
        }
        try {
            if (root.getKind() == 1) {
                module = root.getJavaProject().getModuleDescription();
            }
        }
        catch (JavaModelException e) {
            cache.put(root, NO_MODULE);
            return null;
        }
        if (module == null) {
            IClasspathEntry classpathEntry = rootToEntry.apply(root);
            if (classpathEntry instanceof ClasspathEntry) {
                if (((ClasspathEntry)classpathEntry).isModular() && (module = root.getModuleDescription()) == null) {
                    module = ((PackageFragmentRoot)root).getAutomaticModuleDescription(classpathEntry);
                }
            } else if (root instanceof JrtPackageFragmentRoot) {
                module = root.getModuleDescription();
            }
        }
        cache.put(root, module != null ? module : NO_MODULE);
        return module;
    }

    public IModule getModuleDescriptionInfo(PackageFragmentRoot root) {
        IModuleDescription desc = NameLookup.getModuleDescription(this.rootProject, root, this.rootToModule, this.rootToResolvedEntries::get);
        if (desc != null) {
            return NameLookup.getModuleDescriptionInfo(desc);
        }
        return null;
    }

    private AccessRestriction getViolatedRestriction(String typeName, String packageName, ClasspathEntry entry, AccessRestriction accessRestriction) {
        AccessRuleSet accessRuleSet = entry.getAccessRuleSet();
        if (accessRuleSet != null) {
            char[][] packageChars = CharOperation.splitOn('.', packageName.toCharArray());
            char[] typeChars = typeName.toCharArray();
            accessRestriction = accessRuleSet.getViolatedRestriction(CharOperation.concatWith(packageChars, typeChars, '/'));
        }
        return accessRestriction;
    }

    public IType findType(String name, IPackageFragment pkg, boolean partialMatch, int acceptFlags, boolean waitForIndices, boolean considerSecondaryTypes) {
        if (pkg == null) {
            return null;
        }
        SingleTypeRequestor typeRequestor = new SingleTypeRequestor();
        this.seekTypes(name, pkg, partialMatch, acceptFlags, typeRequestor, considerSecondaryTypes);
        IType type = typeRequestor.getType();
        if (type == null && considerSecondaryTypes) {
            type = this.findSecondaryType(pkg.getElementName(), name, pkg.getJavaProject(), waitForIndices, null);
        }
        return type;
    }

    public IType findType(String name, IPackageFragment pkg, boolean partialMatch, int acceptFlags) {
        if (pkg == null) {
            return null;
        }
        SingleTypeRequestor typeRequestor = new SingleTypeRequestor();
        this.seekTypes(name, pkg, partialMatch, acceptFlags, typeRequestor, false);
        return typeRequestor.getType();
    }

    public IType findType(String name, boolean partialMatch, int acceptFlags) {
        Answer answer = this.findType(name, partialMatch, acceptFlags, false);
        return answer == null ? null : answer.type;
    }

    public Answer findType(String name, boolean partialMatch, int acceptFlags, boolean checkRestrictions) {
        return this.findType(name, partialMatch, acceptFlags, true, true, checkRestrictions, null);
    }

    public Answer findType(String name, boolean partialMatch, int acceptFlags, boolean considerSecondaryTypes, boolean waitForIndexes, boolean checkRestrictions, IProgressMonitor monitor) {
        int index = name.lastIndexOf(46);
        if (index == 0) {
            return null;
        }
        String className = null;
        String packageName = null;
        if (index == -1) {
            packageName = "";
            className = name;
        } else {
            packageName = name.substring(0, index);
            className = name.substring(index + 1);
        }
        return this.findType(className, packageName, partialMatch, acceptFlags, considerSecondaryTypes, waitForIndexes, checkRestrictions, monitor);
    }

    public Answer findModule(char[] moduleName) {
        JavaElementRequestor requestor = new JavaElementRequestor();
        this.seekModule(moduleName, false, requestor);
        IModuleDescription[] modules = requestor.getModules();
        if (modules.length == 0) {
            try {
                JavaModelManager.getModulePathManager().seekModule(moduleName, false, requestor);
                modules = requestor.getModules();
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        if (modules.length > 0) {
            return new Answer(modules[0]);
        }
        return null;
    }

    private IType getMemberType(IType type, String name, int dot) {
        while (dot != -1) {
            int start;
            String typeName = name.substring(start, (dot = name.indexOf(46, start = dot + 1)) == -1 ? name.length() : dot);
            type = type.getType(typeName);
        }
        return type;
    }

    public boolean isPackage(String[] pkgName) {
        return this.packageFragments.get(pkgName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPackage(String[] pkgName, IPackageFragmentRoot[] moduleContext) {
        if (moduleContext == null) {
            return this.isPackage(pkgName);
        }
        long start = -1L;
        if (VERBOSE) {
            start = System.currentTimeMillis();
        }
        try {
            String[] trimmedPkgName = null;
            for (IPackageFragmentRoot moduleRoot : moduleContext) {
                if (moduleRoot instanceof PackageFragmentRoot) {
                    if (trimmedPkgName == null) {
                        trimmedPkgName = NameLookup.trim(pkgName);
                    }
                    if (!((PackageFragmentRoot)moduleRoot).getPackageFragment(trimmedPkgName).exists()) continue;
                    boolean bl = true;
                    return bl;
                }
                if (!moduleRoot.getPackageFragment(String.join((CharSequence)".", pkgName)).exists()) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (VERBOSE) {
                this.timeSpentInIsPackageWithModuleContext += System.currentTimeMillis() - start;
            }
        }
        return false;
    }

    private static String[] trim(String[] strings) {
        String[] trimmed = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            trimmed[i] = strings[i].trim();
        }
        return trimmed;
    }

    private boolean moduleMatches(IPackageFragmentRoot root, IPackageFragmentRoot[] moduleContext) {
        for (IPackageFragmentRoot moduleRoot : moduleContext) {
            if (!moduleRoot.equals(root)) continue;
            return true;
        }
        return false;
    }

    protected boolean nameMatches(String searchName, IJavaElement element, boolean partialMatch) {
        if (partialMatch) {
            return element.getElementName().toLowerCase().startsWith(searchName);
        }
        return element.getElementName().equals(searchName);
    }

    protected boolean nameMatches(String searchName, ICompilationUnit cu, boolean partialMatch) {
        if (partialMatch) {
            return cu.getElementName().toLowerCase().startsWith(searchName);
        }
        return Util.equalsIgnoreJavaLikeExtension(cu.getElementName(), searchName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seekPackageFragments(String name, boolean partialMatch, IJavaElementRequestor requestor, IPackageFragmentRoot[] moduleContext) {
        if (moduleContext == null) {
            this.seekPackageFragments(name, partialMatch, requestor);
            return;
        }
        if (partialMatch) {
            this.seekModuleAwarePartialPackageFragments(name, requestor, moduleContext);
            return;
        }
        long start = -1L;
        if (VERBOSE) {
            start = System.currentTimeMillis();
        }
        try {
            for (IPackageFragmentRoot moduleRoot : moduleContext) {
                IPackageFragment fragment = moduleRoot.getPackageFragment(name);
                if (!fragment.exists()) continue;
                requestor.acceptPackageFragment(fragment);
            }
        }
        finally {
            if (VERBOSE) {
                this.timeSpentInSeekPackageFragmentsWithModuleContext += System.currentTimeMillis() - start;
            }
        }
    }

    public void seekTypes(String pkgName, String name, boolean partialMatch, IJavaElementRequestor requestor, int acceptFlags, IPackageFragmentRoot[] moduleContext, String moduleName) {
        Selector selector = new Selector(moduleName);
        this.seekPackageFragments(pkgName, true, selector, moduleContext);
        if (selector.pkgFragments.size() == 0) {
            return;
        }
        for (IPackageFragment pkg : selector.pkgFragments) {
            this.seekTypes(name, pkg, partialMatch, acceptFlags, requestor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void seekModuleAwarePartialPackageFragments(String name, IJavaElementRequestor requestor, IPackageFragmentRoot[] moduleContext) {
        long start = -1L;
        if (VERBOSE) {
            start = System.currentTimeMillis();
        }
        try {
            boolean allPrefixMatch = CharOperation.equals(name.toCharArray(), CharOperation.ALL_PREFIX);
            String lName = name.toLowerCase();
            Arrays.stream(this.packageFragments.keyTable).filter(k -> k != null).filter(k -> allPrefixMatch || Util.concatWith((String[])k, '.').toLowerCase().startsWith(lName)).forEach(k -> this.checkModulePackages(requestor, moduleContext, this.packageFragments.getIndex((Object[])k)));
        }
        finally {
            if (VERBOSE) {
                this.timeSpentInSeekModuleAwarePartialPackageFragments += System.currentTimeMillis() - start;
            }
        }
    }

    private void checkModulePackages(IJavaElementRequestor requestor, IPackageFragmentRoot[] moduleContext, int pkgIndex) {
        Object value = this.packageFragments.valueTable[pkgIndex];
        String[] pkgName = (String[])this.packageFragments.keyTable[pkgIndex];
        if (value instanceof PackageFragmentRoot) {
            PackageFragmentRoot root = (PackageFragmentRoot)value;
            if (this.moduleMatches(root, moduleContext)) {
                requestor.acceptPackageFragment(root.getPackageFragment(pkgName));
            }
        } else {
            IPackageFragmentRoot[] roots = (IPackageFragmentRoot[])value;
            if (roots != null) {
                int length = roots.length;
                for (int i = 0; i < length; ++i) {
                    if (requestor.isCanceled()) {
                        return;
                    }
                    PackageFragmentRoot root = (PackageFragmentRoot)roots[i];
                    if (!this.moduleMatches(root, moduleContext)) continue;
                    requestor.acceptPackageFragment(root.getPackageFragment(pkgName));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seekPackageFragments(String name, boolean partialMatch, IJavaElementRequestor requestor) {
        long start = -1L;
        if (VERBOSE) {
            start = System.currentTimeMillis();
        }
        try {
            if (partialMatch) {
                String[] splittedName = Util.splitOn('.', name, 0, name.length());
                Object[][] keys = this.packageFragments.keyTable;
                int length = keys.length;
                for (int i = 0; i < length; ++i) {
                    if (requestor.isCanceled()) {
                        return;
                    }
                    String[] pkgName = (String[])keys[i];
                    if (pkgName == null || !Util.startsWithIgnoreCase(pkgName, splittedName, partialMatch)) continue;
                    Object value = this.packageFragments.valueTable[i];
                    if (value instanceof PackageFragmentRoot) {
                        PackageFragmentRoot root = (PackageFragmentRoot)value;
                        requestor.acceptPackageFragment(root.getPackageFragment(pkgName));
                        continue;
                    }
                    IPackageFragmentRoot[] roots = (IPackageFragmentRoot[])value;
                    int length2 = roots.length;
                    for (int j = 0; j < length2; ++j) {
                        if (requestor.isCanceled()) {
                            return;
                        }
                        PackageFragmentRoot root = (PackageFragmentRoot)roots[j];
                        requestor.acceptPackageFragment(root.getPackageFragment(pkgName));
                    }
                }
            } else {
                Object[] splittedName = Util.splitOn('.', name, 0, name.length());
                int pkgIndex = this.packageFragments.getIndex(splittedName);
                if (pkgIndex != -1) {
                    Object value = this.packageFragments.valueTable[pkgIndex];
                    String[] pkgName = (String[])this.packageFragments.keyTable[pkgIndex];
                    if (value instanceof PackageFragmentRoot) {
                        requestor.acceptPackageFragment(((PackageFragmentRoot)value).getPackageFragment(pkgName));
                    } else {
                        IPackageFragmentRoot[] roots = (IPackageFragmentRoot[])value;
                        if (roots != null) {
                            int length = roots.length;
                            for (int i = 0; i < length; ++i) {
                                if (requestor.isCanceled()) {
                                    return;
                                }
                                PackageFragmentRoot root = (PackageFragmentRoot)roots[i];
                                requestor.acceptPackageFragment(root.getPackageFragment(pkgName));
                            }
                        }
                    }
                }
            }
        }
        finally {
            if (VERBOSE) {
                this.timeSpentInSeekPackageFragments += System.currentTimeMillis() - start;
            }
        }
    }

    public void seekTypes(String name, IPackageFragment pkg, boolean partialMatch, int acceptFlags, IJavaElementRequestor requestor) {
        this.seekTypes(name, pkg, partialMatch, acceptFlags, requestor, true);
    }

    public void seekModuleReferences(String name, IJavaElementRequestor requestor, IJavaProject javaProject) {
        this.seekModule(name.toCharArray(), true, requestor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seekModule(char[] name, boolean prefixMatch, IJavaElementRequestor requestor) {
        long start = -1L;
        if (VERBOSE) {
            start = System.currentTimeMillis();
        }
        try {
            IPrefixMatcherCharArray prefixMatcher = prefixMatch ? (CharOperation.equals(name, CharOperation.ALL_PREFIX) ? (x, y, isCaseSensitive) -> true : CharOperation::prefixEquals) : CharOperation::equals;
            int count = this.packageFragmentRoots.length;
            for (int i = 0; i < count; ++i) {
                if (requestor.isCanceled()) {
                    return;
                }
                IPackageFragmentRoot root = this.packageFragmentRoots[i];
                IModuleDescription module = null;
                if (root instanceof JrtPackageFragmentRoot && !prefixMatcher.matches(name, root.getElementName().toCharArray(), false) || (module = NameLookup.getModuleDescription(this.rootProject, root, this.rootToModule, this.rootToResolvedEntries::get)) == null || !prefixMatcher.matches(name, module.getElementName().toCharArray(), false)) continue;
                requestor.acceptModule(module);
            }
        }
        finally {
            if (VERBOSE) {
                this.timeSpentInSeekModule += System.currentTimeMillis() - start;
            }
        }
    }

    public void seekTypes(String name, IPackageFragment pkg, boolean partialMatch, int acceptFlags, IJavaElementRequestor requestor, boolean considerSecondaryTypes) {
        String matchName;
        String string = matchName = partialMatch ? name.toLowerCase() : name;
        if (pkg == null) {
            this.findAllTypes(matchName, partialMatch, acceptFlags, requestor);
            return;
        }
        PackageFragmentRoot root = (PackageFragmentRoot)pkg.getParent();
        try {
            int firstDot = -1;
            String topLevelTypeName = null;
            int packageFlavor = root.internalKind();
            if (this.typesInWorkingCopies != null || packageFlavor == 1) {
                firstDot = matchName.indexOf(46);
                if (!partialMatch) {
                    String string2 = topLevelTypeName = firstDot == -1 ? matchName : matchName.substring(0, firstDot);
                }
            }
            if (this.typesInWorkingCopies != null && this.seekTypesInWorkingCopies(matchName, pkg, firstDot, partialMatch, topLevelTypeName, acceptFlags, requestor, considerSecondaryTypes)) {
                return;
            }
            switch (packageFlavor) {
                case 2: {
                    matchName = matchName.replace('.', '$');
                    this.seekTypesInBinaryPackage(matchName, pkg, partialMatch, acceptFlags, requestor);
                    break;
                }
                case 1: {
                    this.seekTypesInSourcePackage(matchName, pkg, firstDot, partialMatch, topLevelTypeName, acceptFlags, requestor);
                    if (matchName.indexOf(36) != -1) {
                        matchName = matchName.replace('$', '.');
                        firstDot = matchName.indexOf(46);
                        if (!partialMatch) {
                            topLevelTypeName = firstDot == -1 ? matchName : matchName.substring(0, firstDot);
                        }
                        this.seekTypesInSourcePackage(matchName, pkg, firstDot, partialMatch, topLevelTypeName, acceptFlags, requestor);
                    }
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (JavaModelException e) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void seekTypesInBinaryPackage(String name, IPackageFragment pkg, boolean partialMatch, int acceptFlags, IJavaElementRequestor requestor) {
        block17: {
            long start = -1L;
            if (VERBOSE) {
                start = System.currentTimeMillis();
            }
            try {
                if (!partialMatch) {
                    IType type;
                    if (requestor.isCanceled()) {
                        return;
                    }
                    ClassFile classFile = new ClassFile((PackageFragment)pkg, name);
                    if (classFile.existsUsingJarTypeCache() && this.acceptType(type = classFile.getType(), acceptFlags, false)) {
                        requestor.acceptType(type);
                    }
                    break block17;
                }
                IJavaElement[] classFiles = null;
                try {
                    classFiles = pkg.getChildren();
                }
                catch (JavaModelException npe) {
                    if (VERBOSE) {
                        this.timeSpentInSeekTypesInBinaryPackage += System.currentTimeMillis() - start;
                    }
                    return;
                }
                int length = classFiles.length;
                String unqualifiedName = name;
                int index = name.lastIndexOf(36);
                if (index != -1) {
                    unqualifiedName = Util.localTypeName(name, index, name.length());
                }
                int matchLength = name.length();
                for (int i = 0; i < length; ++i) {
                    IType type;
                    String typeName;
                    if (requestor.isCanceled()) {
                        return;
                    }
                    IJavaElement classFile = classFiles[i];
                    String elementName = classFile.getElementName();
                    if (!elementName.regionMatches(true, 0, name, 0, matchLength) || !(classFile instanceof IOrdinaryClassFile) || (typeName = (type = ((IOrdinaryClassFile)classFile).getType()).getElementName()).length() <= 0 || Character.isDigit(typeName.charAt(0)) || !this.nameMatches(unqualifiedName, type, true) || !this.acceptType(type, acceptFlags, false)) continue;
                    requestor.acceptType(type);
                }
            }
            finally {
                if (VERBOSE) {
                    this.timeSpentInSeekTypesInBinaryPackage += System.currentTimeMillis() - start;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void seekTypesInSourcePackage(String name, IPackageFragment pkg, int firstDot, boolean partialMatch, String topLevelTypeName, int acceptFlags, IJavaElementRequestor requestor) {
        block20: {
            start = -1L;
            if (NameLookup.VERBOSE) {
                start = System.currentTimeMillis();
            }
            try {
                if (!partialMatch) {
                    compilationUnits = pkg.getChildren();
                    length = compilationUnits.length;
                    for (i = 0; i < length; ++i) {
                        if (!requestor.isCanceled()) ** break block19
                        return;
                    }
                    break block20;
                    {
                        try {
                            cu = compilationUnits[i];
                            cuName = cu.getElementName();
                            lastDot = cuName.lastIndexOf(46);
                            if (lastDot != topLevelTypeName.length() || !topLevelTypeName.regionMatches(0, cuName, 0, lastDot) || !(cu instanceof ICompilationUnit)) continue;
                            type = ((ICompilationUnit)cu).getType(topLevelTypeName);
                            if (!this.acceptType(type = this.getMemberType(type, name, firstDot), acceptFlags, true)) continue;
                            requestor.acceptType(type);
                            break block20;
                        }
                        catch (JavaModelException compilationUnits) {
                            break block20;
                            break;
                        }
                    }
                }
                cuPrefix = firstDot == -1 ? name : name.substring(0, firstDot);
                compilationUnits = pkg.getChildren();
                length = compilationUnits.length;
                for (i = 0; i < length; ++i) {
                    if (!requestor.isCanceled()) ** break block21
                    return;
                }
                break block20;
                {
                    try {
                        cu = compilationUnits[i];
                        if (!cu.getElementName().toLowerCase().startsWith(cuPrefix)) continue;
                        try {
                            types = ((ICompilationUnit)cu).getTypes();
                            typeLength = types.length;
                            for (j = 0; j < typeLength; ++j) {
                                this.seekTypesInTopLevelType(name, firstDot, types[j], requestor, acceptFlags);
                            }
                        }
                        catch (JavaModelException var15_23) {
                            // empty catch block
                        }
                        continue;
                    }
                    catch (JavaModelException var10_12) {
                        // empty catch block
                        break block20;
                        break;
                    }
                }
            }
            finally {
                if (NameLookup.VERBOSE) {
                    this.timeSpentInSeekTypesInSourcePackage += System.currentTimeMillis() - start;
                }
            }
        }
    }

    private boolean isPrimaryType(String name, IType type, boolean partialMatch) {
        ICompilationUnit cu = (ICompilationUnit)type.getParent();
        String cuName = cu.getElementName().substring(0, cu.getElementName().lastIndexOf(46));
        if (!cuName.equals(type.getElementName())) {
            return false;
        }
        if (partialMatch) {
            return cuName.regionMatches(0, name, 0, name.length());
        }
        return cuName.equals(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean seekTypesInType(String prefix, int firstDot, IType type, IJavaElementRequestor requestor, int acceptFlags) {
        long start = -1L;
        if (VERBOSE) {
            start = System.currentTimeMillis();
        }
        try {
            IType[] types = null;
            try {
                types = type.getTypes();
            }
            catch (JavaModelException npe) {
                boolean bl = false;
                if (VERBOSE) {
                    this.timeSpentInSeekTypesInType += System.currentTimeMillis() - start;
                }
                return bl;
            }
            int length = types.length;
            if (length == 0) {
                boolean bl = false;
                return bl;
            }
            String memberPrefix = prefix;
            boolean isMemberTypePrefix = false;
            if (firstDot != -1) {
                memberPrefix = prefix.substring(0, firstDot);
                isMemberTypePrefix = true;
            }
            for (int i = 0; i < length; ++i) {
                if (requestor.isCanceled()) {
                    boolean bl = false;
                    return bl;
                }
                IType memberType = types[i];
                if (!memberType.getElementName().toLowerCase().startsWith(memberPrefix)) continue;
                if (isMemberTypePrefix) {
                    String subPrefix = prefix.substring(firstDot + 1, prefix.length());
                    boolean bl = this.seekTypesInType(subPrefix, subPrefix.indexOf(46), memberType, requestor, acceptFlags);
                    return bl;
                }
                if (!this.acceptType(memberType, acceptFlags, true)) continue;
                requestor.acceptMemberType(memberType);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (VERBOSE) {
                this.timeSpentInSeekTypesInType += System.currentTimeMillis() - start;
            }
        }
    }

    protected boolean seekTypesInTopLevelType(String prefix, int firstDot, IType topLevelType, IJavaElementRequestor requestor, int acceptFlags) {
        if (!topLevelType.getElementName().toLowerCase().startsWith(prefix)) {
            return false;
        }
        if (firstDot == -1) {
            if (this.acceptType(topLevelType, acceptFlags, true)) {
                requestor.acceptType(topLevelType);
                return true;
            }
        } else {
            return this.seekTypesInType(prefix, firstDot, topLevelType, requestor, acceptFlags);
        }
        return false;
    }

    protected boolean seekTypesInWorkingCopies(String name, IPackageFragment pkg, int firstDot, boolean partialMatch, String topLevelTypeName, int acceptFlags, IJavaElementRequestor requestor, boolean considerSecondaryTypes) {
        block12: {
            block11: {
                Object object;
                block13: {
                    if (partialMatch) break block11;
                    HashMap typeMap = this.typesInWorkingCopies == null ? null : this.typesInWorkingCopies.get(pkg);
                    if (typeMap == null) break block12;
                    object = typeMap.get(topLevelTypeName);
                    if (!(object instanceof IType)) break block13;
                    IType type = this.getMemberType((IType)object, name, firstDot);
                    if (!considerSecondaryTypes && !this.isPrimaryType(name, (IType)object, false)) {
                        return false;
                    }
                    if (this.acceptType(type, acceptFlags, true)) {
                        requestor.acceptType(type);
                        return true;
                    }
                    break block12;
                }
                if (!(object instanceof IType[])) break block12;
                if (object == NO_TYPES) {
                    String packageInfoName = String.valueOf(TypeConstants.PACKAGE_INFO_NAME);
                    if (packageInfoName.equals(name)) {
                        requestor.acceptType(pkg.getCompilationUnit(packageInfoName.concat(".java")).getType(name));
                    }
                    return true;
                }
                IType[] topLevelTypes = (IType[])object;
                int length = topLevelTypes.length;
                for (int i = 0; i < length; ++i) {
                    if (requestor.isCanceled()) {
                        return false;
                    }
                    IType type = this.getMemberType(topLevelTypes[i], name, firstDot);
                    if (!this.acceptType(type, acceptFlags, true)) continue;
                    requestor.acceptType(type);
                    return true;
                }
                break block12;
            }
            HashMap typeMap = this.typesInWorkingCopies == null ? null : this.typesInWorkingCopies.get(pkg);
            if (typeMap != null) {
                Iterator iterator = typeMap.values().iterator();
                while (iterator.hasNext()) {
                    if (requestor.isCanceled()) {
                        return false;
                    }
                    Object object = iterator.next();
                    if (object instanceof IType) {
                        if (!considerSecondaryTypes && !this.isPrimaryType(name, (IType)object, true)) continue;
                        this.seekTypesInTopLevelType(name, firstDot, (IType)object, requestor, acceptFlags);
                        continue;
                    }
                    if (!(object instanceof IType[])) continue;
                    IType[] topLevelTypes = (IType[])object;
                    int length = topLevelTypes.length;
                    for (int i = 0; i < length; ++i) {
                        this.seekTypesInTopLevelType(name, firstDot, topLevelTypes[i], requestor, acceptFlags);
                    }
                }
            }
        }
        return false;
    }

    public boolean hasCompilationUnit(char[][] pkgName, IPackageFragmentRoot[] moduleContext) {
        IPackageFragment[] packages;
        String packageName = CharOperation.toString(pkgName);
        if (packageName == null || packageName.length() == 0) {
            packageName = "";
        }
        JavaElementRequestor elementRequestor = new JavaElementRequestor();
        this.seekPackageFragments(packageName, false, elementRequestor, moduleContext);
        for (IPackageFragment fragment : packages = elementRequestor.getPackageFragments()) {
            try {
                if (!fragment.containsJavaResources()) continue;
                return true;
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return false;
    }

    public void printTimeSpent() {
        if (!VERBOSE) {
            return;
        }
        Util.verbose(" TIME SPENT NameLoopkup");
        Util.verbose(" -> seekTypesInSourcePackage..................." + this.timeSpentInSeekTypesInSourcePackage + "ms");
        Util.verbose(" -> seekTypesInBinaryPackage..................." + this.timeSpentInSeekTypesInBinaryPackage + "ms");
        Util.verbose(" -> seekTypesInType............................" + this.timeSpentInSeekTypesInType + "ms");
        Util.verbose(" -> seekModule................................." + this.timeSpentInSeekModule + "ms");
        Util.verbose(" -> seekModuleAwarePartialPackageFragments....." + this.timeSpentInSeekModuleAwarePartialPackageFragments + "ms");
        Util.verbose(" -> seekPackageFragments......................." + this.timeSpentInSeekPackageFragments + "ms");
        Util.verbose(" -> seekPackageFragmentsWithModuleContext......" + this.timeSpentInSeekPackageFragmentsWithModuleContext + "ms");
        Util.verbose(" -> isPackage(pkg,moduleCtx)..................." + this.timeSpentInIsPackageWithModuleContext + "ms");
    }

    public static class Answer {
        public IType type;
        public IModuleDescription module;
        AccessRestriction restriction;
        IClasspathEntry entry;

        Answer(IType type, AccessRestriction restriction, IClasspathEntry entry) {
            this(type, restriction, entry, null);
        }

        Answer(IType type, AccessRestriction restriction, IClasspathEntry entry, IModuleDescription module) {
            this.type = type;
            this.restriction = restriction;
            this.entry = entry;
            this.module = module;
        }

        Answer(IModuleDescription module) {
            this.module = module;
            this.restriction = null;
        }

        public boolean ignoreIfBetter() {
            return this.restriction != null && this.restriction.ignoreIfBetter();
        }

        public boolean isBetter(Answer otherAnswer) {
            if (otherAnswer == null) {
                return true;
            }
            if (this.restriction == null) {
                return true;
            }
            return otherAnswer.restriction != null && this.restriction.getProblemId() < otherAnswer.restriction.getProblemId();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.type.toString());
            builder.append("from ").append(this.module);
            return builder.toString();
        }
    }

    private static class Selector
    implements IJavaElementRequestor {
        public List<IPackageFragment> pkgFragments = new ArrayList<IPackageFragment>();

        public Selector(String moduleName) {
        }

        @Override
        public void acceptField(IField field) {
        }

        @Override
        public void acceptInitializer(IInitializer initializer) {
        }

        @Override
        public void acceptMemberType(IType type) {
        }

        @Override
        public void acceptMethod(IMethod method) {
        }

        @Override
        public void acceptPackageFragment(IPackageFragment packageFragment) {
            this.pkgFragments.add(packageFragment);
        }

        @Override
        public void acceptType(IType type) {
        }

        @Override
        public void acceptModule(IModuleDescription module) {
        }

        @Override
        public boolean isCanceled() {
            return false;
        }
    }

    @FunctionalInterface
    static interface IPrefixMatcherCharArray {
        public boolean matches(char[] var1, char[] var2, boolean var3);
    }
}

