/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryElementValuePair;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryNestedType;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.IRecordComponent;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.Annotation;
import org.eclipse.jdt.internal.core.AnnotationInfo;
import org.eclipse.jdt.internal.core.BinaryField;
import org.eclipse.jdt.internal.core.BinaryMember;
import org.eclipse.jdt.internal.core.BinaryMethod;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.LocalVariable;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.TypeParameter;
import org.eclipse.jdt.internal.core.TypeParameterElementInfo;

class ClassFileInfo
extends OpenableElementInfo
implements SuffixConstants {
    protected JavaElement[] binaryChildren = null;
    protected ITypeParameter[] typeParameters;

    ClassFileInfo() {
    }

    private void generateAnnotationsInfos(JavaElement member, IBinaryAnnotation[] binaryAnnotations, long tagBits, HashMap newElements) {
        this.generateAnnotationsInfos(member, null, binaryAnnotations, tagBits, newElements);
    }

    private void generateAnnotationsInfos(JavaElement member, char[] parameterName, IBinaryAnnotation[] binaryAnnotations, long tagBits, HashMap newElements) {
        if (binaryAnnotations != null) {
            for (IBinaryAnnotation annotationInfo : binaryAnnotations) {
                this.generateAnnotationInfo(member, parameterName, newElements, annotationInfo, null);
            }
        }
        this.generateStandardAnnotationsInfos(member, parameterName, tagBits, newElements);
    }

    private void generateAnnotationInfo(JavaElement parent, HashMap newElements, IBinaryAnnotation annotationInfo, String memberValuePairName) {
        this.generateAnnotationInfo(parent, null, newElements, annotationInfo, memberValuePairName);
    }

    private void generateAnnotationInfo(JavaElement parent, char[] parameterName, HashMap newElements, IBinaryAnnotation annotationInfo, String memberValuePairName) {
        char[] typeName = Signature.toCharArray(CharOperation.replaceOnCopy(annotationInfo.getTypeName(), '/', '.'));
        Annotation annotation = new Annotation(parent, new String(typeName), memberValuePairName);
        while (newElements.containsKey(annotation)) {
            ++annotation.occurrenceCount;
        }
        newElements.put(annotation, annotationInfo);
        IBinaryElementValuePair[] pairs = annotationInfo.getElementValuePairs();
        int length = pairs.length;
        for (int i = 0; i < length; ++i) {
            Object value = pairs[i].getValue();
            if (value instanceof IBinaryAnnotation) {
                this.generateAnnotationInfo(annotation, newElements, (IBinaryAnnotation)value, new String(pairs[i].getName()));
                continue;
            }
            if (!(value instanceof Object[])) continue;
            for (Object nestedValue : (Object[])value) {
                if (!(nestedValue instanceof IBinaryAnnotation)) continue;
                this.generateAnnotationInfo(annotation, newElements, (IBinaryAnnotation)nestedValue, new String(pairs[i].getName()));
            }
        }
    }

    private void generateStandardAnnotationsInfos(JavaElement javaElement, char[] parameterName, long tagBits, HashMap newElements) {
        if ((tagBits & 0x77FFFFF840000000L) == 0L) {
            return;
        }
        if ((tagBits & 0x300000000000L) != 0L) {
            this.generateStandardAnnotation(javaElement, TypeConstants.JAVA_LANG_ANNOTATION_RETENTION, this.getRetentionPolicy(tagBits), newElements);
        }
        if ((tagBits & 0x400000000000L) != 0L) {
            this.generateStandardAnnotation(javaElement, TypeConstants.JAVA_LANG_DEPRECATED, Annotation.NO_MEMBER_VALUE_PAIRS, newElements);
        }
        if ((tagBits & 0x800000000000L) != 0L) {
            this.generateStandardAnnotation(javaElement, TypeConstants.JAVA_LANG_ANNOTATION_DOCUMENTED, Annotation.NO_MEMBER_VALUE_PAIRS, newElements);
        }
        if ((tagBits & 0x1000000000000L) != 0L) {
            this.generateStandardAnnotation(javaElement, TypeConstants.JAVA_LANG_ANNOTATION_INHERITED, Annotation.NO_MEMBER_VALUE_PAIRS, newElements);
        }
        if ((tagBits & 0x10000000000000L) != 0L) {
            this.generateStandardAnnotation(javaElement, TypeConstants.JAVA_LANG_INVOKE_METHODHANDLE_$_POLYMORPHICSIGNATURE, Annotation.NO_MEMBER_VALUE_PAIRS, newElements);
        }
        if ((tagBits & 0x8000000000000L) != 0L) {
            this.generateStandardAnnotation(javaElement, TypeConstants.JAVA_LANG_SAFEVARARGS, Annotation.NO_MEMBER_VALUE_PAIRS, newElements);
        }
    }

    private void generateStandardAnnotation(JavaElement javaElement, char[][] typeName, IMemberValuePair[] members, HashMap newElements) {
        Annotation annotation = new Annotation(javaElement, new String(CharOperation.concatWith(typeName, '.')));
        AnnotationInfo annotationInfo = new AnnotationInfo();
        annotationInfo.members = members;
        newElements.put(annotation, annotationInfo);
    }

    private IMemberValuePair[] getRetentionPolicy(long tagBits) {
        if ((tagBits & 0x300000000000L) == 0L) {
            return Annotation.NO_MEMBER_VALUE_PAIRS;
        }
        String retention = null;
        retention = (tagBits & 0x300000000000L) == 0x300000000000L ? new String(CharOperation.concatWith(TypeConstants.JAVA_LANG_ANNOTATION_RETENTIONPOLICY, '.')) + "." + new String(TypeConstants.UPPER_RUNTIME) : ((tagBits & 0x100000000000L) != 0L ? new String(CharOperation.concatWith(TypeConstants.JAVA_LANG_ANNOTATION_RETENTIONPOLICY, '.')) + "." + new String(TypeConstants.UPPER_SOURCE) : new String(CharOperation.concatWith(TypeConstants.JAVA_LANG_ANNOTATION_RETENTIONPOLICY, '.')) + "." + new String(TypeConstants.UPPER_CLASS));
        final String value = retention;
        return new IMemberValuePair[]{new IMemberValuePair(){

            @Override
            public int getValueKind() {
                return 12;
            }

            @Override
            public Object getValue() {
                return value;
            }

            @Override
            public String getMemberName() {
                return new String(TypeConstants.VALUE);
            }
        }};
    }

    private void generateFieldInfos(IType type, IBinaryType typeInfo, HashMap newElements, ArrayList childrenHandles) {
        IBinaryField[] fields = typeInfo.getFields();
        if (fields == null) {
            return;
        }
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        for (IBinaryField fieldInfo : fields) {
            if (typeInfo.isRecord() && (fieldInfo.getModifiers() & 8) == 0) continue;
            BinaryField field = new BinaryField((JavaElement)((Object)type), manager.intern(new String(fieldInfo.getName())));
            newElements.put(field, fieldInfo);
            childrenHandles.add(field);
            this.generateAnnotationsInfos(field, fieldInfo.getAnnotations(), fieldInfo.getTagBits(), newElements);
        }
    }

    private void generateRecordComponentInfos(IType type, IBinaryType typeInfo, HashMap newElements, ArrayList childrenHandles) {
        IRecordComponent[] components = typeInfo.getRecordComponents();
        if (components == null) {
            return;
        }
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        for (IRecordComponent componentInfo : components) {
            BinaryField component = new BinaryField((JavaElement)((Object)type), manager.intern(new String(componentInfo.getName()))){

                @Override
                public boolean isRecordComponent() throws JavaModelException {
                    return true;
                }
            };
            newElements.put(component, componentInfo);
            childrenHandles.add(component);
            this.generateAnnotationsInfos(component, componentInfo.getAnnotations(), componentInfo.getTagBits(), newElements);
        }
    }

    private void generateInnerClassHandles(IType type, IBinaryType typeInfo, ArrayList childrenHandles) {
        IBinaryNestedType[] innerTypes = typeInfo.getMemberTypes();
        if (innerTypes != null) {
            IPackageFragment pkg = (IPackageFragment)type.getAncestor(4);
            for (IBinaryNestedType binaryType : innerTypes) {
                IClassFile parentClassFile = pkg.getClassFile(new String(ClassFile.unqualifiedName(binaryType.getName())) + ".class");
                BinaryType innerType = new BinaryType((JavaElement)((Object)parentClassFile), ClassFile.simpleName(binaryType.getName()));
                childrenHandles.add(innerType);
            }
        }
    }

    private void generateMethodInfos(IType type, IBinaryType typeInfo, HashMap newElements, ArrayList childrenHandles, ArrayList typeParameterHandles) {
        IBinaryMethod[] methods = typeInfo.getMethods();
        if (methods == null) {
            return;
        }
        for (IBinaryMethod methodInfo : methods) {
            boolean isConstructor = methodInfo.isConstructor();
            boolean isEnum = false;
            try {
                isEnum = type.isEnum();
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            boolean useGenericSignature = true;
            char[] signature = methodInfo.getGenericSignature();
            String[] pNames = null;
            if (signature == null) {
                int length;
                useGenericSignature = false;
                signature = methodInfo.getMethodDescriptor();
                if (isEnum && isConstructor && (length = (pNames = Signature.getParameterTypes(new String(signature))).length - 2) >= 0) {
                    String[] stringArray = pNames;
                    pNames = new String[length];
                    System.arraycopy(stringArray, 2, pNames, 0, length);
                }
            }
            String selector = new String(methodInfo.getSelector());
            if (isConstructor) {
                selector = type.getElementName();
            }
            try {
                if (!isEnum || !isConstructor || useGenericSignature) {
                    pNames = Signature.getParameterTypes(new String(signature));
                }
                if (isConstructor && useGenericSignature && type.isMember() && !Flags.isStatic(type.getFlags())) {
                    int length = pNames.length;
                    String[] stringArray = pNames;
                    pNames = new String[length + 1];
                    System.arraycopy(stringArray, 0, pNames, 1, length);
                    char[] descriptor = methodInfo.getMethodDescriptor();
                    String[] parameterTypes = Signature.getParameterTypes(new String(descriptor));
                    pNames[0] = parameterTypes[0];
                }
            }
            catch (IllegalArgumentException | JavaModelException e) {
                signature = methodInfo.getMethodDescriptor();
                pNames = Signature.getParameterTypes(new String(signature));
            }
            char[][] paramNames = new char[pNames.length][];
            for (int j = 0; j < pNames.length; ++j) {
                paramNames[j] = pNames[j].toCharArray();
            }
            char[][] parameterTypes = ClassFile.translatedNames(paramNames);
            JavaModelManager manager = JavaModelManager.getJavaModelManager();
            selector = manager.intern(selector);
            for (int j = 0; j < pNames.length; ++j) {
                pNames[j] = manager.intern(new String(parameterTypes[j]));
            }
            BinaryMethod method = new BinaryMethod((JavaElement)((Object)type), selector, pNames);
            childrenHandles.add(method);
            while (newElements.containsKey(method)) {
                ++method.occurrenceCount;
            }
            newElements.put(method, methodInfo);
            int max = pNames.length;
            Object argumentNames = methodInfo.getArgumentNames();
            if (argumentNames == null || ((char[][])argumentNames).length < max) {
                argumentNames = new char[max][];
                for (int j = 0; j < max; ++j) {
                    argumentNames[j] = ("arg" + j).toCharArray();
                }
            }
            int startIndex = 0;
            try {
                if (isConstructor) {
                    if (isEnum) {
                        startIndex = 2;
                    } else if (type.isMember() && !Flags.isStatic(type.getFlags())) {
                        startIndex = 1;
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            for (int j = startIndex; j < max; ++j) {
                IBinaryAnnotation[] parameterAnnotations = methodInfo.getParameterAnnotations(j - startIndex, typeInfo.getFileName());
                if (parameterAnnotations == null) continue;
                LocalVariable localVariable = new LocalVariable(method, new String(argumentNames[j]), 0, -1, 0, -1, method.parameterTypes[j], null, -1, true);
                this.generateAnnotationsInfos(localVariable, argumentNames[j], parameterAnnotations, methodInfo.getTagBits(), newElements);
            }
            this.generateTypeParameterInfos(method, signature, newElements, typeParameterHandles);
            this.generateAnnotationsInfos(method, methodInfo.getAnnotations(), methodInfo.getTagBits(), newElements);
            Object defaultValue = methodInfo.getDefaultValue();
            if (!(defaultValue instanceof IBinaryAnnotation)) continue;
            this.generateAnnotationInfo(method, newElements, (IBinaryAnnotation)defaultValue, new String(methodInfo.getSelector()));
        }
    }

    private void generateTypeParameterInfos(BinaryMember parent, char[] signature, HashMap newElements, ArrayList typeParameterHandles) {
        if (signature == null) {
            return;
        }
        for (char[] typeParameterSignature : Signature.getTypeParameters(signature)) {
            char[] typeParameterName = Signature.getTypeVariable(typeParameterSignature);
            CharOperation.replace(typeParameterSignature, '/', '.');
            char[][] typeParameterBoundSignatures = Signature.getTypeParameterBounds(typeParameterSignature);
            int boundLength = typeParameterBoundSignatures.length;
            char[][] typeParameterBounds = new char[boundLength][];
            for (int j = 0; j < boundLength; ++j) {
                typeParameterBounds[j] = Signature.toCharArray(typeParameterBoundSignatures[j]);
            }
            TypeParameter typeParameter = new TypeParameter(parent, new String(typeParameterName));
            TypeParameterElementInfo info = new TypeParameterElementInfo();
            info.bounds = typeParameterBounds;
            info.boundsSignatures = typeParameterBoundSignatures;
            typeParameterHandles.add(typeParameter);
            while (newElements.containsKey(typeParameter)) {
                ++typeParameter.occurrenceCount;
            }
            newElements.put(typeParameter, info);
        }
    }

    protected void readBinaryChildren(ClassFile classFile, HashMap newElements, IBinaryType typeInfo) {
        ArrayList childrenHandles = new ArrayList();
        BinaryType type = (BinaryType)classFile.getType();
        ArrayList typeParameterHandles = new ArrayList();
        if (typeInfo != null) {
            this.generateAnnotationsInfos(type, typeInfo.getAnnotations(), typeInfo.getTagBits(), newElements);
            this.generateTypeParameterInfos(type, typeInfo.getGenericSignature(), newElements, typeParameterHandles);
            this.generateFieldInfos(type, typeInfo, newElements, childrenHandles);
            this.generateRecordComponentInfos(type, typeInfo, newElements, childrenHandles);
            this.generateMethodInfos(type, typeInfo, newElements, childrenHandles, typeParameterHandles);
            this.generateInnerClassHandles(type, typeInfo, childrenHandles);
        }
        this.binaryChildren = new JavaElement[childrenHandles.size()];
        childrenHandles.toArray(this.binaryChildren);
        int typeParameterHandleSize = typeParameterHandles.size();
        if (typeParameterHandleSize == 0) {
            this.typeParameters = TypeParameter.NO_TYPE_PARAMETERS;
        } else {
            this.typeParameters = new ITypeParameter[typeParameterHandleSize];
            typeParameterHandles.toArray(this.typeParameters);
        }
    }

    void removeBinaryChildren() throws JavaModelException {
        int i;
        JavaModelManager manager;
        if (this.binaryChildren != null) {
            manager = JavaModelManager.getJavaModelManager();
            for (i = 0; i < this.binaryChildren.length; ++i) {
                JavaElement child = this.binaryChildren[i];
                if (child instanceof BinaryType) {
                    manager.removeInfoAndChildren(child.getParent());
                    continue;
                }
                manager.removeInfoAndChildren(child);
            }
            this.binaryChildren = JavaElement.NO_ELEMENTS;
        }
        if (this.typeParameters != null) {
            manager = JavaModelManager.getJavaModelManager();
            for (i = 0; i < this.typeParameters.length; ++i) {
                TypeParameter typeParameter = (TypeParameter)this.typeParameters[i];
                manager.removeInfoAndChildren(typeParameter);
            }
            this.typeParameters = TypeParameter.NO_TYPE_PARAMETERS;
        }
    }
}

