/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.ModuleDescriptionInfo;
import org.eclipse.jdt.internal.core.NamedMember;

public interface AbstractModule
extends IModuleDescription {
    public Object getElementInfo() throws JavaModelException;

    default public IModule getModuleInfo() throws JavaModelException {
        return (IModule)this.getElementInfo();
    }

    @Override
    default public String[] getExportedPackageNames(IModuleDescription targetModule) throws JavaModelException {
        IModule info = this.getModuleInfo();
        if (info != null) {
            ArrayList<String> result = new ArrayList<String>();
            for (IModule.IPackageExport packageExport : info.exports()) {
                if (targetModule != null && packageExport.isQualified() && !CharOperation.containsEqual(packageExport.targets(), targetModule.getElementName().toCharArray())) continue;
                result.add(new String(packageExport.name()));
            }
            return result.toArray(new String[result.size()]);
        }
        return new String[0];
    }

    @Override
    default public String[] getOpenedPackageNames(IModuleDescription targetModule) throws JavaModelException {
        IModule info = this.getModuleInfo();
        if (info != null) {
            ArrayList<String> result = new ArrayList<String>();
            for (IModule.IPackageExport packageOpen : info.opens()) {
                if (targetModule != null && packageOpen.isQualified() && !CharOperation.containsEqual(packageOpen.targets(), targetModule.getElementName().toCharArray())) continue;
                result.add(new String(packageOpen.name()));
            }
            return result.toArray(new String[result.size()]);
        }
        return new String[0];
    }

    default public IModule.IModuleReference[] getRequiredModules() throws JavaModelException {
        return this.getModuleInfo().requires();
    }

    default public IModule.IPackageExport[] getExportedPackages() throws JavaModelException {
        return this.getModuleInfo().exports();
    }

    default public IModule.IService[] getProvidedServices() throws JavaModelException {
        return this.getModuleInfo().provides();
    }

    @Override
    default public String[] getProvidedServiceNames() throws JavaModelException {
        IModule.IService[] services;
        ArrayList<String> results = new ArrayList<String>();
        for (IModule.IService service : services = this.getProvidedServices()) {
            results.add(new String(service.name()));
        }
        return results.toArray(new String[0]);
    }

    default public char[][] getUsedServices() throws JavaModelException {
        return this.getModuleInfo().uses();
    }

    @Override
    default public String[] getUsedServiceNames() throws JavaModelException {
        ArrayList<String> results = new ArrayList<String>();
        char[][] services = this.getUsedServices();
        for (int i = 0; i < services.length; ++i) {
            char[] service = services[i];
            results.add(new String(service));
        }
        return results.toArray(new String[0]);
    }

    default public IModule.IPackageExport[] getOpenedPackages() throws JavaModelException {
        return this.getModuleInfo().opens();
    }

    @Override
    default public String[] getRequiredModuleNames() throws JavaModelException {
        IModule.IModuleReference[] references = this.getRequiredModules();
        return (String[])Arrays.stream(references).map(ref -> String.valueOf(ref.name())).toArray(String[]::new);
    }

    default public String toString(String lineDelimiter) {
        StringBuffer buffer = new StringBuffer();
        try {
            this.toStringContent(buffer, lineDelimiter);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }

    default public void toStringContent(StringBuffer buffer, String lineDelimiter) throws JavaModelException {
        int i;
        IModule.IPackageExport[] exports = this.getExportedPackages();
        IModule.IModuleReference[] requires = this.getRequiredModules();
        buffer.append("module ");
        buffer.append(this.getElementName()).append(' ');
        buffer.append('{').append(lineDelimiter);
        if (exports != null) {
            for (i = 0; i < exports.length; ++i) {
                buffer.append("\texports ");
                buffer.append(exports[i].toString());
                buffer.append(lineDelimiter);
            }
        }
        buffer.append(lineDelimiter);
        if (requires != null) {
            for (i = 0; i < requires.length; ++i) {
                buffer.append("\trequires ");
                if (requires[i].isTransitive()) {
                    buffer.append(" public ");
                }
                buffer.append(requires[i].name());
                buffer.append(';').append(lineDelimiter);
            }
        }
        buffer.append(lineDelimiter).append('}').toString();
    }

    @Override
    default public int getElementType() {
        return 17;
    }

    public static class AutoModule
    extends NamedMember
    implements AbstractModule {
        private boolean nameFromManifest;

        public AutoModule(JavaElement parent, String name, boolean nameFromManifest) {
            super(parent, name);
            this.nameFromManifest = nameFromManifest;
        }

        @Override
        public IJavaElement[] getChildren() throws JavaModelException {
            return JavaElement.NO_ELEMENTS;
        }

        @Override
        public int getFlags() throws JavaModelException {
            return 0;
        }

        @Override
        public boolean isAutoModule() {
            return true;
        }

        public boolean isAutoNameFromManifest() {
            return this.nameFromManifest;
        }

        @Override
        public char getHandleMementoDelimiter() {
            return '`';
        }

        @Override
        public ITypeRoot getTypeRoot() {
            return null;
        }

        @Override
        public IModule.IModuleReference[] getRequiredModules() throws JavaModelException {
            return ModuleDescriptionInfo.NO_REQUIRES;
        }

        @Override
        public void toStringContent(StringBuffer buffer, String lineDelimiter) throws JavaModelException {
            buffer.append("automatic module ");
            buffer.append(this.name);
        }
    }
}

