/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.env;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class AutomaticModuleNaming {
    private static final String AUTOMATIC_MODULE_NAME = "Automatic-Module-Name";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char[] determineAutomaticModuleName(String jarFileName) {
        try (JarFile jar = new JarFile(jarFileName);){
            Manifest manifest = jar.getManifest();
            if (manifest == null) return AutomaticModuleNaming.determineAutomaticModuleNameFromFileName(jarFileName, true, true);
            String automaticModuleName = manifest.getMainAttributes().getValue(AUTOMATIC_MODULE_NAME);
            if (automaticModuleName == null) return AutomaticModuleNaming.determineAutomaticModuleNameFromFileName(jarFileName, true, true);
            char[] cArray = automaticModuleName.toCharArray();
            return cArray;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return AutomaticModuleNaming.determineAutomaticModuleNameFromFileName(jarFileName, true, true);
    }

    public static char[] determineAutomaticModuleName(String fileName, boolean isFile, Manifest manifest) {
        String automaticModuleName;
        if (manifest != null && (automaticModuleName = manifest.getMainAttributes().getValue(AUTOMATIC_MODULE_NAME)) != null) {
            return automaticModuleName.toCharArray();
        }
        return AutomaticModuleNaming.determineAutomaticModuleNameFromFileName(fileName, true, isFile);
    }

    public static char[] determineAutomaticModuleNameFromManifest(Manifest manifest) {
        String automaticModuleName;
        if (manifest != null && (automaticModuleName = manifest.getMainAttributes().getValue(AUTOMATIC_MODULE_NAME)) != null) {
            return automaticModuleName.toCharArray();
        }
        return null;
    }

    public static char[] determineAutomaticModuleNameFromFileName(String name, boolean skipDirectory, boolean removeExtension) {
        int index;
        int start = 0;
        int end = name.length();
        if (skipDirectory) {
            index = name.lastIndexOf(File.separatorChar);
            start = index + 1;
        }
        if (removeExtension && (name.endsWith(".jar") || name.endsWith(".JAR"))) {
            end -= 4;
        }
        block0: for (index = start; index < end - 1; ++index) {
            char c;
            if (name.charAt(index) != '-' || name.charAt(index + 1) < '0' || name.charAt(index + 1) > '9') continue;
            for (int index2 = index + 2; index2 < end && (c = name.charAt(index2)) != '.'; ++index2) {
                if (c < '0' || c > '9') continue block0;
            }
            end = index;
            break;
        }
        StringBuilder sb = new StringBuilder(end - start);
        boolean needDot = false;
        for (int i = start; i < end; ++i) {
            char c = name.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                if (needDot) {
                    sb.append('.');
                    needDot = false;
                }
                sb.append(c);
                continue;
            }
            if (sb.length() <= 0) continue;
            needDot = true;
        }
        return sb.toString().toCharArray();
    }
}

