/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.List;
import java.util.function.BiPredicate;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FakedTrackingVariable;
import org.eclipse.jdt.internal.compiler.ast.RecordComponent;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.AnnotationContext;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;

public class MethodDeclaration
extends AbstractMethodDeclaration {
    public TypeReference returnType;
    public TypeParameter[] typeParameters;

    public MethodDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
        this.bits |= 0x100;
    }

    public void analyseCode(ClassScope classScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            TypeBinding returnTypeBinding;
            if (this.binding == null) {
                return;
            }
            if (!this.binding.isUsed() && !this.binding.isAbstract() && (this.binding.isPrivate() || (this.binding.modifiers & 0x30000000) == 0 && this.binding.isOrEnclosedByPrivateType()) && !classScope.referenceCompilationUnit().compilationResult.hasSyntaxError) {
                this.scope.problemReporter().unusedPrivateMethod(this);
            }
            if (this.binding.declaringClass.isEnum() && (this.selector == TypeConstants.VALUES || this.selector == TypeConstants.VALUEOF)) {
                return;
            }
            if (this.binding.isAbstract() || this.binding.isNative()) {
                return;
            }
            if (this.typeParameters != null && !this.scope.referenceCompilationUnit().compilationResult.hasSyntaxError) {
                for (TypeParameter typeParameter : this.typeParameters) {
                    if ((typeParameter.binding.modifiers & 0x8000000) != 0) continue;
                    this.scope.problemReporter().unusedTypeParameter(typeParameter);
                }
            }
            ExceptionHandlingFlowContext methodContext = new ExceptionHandlingFlowContext(flowContext, this, this.binding.thrownExceptions, null, this.scope, FlowInfo.DEAD_END);
            MethodDeclaration.analyseArguments(classScope.environment(), flowInfo, this.arguments, this.binding);
            BiPredicate<TypeBinding, ReferenceBinding> condition = (argType, declClass) -> {
                ReferenceBinding enclosingType = argType.enclosingType();
                return enclosingType != null && TypeBinding.equalsEquals(declClass, enclosingType.actualType());
            };
            boolean referencesGenericType = false;
            ReferenceBinding declaringClass = this.binding.declaringClass;
            if (declaringClass.isGenericType()) {
                if (condition.test(this.binding.returnType, declaringClass)) {
                    referencesGenericType = true;
                }
                if (!referencesGenericType && this.binding.parameters != null && this.arguments != null) {
                    int length = Math.min(this.binding.parameters.length, this.arguments.length);
                    for (int i = 0; i < length; ++i) {
                        if (!condition.test(this.binding.parameters[i], this.binding.declaringClass)) continue;
                        referencesGenericType = true;
                        break;
                    }
                }
            }
            if (this.binding.declaringClass instanceof MemberTypeBinding && !this.binding.declaringClass.isStatic() || referencesGenericType) {
                this.bits &= 0xFFFFFEFF;
            }
            if (this.statements != null) {
                CompilerOptions compilerOptions = this.scope.compilerOptions();
                boolean enableSyntacticNullAnalysisForFields = compilerOptions.enableSyntacticNullAnalysisForFields;
                int complaintLevel = (flowInfo.reachMode() & 3) == 0 ? 0 : 1;
                for (Statement stat : this.statements) {
                    if ((complaintLevel = stat.complainIfUnreachable(flowInfo, this.scope, complaintLevel, true)) < 2) {
                        flowInfo = stat.analyseCode(this.scope, methodContext, flowInfo);
                    }
                    if (enableSyntacticNullAnalysisForFields) {
                        methodContext.expireNullCheckedFieldInfo();
                    }
                    if (!compilerOptions.analyseResourceLeaks) continue;
                    FakedTrackingVariable.cleanUpUnassigned(this.scope, stat, flowInfo);
                }
            } else {
                this.bits &= 0xFFFFFEFF;
            }
            if ((returnTypeBinding = this.binding.returnType) == TypeBinding.VOID || this.isAbstract()) {
                if ((flowInfo.tagBits & 1) == 0) {
                    this.bits |= 0x40;
                }
            } else if (flowInfo != FlowInfo.DEAD_END) {
                this.scope.problemReporter().shouldReturn(returnTypeBinding, this);
            }
            methodContext.complainIfUnusedExceptionHandlers(this);
            this.scope.checkUnusedParameters(this.binding);
            if (!(this.binding.isStatic() || (this.bits & 0x100) == 0 || this.isDefaultMethod() || this.binding.isOverriding() || this.binding.isImplementing())) {
                if (this.binding.isPrivate() || this.binding.isFinal() || this.binding.declaringClass.isFinal()) {
                    this.scope.problemReporter().methodCanBeDeclaredStatic(this);
                } else {
                    this.scope.problemReporter().methodCanBePotentiallyDeclaredStatic(this);
                }
            }
            this.scope.checkUnclosedCloseables(flowInfo, null, null, null);
        }
        catch (AbortMethod e) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    @Override
    public void getAllAnnotationContexts(int targetType, List allAnnotationContexts) {
        TypeReference.AnnotationCollector collector = new TypeReference.AnnotationCollector(this.returnType, targetType, (List<AnnotationContext>)allAnnotationContexts);
        for (Annotation annotation : this.annotations) {
            annotation.traverse((ASTVisitor)collector, (BlockScope)null);
        }
    }

    public boolean hasNullTypeAnnotation(TypeReference.AnnotationPosition position) {
        return TypeReference.containsNullAnnotation(this.annotations) || this.returnType != null && this.returnType.hasNullTypeAnnotation(position);
    }

    @Override
    public boolean isDefaultMethod() {
        return (this.modifiers & 0x10000) != 0;
    }

    @Override
    public boolean isMethod() {
        return true;
    }

    @Override
    public RecordComponent getRecordComponent() {
        if (this.arguments != null && this.arguments.length != 0) {
            return null;
        }
        ClassScope skope = this.scope.classScope();
        TypeDeclaration typeDecl = skope.referenceContext;
        if (!typeDecl.isRecord()) {
            return null;
        }
        if (!skope.referenceContext.isRecord()) {
            return null;
        }
        RecordComponent[] recComps = typeDecl.recordComponents;
        if (recComps == null || recComps.length == 0) {
            return null;
        }
        for (RecordComponent recComp : recComps) {
            if (recComp == null || recComp.name == null || !CharOperation.equals(this.selector, recComp.name)) continue;
            return recComp;
        }
        return null;
    }

    @Override
    public void parseStatements(Parser parser, CompilationUnitDeclaration unit) {
        parser.parse(this, unit);
        this.containsSwitchWithTry = parser.switchWithTry;
    }

    @Override
    public StringBuffer printReturnType(int indent, StringBuffer output) {
        if (this.returnType == null) {
            return output;
        }
        return this.returnType.printExpression(0, output).append(' ');
    }

    @Override
    public void resolveStatements() {
        int bindingModifiers;
        long complianceLevel;
        RecordComponent recordComponent;
        if (this.returnType != null && this.binding != null) {
            this.bits |= this.returnType.bits & 0x100000;
            this.returnType.resolvedType = this.binding.returnType;
        }
        if ((recordComponent = this.getRecordComponent()) != null) {
            if (this.returnType != null && TypeBinding.notEquals(this.returnType.resolvedType, recordComponent.type.resolvedType)) {
                this.scope.problemReporter().recordIllegalAccessorReturnType(this.returnType, recordComponent.type.resolvedType);
            }
            if (this.typeParameters != null) {
                this.scope.problemReporter().recordAccessorMethodShouldNotBeGeneric(this);
            }
            if (this.binding != null) {
                if ((this.binding.modifiers & 1) == 0) {
                    this.scope.problemReporter().recordAccessorMethodShouldBePublic(this);
                }
                if ((this.binding.modifiers & 8) != 0) {
                    this.scope.problemReporter().recordAccessorMethodShouldNotBeStatic(this);
                }
            }
            if (this.thrownExceptions != null) {
                this.scope.problemReporter().recordAccessorMethodHasThrowsClause(this);
            }
        }
        if (CharOperation.equals(this.scope.enclosingSourceType().sourceName, this.selector)) {
            this.scope.problemReporter().methodWithConstructorName(this);
        }
        boolean returnsUndeclTypeVar = false;
        if (this.returnType != null && this.returnType.resolvedType instanceof TypeVariableBinding) {
            returnsUndeclTypeVar = true;
        }
        if (this.typeParameters != null) {
            for (TypeParameter typeParameter : this.typeParameters) {
                int i;
                this.bits |= typeParameter.bits & 0x100000;
                if (!returnsUndeclTypeVar || !TypeBinding.equalsEquals(this.typeParameters[i].binding, this.returnType.resolvedType)) continue;
                returnsUndeclTypeVar = false;
            }
        }
        CompilerOptions compilerOptions = this.scope.compilerOptions();
        if (this.binding != null && recordComponent == null && (complianceLevel = compilerOptions.complianceLevel) >= 0x310000L) {
            boolean hasUnresolvedArguments;
            int bindingModifiers2 = this.binding.modifiers;
            boolean hasOverrideAnnotation = (this.binding.tagBits & 0x2000000000000L) != 0L;
            boolean bl = hasUnresolvedArguments = (this.binding.tagBits & 0x200L) != 0L;
            if (hasOverrideAnnotation && !hasUnresolvedArguments) {
                if ((bindingModifiers2 & 0x10000008) != 0x10000000 && (complianceLevel < 0x320000L || (bindingModifiers2 & 0x20000008) != 0x20000000)) {
                    this.scope.problemReporter().methodMustOverride(this, complianceLevel);
                }
            } else if (!this.binding.declaringClass.isInterface()) {
                if ((bindingModifiers2 & 0x10000008) == 0x10000000) {
                    this.scope.problemReporter().missingOverrideAnnotation(this);
                } else if (complianceLevel >= 0x320000L && compilerOptions.reportMissingOverrideAnnotationForInterfaceMethodImplementation && this.binding.isImplementing()) {
                    this.scope.problemReporter().missingOverrideAnnotationForInterfaceMethodImplementation(this);
                }
            } else if (complianceLevel >= 0x320000L && compilerOptions.reportMissingOverrideAnnotationForInterfaceMethodImplementation && ((bindingModifiers2 & 0x10000008) == 0x10000000 || this.binding.isImplementing())) {
                this.scope.problemReporter().missingOverrideAnnotationForInterfaceMethodImplementation(this);
            }
        }
        switch (TypeDeclaration.kind(this.scope.referenceType().modifiers)) {
            case 3: {
                if (this.selector == TypeConstants.VALUES || this.selector == TypeConstants.VALUEOF) break;
            }
            case 1: 
            case 5: {
                if ((this.modifiers & 0x1000000) != 0) {
                    if ((this.modifiers & 0x100) != 0 || (this.modifiers & 0x400) != 0) break;
                    this.scope.problemReporter().methodNeedBody(this);
                    break;
                }
                if ((this.modifiers & 0x100) != 0 || (this.modifiers & 0x400) != 0) {
                    this.scope.problemReporter().methodNeedingNoBody(this);
                    break;
                }
                if (this.binding != null && !this.binding.isStatic() && !(this.binding.declaringClass instanceof LocalTypeBinding) && !returnsUndeclTypeVar) break;
                this.bits &= 0xFFFFFEFF;
                break;
            }
            case 2: {
                boolean isPrivateMethod;
                if (compilerOptions.sourceLevel < 0x340000L || (this.modifiers & 0x1000400) != 0x1000000) break;
                boolean bl = isPrivateMethod = compilerOptions.sourceLevel >= 0x350000L && (this.modifiers & 2) != 0;
                if (!isPrivateMethod && (this.modifiers & 0x10008) == 0) break;
                this.scope.problemReporter().methodNeedBody(this);
            }
        }
        super.resolveStatements();
        if (compilerOptions.getSeverity(0x20100000) != 256 && this.binding != null && ((bindingModifiers = this.binding.modifiers) & 0x30000000) == 0x10000000 && (this.bits & 0x10) == 0) {
            this.scope.problemReporter().overridesMethodWithoutSuperInvocation(this.binding);
        }
    }

    @Override
    public void traverse(ASTVisitor visitor, ClassScope classScope) {
        if (visitor.visit(this, classScope)) {
            int i;
            if (this.javadoc != null) {
                this.javadoc.traverse(visitor, this.scope);
            }
            if (this.annotations != null) {
                int annotationsLength = this.annotations.length;
                for (i = 0; i < annotationsLength; ++i) {
                    this.annotations[i].traverse(visitor, this.scope);
                }
            }
            if (this.typeParameters != null) {
                int typeParametersLength = this.typeParameters.length;
                for (i = 0; i < typeParametersLength; ++i) {
                    this.typeParameters[i].traverse(visitor, this.scope);
                }
            }
            if (this.returnType != null) {
                this.returnType.traverse(visitor, this.scope);
            }
            if (this.arguments != null) {
                int argumentLength = this.arguments.length;
                for (i = 0; i < argumentLength; ++i) {
                    this.arguments[i].traverse(visitor, this.scope);
                }
            }
            if (this.thrownExceptions != null) {
                int thrownExceptionsLength = this.thrownExceptions.length;
                for (i = 0; i < thrownExceptionsLength; ++i) {
                    this.thrownExceptions[i].traverse(visitor, this.scope);
                }
            }
            if (this.statements != null) {
                int statementsLength = this.statements.length;
                for (i = 0; i < statementsLength; ++i) {
                    this.statements[i].traverse(visitor, this.scope);
                }
            }
        }
        visitor.endVisit(this, classScope);
    }

    @Override
    public TypeParameter[] typeParameters() {
        return this.typeParameters;
    }
}

