/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.AnnotationBinding;
import org.eclipse.jdt.core.dom.BindingComparator;
import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.DefaultBindingResolver;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MemberValuePairBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.util.Util;

class MethodBinding
implements IMethodBinding {
    private static final int VALID_MODIFIERS = 68927;
    private static final ITypeBinding[] NO_TYPE_BINDINGS = new ITypeBinding[0];
    static final IVariableBinding[] NO_VARIABLE_BINDINGS = new IVariableBinding[0];
    protected org.eclipse.jdt.internal.compiler.lookup.MethodBinding binding;
    protected BindingResolver resolver;
    private volatile ITypeBinding[] parameterTypes;
    private volatile ITypeBinding[] exceptionTypes;
    private volatile String name;
    private volatile ITypeBinding declaringClass;
    private volatile ITypeBinding returnType;
    private volatile String key;
    private volatile ITypeBinding[] typeParameters;
    private volatile ITypeBinding[] typeArguments;
    private volatile IAnnotationBinding[] annotations;
    private volatile IAnnotationBinding[][] parameterAnnotations;

    MethodBinding(BindingResolver resolver, org.eclipse.jdt.internal.compiler.lookup.MethodBinding binding) {
        this.resolver = resolver;
        this.binding = binding;
    }

    @Override
    public boolean isAnnotationMember() {
        return this.getDeclaringClass().isAnnotation();
    }

    @Override
    public boolean isConstructor() {
        return this.binding.isConstructor();
    }

    @Override
    public boolean isCompactConstructor() {
        return this.binding.isCompactConstructor();
    }

    @Override
    public boolean isCanonicalConstructor() {
        return this.binding.isCanonicalConstructor();
    }

    @Override
    public boolean isDefaultConstructor() {
        ReferenceBinding declaringClassBinding = this.binding.declaringClass;
        if (declaringClassBinding.isRawType()) {
            RawTypeBinding rawTypeBinding = (RawTypeBinding)declaringClassBinding;
            if (rawTypeBinding.genericType().isBinaryBinding()) {
                return false;
            }
            return (this.binding.modifiers & 0x4000000) != 0;
        }
        if (declaringClassBinding.isBinaryBinding()) {
            return false;
        }
        return (this.binding.modifiers & 0x4000000) != 0;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.binding.isConstructor() ? this.getDeclaringClass().getName() : new String(this.binding.selector);
        }
        return this.name;
    }

    @Override
    public IAnnotationBinding[] getAnnotations() {
        if (this.annotations != null) {
            return this.annotations;
        }
        org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding[] internalAnnotations = this.binding.getAnnotations();
        this.annotations = this.filterTypeAnnotations(internalAnnotations);
        return this.annotations;
    }

    @Override
    public ITypeBinding getDeclaringClass() {
        if (this.declaringClass == null) {
            this.declaringClass = this.resolver.getTypeBinding(this.binding.declaringClass);
        }
        return this.declaringClass;
    }

    @Override
    public IBinding getDeclaringMember() {
        return null;
    }

    @Override
    public IAnnotationBinding[] getParameterAnnotations(int index) {
        if (this.getParameterTypes() == NO_TYPE_BINDINGS) {
            return AnnotationBinding.NoAnnotations;
        }
        if (this.parameterAnnotations != null) {
            return this.parameterAnnotations[index];
        }
        org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding[][] bindingAnnotations = this.binding.getParameterAnnotations();
        if (bindingAnnotations == null) {
            return AnnotationBinding.NoAnnotations;
        }
        int length = bindingAnnotations.length;
        IAnnotationBinding[][] domAnnotations = new IAnnotationBinding[length][];
        block0: for (int i = 0; i < length; ++i) {
            org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding[] paramBindingAnnotations = bindingAnnotations[i];
            int pLength = paramBindingAnnotations.length;
            domAnnotations[i] = new AnnotationBinding[pLength];
            for (int j = 0; j < pLength; ++j) {
                IAnnotationBinding domAnnotation = this.resolver.getAnnotationInstance(paramBindingAnnotations[j]);
                if (domAnnotation == null) {
                    domAnnotations[i] = AnnotationBinding.NoAnnotations;
                    continue block0;
                }
                domAnnotations[i][j] = domAnnotation;
            }
        }
        this.parameterAnnotations = domAnnotations;
        return this.parameterAnnotations[index];
    }

    @Override
    public ITypeBinding[] getParameterTypes() {
        int length;
        if (this.parameterTypes != null) {
            return this.parameterTypes;
        }
        TypeBinding[] parameters = this.binding.parameters;
        int n = length = parameters == null ? 0 : parameters.length;
        if (length == 0) {
            this.parameterTypes = NO_TYPE_BINDINGS;
            return NO_TYPE_BINDINGS;
        }
        ITypeBinding[] paramTypes = new ITypeBinding[length];
        for (int i = 0; i < length; ++i) {
            ITypeBinding typeBinding;
            TypeBinding parameterBinding = parameters[i];
            if (parameterBinding != null) {
                typeBinding = this.resolver.getTypeBinding(parameterBinding);
                if (typeBinding == null) {
                    this.parameterTypes = NO_TYPE_BINDINGS;
                    return NO_TYPE_BINDINGS;
                }
            } else {
                StringBuilder message = new StringBuilder("Report method binding where a parameter is null:\n");
                message.append(this.toString());
                Util.log(new IllegalArgumentException(), message.toString());
                this.parameterTypes = NO_TYPE_BINDINGS;
                return NO_TYPE_BINDINGS;
            }
            paramTypes[i] = typeBinding;
        }
        this.parameterTypes = paramTypes;
        return paramTypes;
    }

    @Override
    public ITypeBinding getDeclaredReceiverType() {
        return this.resolver.getTypeBinding(this.binding.receiver);
    }

    @Override
    public ITypeBinding getReturnType() {
        if (this.returnType == null) {
            this.returnType = this.resolver.getTypeBinding(this.binding.returnType);
        }
        return this.returnType;
    }

    protected IAnnotationBinding[] filterTypeAnnotations(org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding[] internalAnnotations) {
        int length;
        int n = length = internalAnnotations == null ? 0 : internalAnnotations.length;
        if (length != 0) {
            IAnnotationBinding[] tempAnnotations = new IAnnotationBinding[length];
            int convertedAnnotationCount = 0;
            boolean isConstructor = this.isConstructor();
            for (int i = 0; i < length; ++i) {
                IAnnotationBinding annotationInstance;
                org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding internalAnnotation = internalAnnotations[i];
                ReferenceBinding annotationType = internalAnnotation.getAnnotationType();
                long metaTagBits = annotationType.getAnnotationTagBits();
                if (isConstructor && (metaTagBits & 0x10000000000L) == 0L && (metaTagBits & 0x20600FF840000000L) != 0L || (annotationInstance = this.resolver.getAnnotationInstance(internalAnnotation)) == null) continue;
                tempAnnotations[convertedAnnotationCount++] = annotationInstance;
            }
            if (convertedAnnotationCount == length) {
                return tempAnnotations;
            }
            if (convertedAnnotationCount == 0) {
                return AnnotationBinding.NoAnnotations;
            }
            IAnnotationBinding[] iAnnotationBindingArray = tempAnnotations;
            tempAnnotations = new IAnnotationBinding[convertedAnnotationCount];
            System.arraycopy(iAnnotationBindingArray, 0, tempAnnotations, 0, convertedAnnotationCount);
            return tempAnnotations;
        }
        return AnnotationBinding.NoAnnotations;
    }

    @Override
    public Object getDefaultValue() {
        if (this.isAnnotationMember()) {
            return MemberValuePairBinding.buildDOMValue(this.binding.getDefaultValue(), this.resolver);
        }
        return null;
    }

    @Override
    public ITypeBinding[] getExceptionTypes() {
        int length;
        if (this.exceptionTypes != null) {
            return this.exceptionTypes;
        }
        ReferenceBinding[] exceptions = this.binding.thrownExceptions;
        int n = length = exceptions == null ? 0 : exceptions.length;
        if (length == 0) {
            this.exceptionTypes = NO_TYPE_BINDINGS;
            return NO_TYPE_BINDINGS;
        }
        ITypeBinding[] exTypes = new ITypeBinding[length];
        for (int i = 0; i < length; ++i) {
            ITypeBinding typeBinding = this.resolver.getTypeBinding(exceptions[i]);
            if (typeBinding == null) {
                this.exceptionTypes = NO_TYPE_BINDINGS;
                return NO_TYPE_BINDINGS;
            }
            exTypes[i] = typeBinding;
        }
        this.exceptionTypes = exTypes;
        return exTypes;
    }

    @Override
    public IJavaElement getJavaElement() {
        JavaElement element = this.getUnresolvedJavaElement();
        if (element == null) {
            return null;
        }
        return element.resolved(this.binding);
    }

    private JavaElement getUnresolvedJavaElement() {
        if (JavaCore.getPlugin() == null) {
            return null;
        }
        if (!(this.resolver instanceof DefaultBindingResolver)) {
            return null;
        }
        DefaultBindingResolver defaultBindingResolver = (DefaultBindingResolver)this.resolver;
        if (!defaultBindingResolver.fromJavaProject) {
            return null;
        }
        return Util.getUnresolvedJavaElement(this.binding, defaultBindingResolver.workingCopyOwner, defaultBindingResolver.getBindingsToNodesMap());
    }

    @Override
    public int getKind() {
        return 4;
    }

    @Override
    public int getModifiers() {
        return this.binding.getAccessFlags() & 0x10D3F;
    }

    @Override
    public boolean isDeprecated() {
        return this.binding.isDeprecated();
    }

    @Override
    public boolean isRecovered() {
        return false;
    }

    @Override
    public boolean isSynthetic() {
        return this.binding.isSynthetic();
    }

    @Override
    public boolean isVarargs() {
        return this.binding.isVarargs();
    }

    @Override
    public String getKey() {
        if (this.key == null) {
            this.key = new String(this.binding.computeUniqueKey());
        }
        return this.key;
    }

    @Override
    public boolean isEqualTo(IBinding other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof MethodBinding)) {
            return false;
        }
        org.eclipse.jdt.internal.compiler.lookup.MethodBinding otherBinding = ((MethodBinding)other).binding;
        return BindingComparator.isEqual(this.binding, otherBinding);
    }

    @Override
    public ITypeBinding[] getTypeParameters() {
        int typeVariableBindingsLength;
        if (this.typeParameters != null) {
            return this.typeParameters;
        }
        TypeVariableBinding[] typeVariableBindings = this.binding.typeVariables();
        int n = typeVariableBindingsLength = typeVariableBindings == null ? 0 : typeVariableBindings.length;
        if (typeVariableBindingsLength == 0) {
            this.typeParameters = NO_TYPE_BINDINGS;
            return NO_TYPE_BINDINGS;
        }
        ITypeBinding[] tParameters = new ITypeBinding[typeVariableBindingsLength];
        for (int i = 0; i < typeVariableBindingsLength; ++i) {
            ITypeBinding typeBinding = this.resolver.getTypeBinding(typeVariableBindings[i]);
            if (typeBinding == null) {
                this.typeParameters = NO_TYPE_BINDINGS;
                return NO_TYPE_BINDINGS;
            }
            tParameters[i] = typeBinding;
        }
        this.typeParameters = tParameters;
        return tParameters;
    }

    @Override
    public boolean isGenericMethod() {
        if (this.typeParameters != null) {
            return this.typeParameters.length > 0;
        }
        TypeVariableBinding[] typeVariableBindings = this.binding.typeVariables();
        return typeVariableBindings != null && typeVariableBindings.length > 0;
    }

    @Override
    public ITypeBinding[] getTypeArguments() {
        if (this.typeArguments != null) {
            return this.typeArguments;
        }
        if (this.binding instanceof ParameterizedGenericMethodBinding) {
            int typeArgumentsLength;
            ParameterizedGenericMethodBinding genericMethodBinding = (ParameterizedGenericMethodBinding)this.binding;
            TypeBinding[] typeArgumentsBindings = genericMethodBinding.typeArguments;
            int n = typeArgumentsLength = typeArgumentsBindings == null ? 0 : typeArgumentsBindings.length;
            if (typeArgumentsLength != 0) {
                ITypeBinding[] tArguments = new ITypeBinding[typeArgumentsLength];
                for (int i = 0; i < typeArgumentsLength; ++i) {
                    ITypeBinding typeBinding = this.resolver.getTypeBinding(typeArgumentsBindings[i]);
                    if (typeBinding == null) {
                        this.typeArguments = NO_TYPE_BINDINGS;
                        return NO_TYPE_BINDINGS;
                    }
                    tArguments[i] = typeBinding;
                }
                this.typeArguments = tArguments;
                return tArguments;
            }
        }
        this.typeArguments = NO_TYPE_BINDINGS;
        return NO_TYPE_BINDINGS;
    }

    @Override
    public boolean isParameterizedMethod() {
        return this.binding instanceof ParameterizedGenericMethodBinding && !((ParameterizedGenericMethodBinding)this.binding).isRaw;
    }

    @Override
    public boolean isRawMethod() {
        return this.binding instanceof ParameterizedGenericMethodBinding && ((ParameterizedGenericMethodBinding)this.binding).isRaw;
    }

    @Override
    public boolean isSubsignature(IMethodBinding otherMethod) {
        try {
            LookupEnvironment lookupEnvironment = this.resolver.lookupEnvironment();
            return lookupEnvironment != null && lookupEnvironment.methodVerifier().isMethodSubsignature(this.binding, ((MethodBinding)otherMethod).binding);
        }
        catch (AbortCompilation e) {
            return false;
        }
    }

    @Override
    public IMethodBinding getMethodDeclaration() {
        return this.resolver.getMethodBinding(this.binding.original());
    }

    @Override
    public boolean overrides(IMethodBinding otherMethod) {
        LookupEnvironment lookupEnvironment = this.resolver.lookupEnvironment();
        return lookupEnvironment != null && lookupEnvironment.methodVerifier().doesMethodOverride(this.binding, ((MethodBinding)otherMethod).binding);
    }

    @Override
    public String toString() {
        return this.binding.toString();
    }

    @Override
    public IVariableBinding[] getSyntheticOuterLocals() {
        return NO_VARIABLE_BINDINGS;
    }

    @Override
    public boolean isSyntheticRecordMethod() {
        return this.getDeclaringClass().isRecord() && this.binding instanceof SyntheticMethodBinding;
    }

    @Override
    public String[] getParameterNames() {
        return CharOperation.toStrings(this.binding.parameterNames);
    }

    static class LambdaMethod
    extends MethodBinding {
        private MethodBinding implementation;
        private IBinding declaringMember;
        private IVariableBinding[] syntheticOuterLocalVariables;

        public LambdaMethod(DefaultBindingResolver resolver, org.eclipse.jdt.internal.compiler.lookup.MethodBinding lambdaDescriptor, org.eclipse.jdt.internal.compiler.lookup.MethodBinding implementation, IBinding declaringMember) {
            super(resolver, lambdaDescriptor);
            this.implementation = new MethodBinding(resolver, implementation);
            this.declaringMember = declaringMember;
        }

        @Override
        public int getModifiers() {
            return super.getModifiers() & 0xFFFFFBFF;
        }

        @Override
        public String getKey() {
            return this.implementation.getKey();
        }

        @Override
        public ITypeBinding[] getParameterTypes() {
            return this.implementation.getParameterTypes();
        }

        @Override
        public IAnnotationBinding[] getParameterAnnotations(int paramIndex) {
            return this.implementation.getParameterAnnotations(paramIndex);
        }

        @Override
        public IAnnotationBinding[] getAnnotations() {
            return this.implementation.getAnnotations();
        }

        @Override
        public IBinding getDeclaringMember() {
            return this.declaringMember;
        }

        @Override
        public IMethodBinding getMethodDeclaration() {
            return this.resolver.getMethodBinding(this.binding);
        }

        @Override
        public String toString() {
            return super.toString().replace("public abstract ", "public ");
        }

        @Override
        public IVariableBinding[] getSyntheticOuterLocals() {
            if (this.syntheticOuterLocalVariables != null) {
                return this.syntheticOuterLocalVariables;
            }
            return NO_VARIABLE_BINDINGS;
        }

        public void setSyntheticOuterLocals(IVariableBinding[] syntheticOuterLocalVariables) {
            this.syntheticOuterLocalVariables = syntheticOuterLocalVariables;
        }
    }
}

