/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.CompilationGroup;
import org.eclipse.jdt.internal.core.builder.NameEnvironment;
import org.eclipse.jdt.internal.core.builder.ProblemFactory;

public class ModuleUtil {
    private static Compiler newCompiler(ModuleAccumulatorEnvironment environment, IJavaProject javaProject) {
        Map<String, String> projectOptions = javaProject.getOptions(true);
        CompilerOptions compilerOptions = new CompilerOptions(projectOptions);
        compilerOptions.performMethodsFullRecovery = true;
        compilerOptions.performStatementsRecovery = true;
        ICompilerRequestor requestor = new ICompilerRequestor(){

            @Override
            public void acceptResult(CompilationResult result) {
            }
        };
        Compiler newCompiler = new Compiler((INameEnvironment)environment, DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, requestor, (IProblemFactory)ProblemFactory.getProblemFactory(Locale.getDefault()));
        return newCompiler;
    }

    public static String[] getReferencedModules(IJavaProject project) throws CoreException {
        IPackageFragmentRoot[] roots;
        ModuleAccumulatorEnvironment environment = new ModuleAccumulatorEnvironment(project);
        Compiler compiler = ModuleUtil.newCompiler(environment, project);
        ArrayList required = new ArrayList();
        HashSet<BasicCompilationUnit> toCompile = new HashSet<BasicCompilationUnit>();
        for (IPackageFragmentRoot root : roots = project.getPackageFragmentRoots()) {
            IJavaElement[] children;
            if (root.getKind() != 1) continue;
            for (IJavaElement child : children = root.getChildren()) {
                org.eclipse.jdt.core.ICompilationUnit[] units;
                IPackageFragment fragment;
                if (!(child instanceof IPackageFragment) || (fragment = (IPackageFragment)child).isDefaultPackage() || (units = fragment.getCompilationUnits()).length == 0) continue;
                String pack = fragment.getElementName();
                for (org.eclipse.jdt.core.ICompilationUnit iUnit : units) {
                    BasicCompilationUnit sourceFile = new BasicCompilationUnit(iUnit.getSource().toCharArray(), CharOperation.splitOn('.', pack.toCharArray()), iUnit.getPath().toOSString(), iUnit);
                    toCompile.add(sourceFile);
                }
            }
        }
        ICompilationUnit[] sources = new ICompilationUnit[toCompile.size()];
        toCompile.toArray(sources);
        compiler.compile(sources);
        String[] mods = environment.getModules();
        Collections.addAll(required, mods);
        Collections.sort(required, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        return required.toArray(new String[required.size()]);
    }

    static class ModuleAccumulatorEnvironment
    extends NameEnvironment {
        Set<String> modules = new HashSet<String>();

        public ModuleAccumulatorEnvironment(IJavaProject javaProject) {
            super(javaProject, CompilationGroup.MAIN);
        }

        public String[] getModules() {
            this.modules.remove(String.valueOf(TypeConstants.JAVA_BASE));
            String[] mods = new String[this.modules.size()];
            return this.modules.toArray(mods);
        }

        @Override
        protected boolean isOnModulePath(ClasspathEntry entry) {
            return true;
        }

        @Override
        public void cleanup() {
            this.modules.clear();
        }

        @Override
        public NameEnvironmentAnswer findType(char[][] compoundTypeName, char[] moduleName) {
            NameEnvironmentAnswer answer = super.findType(compoundTypeName, moduleName);
            if (answer != null && answer.moduleName() != null) {
                this.modules.add(String.valueOf(answer.moduleName()));
            }
            return answer;
        }

        @Override
        public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName, char[] moduleName) {
            NameEnvironmentAnswer answer = super.findType(typeName, packageName, moduleName);
            if (answer != null && answer.moduleName() != null) {
                this.modules.add(String.valueOf(answer.moduleName()));
            }
            return answer;
        }
    }
}

