/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.jdt.internal.core.search.indexing.SaveIndex;
import org.eclipse.jdt.internal.core.search.processing.JobManager;
import org.eclipse.jdt.internal.core.util.Util;

public class IndexAllProject
extends IndexRequest {
    IProject project;

    public IndexAllProject(IProject project, IndexManager manager) {
        super(project.getFullPath(), manager);
        this.project = project;
    }

    public boolean equals(Object o) {
        if (o instanceof IndexAllProject) {
            return this.project.equals(((IndexAllProject)o).project);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(IProgressMonitor progressMonitor) {
        if (this.isCancelled || progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        if (!this.project.isAccessible()) {
            return true;
        }
        ReadWriteMonitor monitor = null;
        try {
            Index index;
            JavaProject javaProject = (JavaProject)JavaCore.create(this.project);
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            int length = entries.length;
            IClasspathEntry[] sourceEntries = new IClasspathEntry[length];
            int sourceEntriesNumber = 0;
            for (int i = 0; i < length; ++i) {
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() != 3) continue;
                sourceEntries[sourceEntriesNumber++] = entry;
            }
            if (sourceEntriesNumber == 0) {
                IPath projectPath = javaProject.getPath();
                for (int i = 0; i < length; ++i) {
                    IClasspathEntry entry = entries[i];
                    if (entry.getEntryKind() != 1 || !entry.getPath().equals((Object)projectPath)) continue;
                    this.manager.indexLibrary(projectPath, this.project, ((ClasspathEntry)entry).getLibraryIndexLocation());
                    boolean bl = true;
                    return bl;
                }
                Index index2 = this.manager.getIndexForUpdate(this.containerPath, true, true);
                if (index2 != null) {
                    this.manager.saveIndex(index2);
                }
                boolean entry = true;
                return entry;
            }
            if (sourceEntriesNumber != length) {
                IClasspathEntry[] iClasspathEntryArray = sourceEntries;
                sourceEntries = new IClasspathEntry[sourceEntriesNumber];
                System.arraycopy(iClasspathEntryArray, 0, sourceEntries, 0, sourceEntriesNumber);
            }
            if ((index = this.manager.getIndexForUpdate(this.containerPath, true, true)) == null) {
                boolean index2 = true;
                return index2;
            }
            monitor = index.monitor;
            if (monitor == null) {
                boolean index2 = true;
                return index2;
            }
            monitor.enterRead();
            String[] paths = index.queryDocumentNames("");
            int max = paths == null ? 0 : paths.length;
            final SimpleLookupTable indexedFileNames = new SimpleLookupTable(max == 0 ? 33 : max + 11);
            String OK = "OK";
            String DELETED = "DELETED";
            if (paths != null) {
                for (int i = 0; i < max; ++i) {
                    indexedFileNames.put(paths[i], "DELETED");
                }
            }
            final long indexLastModified = max == 0 ? 0L : index.getIndexLastModified();
            IWorkspaceRoot root = this.project.getWorkspace().getRoot();
            for (int i = 0; i < sourceEntriesNumber; ++i) {
                if (this.isCancelled) {
                    boolean bl = false;
                    return bl;
                }
                IClasspathEntry entry = sourceEntries[i];
                IResource sourceFolder = root.findMember(entry.getPath());
                if (sourceFolder == null) continue;
                final HashSet<IPath> outputs = new HashSet<IPath>();
                if (sourceFolder.getType() == 4) {
                    outputs.add(javaProject.getOutputLocation());
                    for (int j = 0; j < sourceEntriesNumber; ++j) {
                        IPath output = sourceEntries[j].getOutputLocation();
                        if (output == null) continue;
                        outputs.add(output);
                    }
                }
                final boolean hasOutputs = !outputs.isEmpty();
                final char[][] inclusionPatterns = ((ClasspathEntry)entry).fullInclusionPatternChars();
                final char[][] exclusionPatterns = ((ClasspathEntry)entry).fullExclusionPatternChars();
                if (max == 0) {
                    sourceFolder.accept(new IResourceProxyVisitor(){

                        public boolean visit(IResourceProxy proxy) {
                            if (IndexAllProject.this.isCancelled) {
                                return false;
                            }
                            switch (proxy.getType()) {
                                case 1: {
                                    if (Util.isJavaLikeFileName(proxy.getName())) {
                                        IFile file = (IFile)proxy.requestResource();
                                        if ((exclusionPatterns != null || inclusionPatterns != null) && Util.isExcluded((IResource)file, inclusionPatterns, exclusionPatterns)) {
                                            return false;
                                        }
                                        indexedFileNames.put(Util.relativePath(file.getFullPath(), 1), file);
                                    }
                                    return false;
                                }
                                case 2: {
                                    if (exclusionPatterns != null && inclusionPatterns == null && Util.isExcluded(proxy.requestFullPath(), inclusionPatterns, exclusionPatterns, true)) {
                                        return false;
                                    }
                                    if (!hasOutputs || !outputs.contains(proxy.requestFullPath())) break;
                                    return false;
                                }
                            }
                            return true;
                        }
                    }, 0);
                    continue;
                }
                sourceFolder.accept(new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy proxy) throws CoreException {
                        if (IndexAllProject.this.isCancelled) {
                            return false;
                        }
                        switch (proxy.getType()) {
                            case 1: {
                                if (Util.isJavaLikeFileName(proxy.getName())) {
                                    String relativePathString;
                                    IFile file = (IFile)proxy.requestResource();
                                    URI location = file.getLocationURI();
                                    if (location == null) {
                                        return false;
                                    }
                                    if ((exclusionPatterns != null || inclusionPatterns != null) && Util.isExcluded((IResource)file, inclusionPatterns, exclusionPatterns)) {
                                        return false;
                                    }
                                    indexedFileNames.put(relativePathString, indexedFileNames.get(relativePathString = Util.relativePath(file.getFullPath(), 1)) == null || indexLastModified < EFS.getStore((URI)location).fetchInfo().getLastModified() ? file : "OK");
                                }
                                return false;
                            }
                            case 2: {
                                if ((exclusionPatterns != null || inclusionPatterns != null) && Util.isExcluded(proxy.requestResource(), inclusionPatterns, exclusionPatterns)) {
                                    return false;
                                }
                                if (!hasOutputs || !outputs.contains(proxy.requestFullPath())) break;
                                return false;
                            }
                        }
                        return true;
                    }
                }, 0);
            }
            SourceElementParser parser = this.manager.getSourceElementParser(javaProject, null);
            Object[] names = indexedFileNames.keyTable;
            Object[] values = indexedFileNames.valueTable;
            int namesLength = names.length;
            for (int i = 0; i < namesLength; ++i) {
                String name = (String)names[i];
                if (name == null) continue;
                if (this.isCancelled) {
                    boolean exclusionPatterns = false;
                    return exclusionPatterns;
                }
                Object value = values[i];
                if (value == "OK") continue;
                if (value == "DELETED") {
                    this.manager.remove(name, this.containerPath);
                    continue;
                }
                this.manager.addSource((IFile)value, this.containerPath, parser);
            }
            this.manager.request(new SaveIndex(this.containerPath, this.manager));
        }
        catch (IOException | CoreException e) {
            if (JobManager.VERBOSE) {
                Util.verbose("-> failed to index " + this.project + " because of the following exception:", System.err);
                e.printStackTrace();
            }
            this.manager.removeIndex(this.containerPath);
            boolean bl = false;
            return bl;
        }
        finally {
            if (monitor != null) {
                monitor.exitRead();
            }
        }
        return true;
    }

    public int hashCode() {
        return this.project.hashCode();
    }

    @Override
    protected Integer updatedIndexState() {
        return IndexManager.REBUILDING_STATE;
    }

    public String toString() {
        return "indexing project " + this.project.getFullPath();
    }
}

