/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.nd.java.model;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JrtPackageFragmentRoot;
import org.eclipse.jdt.internal.core.ModularClassFile;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.nd.java.model.BinaryModuleDescriptor;
import org.eclipse.jdt.internal.core.nd.java.model.BinaryTypeFactory;

public class BinaryModuleFactory {
    public static BinaryModuleDescriptor createDescriptor(ModularClassFile modularClassFile) {
        return BinaryModuleFactory.createDescriptor(modularClassFile.getPackageFragmentRoot(), modularClassFile);
    }

    private static BinaryModuleDescriptor createDescriptor(PackageFragmentRoot root, ModularClassFile classFile) {
        Object indexPath;
        IPath location = BinaryTypeFactory.getLocationForElement(root);
        if (location == null) {
            return null;
        }
        String entryName = "module-info.class";
        IPath workspacePath = root.getPath();
        char[] moduleName = null;
        if (root instanceof JarPackageFragmentRoot) {
            entryName = ((JarPackageFragmentRoot)root).getClassFilePath(entryName);
            indexPath = root.getHandleIdentifier() + "|" + entryName;
            if (root instanceof JrtPackageFragmentRoot) {
                moduleName = root.getElementName().toCharArray();
            }
        } else {
            location = location.append(entryName);
            indexPath = workspacePath.append(entryName).toString();
            workspacePath = classFile.resource().getFullPath();
        }
        return new BinaryModuleDescriptor(location.toString().toCharArray(), moduleName, workspacePath.toString().toCharArray(), ((String)indexPath).toCharArray());
    }

    public static IBinaryModule readModule(BinaryModuleDescriptor descriptor, IProgressMonitor monitor) throws JavaModelException, ClassFormatException {
        return BinaryModuleFactory.rawReadModule(descriptor, true);
    }

    public static IBinaryModule rawReadModule(BinaryModuleDescriptor descriptor, boolean fullyInitialize) throws JavaModelException, ClassFormatException {
        try {
            return BinaryModuleFactory.rawReadModuleTestForExists(descriptor, fullyInitialize, true);
        }
        catch (FileNotFoundException e) {
            throw new JavaModelException(e, 985);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IBinaryModule rawReadModuleTestForExists(BinaryModuleDescriptor descriptor, boolean fullyInitialize, boolean useInvalidArchiveCache) throws JavaModelException, ClassFormatException, FileNotFoundException {
        byte[] contents;
        if (descriptor == null) {
            return null;
        }
        if (descriptor.isInJarFile()) {
            ZipFile zip = null;
            try {
                zip = JavaModelManager.getJavaModelManager().getZipFile((IPath)new Path(new String(descriptor.workspacePath)), useInvalidArchiveCache);
                String entryName = "module-info.class";
                ZipEntry ze = zip.getEntry(entryName);
                if (ze != null) {
                    void contents2;
                    try {
                        byte[] contents22 = Util.getZipEntryByteContent(ze, zip);
                    }
                    catch (IOException ioe) {
                        throw new JavaModelException(ioe, 985);
                    }
                    ClassFileReader classFileReader = new ClassFileReader((byte[])contents2, descriptor.indexPath, fullyInitialize);
                    IBinaryModule iBinaryModule = classFileReader.getModuleDeclaration();
                    JavaModelManager.getJavaModelManager().closeZipFile(zip);
                    return iBinaryModule;
                }
                JavaModelManager.getJavaModelManager().closeZipFile(zip);
                return null;
            }
            catch (CoreException e) {
                try {
                    throw new JavaModelException(e);
                }
                catch (Throwable throwable) {
                    JavaModelManager.getJavaModelManager().closeZipFile(zip);
                    throw throwable;
                }
            }
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(new String(descriptor.workspacePath)));
        try (InputStream stream = file.getContents(true);){
            contents = Util.getInputStreamAsByteArray(stream);
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            if (status.getCode() != 368) throw new JavaModelException(e);
            throw new FileNotFoundException();
        }
        catch (IOException e) {
            throw new JavaModelException(e, 985);
        }
        ClassFileReader classFileReader = new ClassFileReader(contents, file.getFullPath().toString().toCharArray(), fullyInitialize);
        return classFileReader.getModuleDeclaration();
    }
}

