/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.hierarchy;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.IGenericType;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.SourceTypeConverter;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.Member;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.hierarchy.BindingMap;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyBinaryType;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyBuilder;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyType;
import org.eclipse.jdt.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.jdt.internal.core.util.ASTNodeFinder;
import org.eclipse.jdt.internal.core.util.HandleFactory;

public class HierarchyResolver
implements ITypeRequestor {
    private ReferenceBinding focusType;
    private boolean superTypesOnly;
    private boolean hasMissingSuperClass;
    LookupEnvironment lookupEnvironment;
    private CompilerOptions options;
    HierarchyBuilder builder;
    private ReferenceBinding[] typeBindings;
    private BindingMap<IGenericType> bindingMap = new BindingMap();
    private int typeIndex;
    private IGenericType[] typeModels;
    private Parser basicParser;
    private static final CompilationUnitDeclaration FakeUnit;

    public HierarchyResolver(INameEnvironment nameEnvironment, Map settings, HierarchyBuilder builder, IProblemFactory problemFactory) {
        this.options = new CompilerOptions(settings);
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.exitAfterAllProblems();
        ProblemReporter problemReporter = new ProblemReporter(policy, this.options, problemFactory);
        LookupEnvironment environment = new LookupEnvironment(this, this.options, problemReporter, nameEnvironment);
        environment.mayTolerateMissingType = true;
        this.setEnvironment(environment, builder);
    }

    public HierarchyResolver(LookupEnvironment lookupEnvironment, HierarchyBuilder builder) {
        this.setEnvironment(lookupEnvironment, builder);
    }

    @Override
    public void accept(IBinaryType binaryType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        SubMonitor progressMonitor = this.builder.hierarchy.progressMonitor;
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.sanitizeBinaryType(binaryType);
        BinaryTypeBinding typeBinding = this.lookupEnvironment.createBinaryTypeFrom(binaryType, packageBinding, accessRestriction);
        try {
            this.remember(binaryType, (ReferenceBinding)typeBinding);
        }
        catch (AbortCompilation abortCompilation) {
            // empty catch block
        }
    }

    private void sanitizeBinaryType(IGenericType binaryType) {
        HierarchyBinaryType hierarchyBinaryType;
        if (binaryType instanceof HierarchyBinaryType && (hierarchyBinaryType = (HierarchyBinaryType)binaryType).getSuperclassName() == null) {
            hierarchyBinaryType.recordSuperclass(CharOperation.concatWith(TypeConstants.JAVA_LANG_OBJECT, '/'));
        }
    }

    @Override
    public void accept(ICompilationUnit sourceUnit, AccessRestriction accessRestriction) {
        if (CharOperation.equals(TypeConstants.MODULE_INFO_NAME, sourceUnit.getMainTypeName())) {
            CompilationResult unitResult = new CompilationResult(sourceUnit, 1, 1, this.options.maxProblemsPerUnit);
            CompilationUnitDeclaration parsedUnit = this.basicParser().dietParse(sourceUnit, unitResult);
            this.lookupEnvironment.buildTypeBindings(parsedUnit, accessRestriction);
            this.lookupEnvironment.completeTypeBindings(parsedUnit, true);
        } else {
            this.lookupEnvironment.problemReporter.abortDueToInternalError(new StringBuffer(Messages.accept_cannot).append(sourceUnit.getFileName()).toString());
        }
    }

    private Parser basicParser() {
        if (this.basicParser == null) {
            ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.options, new DefaultProblemFactory());
            this.basicParser = new Parser(problemReporter, false);
            this.basicParser.reportOnlyOneSyntaxError = true;
        }
        return this.basicParser;
    }

    @Override
    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        CompilationResult result;
        SubMonitor progressMonitor = this.builder.hierarchy.progressMonitor;
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        ISourceType sourceType = sourceTypes[0];
        while (sourceType.getEnclosingType() != null) {
            sourceType = sourceType.getEnclosingType();
        }
        CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(new ISourceType[]{sourceType}, 8 | (this.lookupEnvironment.globalOptions.sourceLevel >= 0x340000L ? 4 : 0), this.lookupEnvironment.problemReporter, result = new CompilationResult(sourceType.getFileName(), 1, 1, this.options.maxProblemsPerUnit));
        if (unit != null) {
            try {
                LookupEnvironment environment = packageBinding.environment;
                if (environment == null) {
                    environment = this.lookupEnvironment;
                }
                environment.buildTypeBindings(unit, accessRestriction);
                org.eclipse.jdt.core.ICompilationUnit cu = ((SourceTypeElementInfo)sourceType).getHandle().getCompilationUnit();
                this.rememberAllTypes(unit, cu, false);
                environment.completeTypeBindings(unit, true);
            }
            catch (AbortCompilation abortCompilation) {
                // empty catch block
            }
        }
    }

    private IType findSuperClass(IGenericType type, ReferenceBinding typeBinding) {
        ReferenceBinding superBinding = typeBinding.superclass();
        if (superBinding != null) {
            IGenericType typeModel;
            superBinding = (ReferenceBinding)superBinding.erasure();
            if (typeBinding.isHierarchyInconsistent()) {
                if (superBinding.problemId() == 1) {
                    this.hasMissingSuperClass = true;
                    this.builder.hierarchy.missingTypes.add(new String(superBinding.sourceName));
                    return null;
                }
                if (superBinding.id == 1) {
                    int separator;
                    char[] superclassName;
                    if (type instanceof IBinaryType) {
                        superclassName = ((IBinaryType)type).getSuperclassName();
                        separator = 47;
                    } else if (type instanceof ISourceType) {
                        superclassName = ((ISourceType)type).getSuperclassName();
                        separator = 46;
                    } else if (type instanceof HierarchyType) {
                        superclassName = ((HierarchyType)type).superclassName;
                        separator = 46;
                    } else {
                        return null;
                    }
                    if (superclassName != null) {
                        char[] simpleName;
                        int lastSeparator = CharOperation.lastIndexOf((char)separator, superclassName);
                        char[] cArray = simpleName = lastSeparator == -1 ? superclassName : CharOperation.subarray(superclassName, lastSeparator + 1, superclassName.length);
                        if (!CharOperation.equals(simpleName, TypeConstants.OBJECT)) {
                            this.hasMissingSuperClass = true;
                            this.builder.hierarchy.missingTypes.add(new String(simpleName));
                            return null;
                        }
                    }
                }
            }
            if ((typeModel = this.bindingMap.get(superBinding)) != null) {
                return this.builder.getHandle(typeModel, superBinding);
            }
        }
        return null;
    }

    private IType[] findSuperInterfaces(IGenericType type, ReferenceBinding typeBinding) {
        char separator;
        Object superInterfaceNames;
        if (type instanceof IBinaryType) {
            superInterfaceNames = ((IBinaryType)type).getInterfaceNames();
            separator = '/';
        } else if (type instanceof ISourceType) {
            ISourceType sourceType = (ISourceType)type;
            superInterfaceNames = sourceType.isAnonymous() ? (typeBinding.superInterfaces() != null && typeBinding.superInterfaces().length > 0 ? (Object)new char[][]{sourceType.getSuperclassName()} : sourceType.getInterfaceNames()) : (TypeDeclaration.kind(sourceType.getModifiers()) == 4 ? (Object)new char[][]{TypeConstants.CharArray_JAVA_LANG_ANNOTATION_ANNOTATION} : sourceType.getInterfaceNames());
            separator = '.';
        } else if (type instanceof HierarchyType) {
            HierarchyType hierarchyType = (HierarchyType)type;
            superInterfaceNames = hierarchyType.isAnonymous() ? (typeBinding.superInterfaces() != null && typeBinding.superInterfaces().length > 0 ? (Object)new char[][]{hierarchyType.superclassName} : hierarchyType.superInterfaceNames) : hierarchyType.superInterfaceNames;
            separator = '.';
        } else {
            return null;
        }
        ReferenceBinding[] interfaceBindings = typeBinding.superInterfaces();
        int bindingIndex = 0;
        int bindingLength = interfaceBindings == null ? 0 : interfaceBindings.length;
        int length = superInterfaceNames == null ? 0 : ((char[][])superInterfaceNames).length;
        IType[] superinterfaces = new IType[length];
        int index = 0;
        for (int i = 0; i < length; ++i) {
            int lastSeparator;
            int start;
            int lastDollar;
            char[] superInterfaceName = superInterfaceNames[i];
            int end = superInterfaceName.length;
            int genericStart = CharOperation.indexOf('<', superInterfaceName);
            if (genericStart != -1) {
                end = genericStart;
            }
            if ((lastDollar = CharOperation.lastIndexOf('$', superInterfaceName, start = (lastSeparator = CharOperation.lastIndexOf(separator, superInterfaceName, 0, end)) + 1)) != -1) {
                start = lastDollar + 1;
            }
            char[] simpleName = CharOperation.subarray(superInterfaceName, start, end);
            if (bindingIndex < bindingLength) {
                ReferenceBinding interfaceBinding = (ReferenceBinding)interfaceBindings[bindingIndex].erasure();
                if (CharOperation.equals(simpleName, interfaceBinding.sourceName)) {
                    IType handle;
                    ++bindingIndex;
                    IGenericType genericType = this.bindingMap.get(interfaceBinding);
                    if (genericType != null && (handle = this.builder.getHandle(genericType, interfaceBinding)) != null) {
                        superinterfaces[index++] = handle;
                        continue;
                    }
                }
            }
            this.builder.hierarchy.missingTypes.add(new String(simpleName));
        }
        if (index != length) {
            IType[] iTypeArray = superinterfaces;
            superinterfaces = new IType[index];
            System.arraycopy(iTypeArray, 0, superinterfaces, 0, index);
        }
        return superinterfaces;
    }

    private void fixSupertypeBindings() {
        for (int current = this.typeIndex; current >= 0; --current) {
            ReferenceBinding typeBinding = this.typeBindings[current];
            if ((typeBinding.tagBits & 0x20000L) == 0L) continue;
            if (typeBinding instanceof SourceTypeBinding) {
                int length;
                TypeBinding superclass;
                ClassScope scope;
                if (typeBinding instanceof LocalTypeBinding) {
                    TypeReference type;
                    LocalTypeBinding localTypeBinding = (LocalTypeBinding)typeBinding;
                    QualifiedAllocationExpression allocationExpression = localTypeBinding.scope.referenceContext.allocation;
                    if (allocationExpression != null && (type = allocationExpression.type) != null && type.resolvedType != null) {
                        localTypeBinding.setSuperClass((ReferenceBinding)type.resolvedType);
                        continue;
                    }
                }
                if ((scope = ((SourceTypeBinding)typeBinding).scope) == null) continue;
                TypeDeclaration typeDeclaration = scope.referenceContext;
                TypeReference superclassRef = typeDeclaration == null ? null : typeDeclaration.superclass;
                TypeBinding typeBinding2 = superclass = superclassRef == null ? null : superclassRef.resolvedType;
                if (superclass != null) {
                    superclass = superclass.closestMatch();
                }
                if (superclass instanceof ReferenceBinding && !this.subTypeOfType((ReferenceBinding)superclass, typeBinding)) {
                    ((SourceTypeBinding)typeBinding).setSuperClass((ReferenceBinding)superclass);
                }
                TypeReference[] superInterfaces = typeDeclaration == null ? null : typeDeclaration.superInterfaces;
                ReferenceBinding[] interfaceBindings = typeBinding.superInterfaces();
                if (superInterfaces == null || (length = superInterfaces.length) <= (interfaceBindings == null ? 0 : interfaceBindings.length)) continue;
                interfaceBindings = new ReferenceBinding[length];
                int index = 0;
                for (int i = 0; i < length; ++i) {
                    TypeBinding superInterface = superInterfaces[i].resolvedType;
                    if (superInterface != null) {
                        superInterface = superInterface.closestMatch();
                    }
                    if (!(superInterface instanceof ReferenceBinding) || this.subTypeOfType((ReferenceBinding)superInterface, typeBinding)) continue;
                    interfaceBindings[index++] = (ReferenceBinding)superInterface;
                }
                if (index < length) {
                    ReferenceBinding[] referenceBindingArray = interfaceBindings;
                    interfaceBindings = new ReferenceBinding[index];
                    System.arraycopy(referenceBindingArray, 0, interfaceBindings, 0, index);
                }
                ((SourceTypeBinding)typeBinding).setSuperInterfaces(interfaceBindings);
                continue;
            }
            if (!(typeBinding instanceof BinaryTypeBinding)) continue;
            try {
                typeBinding.superclass();
            }
            catch (AbortCompilation e) {
                ((BinaryTypeBinding)typeBinding).tagBits &= 0xFFFFFFFFFDFFFFFFL;
                this.builder.hierarchy.missingTypes.add(new String(typeBinding.superclass().sourceName()));
                this.hasMissingSuperClass = true;
            }
            try {
                typeBinding.superInterfaces();
                continue;
            }
            catch (AbortCompilation e) {
                ((BinaryTypeBinding)typeBinding).tagBits &= 0xFFFFFFFFFBFFFFFFL;
            }
        }
    }

    private void remember(IGenericType suppliedType, ReferenceBinding typeBinding) {
        if (typeBinding == null) {
            return;
        }
        if (++this.typeIndex == this.typeModels.length) {
            this.typeModels = new IGenericType[this.typeIndex * 2];
            System.arraycopy(this.typeModels, 0, this.typeModels, 0, this.typeIndex);
            this.typeBindings = new ReferenceBinding[this.typeIndex * 2];
            System.arraycopy(this.typeBindings, 0, this.typeBindings, 0, this.typeIndex);
        }
        this.typeModels[this.typeIndex] = suppliedType;
        this.typeBindings[this.typeIndex] = typeBinding;
        this.bindingMap.put(typeBinding, suppliedType);
    }

    private void remember(IType type, ReferenceBinding typeBinding) {
        if (((CompilationUnit)type.getCompilationUnit()).isOpen()) {
            try {
                IGenericType genericType = (IGenericType)((JavaElement)((Object)type)).getElementInfo();
                this.remember(genericType, typeBinding);
            }
            catch (JavaModelException e) {
                return;
            }
        }
        if (typeBinding == null) {
            return;
        }
        boolean isAnonymous = false;
        try {
            isAnonymous = type.isAnonymous();
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        if (typeBinding instanceof SourceTypeBinding) {
            TypeDeclaration typeDeclaration = ((SourceTypeBinding)typeBinding).scope.referenceType();
            char[] superclassName = null;
            TypeReference superclass = (typeDeclaration.bits & 0x200) != 0 ? typeDeclaration.allocation.type : typeDeclaration.superclass;
            if (superclass != null) {
                char[][] typeName = superclass.getTypeName();
                superclassName = typeName == null ? null : typeName[typeName.length - 1];
            }
            char[][] superInterfaceNames = null;
            TypeReference[] superInterfaces = typeDeclaration.superInterfaces;
            if (superInterfaces != null) {
                int length = superInterfaces.length;
                superInterfaceNames = new char[length][];
                for (int i = 0; i < length; ++i) {
                    TypeReference superInterface = superInterfaces[i];
                    char[][] typeName = superInterface.getTypeName();
                    superInterfaceNames[i] = typeName[typeName.length - 1];
                }
            }
            HierarchyType hierarchyType = new HierarchyType(type, typeDeclaration.name, typeDeclaration.binding.modifiers, superclassName, superInterfaceNames, isAnonymous);
            this.remember(hierarchyType, (ReferenceBinding)typeDeclaration.binding);
        } else {
            HierarchyType hierarchyType = new HierarchyType(type, typeBinding.sourceName(), typeBinding.modifiers, typeBinding.superclass().sourceName(), new char[][]{typeBinding.superInterfaces()[0].sourceName()}, isAnonymous);
            this.remember(hierarchyType, typeBinding);
        }
    }

    private void rememberAllTypes(CompilationUnitDeclaration parsedUnit, org.eclipse.jdt.core.ICompilationUnit cu, boolean includeLocalTypes) {
        TypeDeclaration[] types = parsedUnit.types;
        if (types != null) {
            for (TypeDeclaration type : types) {
                this.rememberWithMemberTypes(type, cu.getType(new String(type.name)));
            }
        }
        if (!includeLocalTypes || parsedUnit.localTypes.isEmpty() && parsedUnit.functionalExpressions == null) {
            return;
        }
        HandleFactory factory = new HandleFactory();
        HashSet existingElements = new HashSet(parsedUnit.localTypes.size() + parsedUnit.functionalExpressionsCount);
        HashMap knownScopes = new HashMap(parsedUnit.localTypes.size() + parsedUnit.functionalExpressionsCount);
        for (LocalTypeBinding localType : parsedUnit.localTypes.values()) {
            ClassScope classScope = localType.scope;
            TypeDeclaration typeDecl = classScope.referenceType();
            IType typeHandle = (IType)factory.createElement(classScope, cu, existingElements, knownScopes);
            this.rememberWithMemberTypes(typeDecl, typeHandle);
        }
        if (parsedUnit.functionalExpressions != null) {
            for (int i = 0; i < parsedUnit.functionalExpressionsCount; ++i) {
                if (!(parsedUnit.functionalExpressions[i] instanceof LambdaExpression)) continue;
                LambdaExpression expression = (LambdaExpression)parsedUnit.functionalExpressions[i];
                if (expression.resolvedType == null || !expression.resolvedType.isValidBinding()) continue;
                IType typeHandle = (IType)factory.createLambdaTypeElement(expression, cu, existingElements, knownScopes);
                this.remember(typeHandle, expression.getTypeBinding());
            }
        }
    }

    private void rememberWithMemberTypes(TypeDeclaration typeDecl, IType typeHandle) {
        this.remember(typeHandle, (ReferenceBinding)typeDecl.binding);
        TypeDeclaration[] memberTypes = typeDecl.memberTypes;
        if (memberTypes != null) {
            for (TypeDeclaration memberType : memberTypes) {
                this.rememberWithMemberTypes(memberType, typeHandle.getType(new String(memberType.name)));
            }
        }
    }

    private void reportHierarchy(IType focus, TypeDeclaration focusLocalType, ReferenceBinding binaryTypeBinding) {
        if (focus != null) {
            if (binaryTypeBinding != null) {
                this.focusType = binaryTypeBinding;
            } else if (focusLocalType != null) {
                this.focusType = focusLocalType.binding;
            } else {
                char[] fullyQualifiedName = focus.getFullyQualifiedName().toCharArray();
                this.setFocusType(CharOperation.splitOn('.', fullyQualifiedName));
            }
        }
        this.fixSupertypeBindings();
        int objectIndex = -1;
        SubMonitor progressMonitor = this.builder.hierarchy.progressMonitor;
        for (int current = this.typeIndex; current >= 0; --current) {
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            ReferenceBinding typeBinding = this.typeBindings[current];
            if (typeBinding.id == 1) {
                objectIndex = current;
                continue;
            }
            IGenericType suppliedType = this.typeModels[current];
            if (!this.subOrSuperOfFocus(typeBinding)) continue;
            IType superclass = typeBinding.isInterface() ? null : this.findSuperClass(suppliedType, typeBinding);
            IType[] superinterfaces = this.findSuperInterfaces(suppliedType, typeBinding);
            this.builder.connect(suppliedType, this.builder.getHandle(suppliedType, typeBinding), superclass, superinterfaces);
        }
        if (!(objectIndex <= -1 || this.hasMissingSuperClass && this.focusType != null)) {
            IGenericType objectType = this.typeModels[objectIndex];
            this.builder.connect(objectType, this.builder.getHandle(objectType, this.typeBindings[objectIndex]), null, null);
        }
    }

    private void reset() {
        this.lookupEnvironment.reset();
        this.focusType = null;
        this.superTypesOnly = false;
        this.typeIndex = -1;
        this.typeModels = new IGenericType[5];
        this.typeBindings = new ReferenceBinding[5];
        this.bindingMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve(IGenericType suppliedType) {
        try {
            if (suppliedType.isBinaryType()) {
                int startIndex;
                this.sanitizeBinaryType(suppliedType);
                BinaryTypeBinding binaryTypeBinding = this.lookupEnvironment.cacheBinaryType((IBinaryType)suppliedType, false, null);
                this.remember(suppliedType, (ReferenceBinding)binaryTypeBinding);
                for (int i = startIndex = this.typeIndex; i <= this.typeIndex; ++i) {
                    IGenericType igType = this.typeModels[i];
                    if (igType == null || !igType.isBinaryType()) continue;
                    CompilationUnitDeclaration previousUnitBeingCompleted = this.lookupEnvironment.unitBeingCompleted;
                    try {
                        if (previousUnitBeingCompleted == null) {
                            this.lookupEnvironment.unitBeingCompleted = FakeUnit;
                        }
                        ReferenceBinding typeBinding = this.typeBindings[i];
                        typeBinding.superclass();
                        typeBinding.superInterfaces();
                        continue;
                    }
                    catch (AbortCompilation abortCompilation) {
                        continue;
                    }
                    finally {
                        this.lookupEnvironment.unitBeingCompleted = previousUnitBeingCompleted;
                    }
                }
                this.superTypesOnly = true;
                this.reportHierarchy(this.builder.getType(), null, binaryTypeBinding);
            } else {
                org.eclipse.jdt.core.ICompilationUnit cu = ((SourceTypeElementInfo)suppliedType).getHandle().getCompilationUnit();
                if (cu != null) {
                    HashSet<String> localTypes = new HashSet<String>();
                    localTypes.add(cu.getPath().toString());
                    this.superTypesOnly = true;
                    this.resolve(new Openable[]{(Openable)((Object)cu)}, localTypes, null);
                }
            }
        }
        catch (AbortCompilation abortCompilation) {
        }
        finally {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve(Openable[] openables, HashSet localTypes, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        try {
            char[] fullyQualifiedName;
            CompilationUnitDeclaration parsedUnit;
            int openablesLength = openables.length;
            CompilationUnitDeclaration[] parsedUnits = new CompilationUnitDeclaration[openablesLength];
            boolean[] hasLocalType = new boolean[openablesLength];
            org.eclipse.jdt.core.ICompilationUnit[] cus = new org.eclipse.jdt.core.ICompilationUnit[openablesLength];
            int unitsIndex = 0;
            CompilationUnitDeclaration focusUnit = null;
            ReferenceBinding focusBinaryBinding = null;
            IType focus = this.builder.getType();
            Openable focusOpenable = null;
            if (focus != null) {
                focusOpenable = focus.isBinary() ? (Openable)((Object)focus.getClassFile()) : (Openable)((Object)focus.getCompilationUnit());
            }
            subMonitor.split(1);
            Parser parser = new Parser(this.lookupEnvironment.problemReporter, true);
            boolean isJava8 = this.options.sourceLevel >= 0x340000L;
            for (int i = 0; i < openablesLength; ++i) {
                Openable openable = openables[i];
                if (openable instanceof org.eclipse.jdt.core.ICompilationUnit) {
                    org.eclipse.jdt.core.ICompilationUnit cu = (org.eclipse.jdt.core.ICompilationUnit)((Object)openable);
                    boolean containsLocalType = false;
                    if (localTypes == null) {
                        containsLocalType = true;
                    } else {
                        IPath path = cu.getPath();
                        containsLocalType = cu.isWorkingCopy() ? true : localTypes.contains(path.toString());
                    }
                    parsedUnit = null;
                    if (cu.isOpen()) {
                        CompilationResult result = new CompilationResult((ICompilationUnit)((Object)cu), i, openablesLength, this.options.maxProblemsPerUnit);
                        ISourceType[] typeInfos = null;
                        try {
                            IType[] topLevelTypes = cu.getTypes();
                            int topLevelLength = topLevelTypes.length;
                            if (topLevelLength == 0) continue;
                            typeInfos = new SourceTypeElementInfo[topLevelLength];
                            for (int j = 0; j < topLevelLength; ++j) {
                                IType topLevelType = topLevelTypes[j];
                                typeInfos[j] = (SourceTypeElementInfo)((JavaElement)((Object)topLevelType)).getElementInfo();
                            }
                        }
                        catch (JavaModelException topLevelTypes) {
                            // empty catch block
                        }
                        int flags = !containsLocalType ? 8 | (isJava8 ? 4 : 0) : 47;
                        parsedUnit = SourceTypeConverter.buildCompilationUnit(typeInfos, flags, this.lookupEnvironment.problemReporter, result);
                        if (containsLocalType && parsedUnit != null) {
                            parsedUnit.bits |= 0x10;
                        }
                    } else {
                        IFile file = (IFile)cu.getResource();
                        ICompilationUnit sourceUnit = this.builder.createCompilationUnitFromPath(openable, file, this.findAssociatedModuleName(openable));
                        CompilationResult unitResult = new CompilationResult(sourceUnit, i, openablesLength, this.options.maxProblemsPerUnit);
                        parsedUnit = parser.dietParse(sourceUnit, unitResult);
                    }
                    if (parsedUnit == null) continue;
                    hasLocalType[unitsIndex] = containsLocalType;
                    cus[unitsIndex] = cu;
                    parsedUnits[unitsIndex++] = parsedUnit;
                    try {
                        this.lookupEnvironment.buildTypeBindings(parsedUnit, null);
                        if (!openable.equals(focusOpenable)) continue;
                        focusUnit = parsedUnit;
                    }
                    catch (AbortCompilation file) {}
                    continue;
                }
                ClassFile classFile = (ClassFile)openable;
                IBinaryType binaryType = (IBinaryType)JavaModelManager.getJavaModelManager().getInfo(classFile.getType());
                if (binaryType == null) {
                    if (classFile.getPackageFragmentRoot().isArchive()) {
                        binaryType = this.builder.createInfoFromClassFileInJar(classFile);
                    } else {
                        IResource file = classFile.resource();
                        binaryType = this.builder.createInfoFromClassFile(classFile, file);
                    }
                }
                if (binaryType == null) continue;
                try {
                    this.sanitizeBinaryType(binaryType);
                    BinaryTypeBinding binaryTypeBinding = this.lookupEnvironment.cacheBinaryType(binaryType, false, null);
                    this.remember(binaryType, (ReferenceBinding)binaryTypeBinding);
                    if (!openable.equals(focusOpenable)) continue;
                    focusBinaryBinding = binaryTypeBinding;
                    continue;
                }
                catch (AbortCompilation binaryTypeBinding) {
                    // empty catch block
                }
            }
            TypeDeclaration focusLocalType = null;
            if (focus != null && focusBinaryBinding == null && focusUnit != null && ((Member)((Object)focus)).getOuterMostLocalContext() != null) {
                focusLocalType = new ASTNodeFinder(focusUnit).findType(focus);
            }
            for (int i = 0; i <= this.typeIndex; ++i) {
                IGenericType suppliedType = this.typeModels[i];
                if (suppliedType == null || !suppliedType.isBinaryType()) continue;
                CompilationUnitDeclaration previousUnitBeingCompleted = this.lookupEnvironment.unitBeingCompleted;
                try {
                    if (previousUnitBeingCompleted == null) {
                        this.lookupEnvironment.unitBeingCompleted = FakeUnit;
                    }
                    ReferenceBinding typeBinding = this.typeBindings[i];
                    typeBinding.superclass();
                    typeBinding.superInterfaces();
                    continue;
                }
                catch (AbortCompilation typeBinding) {
                    continue;
                }
                finally {
                    this.lookupEnvironment.unitBeingCompleted = previousUnitBeingCompleted;
                }
            }
            SubMonitor unitLoopMonitor = subMonitor.split(1).setWorkRemaining(unitsIndex);
            for (int i = 0; i < unitsIndex; ++i) {
                unitLoopMonitor.split(1);
                CompilationUnitDeclaration parsedUnit2 = parsedUnits[i];
                if (parsedUnit2 == null) continue;
                try {
                    if (!hasLocalType[i]) continue;
                    parser.getMethodBodies(parsedUnit2);
                    continue;
                }
                catch (AbortCompilation e) {
                    hasLocalType[i] = false;
                }
            }
            try {
                SubMonitor completeLoopMonitor = subMonitor.split(1).setWorkRemaining(unitsIndex);
                this.lookupEnvironment.completeTypeBindings(parsedUnits, hasLocalType, unitsIndex);
                for (int i = 0; i < unitsIndex; ++i) {
                    completeLoopMonitor.split(1);
                    parsedUnit = parsedUnits[i];
                    if (parsedUnit == null) continue;
                    boolean containsLocalType = hasLocalType[i];
                    if (containsLocalType) {
                        parsedUnit.scope.faultInTypes();
                        parsedUnit.resolve();
                    }
                    this.rememberAllTypes(parsedUnit, cus[i], containsLocalType);
                }
            }
            catch (AbortCompilation completeLoopMonitor) {
                // empty catch block
            }
            if (focusBinaryBinding == null && focus != null && focus.isBinary() && ((focusBinaryBinding = this.lookupEnvironment.getCachedType(CharOperation.splitOn('.', fullyQualifiedName = focus.getFullyQualifiedName().toCharArray()))) == null || (focusBinaryBinding.tagBits & 0x2000000L) != 0L)) {
                return;
            }
            this.reportHierarchy(focus, focusLocalType, focusBinaryBinding);
        }
        catch (ClassCastException openablesLength) {
        }
        catch (AbortCompilation e) {
            if (TypeHierarchy.DEBUG) {
                e.printStackTrace();
            }
        }
        finally {
            this.reset();
        }
    }

    private char[] findAssociatedModuleName(Openable openable) {
        IJavaElement module = null;
        PackageFragmentRoot root = openable.getPackageFragmentRoot();
        try {
            module = root.getKind() == 1 ? root.getJavaProject().getModuleDescription() : root.getModuleDescription();
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        if (module != null) {
            return module.getElementName().toCharArray();
        }
        return null;
    }

    private void setEnvironment(LookupEnvironment lookupEnvironment, HierarchyBuilder builder) {
        this.lookupEnvironment = lookupEnvironment;
        this.builder = builder;
        this.typeIndex = -1;
        this.typeModels = new IGenericType[5];
        this.typeBindings = new ReferenceBinding[5];
        this.bindingMap.clear();
    }

    public ReferenceBinding setFocusType(char[][] compoundName) {
        if (compoundName == null || this.lookupEnvironment == null) {
            return null;
        }
        this.focusType = this.lookupEnvironment.getCachedType(compoundName);
        if (this.focusType == null) {
            int length;
            char[] typeName;
            int firstDollar;
            this.focusType = this.lookupEnvironment.askForType(compoundName, this.lookupEnvironment.UnNamedModule);
            if (this.focusType == null && (firstDollar = CharOperation.indexOf('$', typeName = compoundName[(length = compoundName.length) - 1])) != -1) {
                compoundName[length - 1] = CharOperation.subarray(typeName, 0, firstDollar);
                this.focusType = this.lookupEnvironment.askForType(compoundName, this.lookupEnvironment.UnNamedModule);
                if (this.focusType != null) {
                    char[][] memberTypeNames = CharOperation.splitOn('$', typeName, firstDollar + 1, typeName.length);
                    for (int i = 0; i < memberTypeNames.length; ++i) {
                        this.focusType = this.focusType.getMemberType(memberTypeNames[i]);
                        if (this.focusType != null) continue;
                        return null;
                    }
                }
            }
        }
        return this.focusType;
    }

    public boolean subOrSuperOfFocus(ReferenceBinding typeBinding) {
        if (this.focusType == null) {
            return true;
        }
        try {
            if (this.subTypeOfType(this.focusType, typeBinding)) {
                return true;
            }
            if (!this.superTypesOnly && this.subTypeOfType(typeBinding, this.focusType)) {
                return true;
            }
        }
        catch (AbortCompilation abortCompilation) {
            // empty catch block
        }
        return false;
    }

    private boolean subTypeOfType(ReferenceBinding subType, ReferenceBinding typeBinding) {
        if (typeBinding == null || subType == null) {
            return false;
        }
        if (TypeBinding.equalsEquals(subType, typeBinding)) {
            return true;
        }
        ReferenceBinding superclass = subType.superclass();
        if (superclass != null) {
            superclass = (ReferenceBinding)superclass.erasure();
        }
        if (this.subTypeOfType(superclass, typeBinding)) {
            return true;
        }
        ReferenceBinding[] superInterfaces = subType.superInterfaces();
        if (superInterfaces != null) {
            int length = superInterfaces.length;
            for (int i = 0; i < length; ++i) {
                ReferenceBinding superInterface = (ReferenceBinding)superInterfaces[i].erasure();
                if (superInterface.isHierarchyInconsistent()) {
                    return false;
                }
                if (!this.subTypeOfType(superInterface, typeBinding)) continue;
                return true;
            }
        }
        return false;
    }

    protected void worked(IProgressMonitor monitor, int work) {
        if (monitor != null) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.worked(work);
        }
    }

    static {
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.exitAfterAllProblems();
        ProblemReporter problemReporter = new ProblemReporter(policy, new CompilerOptions(), new DefaultProblemFactory());
        CompilationResult result = new CompilationResult(CharOperation.NO_CHAR, 0, 0, 0);
        FakeUnit = new CompilationUnitDeclaration(problemReporter, result, 0);
    }
}

