/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.dom.rewrite.imports;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.dom.rewrite.imports.ConflictingSimpleNameFinder;

final class StaticConflictingSimpleNameFinder
implements ConflictingSimpleNameFinder {
    private final IJavaProject project;

    private static boolean isStaticImportableMember(int memberFlags) {
        return (Flags.isStatic(memberFlags) || Flags.isEnum(memberFlags)) && !Flags.isPrivate(memberFlags);
    }

    StaticConflictingSimpleNameFinder(IJavaProject project) {
        this.project = project;
    }

    @Override
    public Set<String> findConflictingSimpleNames(Set<String> simpleNames, Set<String> onDemandAndImplicitContainerNames, IProgressMonitor monitor) throws JavaModelException {
        HashSet<String> memberNamesFoundInMultipleTypes = new HashSet<String>();
        HashSet<String> foundMemberNames = new HashSet<String>();
        for (String containerName : onDemandAndImplicitContainerNames) {
            IType containingType = this.project.findType(containerName, monitor);
            if (containingType == null || !containingType.exists()) continue;
            for (String memberName : this.extractStaticMemberNames(containingType)) {
                if (!simpleNames.contains(memberName)) continue;
                if (foundMemberNames.contains(memberName)) {
                    memberNamesFoundInMultipleTypes.add(memberName);
                    continue;
                }
                foundMemberNames.add(memberName);
            }
        }
        return memberNamesFoundInMultipleTypes;
    }

    private Set<String> extractStaticMemberNames(IType type) throws JavaModelException {
        HashSet<String> memberNames = new HashSet<String>();
        for (IField iField : type.getFields()) {
            if (!StaticConflictingSimpleNameFinder.isStaticImportableMember(iField.getFlags())) continue;
            memberNames.add(iField.getElementName());
        }
        for (IAnnotatable iAnnotatable : type.getMethods()) {
            if (!StaticConflictingSimpleNameFinder.isStaticImportableMember(iAnnotatable.getFlags())) continue;
            memberNames.add(iAnnotatable.getElementName());
        }
        return memberNames;
    }
}

