/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.AbstractAnnotationProcessorManager;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.core.CompilationGroup;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.builder.BatchImageBuilder;
import org.eclipse.jdt.internal.core.builder.BuildNotifier;
import org.eclipse.jdt.internal.core.builder.ClasspathMultiDirectory;
import org.eclipse.jdt.internal.core.builder.CompilationParticipantResult;
import org.eclipse.jdt.internal.core.builder.ICompilationUnitLocator;
import org.eclipse.jdt.internal.core.builder.ImageBuilderInternalException;
import org.eclipse.jdt.internal.core.builder.JavaBuilder;
import org.eclipse.jdt.internal.core.builder.NameEnvironment;
import org.eclipse.jdt.internal.core.builder.ProblemFactory;
import org.eclipse.jdt.internal.core.builder.ReferenceCollection;
import org.eclipse.jdt.internal.core.builder.SourceFile;
import org.eclipse.jdt.internal.core.builder.State;
import org.eclipse.jdt.internal.core.builder.WorkQueue;
import org.eclipse.jdt.internal.core.util.Messages;
import org.eclipse.jdt.internal.core.util.Util;

public abstract class AbstractImageBuilder
implements ICompilerRequestor,
ICompilationUnitLocator {
    protected JavaBuilder javaBuilder;
    protected State newState;
    protected NameEnvironment nameEnvironment;
    protected ClasspathMultiDirectory[] sourceLocations;
    protected BuildNotifier notifier;
    protected Compiler compiler;
    protected WorkQueue workQueue;
    protected LinkedHashSet<SourceFile> problemSourceFiles;
    protected boolean compiledAllAtOnce;
    private boolean inCompiler;
    protected boolean keepStoringProblemMarkers;
    protected Set<SourceFile> filesWithAnnotations = null;
    public static int MAX_AT_ONCE = Integer.getInteger("maxCompiledUnitsAtOnce", 2000);
    public static final String[] JAVA_PROBLEM_MARKER_ATTRIBUTE_NAMES = new String[]{"message", "severity", "id", "charStart", "charEnd", "lineNumber", "arguments", "categoryId"};
    public static final Integer S_ERROR = 2;
    public static final Integer S_WARNING = 1;
    public static final Integer S_INFO = 0;
    public static final Integer P_HIGH = 2;
    public static final Integer P_NORMAL = 1;
    public static final Integer P_LOW = 0;
    private CompilationGroup compilationGroup;

    protected AbstractImageBuilder(JavaBuilder javaBuilder, boolean buildStarting, State newState, CompilationGroup compilationGroup) {
        this.javaBuilder = javaBuilder;
        this.compilationGroup = compilationGroup;
        this.nameEnvironment = compilationGroup == CompilationGroup.TEST ? javaBuilder.testNameEnvironment : javaBuilder.nameEnvironment;
        this.sourceLocations = this.nameEnvironment.sourceLocations;
        this.notifier = javaBuilder.notifier;
        this.keepStoringProblemMarkers = true;
        if (buildStarting) {
            this.newState = newState == null ? new State(javaBuilder) : newState;
            this.compiler = this.newCompiler();
            this.workQueue = new WorkQueue();
            this.problemSourceFiles = new LinkedHashSet(3);
            if (this.javaBuilder.participants != null) {
                int l = this.javaBuilder.participants.length;
                for (int i = 0; i < l; ++i) {
                    if (!this.javaBuilder.participants[i].isAnnotationProcessor()) continue;
                    this.filesWithAnnotations = new HashSet<SourceFile>(1);
                    break;
                }
            }
        }
    }

    @Override
    public void acceptResult(CompilationResult result) {
        ICompilationUnit resultCU = result.getCompilationUnit();
        if (!(resultCU instanceof SourceFile)) {
            return;
        }
        SourceFile compilationUnit = (SourceFile)resultCU;
        if (!this.workQueue.isCompiled(compilationUnit)) {
            this.workQueue.finished(compilationUnit);
            try {
                this.updateProblemsFor(compilationUnit, result);
                this.updateTasksFor(compilationUnit, result);
            }
            catch (CoreException e) {
                throw this.internalException(e);
            }
            if (result.hasInconsistentToplevelHierarchies) {
                this.problemSourceFiles.add(compilationUnit);
            }
            IType mainType = null;
            String mainTypeName = null;
            String typeLocator = compilationUnit.typeLocator();
            ClassFile[] classFiles = result.getClassFiles();
            int length = classFiles.length;
            ArrayList<char[][]> duplicateTypeNames = null;
            ArrayList<char[]> definedTypeNames = new ArrayList<char[]>(length);
            for (int i = 0; i < length; ++i) {
                String qualifiedTypeName;
                ClassFile classFile = classFiles[i];
                char[][] compoundName = classFile.getCompoundName();
                char[] typeName = compoundName[compoundName.length - 1];
                boolean isNestedType = classFile.isNestedType;
                if (isNestedType) {
                    qualifiedTypeName = new String(classFile.outerMostEnclosingClassFile().fileName());
                    if (this.newState.isDuplicateLocator(qualifiedTypeName, typeLocator)) {
                        continue;
                    }
                } else {
                    qualifiedTypeName = new String(classFile.fileName());
                    if (this.newState.isDuplicateLocator(qualifiedTypeName, typeLocator)) {
                        IType type;
                        if (duplicateTypeNames == null) {
                            duplicateTypeNames = new ArrayList<char[][]>();
                        }
                        duplicateTypeNames.add(compoundName);
                        if (mainType == null) {
                            try {
                                mainTypeName = compilationUnit.initialTypeName;
                                mainType = this.javaBuilder.javaProject.findType(mainTypeName.replace('/', '.'));
                            }
                            catch (JavaModelException javaModelException) {
                                // empty catch block
                            }
                        }
                        if (qualifiedTypeName.equals(mainTypeName)) {
                            type = mainType;
                        } else {
                            String simpleName = qualifiedTypeName.substring(qualifiedTypeName.lastIndexOf(47) + 1);
                            type = mainType == null ? null : mainType.getCompilationUnit().getType(simpleName);
                        }
                        this.createProblemFor((IResource)compilationUnit.resource, type, Messages.bind(Messages.build_duplicateClassFile, new String(typeName)), "error");
                        continue;
                    }
                    this.newState.recordLocatorForType(qualifiedTypeName, typeLocator);
                    if (result.checkSecondaryTypes && !qualifiedTypeName.equals(compilationUnit.initialTypeName)) {
                        this.acceptSecondaryType(classFile);
                    }
                }
                try {
                    definedTypeNames.add(this.writeClassFile(classFile, compilationUnit, !isNestedType));
                    continue;
                }
                catch (CoreException e) {
                    Util.log(e, "JavaBuilder handling CoreException");
                    if (e.getStatus().getCode() == 275) {
                        this.createProblemFor((IResource)compilationUnit.resource, null, Messages.bind(Messages.build_classFileCollision, e.getMessage()), "error");
                        continue;
                    }
                    this.createProblemFor((IResource)compilationUnit.resource, null, Messages.build_inconsistentClassFile, "error");
                }
            }
            if (result.hasAnnotations && this.filesWithAnnotations != null) {
                this.filesWithAnnotations.add(compilationUnit);
            }
            this.compiler.lookupEnvironment.releaseClassFiles(classFiles);
            this.finishedWith(typeLocator, result, compilationUnit.getMainTypeName(), definedTypeNames, duplicateTypeNames);
            this.notifier.compiled(compilationUnit);
        }
    }

    protected void acceptSecondaryType(ClassFile classFile) {
    }

    protected void addAllSourceFiles(final LinkedHashSet<SourceFile> sourceFiles) throws CoreException {
        for (final ClasspathMultiDirectory sourceLocation : this.sourceLocations) {
            final char[][] exclusionPatterns = sourceLocation.exclusionPatterns;
            final char[][] inclusionPatterns = sourceLocation.inclusionPatterns;
            final boolean isAlsoProject = sourceLocation.sourceFolder.equals(this.javaBuilder.currentProject);
            final int segmentCount = sourceLocation.sourceFolder.getFullPath().segmentCount();
            final IContainer outputFolder = sourceLocation.binaryFolder;
            final boolean isOutputFolder = sourceLocation.sourceFolder.equals(outputFolder);
            sourceLocation.sourceFolder.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    switch (proxy.getType()) {
                        case 1: {
                            if (Util.isJavaLikeFileName(proxy.getName())) {
                                IResource resource = proxy.requestResource();
                                if ((exclusionPatterns != null || inclusionPatterns != null) && Util.isExcluded(resource.getFullPath(), inclusionPatterns, exclusionPatterns, false)) {
                                    return false;
                                }
                                SourceFile unit = new SourceFile((IFile)resource, sourceLocation);
                                sourceFiles.add(unit);
                            }
                            return false;
                        }
                        case 2: {
                            String complianceLevel;
                            String sourceLevel;
                            String packageName;
                            IPath folderPath = null;
                            if (isAlsoProject && AbstractImageBuilder.this.isExcludedFromProject(folderPath = proxy.requestFullPath())) {
                                return false;
                            }
                            if (exclusionPatterns != null) {
                                if (folderPath == null) {
                                    folderPath = proxy.requestFullPath();
                                }
                                if (Util.isExcluded(folderPath, inclusionPatterns, exclusionPatterns, true)) {
                                    return inclusionPatterns != null;
                                }
                            }
                            if (isOutputFolder) break;
                            if (folderPath == null) {
                                folderPath = proxy.requestFullPath();
                            }
                            if ((packageName = folderPath.lastSegment()).length() <= 0 || JavaConventions.validatePackageName(packageName, sourceLevel = AbstractImageBuilder.this.javaBuilder.javaProject.getOption("org.eclipse.jdt.core.compiler.source", true), complianceLevel = AbstractImageBuilder.this.javaBuilder.javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true)).getSeverity() == 4) break;
                            AbstractImageBuilder.this.createFolder(folderPath.removeFirstSegments(segmentCount), outputFolder);
                        }
                    }
                    return true;
                }
            }, 0);
            this.notifier.checkCancel();
        }
    }

    protected void cleanUp() {
        if (this.nameEnvironment != null) {
            this.nameEnvironment.cleanup();
        }
        this.javaBuilder = null;
        this.nameEnvironment = null;
        this.sourceLocations = null;
        this.notifier = null;
        this.compiler = null;
        this.workQueue = null;
        this.problemSourceFiles = null;
    }

    protected void compile(SourceFile[] units) {
        int i;
        CompilationParticipantResult[] participantResults;
        if (this.filesWithAnnotations != null && this.filesWithAnnotations.size() > 0) {
            this.filesWithAnnotations.clear();
        }
        CompilationParticipantResult[] compilationParticipantResultArray = participantResults = this.javaBuilder.participants == null ? null : this.notifyParticipants(units);
        if (participantResults != null && participantResults.length > units.length) {
            units = new SourceFile[participantResults.length];
            int i2 = participantResults.length;
            while (--i2 >= 0) {
                units[i2] = participantResults[i2].sourceFile;
            }
        }
        int unitsLength = units.length;
        boolean bl = this.compiledAllAtOnce = MAX_AT_ONCE == 0 || unitsLength <= MAX_AT_ONCE;
        if (this.compiledAllAtOnce) {
            if (JavaBuilder.DEBUG) {
                for (i = 0; i < unitsLength; ++i) {
                    System.out.println("About to compile " + units[i].typeLocator());
                }
            }
            this.compile(units, null, true);
        } else {
            SourceFile[] remainingUnits = new SourceFile[unitsLength];
            System.arraycopy(units, 0, remainingUnits, 0, unitsLength);
            int doNow = unitsLength < MAX_AT_ONCE ? unitsLength : MAX_AT_ONCE;
            SourceFile[] toCompile = new SourceFile[doNow];
            int remainingIndex = 0;
            boolean compilingFirstGroup = true;
            while (remainingIndex < unitsLength) {
                int count = 0;
                while (remainingIndex < unitsLength && count < doNow) {
                    SourceFile unit = remainingUnits[remainingIndex];
                    if (unit != null && (compilingFirstGroup || this.workQueue.isWaiting(unit))) {
                        if (JavaBuilder.DEBUG) {
                            System.out.println("About to compile #" + remainingIndex + " : " + unit.typeLocator());
                        }
                        toCompile[count++] = unit;
                    }
                    remainingUnits[remainingIndex++] = null;
                }
                if (count < doNow) {
                    SourceFile[] sourceFileArray = toCompile;
                    toCompile = new SourceFile[count];
                    System.arraycopy(sourceFileArray, 0, toCompile, 0, count);
                }
                if (!compilingFirstGroup) {
                    for (int a = remainingIndex; a < unitsLength; ++a) {
                        if (remainingUnits[a] == null || !this.workQueue.isCompiled(remainingUnits[a])) continue;
                        remainingUnits[a] = null;
                    }
                }
                this.compile(toCompile, remainingUnits, compilingFirstGroup);
                compilingFirstGroup = false;
            }
        }
        if (participantResults != null) {
            i = participantResults.length;
            while (--i >= 0) {
                if (participantResults[i] == null) continue;
                this.recordParticipantResult(participantResults[i]);
            }
            this.processAnnotations(participantResults);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compile(SourceFile[] units, SourceFile[] additionalUnits, boolean compilingFirstGroup) {
        if (units.length == 0) {
            return;
        }
        this.notifier.aboutToCompile(units[0]);
        if (!this.problemSourceFiles.isEmpty()) {
            int length;
            int toAdd = this.problemSourceFiles.size();
            int n = length = additionalUnits == null ? 0 : additionalUnits.length;
            if (length == 0) {
                additionalUnits = new SourceFile[toAdd];
            } else {
                SourceFile[] sourceFileArray = additionalUnits;
                additionalUnits = new SourceFile[length + toAdd];
                System.arraycopy(sourceFileArray, 0, additionalUnits, 0, length);
            }
            Iterator iterator = this.problemSourceFiles.iterator();
            for (int i = 0; i < toAdd; ++i) {
                additionalUnits[length + i] = (SourceFile)iterator.next();
            }
        }
        String[] initialTypeNames = new String[units.length];
        int l = units.length;
        for (int i = 0; i < l; ++i) {
            char[] moduleName = units[i].getModuleName();
            initialTypeNames[i] = moduleName == null ? units[i].initialTypeName : new StringBuilder(60).append(moduleName).append(':').append(units[i].initialTypeName).toString();
        }
        this.nameEnvironment.setNames(initialTypeNames, additionalUnits);
        this.notifier.checkCancel();
        try {
            this.inCompiler = true;
            this.compiler.compile(units);
        }
        catch (AbortCompilation abortCompilation) {
        }
        finally {
            this.inCompiler = false;
        }
        this.notifier.checkCancel();
    }

    protected void copyResource(IResource source, IResource destination) throws CoreException {
        IPath destPath = destination.getFullPath();
        try {
            source.copy(destPath, 1025, null);
        }
        catch (CoreException e) {
            source.refreshLocal(0, null);
            if (!source.exists()) {
                return;
            }
            throw e;
        }
        Util.setReadOnly(destination, false);
    }

    protected void createProblemFor(IResource resource, IMember javaElement, String message, String problemSeverity) {
        try {
            ISourceRange range;
            int severity;
            IMarker marker;
            block6: {
                marker = resource.createMarker("org.eclipse.jdt.core.problem");
                severity = problemSeverity.equals("warning") ? 1 : 2;
                range = null;
                if (javaElement != null) {
                    try {
                        range = javaElement.getNameRange();
                    }
                    catch (JavaModelException e) {
                        if (e.getJavaModelStatus().getCode() != 969) {
                            throw e;
                        }
                        if (CharOperation.equals(javaElement.getElementName().toCharArray(), TypeConstants.PACKAGE_INFO_NAME)) break block6;
                        throw e;
                    }
                }
            }
            int start = range == null ? 0 : range.getOffset();
            int end = range == null ? 1 : start + range.getLength();
            marker.setAttributes(new String[]{"message", "severity", "charStart", "charEnd", "sourceId"}, new Object[]{message, severity, start, end, "JDT"});
        }
        catch (CoreException e) {
            throw this.internalException(e);
        }
    }

    protected void deleteGeneratedFiles(IFile[] deletedGeneratedFiles) {
    }

    protected SourceFile findSourceFile(IFile file, boolean mustExist) {
        if (mustExist && !file.exists()) {
            return null;
        }
        ClasspathMultiDirectory md = null;
        if (this.sourceLocations.length > 0) {
            IPath sourceFileFullPath = file.getFullPath();
            int m = this.sourceLocations.length;
            for (int j = 0; j < m; ++j) {
                if (!this.sourceLocations[j].sourceFolder.getFullPath().isPrefixOf(sourceFileFullPath)) continue;
                md = this.sourceLocations[j];
                if (md.exclusionPatterns == null && md.inclusionPatterns == null || !Util.isExcluded((IResource)file, md.inclusionPatterns, md.exclusionPatterns)) break;
            }
        }
        return md == null ? null : new SourceFile(file, md);
    }

    protected void finishedWith(String sourceLocator, CompilationResult result, char[] mainTypeName, ArrayList definedTypeNames, ArrayList duplicateTypeNames) {
        if (duplicateTypeNames == null) {
            this.newState.record(sourceLocator, result.qualifiedReferences, result.simpleNameReferences, result.rootReferences, mainTypeName, definedTypeNames);
            return;
        }
        Object simpleRefs = result.simpleNameReferences;
        int l = duplicateTypeNames.size();
        block0: for (int i = 0; i < l; ++i) {
            char[][] compoundName = (char[][])duplicateTypeNames.get(i);
            char[] typeName = compoundName[compoundName.length - 1];
            int sLength = ((char[][])simpleRefs).length;
            for (int j = 0; j < sLength; ++j) {
                if (CharOperation.equals(simpleRefs[j], typeName)) continue block0;
            }
            char[][] cArray = simpleRefs;
            char[][] cArrayArray = new char[sLength + 1][];
            simpleRefs = cArrayArray;
            System.arraycopy(cArray, 0, cArrayArray, 0, sLength);
            simpleRefs[sLength] = typeName;
        }
        this.newState.record(sourceLocator, result.qualifiedReferences, (char[][])simpleRefs, result.rootReferences, mainTypeName, definedTypeNames);
    }

    protected IContainer createFolder(IPath packagePath, IContainer outputFolder) throws CoreException {
        if (packagePath.isEmpty()) {
            return outputFolder;
        }
        IFolder folder = outputFolder.getFolder(packagePath);
        if (!folder.exists()) {
            this.createFolder(packagePath.removeLastSegments(1), outputFolder);
            folder.create(1025, true, null);
        }
        return folder;
    }

    @Override
    public ICompilationUnit fromIFile(IFile file) {
        return this.findSourceFile(file, true);
    }

    protected void initializeAnnotationProcessorManager(Compiler newCompiler) {
        AbstractAnnotationProcessorManager annotationManager = JavaModelManager.getJavaModelManager().createAnnotationProcessorManager();
        if (annotationManager != null) {
            annotationManager.configureFromPlatform(newCompiler, this, this.javaBuilder.javaProject, this.compilationGroup == CompilationGroup.TEST);
            annotationManager.setErr(new PrintWriter(System.err));
            annotationManager.setOut(new PrintWriter(System.out));
        }
        newCompiler.annotationProcessorManager = annotationManager;
    }

    protected RuntimeException internalException(CoreException t) {
        ImageBuilderInternalException imageBuilderException = new ImageBuilderInternalException(t);
        if (this.inCompiler) {
            return new AbortCompilation(true, imageBuilderException);
        }
        return imageBuilderException;
    }

    protected boolean isExcludedFromProject(IPath childPath) throws JavaModelException {
        if (childPath.segmentCount() > 2) {
            return false;
        }
        int k = this.sourceLocations.length;
        for (int j = 0; j < k; ++j) {
            if (childPath.equals((Object)this.sourceLocations[j].binaryFolder.getFullPath())) {
                return true;
            }
            if (!childPath.equals((Object)this.sourceLocations[j].sourceFolder.getFullPath())) continue;
            return true;
        }
        return childPath.equals((Object)this.javaBuilder.javaProject.getOutputLocation());
    }

    protected Compiler newCompiler() {
        Map<String, String> projectOptions = this.javaBuilder.javaProject.getOptions(true);
        String option = projectOptions.get("org.eclipse.jdt.core.compiler.problem.invalidJavadoc");
        if (!(option != null && !option.equals("ignore") || (option = projectOptions.get("org.eclipse.jdt.core.compiler.problem.missingJavadocTags")) != null && !option.equals("ignore") || (option = projectOptions.get("org.eclipse.jdt.core.compiler.problem.missingJavadocComments")) != null && !option.equals("ignore") || (option = projectOptions.get("org.eclipse.jdt.core.compiler.problem.unusedImport")) != null && !option.equals("ignore"))) {
            projectOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "disabled");
        }
        CompilerOptions compilerOptions = new CompilerOptions(projectOptions);
        compilerOptions.performMethodsFullRecovery = true;
        compilerOptions.performStatementsRecovery = true;
        Compiler newCompiler = new Compiler((INameEnvironment)this.nameEnvironment, DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, (ICompilerRequestor)this, (IProblemFactory)ProblemFactory.getProblemFactory(Locale.getDefault()));
        CompilerOptions options = newCompiler.options;
        String setting = System.getProperty("jdt.compiler.useSingleThread");
        newCompiler.useSingleThread = setting != null && setting.equals("true");
        options.produceReferenceInfo = true;
        if (options.complianceLevel >= 0x320000L && options.processAnnotations) {
            this.initializeAnnotationProcessorManager(newCompiler);
        }
        return newCompiler;
    }

    protected CompilationParticipantResult[] notifyParticipants(SourceFile[] unitsAboutToCompile) {
        BuildContext[] results = new CompilationParticipantResult[unitsAboutToCompile.length];
        int i = unitsAboutToCompile.length;
        while (--i >= 0) {
            results[i] = new CompilationParticipantResult(unitsAboutToCompile[i], this.compilationGroup == CompilationGroup.TEST);
        }
        int l = this.javaBuilder.participants.length;
        for (i = 0; i < l; ++i) {
            this.javaBuilder.participants[i].buildStarting(results, this instanceof BatchImageBuilder);
        }
        SimpleSet uniqueFiles = null;
        CompilationParticipantResult[] toAdd = null;
        int added = 0;
        int i2 = results.length;
        while (--i2 >= 0) {
            IFile[] addedGeneratedFiles;
            BuildContext result = results[i2];
            if (result == null) continue;
            IFile[] deletedGeneratedFiles = ((CompilationParticipantResult)result).deletedFiles;
            if (deletedGeneratedFiles != null) {
                this.deleteGeneratedFiles(deletedGeneratedFiles);
            }
            if ((addedGeneratedFiles = ((CompilationParticipantResult)result).addedFiles) == null) continue;
            int j = addedGeneratedFiles.length;
            while (--j >= 0) {
                SourceFile sourceFile = this.findSourceFile(addedGeneratedFiles[j], true);
                if (sourceFile == null) continue;
                if (uniqueFiles == null) {
                    uniqueFiles = new SimpleSet(unitsAboutToCompile.length + 3);
                    int f = unitsAboutToCompile.length;
                    while (--f >= 0) {
                        uniqueFiles.add(unitsAboutToCompile[f]);
                    }
                }
                if (uniqueFiles.addIfNotIncluded(sourceFile) != sourceFile) continue;
                CompilationParticipantResult newResult = new CompilationParticipantResult(sourceFile, this.compilationGroup == CompilationGroup.TEST);
                if (toAdd == null) {
                    toAdd = new CompilationParticipantResult[addedGeneratedFiles.length];
                } else {
                    int length = toAdd.length;
                    if (added == length) {
                        CompilationParticipantResult[] compilationParticipantResultArray = toAdd;
                        toAdd = new CompilationParticipantResult[length + addedGeneratedFiles.length];
                        System.arraycopy(compilationParticipantResultArray, 0, toAdd, 0, length);
                    }
                }
                toAdd[added++] = newResult;
                this.workQueue.add(sourceFile);
            }
        }
        if (added > 0) {
            int length = results.length;
            BuildContext[] buildContextArray = results;
            results = new CompilationParticipantResult[length + added];
            System.arraycopy(buildContextArray, 0, results, 0, length);
            System.arraycopy(toAdd, 0, results, length, added);
        }
        return results;
    }

    protected abstract void processAnnotationResults(CompilationParticipantResult[] var1);

    protected void processAnnotations(CompilationParticipantResult[] results) {
        boolean hasAnnotationProcessor = false;
        int l = this.javaBuilder.participants.length;
        for (int i = 0; !hasAnnotationProcessor && i < l; ++i) {
            hasAnnotationProcessor = this.javaBuilder.participants[i].isAnnotationProcessor();
        }
        if (!hasAnnotationProcessor) {
            return;
        }
        boolean foundAnnotations = this.filesWithAnnotations != null && this.filesWithAnnotations.size() > 0;
        int i = results.length;
        while (--i >= 0) {
            results[i].reset(foundAnnotations && this.filesWithAnnotations.contains(results[i].sourceFile));
        }
        int l2 = this.javaBuilder.participants.length;
        for (i = 0; i < l2; ++i) {
            if (!this.javaBuilder.participants[i].isAnnotationProcessor()) continue;
            this.javaBuilder.participants[i].processAnnotations(results);
        }
        this.processAnnotationResults(results);
    }

    protected void recordParticipantResult(CompilationParticipantResult result) {
        ReferenceCollection refs;
        String[] dependencies;
        CategorizedProblem[] problems = result.problems;
        if (problems != null && problems.length > 0) {
            this.notifier.updateProblemCounts(problems);
            try {
                this.storeProblemsFor(result.sourceFile, problems);
            }
            catch (CoreException e) {
                Util.log(e, "JavaBuilder logging CompilationParticipant's CoreException to help debugging");
            }
        }
        if ((dependencies = result.dependencies) != null && (refs = this.newState.references.get(result.sourceFile.typeLocator())) != null) {
            refs.addDependencies(dependencies);
        }
    }

    protected void storeProblemsFor(SourceFile sourceFile, CategorizedProblem[] problems) throws CoreException {
        if (sourceFile == null || problems == null || problems.length == 0) {
            return;
        }
        if (!this.keepStoringProblemMarkers) {
            return;
        }
        HashSet<String> managedMarkerTypes = JavaModelManager.getJavaModelManager().compilationParticipants.managedMarkerTypes();
        block6: for (CategorizedProblem problem : problems) {
            int j;
            int id = problem.getID();
            IFile resource = sourceFile.resource;
            String buildPathProblemMessage = null;
            switch (id) {
                case 0x1000144: 
                case 16777563: {
                    buildPathProblemMessage = Messages.bind(Messages.build_incompleteClassPath, problem.getArguments()[0]);
                    break;
                }
                case 8389927: {
                    buildPathProblemMessage = Messages.bind(Messages.build_errorOnModuleDirective, problem.getMessage());
                }
            }
            if (buildPathProblemMessage != null) {
                boolean isInvalidClasspathError;
                if (JavaBuilder.DEBUG) {
                    System.out.println(buildPathProblemMessage);
                }
                if ((isInvalidClasspathError = "error".equals(this.javaBuilder.javaProject.getOption("org.eclipse.jdt.core.incompleteClasspath", true))) && "abort".equals(this.javaBuilder.javaProject.getOption("org.eclipse.jdt.core.builder.invalidClasspath", true))) {
                    JavaBuilder.removeProblemsAndTasksFor((IResource)this.javaBuilder.currentProject);
                    this.keepStoringProblemMarkers = false;
                }
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("message", buildPathProblemMessage);
                attributes.put("severity", isInvalidClasspathError ? 2 : 1);
                attributes.put("categoryId", 10);
                attributes.put("sourceId", "JDT");
                this.javaBuilder.currentProject.createMarker("org.eclipse.jdt.core.problem", attributes);
            }
            String markerType = problem.getMarkerType();
            boolean managedProblem = false;
            if (!"org.eclipse.jdt.core.problem".equals(markerType) && !(managedProblem = managedMarkerTypes.contains(markerType))) continue;
            if (id == 536871825 && !CharOperation.equals(sourceFile.getMainTypeName(), TypeConstants.PACKAGE_INFO_NAME)) {
                char[] fileName = sourceFile.getFileName();
                int pkgEnd = CharOperation.lastIndexOf('/', fileName);
                if (pkgEnd == -1) {
                    pkgEnd = CharOperation.lastIndexOf(File.separatorChar, fileName);
                }
                Openable pkg = null;
                if (pkgEnd != -1) {
                    pkg = (PackageFragment)Util.getPackageFragment(sourceFile.getFileName(), pkgEnd, -1);
                }
                if (pkg != null) {
                    IResource tempRes;
                    block23: {
                        try {
                            IMarker[] existingMarkers = pkg.resource().findMarkers("org.eclipse.jdt.core.problem", false, 0);
                            int len = existingMarkers.length;
                            for (j = 0; j < len; ++j) {
                                if ((Integer)existingMarkers[j].getAttribute("id") == 536871825) continue block6;
                            }
                        }
                        catch (CoreException e) {
                            if (!JavaModelManager.VERBOSE) break block23;
                            e.printStackTrace();
                        }
                    }
                    if ((tempRes = pkg.resource()) != null) {
                        resource = tempRes;
                    }
                }
            }
            int attributesLength = JAVA_PROBLEM_MARKER_ATTRIBUTE_NAMES.length;
            if (!managedProblem) {
                ++attributesLength;
            }
            String[] extraAttributeNames = problem.getExtraMarkerAttributeNames();
            Object[] extraAttributeValues = problem.getExtraMarkerAttributeValues();
            boolean extraAttributesExist = false;
            if (extraAttributeNames != null && extraAttributeValues != null && extraAttributeNames.length == extraAttributeValues.length) {
                attributesLength += extraAttributeNames.length;
                extraAttributesExist = true;
            }
            HashMap<String, Object> attributes = new HashMap<String, Object>(attributesLength, 1.0f);
            attributes.put(JAVA_PROBLEM_MARKER_ATTRIBUTE_NAMES[0], problem.getMessage());
            attributes.put(JAVA_PROBLEM_MARKER_ATTRIBUTE_NAMES[1], problem.isError() ? S_ERROR : (problem.isWarning() ? S_WARNING : S_INFO));
            attributes.put(JAVA_PROBLEM_MARKER_ATTRIBUTE_NAMES[2], id);
            attributes.put(JAVA_PROBLEM_MARKER_ATTRIBUTE_NAMES[3], problem.getSourceStart());
            attributes.put(JAVA_PROBLEM_MARKER_ATTRIBUTE_NAMES[4], problem.getSourceEnd() + 1);
            attributes.put(JAVA_PROBLEM_MARKER_ATTRIBUTE_NAMES[5], problem.getSourceLineNumber());
            attributes.put(JAVA_PROBLEM_MARKER_ATTRIBUTE_NAMES[6], Util.getProblemArgumentsForMarker(problem.getArguments()));
            attributes.put(JAVA_PROBLEM_MARKER_ATTRIBUTE_NAMES[7], problem.getCategoryID());
            if (!managedProblem) {
                attributes.put("sourceId", "JDT");
            }
            if (extraAttributesExist) {
                for (j = 0; j < extraAttributeNames.length; ++j) {
                    attributes.put(extraAttributeNames[j], extraAttributeValues[j]);
                }
            }
            resource.createMarker(markerType, attributes);
            if (this.keepStoringProblemMarkers) continue;
            return;
        }
    }

    protected void storeTasksFor(SourceFile sourceFile, CategorizedProblem[] tasks) throws CoreException {
        if (sourceFile == null || tasks == null || tasks.length == 0) {
            return;
        }
        IFile resource = sourceFile.resource;
        for (CategorizedProblem task : tasks) {
            if (task.getID() != 536871362) continue;
            Integer priority = P_NORMAL;
            String compilerPriority = task.getArguments()[2];
            if ("HIGH".equals(compilerPriority)) {
                priority = P_HIGH;
            } else if ("LOW".equals(compilerPriority)) {
                priority = P_LOW;
            }
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("message", task.getMessage());
            attributes.put("priority", priority);
            attributes.put("id", task.getID());
            attributes.put("charStart", task.getSourceStart());
            attributes.put("charEnd", task.getSourceEnd() + 1);
            attributes.put("lineNumber", task.getSourceLineNumber());
            attributes.put("userEditable", Boolean.FALSE);
            attributes.put("sourceId", "JDT");
            String[] extraAttributeNames = task.getExtraMarkerAttributeNames();
            Object[] extraAttributeValues = task.getExtraMarkerAttributeValues();
            if (extraAttributeNames != null && extraAttributeValues != null && extraAttributeNames.length == extraAttributeValues.length) {
                for (int j = 0; j < extraAttributeNames.length; ++j) {
                    attributes.put(extraAttributeNames[j], extraAttributeValues[j]);
                }
            }
            resource.createMarker("org.eclipse.jdt.core.task", attributes);
        }
    }

    protected void updateProblemsFor(SourceFile sourceFile, CompilationResult result) throws CoreException {
        CategorizedProblem[] problems = result.getProblems();
        if (problems == null || problems.length == 0) {
            return;
        }
        this.notifier.updateProblemCounts(problems);
        this.storeProblemsFor(sourceFile, problems);
    }

    protected void updateTasksFor(SourceFile sourceFile, CompilationResult result) throws CoreException {
        CategorizedProblem[] tasks = result.getTasks();
        if (tasks == null || tasks.length == 0) {
            return;
        }
        this.storeTasksFor(sourceFile, tasks);
    }

    protected char[] writeClassFile(ClassFile classFile, SourceFile compilationUnit, boolean isTopLevelType) throws CoreException {
        IContainer outputFolder;
        String fileName = new String(classFile.fileName());
        Path filePath = new Path(fileName);
        IContainer container = outputFolder = compilationUnit.sourceLocation.binaryFolder;
        if (filePath.segmentCount() > 1) {
            container = this.createFolder(filePath.removeLastSegments(1), outputFolder);
            filePath = new Path(filePath.lastSegment());
        }
        IFile file = container.getFile(filePath.addFileExtension("class"));
        this.writeClassFileContents(classFile, file, fileName, isTopLevelType, compilationUnit);
        return filePath.lastSegment().toCharArray();
    }

    protected void writeClassFileContents(ClassFile classFile, IFile file, String qualifiedFileName, boolean isTopLevelType, SourceFile compilationUnit) throws CoreException {
        ByteArrayInputStream input = new ByteArrayInputStream(classFile.getBytes());
        if (file.exists()) {
            if (JavaBuilder.DEBUG) {
                System.out.println("Writing changed class file " + file.getName());
            }
            if (!file.isDerived()) {
                file.setDerived(true, null);
            }
            file.setContents((InputStream)input, true, false, null);
        } else {
            if (JavaBuilder.DEBUG) {
                System.out.println("Writing new class file " + file.getName());
            }
            file.create((InputStream)input, 1025, null);
        }
    }
}

