/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.util.Util;

public class ExternalAnnotationTracker
implements IResourceChangeListener {
    DirectoryNode tree = new DirectoryNode(null, null);
    private static ExternalAnnotationTracker singleton;

    private ExternalAnnotationTracker() {
    }

    static void start(IWorkspace workspace) {
        singleton = new ExternalAnnotationTracker();
        workspace.addResourceChangeListener((IResourceChangeListener)singleton);
    }

    static void shutdown(IWorkspace workspace) {
        if (singleton != null) {
            workspace.removeResourceChangeListener((IResourceChangeListener)singleton);
            ExternalAnnotationTracker.singleton.tree.children = null;
        }
    }

    public static void registerClassFile(IPath annotationBase, IPath relativeAnnotationPath, ClassFile classFile) {
        int baseDepth = annotationBase.segmentCount();
        if (baseDepth == 0) {
            Util.log(new IllegalArgumentException("annotationBase cannot be empty"));
        } else {
            relativeAnnotationPath = relativeAnnotationPath.addFileExtension("eea");
            DirectoryNode base = singleton.getAnnotationBase(ExternalAnnotationTracker.singleton.tree, annotationBase, baseDepth, 1);
            base.registerClassFile(relativeAnnotationPath, classFile);
        }
    }

    public static void unregisterClassFile(IPath annotationBase, IPath relativeAnnotationPath) {
        int baseDepth = annotationBase.segmentCount();
        if (baseDepth == 0) {
            Util.log(new IllegalArgumentException("annotationBase cannot be empty"));
        } else {
            relativeAnnotationPath = relativeAnnotationPath.addFileExtension("eea");
            DirectoryNode base = singleton.getAnnotationBase(ExternalAnnotationTracker.singleton.tree, annotationBase, baseDepth, 1);
            base.unregisterClassFile(relativeAnnotationPath);
        }
    }

    private DirectoryNode getAnnotationBase(DirectoryNode current, IPath annotationBase, int baseDepth, int nextDepth) {
        IPath nextHead = annotationBase.uptoSegment(nextDepth);
        Map<IPath, DirectoryNode> children = current.getChildren();
        DirectoryNode nextHeadNode = children.get(nextHead);
        if (nextHeadNode == null) {
            nextHeadNode = new DirectoryNode(current, nextHead);
            children.put(nextHead, nextHeadNode);
        }
        if (baseDepth == nextDepth) {
            return nextHeadNode;
        }
        return this.getAnnotationBase(nextHeadNode, annotationBase, baseDepth, nextDepth + 1);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null && delta.getFullPath().isRoot() && this.tree.children != null) {
            for (IResourceDelta child : delta.getAffectedChildren()) {
                DirectoryNode directoryNode = this.tree.children.get(child.getFullPath());
                if (directoryNode == null) continue;
                this.traverseForDirectories(directoryNode, child);
            }
        }
    }

    private void traverseForDirectories(DirectoryNode directoryNode, IResourceDelta matchedDelta) {
        if (directoryNode.classFiles != null) {
            this.traverseForClassFiles(directoryNode.classFiles, matchedDelta, matchedDelta.getFullPath().segmentCount());
        } else if (directoryNode.children != null) {
            for (IResourceDelta child : matchedDelta.getAffectedChildren()) {
                DirectoryNode childDir = directoryNode.children.get(child.getFullPath());
                if (childDir == null) continue;
                if (child.getKind() == 2) {
                    directoryNode.children.remove(child.getFullPath());
                    continue;
                }
                this.traverseForDirectories(childDir, child);
            }
        }
        if (directoryNode.isEmpty()) {
            directoryNode.parent.children.remove(matchedDelta.getFullPath());
        }
    }

    private void traverseForClassFiles(Map<IPath, ClassFile> classFiles, IResourceDelta matchedDelta, int baseDepth) {
        for (IResourceDelta delta : matchedDelta.getAffectedChildren()) {
            IPath deltaRelativePath = delta.getFullPath().removeFirstSegments(baseDepth);
            ClassFile classFile = classFiles.remove(deltaRelativePath);
            if (classFile != null) {
                try {
                    classFile.closeAndRemoveFromJarTypeCache();
                }
                catch (JavaModelException e) {
                    Util.log((Throwable)((Object)e), "Failed to close ClassFile " + classFile.name);
                }
                continue;
            }
            this.traverseForClassFiles(classFiles, delta, baseDepth);
        }
    }

    static class DirectoryNode {
        DirectoryNode parent;
        IPath path;
        Map<IPath, DirectoryNode> children;
        Map<IPath, ClassFile> classFiles;
        IPackageFragmentRoot modelRoot;

        public DirectoryNode(DirectoryNode parent, IPath path) {
            this.parent = parent;
            this.path = path;
        }

        Map<IPath, DirectoryNode> getChildren() {
            if (this.children == null) {
                this.children = new HashMap<IPath, DirectoryNode>();
            }
            return this.children;
        }

        void registerClassFile(IPath relativeAnnotationPath, ClassFile classFile) {
            if (this.classFiles == null) {
                this.classFiles = new HashMap<IPath, ClassFile>();
            }
            this.classFiles.put(relativeAnnotationPath, classFile);
            if (this.modelRoot == null) {
                this.modelRoot = classFile.getPackageFragmentRoot();
            }
        }

        void unregisterClassFile(IPath relativeAnnotationPath) {
            if (this.classFiles != null) {
                this.classFiles.remove(relativeAnnotationPath);
                if (this.classFiles.isEmpty() && this.parent != null) {
                    this.parent.unregisterDirectory(this);
                }
            }
        }

        void unregisterDirectory(DirectoryNode child) {
            if (this.children != null) {
                this.children.remove(child.path);
            }
            if ((this.children == null || this.children.isEmpty()) && this.parent != null) {
                this.parent.unregisterDirectory(this);
            }
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.classFiles != null) {
                buf.append("annotation base ");
            }
            buf.append("directory\n");
            if (this.children != null) {
                buf.append("\twith ").append(this.children.size()).append(" children\n");
            }
            buf.append("\t#classFiles: ").append(this.numClassFiles());
            return buf.toString();
        }

        int numClassFiles() {
            if (this.classFiles != null) {
                return this.classFiles.size();
            }
            int count = 0;
            if (this.children != null) {
                for (DirectoryNode child : this.children.values()) {
                    count += child.numClassFiles();
                }
            }
            return count;
        }

        boolean isEmpty() {
            return !(this.children != null && !this.children.isEmpty() || this.classFiles != null && !this.classFiles.isEmpty());
        }
    }
}

