/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.SimpleName;

public class ExpressionMethodReference
extends MethodReference {
    public static final ChildPropertyDescriptor EXPRESSION_PROPERTY = new ChildPropertyDescriptor(ExpressionMethodReference.class, "expression", Expression.class, true, true);
    public static final ChildListPropertyDescriptor TYPE_ARGUMENTS_PROPERTY = ExpressionMethodReference.internalTypeArgumentsFactory(ExpressionMethodReference.class);
    public static final ChildPropertyDescriptor NAME_PROPERTY = new ChildPropertyDescriptor(ExpressionMethodReference.class, "name", SimpleName.class, true, false);
    private static final List PROPERTY_DESCRIPTORS_8_0;
    private Expression expression = null;
    private SimpleName methodName = null;

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS_8_0;
    }

    ExpressionMethodReference(AST ast) {
        super(ast);
        this.unsupportedIn2_3_4();
    }

    @Override
    final ChildListPropertyDescriptor internalTypeArgumentsProperty() {
        return TYPE_ARGUMENTS_PROPERTY;
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return ExpressionMethodReference.propertyDescriptors(apiLevel);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == NAME_PROPERTY) {
            if (get) {
                return this.getName();
            }
            this.setName((SimpleName)child);
            return null;
        }
        if (property == EXPRESSION_PROPERTY) {
            if (get) {
                return this.getExpression();
            }
            this.setExpression((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == TYPE_ARGUMENTS_PROPERTY) {
            return this.typeArguments();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final int getNodeType0() {
        return 90;
    }

    @Override
    ASTNode clone0(AST target) {
        ExpressionMethodReference result = new ExpressionMethodReference(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setExpression((Expression)ASTNode.copySubtree(target, this.getExpression()));
        result.typeArguments().addAll(ASTNode.copySubtrees(target, this.typeArguments()));
        result.setName((SimpleName)this.getName().clone(target));
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getExpression());
            this.acceptChildren(visitor, this.typeArguments);
            this.acceptChild(visitor, this.getName());
        }
        visitor.endVisit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression getExpression() {
        if (this.expression == null) {
            ExpressionMethodReference expressionMethodReference = this;
            synchronized (expressionMethodReference) {
                if (this.expression == null) {
                    this.preLazyInit();
                    this.expression = new SimpleName(this.ast);
                    this.postLazyInit(this.expression, EXPRESSION_PROPERTY);
                }
            }
        }
        return this.expression;
    }

    public void setExpression(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.expression;
        this.preReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
        this.expression = expression;
        this.postReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
    }

    @Override
    public List typeArguments() {
        return this.typeArguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleName getName() {
        if (this.methodName == null) {
            ExpressionMethodReference expressionMethodReference = this;
            synchronized (expressionMethodReference) {
                if (this.methodName == null) {
                    this.preLazyInit();
                    this.methodName = new SimpleName(this.ast);
                    this.postLazyInit(this.methodName, NAME_PROPERTY);
                }
            }
        }
        return this.methodName;
    }

    public void setName(SimpleName name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        SimpleName oldChild = this.methodName;
        this.preReplaceChild(oldChild, name, NAME_PROPERTY);
        this.methodName = name;
        this.postReplaceChild(oldChild, name, NAME_PROPERTY);
    }

    @Override
    int memSize() {
        return 52;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.expression == null ? 0 : this.getExpression().treeSize()) + (this.typeArguments == null ? 0 : this.typeArguments.listSize()) + (this.methodName == null ? 0 : this.getName().treeSize());
    }

    static {
        ArrayList propertyList = new ArrayList(4);
        ExpressionMethodReference.createPropertyList(ExpressionMethodReference.class, propertyList);
        ExpressionMethodReference.addProperty(EXPRESSION_PROPERTY, propertyList);
        ExpressionMethodReference.addProperty(TYPE_ARGUMENTS_PROPERTY, propertyList);
        ExpressionMethodReference.addProperty(NAME_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_8_0 = ExpressionMethodReference.reapPropertyList(propertyList);
    }
}

