/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.IParallelizable;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.JavaSearchPattern;
import org.eclipse.jdt.internal.core.search.matching.PackageDeclarationPattern;

public class OrPattern
extends SearchPattern
implements IIndexConstants,
IParallelizable,
Cloneable {
    protected SearchPattern[] patterns;
    int matchCompatibility;

    public OrPattern(SearchPattern leftPattern, SearchPattern rightPattern) {
        super(Math.max(leftPattern.getMatchRule(), rightPattern.getMatchRule()));
        this.kind = 256;
        this.mustResolve = leftPattern.mustResolve || rightPattern.mustResolve;
        SearchPattern[] leftPatterns = leftPattern instanceof OrPattern ? ((OrPattern)leftPattern).patterns : null;
        SearchPattern[] rightPatterns = rightPattern instanceof OrPattern ? ((OrPattern)rightPattern).patterns : null;
        int leftSize = leftPatterns == null ? 1 : leftPatterns.length;
        int rightSize = rightPatterns == null ? 1 : rightPatterns.length;
        this.patterns = new SearchPattern[leftSize + rightSize];
        if (leftPatterns == null) {
            this.patterns[0] = leftPattern;
        } else {
            System.arraycopy(leftPatterns, 0, this.patterns, 0, leftSize);
        }
        if (rightPatterns == null) {
            this.patterns[leftSize] = rightPattern;
        } else {
            System.arraycopy(rightPatterns, 0, this.patterns, leftSize, rightSize);
        }
        this.matchCompatibility = 0;
        int length = this.patterns.length;
        for (int i = 0; i < length; ++i) {
            this.matchCompatibility |= ((JavaSearchPattern)this.patterns[i]).matchCompatibility;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void findIndexMatches(Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor progressMonitor) throws IOException {
        try {
            index.startQuery();
            int length = this.patterns.length;
            for (int i = 0; i < length; ++i) {
                this.patterns[i].findIndexMatches(index, requestor, participant, scope, progressMonitor);
            }
        }
        finally {
            index.stopQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void findIndexMatches(Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, boolean resolveDocumentName, IProgressMonitor progressMonitor) throws IOException {
        try {
            index.startQuery();
            int length = this.patterns.length;
            for (int i = 0; i < length; ++i) {
                this.patterns[i].findIndexMatches(index, requestor, participant, scope, resolveDocumentName, progressMonitor);
            }
        }
        finally {
            index.stopQuery();
        }
    }

    @Override
    public SearchPattern getBlankPattern() {
        return null;
    }

    boolean isErasureMatch() {
        return (this.matchCompatibility & 0x10) != 0;
    }

    @Override
    public boolean isPolymorphicSearch() {
        int length = this.patterns.length;
        for (int i = 0; i < length; ++i) {
            if (!this.patterns[i].isPolymorphicSearch()) continue;
            return true;
        }
        return false;
    }

    public final boolean hasPackageDeclaration() {
        int length = this.patterns.length;
        for (int i = 0; i < length; ++i) {
            if (!(this.patterns[i] instanceof PackageDeclarationPattern)) continue;
            return true;
        }
        return false;
    }

    public final boolean hasSignatures() {
        boolean isErasureMatch = this.isErasureMatch();
        int length = this.patterns.length;
        for (int i = 0; i < length && !isErasureMatch; ++i) {
            if (!((JavaSearchPattern)this.patterns[i]).hasSignatures()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.patterns[0].toString());
        int length = this.patterns.length;
        for (int i = 1; i < length; ++i) {
            buffer.append("\n| ");
            buffer.append(this.patterns[i].toString());
        }
        return buffer.toString();
    }

    @Override
    public boolean isParallelSearchSupported() {
        return Stream.of(this.patterns).allMatch(IParallelizable::isParallelSearchSupported);
    }

    @Override
    public SearchPattern clone() throws CloneNotSupportedException {
        OrPattern pattern = (OrPattern)super.clone();
        pattern.patterns = (SearchPattern[])this.patterns.clone();
        for (int i = 0; i < this.patterns.length; ++i) {
            pattern.patterns[i] = this.patterns[i].clone();
        }
        return pattern;
    }
}

