/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.search.ModuleReferenceMatch;
import org.eclipse.jdt.core.search.PackageReferenceMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.TypeReferenceMatch;
import org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.core.ModularClassFile;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.ModulePattern;
import org.eclipse.jdt.internal.core.search.matching.OrPattern;
import org.eclipse.jdt.internal.core.search.matching.PackageReferencePattern;
import org.eclipse.jdt.internal.core.search.matching.TypeReferencePattern;

public class ModularClassFileMatchLocator
implements IIndexConstants {
    private IBinaryModule binaryModule;
    private ModularClassFile modularClassFile;
    private IModuleDescription moduleDesc;
    private char[] moduleName;
    private ModuleBinding module;

    public void locateMatches(MatchLocator locator, ModularClassFile mClassFile) throws CoreException {
        SearchPattern pattern = locator.pattern;
        this.modularClassFile = mClassFile;
        this.binaryModule = this.modularClassFile.getBinaryModuleInfo();
        if (this.binaryModule == null) {
            return;
        }
        this.moduleDesc = mClassFile.getModule();
        this.moduleName = this.binaryModule.name();
        this.module = locator.lookupEnvironment.getModule(this.moduleName);
        this.matchModuleDeclaration(pattern, locator);
        this.matchModuleReferences(pattern, locator);
        this.matchPackageReferences(pattern, locator);
        this.matchTypeReferences(pattern, locator);
    }

    private void matchModuleDeclaration(SearchPattern pattern, MatchLocator locator) throws CoreException {
        switch (pattern.kind) {
            case 8192: {
                break;
            }
            case 256: {
                SearchPattern[] patterns = ((OrPattern)pattern).patterns;
                int length = patterns.length;
                for (int i = 0; i < length; ++i) {
                    SearchPattern p = patterns[i];
                    if (p.kind != 8192) continue;
                    this.matchModuleReferences(patterns[i], locator);
                }
            }
            default: {
                return;
            }
        }
        ModulePattern modulePattern = (ModulePattern)pattern;
        if (!locator.patternLocator.matchesName(modulePattern.name, this.moduleName)) {
            return;
        }
        ModuleBinding moduleBinding = null;
        int level = 3;
        if (locator.patternLocator.mustResolve) {
            moduleBinding = locator.lookupEnvironment.getModule(this.moduleName);
            level = locator.patternLocator.resolveLevel(moduleBinding);
        }
        if (level == 0) {
            return;
        }
        int accuracy = level == 3 ? 0 : 1;
        SearchMatch match = locator.newDeclarationMatch(this.moduleDesc, moduleBinding, accuracy, -1, 0);
        locator.report(match);
    }

    private void matchModuleReferences(SearchPattern pattern, MatchLocator locator) throws CoreException {
        switch (pattern.kind) {
            case 8192: {
                break;
            }
            case 256: {
                SearchPattern[] patterns = ((OrPattern)pattern).patterns;
                int length = patterns.length;
                for (int i = 0; i < length; ++i) {
                    SearchPattern p = patterns[i];
                    if (p.kind != 8192) continue;
                    this.matchModuleReferences(patterns[i], locator);
                }
            }
            default: {
                return;
            }
        }
        ModulePattern modulePattern = (ModulePattern)pattern;
        if (!modulePattern.findReferences) {
            return;
        }
        this.matchModuleReferences(locator, modulePattern, this.binaryModule.exports());
        this.matchModuleReferences(locator, modulePattern, this.binaryModule.opens());
        if (this.module != null) {
            this.matchModuleReferences(locator, modulePattern, this.module.getAllRequiredModules());
        }
    }

    private void matchModuleReference(MatchLocator locator, ModulePattern modulePattern, char[][] modules, boolean isTarget) throws CoreException {
        if (modules == null) {
            return;
        }
        for (char[] module1 : modules) {
            if (module1 == null || module1.length == 0 || !locator.patternLocator.matchesName(modulePattern.name, module1)) continue;
            ModuleReferenceMatch match = locator.newModuleReferenceMatch(this.moduleDesc, null, isTarget ? 0 : 1, -1, 0, null);
            locator.report(match);
        }
    }

    private void matchModuleReferences(MatchLocator locator, ModulePattern modulePattern, IModule.IPackageExport[] pvs) throws CoreException {
        if (pvs == null) {
            return;
        }
        for (IModule.IPackageExport pv : pvs) {
            this.matchModuleReference(locator, modulePattern, pv.targets(), true);
        }
    }

    private void matchModuleReferences(MatchLocator locator, ModulePattern modulePattern, ModuleBinding[] refs) throws CoreException {
        if (refs == null) {
            return;
        }
        for (ModuleBinding ref : refs) {
            int level;
            char[] name = ref.name();
            if (name == null || (level = locator.patternLocator.resolveLevel(ref)) == 0) continue;
            int accuracy = level == 3 ? 0 : 1;
            ModuleReferenceMatch match = locator.newModuleReferenceMatch(this.moduleDesc, null, accuracy, -1, 0, null);
            locator.report(match);
        }
    }

    private void matchPackageReferences(SearchPattern pattern, MatchLocator locator) throws CoreException {
        switch (pattern.kind) {
            case 1: {
                break;
            }
            case 256: {
                SearchPattern[] patterns = ((OrPattern)pattern).patterns;
                int length = patterns.length;
                for (int i = 0; i < length; ++i) {
                    SearchPattern p = patterns[i];
                    if (p.kind != 1) continue;
                    this.matchPackageReferences(patterns[i], locator);
                }
            }
            default: {
                return;
            }
        }
        this.matchPackReferences(locator, (PackageReferencePattern)pattern, this.module.getExports());
        this.matchPackReferences(locator, (PackageReferencePattern)pattern, this.module.getOpens());
        this.matchPackReferences(locator, (PackageReferencePattern)pattern, this.module.getUses());
        TypeBinding[] services = this.module.getServices();
        if (services != null) {
            this.matchPackReferences(locator, (PackageReferencePattern)pattern, services);
            for (TypeBinding service : services) {
                this.matchPackReferences(locator, (PackageReferencePattern)pattern, this.module.getImplementations(service));
            }
        }
    }

    private void matchPackReferences(MatchLocator locator, PackageReferencePattern packReferencePattern, PackageBinding[] packBindings) throws CoreException {
        if (packBindings == null) {
            return;
        }
        for (PackageBinding pb : packBindings) {
            this.reportPackageMatch(locator, pb);
        }
    }

    private void reportPackageMatch(MatchLocator locator, PackageBinding packageBinding) throws CoreException {
        if (packageBinding == null) {
            return;
        }
        int level = locator.patternLocator.resolveLevel(packageBinding);
        if (level == 0) {
            return;
        }
        int accuracy = level == 3 ? 0 : 1;
        PackageReferenceMatch match = locator.newPackageReferenceMatch(this.moduleDesc, accuracy, -1, 0, null);
        locator.report(match);
    }

    private void matchPackReferences(MatchLocator locator, PackageReferencePattern packReferencePattern, TypeBinding[] types) throws CoreException {
        if (types == null) {
            return;
        }
        for (TypeBinding type : types) {
            this.reportPackageMatch(locator, type.getPackage());
        }
    }

    private void matchTypeReferences(SearchPattern pattern, MatchLocator locator) throws CoreException {
        switch (pattern.kind) {
            case 4: {
                break;
            }
            case 256: {
                SearchPattern[] patterns = ((OrPattern)pattern).patterns;
                int length = patterns.length;
                for (int i = 0; i < length; ++i) {
                    SearchPattern p = patterns[i];
                    if (p.kind != 4) continue;
                    this.matchTypeReferences(patterns[i], locator);
                }
            }
            default: {
                return;
            }
        }
        this.matchTypeReferences(locator, (TypeReferencePattern)pattern, this.module.getUses());
        TypeBinding[] services = this.module.getServices();
        if (services != null) {
            this.matchTypeReferences(locator, (TypeReferencePattern)pattern, services);
            for (TypeBinding service : services) {
                this.matchTypeReferences(locator, (TypeReferencePattern)pattern, this.module.getImplementations(service));
            }
        }
    }

    private void matchTypeReferences(MatchLocator locator, TypeReferencePattern typeReferencePattern, TypeBinding[] types) throws CoreException {
        if (types == null) {
            return;
        }
        for (TypeBinding type : types) {
            int level = locator.patternLocator.resolveLevel(type);
            if (level == 0) continue;
            int accuracy = level == 3 ? 0 : 1;
            TypeReferenceMatch match = locator.newTypeReferenceMatch(this.moduleDesc, null, accuracy, -1, 0, null);
            locator.report(match);
        }
    }
}

