/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import java.util.Collections;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FunctionalExpression;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.jdom.CompilationUnit;
import org.eclipse.jdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.indexing.SourceIndexerRequestor;
import org.eclipse.jdt.internal.core.search.matching.IndexBasedJavaSearchEnvironment;
import org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.eclipse.jdt.internal.core.search.processing.JobManager;

public class SourceIndexer
extends AbstractIndexer
implements ITypeRequestor,
SuffixConstants {
    private LookupEnvironment lookupEnvironment;
    private CompilerOptions options;
    public ISourceElementRequestor requestor = new SourceIndexerRequestor(this);
    private Parser basicParser;
    private CompilationUnit compilationUnit;
    private CompilationUnitDeclaration cud;
    private static final boolean DEBUG = false;

    public SourceIndexer(SearchDocument document) {
        super(document);
    }

    @Override
    public void indexDocument() {
        block8: {
            String documentPath = this.document.getPath();
            SourceElementParser parser = this.document.getParser();
            if (parser == null) {
                Path path = new Path(documentPath);
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                parser = JavaModelManager.getJavaModelManager().indexManager.getSourceElementParser(JavaCore.create(project), this.requestor);
            } else {
                parser.setRequestor(this.requestor);
            }
            char[] source = null;
            char[] name = null;
            try {
                source = this.document.getCharContents();
                name = documentPath.toCharArray();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (source == null || name == null) {
                return;
            }
            this.compilationUnit = new CompilationUnit(source, name);
            try {
                if (parser.parseCompilationUnit(this.compilationUnit, true, null).hasFunctionalTypes()) {
                    this.document.requireIndexingResolvedDocument();
                }
            }
            catch (Exception e) {
                if (!JobManager.VERBOSE) break block8;
                e.printStackTrace();
            }
        }
    }

    @Override
    public void accept(IBinaryType binaryType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        this.lookupEnvironment.createBinaryTypeFrom(binaryType, packageBinding, accessRestriction);
    }

    @Override
    public void accept(ICompilationUnit unit, AccessRestriction accessRestriction) {
        CompilationResult unitResult = new CompilationResult(unit, 1, 1, this.options.maxProblemsPerUnit);
        CompilationUnitDeclaration parsedUnit = this.basicParser.dietParse(unit, unitResult);
        this.lookupEnvironment.buildTypeBindings(parsedUnit, accessRestriction);
        this.lookupEnvironment.completeTypeBindings(parsedUnit, true);
    }

    @Override
    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        ISourceType sourceType = sourceTypes[0];
        while (sourceType.getEnclosingType() != null) {
            sourceType = sourceType.getEnclosingType();
        }
        SourceTypeElementInfo elementInfo = (SourceTypeElementInfo)sourceType;
        IType type = elementInfo.getHandle();
        ICompilationUnit sourceUnit = (ICompilationUnit)((Object)type.getCompilationUnit());
        this.accept(sourceUnit, accessRestriction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveDocument() {
        try {
            Path path = new Path(this.document.getPath());
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
            JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
            JavaProject javaProject = (JavaProject)model.getJavaProject((IResource)project);
            this.options = new CompilerOptions(javaProject.getOptions(true));
            ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.options, new DefaultProblemFactory());
            this.basicParser = new Parser(problemReporter, false);
            this.basicParser.reportOnlyOneSyntaxError = true;
            this.basicParser.scanner.taskTags = null;
            this.cud = this.basicParser.parse(this.compilationUnit, new CompilationResult(this.compilationUnit, 0, 0, this.options.maxProblemsPerUnit));
            JavaModelManager.getJavaModelManager().cacheZipFiles(this);
            INameEnvironment nameEnvironment = IndexBasedJavaSearchEnvironment.create(Collections.singletonList(javaProject), JavaModelManager.getJavaModelManager().getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, true));
            this.lookupEnvironment = new LookupEnvironment(this, this.options, problemReporter, nameEnvironment);
            this.reduceParseTree(this.cud);
            this.lookupEnvironment.buildTypeBindings(this.cud, null);
            this.lookupEnvironment.completeTypeBindings();
            this.cud.scope.faultInTypes();
            this.cud.resolve();
        }
        catch (Exception e) {
            if (JobManager.VERBOSE) {
                e.printStackTrace();
            }
        }
        finally {
            JavaModelManager.getJavaModelManager().flushZipFiles(this);
        }
    }

    private void reduceParseTree(CompilationUnitDeclaration unit) {
        int l;
        TypeDeclaration[] types = unit.types;
        int n = l = types == null ? 0 : types.length;
        for (int i = 0; i < l; ++i) {
            this.purgeMethodStatements(types[i]);
        }
    }

    private void purgeMethodStatements(TypeDeclaration type) {
        int length;
        AbstractMethodDeclaration[] methods = type.methods;
        int n = length = methods == null ? 0 : methods.length;
        for (int j = 0; j < length; ++j) {
            AbstractMethodDeclaration method = methods[j];
            if (method == null || (method.bits & 0x200002) != 0) continue;
            method.statements = null;
            method.javadoc = null;
        }
        TypeDeclaration[] memberTypes = type.memberTypes;
        if (memberTypes != null) {
            int l = memberTypes.length;
            for (int i = 0; i < l; ++i) {
                this.purgeMethodStatements(memberTypes[i]);
            }
        }
    }

    @Override
    public void indexResolvedDocument() {
        block5: {
            try {
                int length = this.cud.functionalExpressionsCount;
                for (int i = 0; i < length; ++i) {
                    MethodBinding binding;
                    FunctionalExpression expression = this.cud.functionalExpressions[i];
                    if (expression instanceof LambdaExpression) {
                        LambdaExpression lambdaExpression = (LambdaExpression)expression;
                        if (lambdaExpression.binding == null || !lambdaExpression.binding.isValidBinding()) continue;
                        char[] superinterface = lambdaExpression.resolvedType.sourceName();
                        this.addIndexEntry(IIndexConstants.METHOD_DECL, MethodPattern.createIndexKey(lambdaExpression.descriptor.selector, lambdaExpression.descriptor.parameters.length));
                        this.addClassDeclaration(0, CharOperation.NO_CHAR, ONE_ZERO, ONE_ZERO_CHAR, CharOperation.NO_CHAR, new char[][]{superinterface}, CharOperation.NO_CHAR_CHAR, true);
                        continue;
                    }
                    ReferenceExpression referenceExpression = (ReferenceExpression)expression;
                    if (referenceExpression.isArrayConstructorReference() || (binding = referenceExpression.getMethodBinding()) == null || !binding.isValidBinding()) continue;
                    if (referenceExpression.isMethodReference()) {
                        this.addMethodReference(binding.selector, binding.parameters.length);
                        continue;
                    }
                    this.addConstructorReference(binding.declaringClass.sourceName(), binding.parameters.length);
                }
            }
            catch (Exception e) {
                if (!JobManager.VERBOSE) break block5;
                e.printStackTrace();
            }
        }
    }
}

