/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.HashMap;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ChangeClasspathOperation;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.util.Util;

public class SetVariablesOperation
extends ChangeClasspathOperation {
    String[] variableNames;
    IPath[] variablePaths;
    boolean updatePreferences;

    public SetVariablesOperation(String[] variableNames, IPath[] variablePaths, boolean updatePreferences) {
        super(new IJavaElement[]{JavaModelManager.getJavaModelManager().getJavaModel()}, !ResourcesPlugin.getWorkspace().isTreeLocked());
        this.variableNames = variableNames;
        this.variablePaths = variablePaths;
        this.updatePreferences = updatePreferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void executeOperation() throws JavaModelException {
        block27: {
            this.checkCanceled();
            try {
                this.beginTask("", 1);
                if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                    this.verbose_set_variables();
                }
                if ((manager = JavaModelManager.getJavaModelManager()).variablePutIfInitializingWithSameValue(this.variableNames, this.variablePaths)) {
                    return;
                }
                varLength = this.variableNames.length;
                affectedProjectClasspaths = new HashMap<JavaProject, IClasspathEntry[]>(5);
                model = this.getJavaModel();
                discardCount = 0;
                for (i = 0; i < varLength; ++i) {
                    variableName = this.variableNames[i];
                    oldPath = manager.variableGet(variableName);
                    if (oldPath == JavaModelManager.VARIABLE_INITIALIZATION_IN_PROGRESS) {
                        oldPath = null;
                    }
                    if (oldPath == null || !oldPath.equals((Object)this.variablePaths[i])) continue;
                    this.variableNames[i] = null;
                    ++discardCount;
                }
                if (discardCount > 0) {
                    if (discardCount == varLength) {
                        return;
                    }
                    changedLength = varLength - discardCount;
                    changedVariableNames = new String[changedLength];
                    changedVariablePaths = new IPath[changedLength];
                    index = 0;
                    for (i = 0; i < varLength; ++i) {
                        if (this.variableNames[i] == null) continue;
                        changedVariableNames[index] = this.variableNames[i];
                        changedVariablePaths[index] = this.variablePaths[i];
                        ++index;
                    }
                    this.variableNames = changedVariableNames;
                    this.variablePaths = changedVariablePaths;
                    varLength = changedLength;
                }
                if (this.isCanceled()) {
                    return;
                }
                projects = model.getJavaProjects();
                projectLength = projects.length;
                block12: for (i = 0; i < projectLength; ++i) {
                    project = (JavaProject)projects[i];
                    for (IClasspathEntry entry : project.getRawClasspath()) {
                        for (k = 0; k < varLength; ++k) {
                            variableName = this.variableNames[k];
                            if (entry.getEntryKind() != 4) continue;
                            if (variableName.equals(entry.getPath().segment(0))) {
                                affectedProjectClasspaths.put(project, project.getResolvedClasspath());
                                continue block12;
                            }
                            sourcePath = entry.getSourceAttachmentPath();
                            if ((sourcePath == null || !variableName.equals(sourcePath.segment(0))) && ((sourceRootPath = entry.getSourceAttachmentRootPath()) == null || !variableName.equals(sourceRootPath.segment(0)))) continue;
                            affectedProjectClasspaths.put(project, project.getResolvedClasspath());
                            continue block12;
                        }
                    }
                }
                for (i = 0; i < varLength; ++i) {
                    manager.variablePut(this.variableNames[i], this.variablePaths[i]);
                    if (!this.updatePreferences) continue;
                    manager.variablePreferencesPut(this.variableNames[i], this.variablePaths[i]);
                }
                if (affectedProjectClasspaths.isEmpty()) break block27;
                dbgVariableNames = this.variableNames;
                projectsToUpdate = affectedProjectClasspaths.keySet().iterator();
                while (projectsToUpdate.hasNext()) {
                    if (this.progressMonitor == null || !this.progressMonitor.isCanceled()) ** break block28
                    return;
                }
                break block27;
                {
                    try {
                        affectedProject = (JavaProject)projectsToUpdate.next();
                        if (JavaModelManager.CP_RESOLVE_VERBOSE_ADVANCED) {
                            this.verbose_update_project(dbgVariableNames, affectedProject);
                        }
                        classpathChange = affectedProject.getPerProjectInfo().resetResolvedClasspath();
                        this.classpathChanged(classpathChange, true);
                        if (!this.canChangeResources) continue;
                        affectedProject.getProject().touch((IProgressMonitor)this.progressMonitor);
                        continue;
                    }
                    catch (CoreException e) {
                        if (JavaModelManager.CP_RESOLVE_VERBOSE || JavaModelManager.CP_RESOLVE_VERBOSE_FAILURE) {
                            this.verbose_failure(dbgVariableNames);
                            e.printStackTrace();
                        }
                        if (e instanceof JavaModelException) {
                            throw (JavaModelException)e;
                        }
                        throw new JavaModelException(e);
                        break;
                    }
                }
            }
            finally {
                this.done();
            }
        }
    }

    private void verbose_failure(String[] dbgVariableNames) {
        Util.verbose("CPVariable SET  - FAILED DUE TO EXCEPTION\n\tvariables: " + org.eclipse.jdt.internal.compiler.util.Util.toString(dbgVariableNames), System.err);
    }

    private void verbose_update_project(String[] dbgVariableNames, JavaProject affectedProject) {
        Util.verbose("CPVariable SET  - updating affected project due to setting variables\n\tproject: " + affectedProject.getElementName() + "\n\tvariables: " + org.eclipse.jdt.internal.compiler.util.Util.toString(dbgVariableNames));
    }

    private void verbose_set_variables() {
        Util.verbose("CPVariable SET  - setting variables\n\tvariables: " + org.eclipse.jdt.internal.compiler.util.Util.toString(this.variableNames) + "\n\tvalues: " + org.eclipse.jdt.internal.compiler.util.Util.toString(this.variablePaths));
    }
}

