/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.ExternalFoldersManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.NonJavaResource;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.util.Util;

class PackageFragmentRootInfo
extends OpenableElementInfo {
    protected SourceMapper sourceMapper = null;
    protected int rootKind = 1;
    private boolean ignoreOptionalProblems;
    private boolean initialized;

    public PackageFragmentRootInfo() {
        this.nonJavaResources = null;
        this.initialized = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Object[] computeFolderNonJavaResources(IPackageFragmentRoot root, IContainer folder, char[][] inclusionPatterns, char[][] exclusionPatterns) throws JavaModelException {
        Object[] nonJavaResources = new IResource[5];
        int nonJavaResourcesCounter = 0;
        try {
            IResource[] members = folder.members();
            int length = members.length;
            if (length > 0) {
                IJavaProject otherJavaProject = JavaCore.create(folder.getProject());
                String sourceLevel = otherJavaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
                String complianceLevel = otherJavaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
                JavaProject javaProject = (JavaProject)root.getJavaProject();
                IClasspathEntry[] classpath = javaProject.getResolvedClasspath();
                block6: for (int i = 0; i < length; ++i) {
                    IResource member = members[i];
                    switch (member.getType()) {
                        case 1: {
                            String fileName = member.getName();
                            if ((!Util.isValidCompilationUnitName(fileName, sourceLevel, complianceLevel) || Util.isExcluded(member, inclusionPatterns, exclusionPatterns)) && !Util.isValidClassFileName(fileName, sourceLevel, complianceLevel) && !PackageFragmentRootInfo.isClasspathEntry(member.getFullPath(), classpath)) break;
                            continue block6;
                        }
                        case 2: {
                            if (Util.isValidFolderNameForPackage(member.getName(), sourceLevel, complianceLevel) && (!Util.isExcluded(member, inclusionPatterns, exclusionPatterns) || PackageFragmentRootInfo.isClasspathEntry(member.getFullPath(), classpath))) continue block6;
                        }
                    }
                    if (nonJavaResources.length == nonJavaResourcesCounter) {
                        Object[] objectArray = nonJavaResources;
                        nonJavaResources = new IResource[nonJavaResourcesCounter * 2];
                        System.arraycopy(objectArray, 0, nonJavaResources, 0, nonJavaResourcesCounter);
                    }
                    nonJavaResources[nonJavaResourcesCounter++] = member;
                }
            }
            if (ExternalFoldersManager.isInternalPathForExternalFolder(folder.getFullPath())) {
                Object[] jarEntryResources = new IJarEntryResource[nonJavaResourcesCounter];
                int i = 0;
                while (true) {
                    if (i >= nonJavaResourcesCounter) {
                        return jarEntryResources;
                    }
                    jarEntryResources[i] = new NonJavaResource(root, (IResource)nonJavaResources[i]);
                    ++i;
                }
            }
            if (nonJavaResources.length != nonJavaResourcesCounter) {
                Object[] objectArray = nonJavaResources;
                nonJavaResources = new IResource[nonJavaResourcesCounter];
                System.arraycopy(objectArray, 0, nonJavaResources, 0, nonJavaResourcesCounter);
            }
            return nonJavaResources;
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    private Object[] computeNonJavaResources(IResource underlyingResource, PackageFragmentRoot handle) {
        Object[] resources = NO_NON_JAVA_RESOURCES;
        try {
            if (underlyingResource.getType() == 2 || underlyingResource.getType() == 4) {
                resources = PackageFragmentRootInfo.computeFolderNonJavaResources(handle, (IContainer)underlyingResource, handle.fullInclusionPatternChars(), handle.fullExclusionPatternChars());
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return resources;
    }

    synchronized Object[] getNonJavaResources(IJavaProject project, IResource underlyingResource, PackageFragmentRoot handle) {
        Object[] resources = this.nonJavaResources;
        if (resources == null) {
            resources = this.computeNonJavaResources(underlyingResource, handle);
            this.nonJavaResources = resources;
        }
        return resources;
    }

    public int getRootKind() {
        return this.rootKind;
    }

    protected SourceMapper getSourceMapper() {
        return this.sourceMapper;
    }

    boolean ignoreOptionalProblems(PackageFragmentRoot packageFragmentRoot) throws JavaModelException {
        if (!this.initialized) {
            this.ignoreOptionalProblems = ((ClasspathEntry)packageFragmentRoot.getRawClasspathEntry()).ignoreOptionalProblems();
            this.initialized = true;
        }
        return this.ignoreOptionalProblems;
    }

    private static boolean isClasspathEntry(IPath path, IClasspathEntry[] resolvedClasspath) {
        for (IClasspathEntry entry : resolvedClasspath) {
            if (!entry.getPath().equals((Object)path)) continue;
            return true;
        }
        return false;
    }

    protected void setRootKind(int newRootKind) {
        this.rootKind = newRootKind;
    }

    protected void setSourceMapper(SourceMapper mapper) {
        this.sourceMapper = mapper;
    }
}

