/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.internal.compiler.util.CharArrayMapper;

public final class CharArrayMap<P>
implements CharArrayMapper<P> {
    private char[][] keyTable;
    private P[] valueTable;
    private int size;

    public CharArrayMap() {
        this(0);
    }

    public CharArrayMap(int estimatedSize) {
        int capacity = estimatedSize > 0 ? estimatedSize : 0;
        this.size = 0;
        this.keyTable = new char[capacity][];
        Object[] x = new Object[capacity];
        this.valueTable = x;
    }

    @Override
    public Collection<P> values() {
        return Arrays.stream(this.valueTable).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Collection<char[]> keys() {
        return Arrays.stream(this.keyTable).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public boolean containsKey(char[] key) {
        for (int i = 0; i < this.size; ++i) {
            if (!Arrays.equals(this.keyTable[i], key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public P get(char[] key) {
        for (int i = 0; i < this.size; ++i) {
            if (!Arrays.equals(this.keyTable[i], key)) continue;
            return this.valueTable[i];
        }
        return null;
    }

    @Override
    public P put(char[] key, P value) {
        int i;
        for (i = 0; i < this.size; ++i) {
            if (!Arrays.equals(this.keyTable[i], key)) continue;
            P previous = this.valueTable[i];
            this.valueTable[i] = value;
            return previous;
        }
        if (i >= this.keyTable.length) {
            this.grow();
        }
        this.keyTable[i] = key;
        this.valueTable[i] = value;
        ++this.size;
        return null;
    }

    void transferTo(CharArrayMapper<P> bigMap) {
        for (int i = 0; i < this.size; ++i) {
            if (this.keyTable[i] == null) continue;
            bigMap.put(this.keyTable[i], this.valueTable[i]);
        }
    }

    private void grow() {
        int capacity = this.keyTable.length > 1 ? this.keyTable.length : 1;
        int newCapacity = capacity * 2;
        this.keyTable = (char[][])Arrays.copyOfRange(this.keyTable, 0, newCapacity);
        this.valueTable = Arrays.copyOfRange(this.valueTable, 0, newCapacity);
    }

    @Override
    public int size() {
        return this.size;
    }

    public String toString() {
        return CharArrayMapper.toString(this);
    }
}

