/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.Invocation;
import org.eclipse.jdt.internal.compiler.ast.ModuleDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.IUpdatableModule;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImportConflictBinding;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.PlainPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBindingSetWrapper;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SortedCompoundNameVector;
import org.eclipse.jdt.internal.compiler.lookup.SortedSimpleNameVector;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeCollisionException;
import org.eclipse.jdt.internal.compiler.lookup.SplitPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.HashtableOfType;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;

public class CompilationUnitScope
extends Scope {
    public LookupEnvironment environment;
    public CompilationUnitDeclaration referenceContext;
    public char[][] currentPackageName;
    public PlainPackageBinding fPackage;
    public ImportBinding[] imports;
    public int importPtr;
    public HashtableOfObject typeOrPackageCache;
    public SourceTypeBinding[] topLevelTypes;
    private SortedCompoundNameVector qualifiedReferences;
    private SortedSimpleNameVector simpleNameReferences;
    private SortedSimpleNameVector rootReferences;
    private LinkedHashSet<ReferenceBindingSetWrapper> referencedTypes;
    private Set<ReferenceBindingSetWrapper> referencedSuperTypesSet;
    private ObjectVector referencedSuperTypes;
    HashtableOfType constantPoolNameUsage;
    private int captureID = 1;
    private ImportBinding[] tempImports;
    private boolean skipCachingImports;
    boolean connectingHierarchy;
    private ArrayList<Invocation> inferredInvocations;
    Map<InferenceVariable.InferenceVarKey, InferenceVariable> uniqueInferenceVariables = new HashMap<InferenceVariable.InferenceVarKey, InferenceVariable>();

    public CompilationUnitScope(CompilationUnitDeclaration unit, LookupEnvironment environment) {
        this(unit, environment.globalOptions);
        this.environment = environment;
    }

    public CompilationUnitScope(CompilationUnitDeclaration unit, CompilerOptions compilerOptions) {
        super(4, null);
        this.referenceContext = unit;
        unit.scope = this;
        char[][] cArray = this.currentPackageName = unit.currentPackage == null ? CharOperation.NO_CHAR_CHAR : unit.currentPackage.tokens;
        if (compilerOptions.produceReferenceInfo) {
            this.qualifiedReferences = new SortedCompoundNameVector();
            this.simpleNameReferences = new SortedSimpleNameVector();
            this.rootReferences = new SortedSimpleNameVector();
            this.referencedTypes = new LinkedHashSet();
            this.referencedSuperTypesSet = new HashSet<ReferenceBindingSetWrapper>();
            this.referencedSuperTypes = new ObjectVector();
        } else {
            this.qualifiedReferences = null;
            this.simpleNameReferences = null;
            this.rootReferences = null;
            this.referencedTypes = null;
            this.referencedSuperTypesSet = null;
            this.referencedSuperTypes = null;
        }
    }

    void buildFieldsAndMethods() {
        int length = this.topLevelTypes.length;
        for (int i = 0; i < length; ++i) {
            this.topLevelTypes[i].scope.buildFieldsAndMethods();
        }
    }

    void buildTypeBindings(AccessRestriction accessRestriction) {
        char[][] expectedPackageName;
        this.topLevelTypes = new SourceTypeBinding[0];
        boolean firstIsSynthetic = false;
        if (this.referenceContext.compilationResult.compilationUnit != null && (expectedPackageName = this.referenceContext.compilationResult.compilationUnit.getPackageName()) != null && !this.referenceContext.isModuleInfo() && !CharOperation.equals(this.currentPackageName, expectedPackageName)) {
            if (this.referenceContext.currentPackage != null || this.referenceContext.types != null || this.referenceContext.imports != null) {
                this.problemReporter().packageIsNotExpectedPackage(this.referenceContext);
            }
            char[][] cArray = this.currentPackageName = expectedPackageName.length == 0 ? CharOperation.NO_CHAR_CHAR : expectedPackageName;
        }
        if (this.currentPackageName == CharOperation.NO_CHAR_CHAR) {
            this.fPackage = this.environment.defaultPackage;
            if (this.referenceContext.isModuleInfo()) {
                ModuleDeclaration moduleDecl = this.referenceContext.moduleDeclaration;
                if (moduleDecl != null) {
                    moduleDecl.createScope(this);
                    moduleDecl.checkAndSetModifiers();
                }
            } else if (this.module() != this.environment.UnNamedModule) {
                this.problemReporter().unnamedPackageInNamedModule(this.module());
            }
        } else {
            this.fPackage = this.environment.createPlainPackage(this.currentPackageName);
            if (this.fPackage == null) {
                if (this.referenceContext.currentPackage != null) {
                    this.problemReporter().packageCollidesWithType(this.referenceContext);
                }
                this.fPackage = this.environment.defaultPackage;
                return;
            }
            if (this.referenceContext.isPackageInfo()) {
                if (this.referenceContext.types == null || this.referenceContext.types.length == 0) {
                    this.referenceContext.types = new TypeDeclaration[1];
                    this.referenceContext.createPackageInfoType();
                    firstIsSynthetic = true;
                }
                if (this.referenceContext.currentPackage != null && this.referenceContext.currentPackage.annotations != null) {
                    this.referenceContext.types[0].annotations = this.referenceContext.currentPackage.annotations;
                }
            }
            this.recordQualifiedReference(this.currentPackageName);
        }
        TypeDeclaration[] types = this.referenceContext.types;
        int typeLength = types == null ? 0 : types.length;
        this.topLevelTypes = new SourceTypeBinding[typeLength];
        int count = 0;
        for (int i = 0; i < typeLength; ++i) {
            char[] mainTypeName;
            TypeDeclaration typeDecl = types[i];
            if (this.environment.root.isProcessingAnnotations && this.environment.isMissingType(typeDecl.name)) {
                throw new SourceTypeCollisionException();
            }
            this.recordSimpleReference(typeDecl.name);
            if (this.fPackage.hasType0Any(typeDecl.name)) {
                if (this.environment.root.isProcessingAnnotations) {
                    throw new SourceTypeCollisionException();
                }
                this.problemReporter().duplicateTypes(this.referenceContext, typeDecl);
                continue;
            }
            if ((typeDecl.modifiers & 1) != 0 && (mainTypeName = this.referenceContext.getMainTypeName()) != null && !CharOperation.equals(mainTypeName, typeDecl.name)) {
                this.problemReporter().publicClassMustMatchFileName(this.referenceContext, typeDecl);
            }
            ClassScope child = new ClassScope(this, typeDecl);
            SourceTypeBinding type = child.buildType(null, this.fPackage, accessRestriction);
            if (firstIsSynthetic && i == 0) {
                type.modifiers |= 0x1000;
            }
            if (type == null) continue;
            this.topLevelTypes[count++] = type;
        }
        if (count != this.topLevelTypes.length) {
            this.topLevelTypes = new SourceTypeBinding[count];
            System.arraycopy(this.topLevelTypes, 0, this.topLevelTypes, 0, count);
        }
        if (this.referenceContext.moduleDeclaration != null) {
            this.module().completeIfNeeded(IUpdatableModule.UpdateKind.MODULE);
            this.referenceContext.moduleDeclaration.resolvePackageDirectives(this);
            this.module().completeIfNeeded(IUpdatableModule.UpdateKind.PACKAGE);
        }
    }

    void checkAndSetImports() {
        TypeDeclaration[] types = this.referenceContext.types;
        if (types != null) {
            for (int i2 = 0; i2 < types.length; ++i2) {
                TypeDeclaration typeDecl = types[i2];
                if (this.fPackage == this.environment.defaultPackage || this.fPackage.getPackage(typeDecl.name, this.module()) == null) continue;
                this.problemReporter().typeCollidesWithPackage(this.referenceContext, typeDecl);
            }
        }
        if (this.referenceContext.moduleDeclaration != null) {
            this.referenceContext.moduleDeclaration.resolveModuleDirectives(this);
        }
        if (this.referenceContext.imports == null) {
            this.imports = this.getDefaultImports();
            return;
        }
        int numberOfStatements = this.referenceContext.imports.length;
        int numberOfImports = numberOfStatements + 1;
        for (int i3 = 0; i3 < numberOfStatements; ++i3) {
            ImportReference importReference = this.referenceContext.imports[i3];
            if ((importReference.bits & 0x20000) == 0 || !CharOperation.equals(TypeConstants.JAVA_LANG, importReference.tokens) || importReference.isStatic()) continue;
            --numberOfImports;
            break;
        }
        ImportBinding[] resolvedImports = new ImportBinding[numberOfImports];
        resolvedImports[0] = this.getDefaultImports()[0];
        int index = 1;
        Predicate<ImportReference> isStaticImport = i -> i.isStatic();
        Predicate<ImportReference> isNotStaticImport = Predicate.not(isStaticImport);
        index = this.resolveImports(numberOfStatements, resolvedImports, index, isNotStaticImport);
        ImportBinding[] temp = new ImportBinding[index];
        System.arraycopy(resolvedImports, 0, temp, 0, index);
        this.imports = temp;
        index = this.resolveImports(numberOfStatements, resolvedImports, index, isStaticImport);
        if (resolvedImports.length > index) {
            ImportBinding[] importBindingArray = resolvedImports;
            resolvedImports = new ImportBinding[index];
            System.arraycopy(importBindingArray, 0, resolvedImports, 0, index);
        }
        this.imports = resolvedImports;
    }

    private int resolveImports(int numberOfStatements, ImportBinding[] resolvedImports, int index, Predicate<ImportReference> filter) {
        block0: for (int i = 0; i < numberOfStatements; ++i) {
            ImportReference importReference = this.referenceContext.imports[i];
            if (!filter.test(importReference)) continue;
            char[][] compoundName = importReference.tokens;
            for (int j = 0; j < index; ++j) {
                ImportBinding resolved = resolvedImports[j];
                if (resolved.onDemand == ((importReference.bits & 0x20000) != 0) && resolved.isStatic() == importReference.isStatic() && CharOperation.equals(compoundName, resolvedImports[j].compoundName)) continue block0;
            }
            if ((importReference.bits & 0x20000) != 0) {
                Binding importBinding;
                if (CharOperation.equals(compoundName, this.currentPackageName) || !(importBinding = this.findImport(compoundName, compoundName.length)).isValidBinding() || importReference.isStatic() && importBinding instanceof PackageBinding) continue;
                resolvedImports[index++] = new ImportBinding(compoundName, true, importBinding, importReference);
                continue;
            }
            resolvedImports[index++] = new ImportBinding(compoundName, false, null, importReference);
        }
        return index;
    }

    void checkParameterizedTypes() {
        if (this.compilerOptions().sourceLevel < 0x310000L) {
            return;
        }
        int length = this.topLevelTypes.length;
        for (int i = 0; i < length; ++i) {
            ClassScope scope = this.topLevelTypes[i].scope;
            scope.checkParameterizedTypeBounds();
            scope.checkParameterizedSuperTypeCollisions();
        }
    }

    public char[] computeConstantPoolName(LocalTypeBinding localType) {
        char[] candidateName;
        boolean isCompliant15;
        if (localType.constantPoolName != null) {
            return localType.constantPoolName;
        }
        if (this.constantPoolNameUsage == null) {
            this.constantPoolNameUsage = new HashtableOfType();
        }
        SourceTypeBinding outerMostEnclosingType = localType.scope.outerMostClassScope().enclosingSourceType();
        int index = 0;
        boolean bl = isCompliant15 = this.compilerOptions().complianceLevel >= 0x310000L;
        while (true) {
            candidateName = localType.isMemberType() ? (index == 0 ? CharOperation.concat(localType.enclosingType().constantPoolName(), localType.sourceName, '$') : CharOperation.concat(localType.enclosingType().constantPoolName(), '$', String.valueOf(index).toCharArray(), '$', localType.sourceName)) : (localType.isAnonymousType() ? (isCompliant15 ? CharOperation.concat(localType.enclosingType.constantPoolName(), String.valueOf(index + 1).toCharArray(), '$') : CharOperation.concat(outerMostEnclosingType.constantPoolName(), String.valueOf(index + 1).toCharArray(), '$')) : (isCompliant15 ? CharOperation.concat(CharOperation.concat(localType.enclosingType().constantPoolName(), String.valueOf(index + 1).toCharArray(), '$'), localType.sourceName) : CharOperation.concat(outerMostEnclosingType.constantPoolName(), '$', String.valueOf(index + 1).toCharArray(), '$', localType.sourceName)));
            if (this.constantPoolNameUsage.get(candidateName) == null) break;
            ++index;
        }
        this.constantPoolNameUsage.put(candidateName, localType);
        return candidateName;
    }

    void connectTypeHierarchy() {
        int i;
        int length = this.topLevelTypes.length;
        for (i = 0; i < length; ++i) {
            this.topLevelTypes[i].scope.connectTypeHierarchy();
        }
        length = this.topLevelTypes.length;
        for (i = 0; i < length; ++i) {
            this.topLevelTypes[i].scope.connectImplicitPermittedTypes();
        }
    }

    void faultInImports() {
        boolean reportUnresolved;
        if (this.tempImports != null) {
            return;
        }
        boolean unresolvedFound = false;
        boolean bl = reportUnresolved = !this.environment.suppressImportErrors;
        if (this.typeOrPackageCache != null && !this.skipCachingImports) {
            return;
        }
        if (this.referenceContext.imports == null) {
            this.typeOrPackageCache = new HashtableOfObject(1);
            return;
        }
        int numberOfStatements = this.referenceContext.imports.length;
        HashtableOfType typesBySimpleNames = null;
        for (int i = 0; i < numberOfStatements; ++i) {
            if ((this.referenceContext.imports[i].bits & 0x20000) != 0) continue;
            typesBySimpleNames = new HashtableOfType(this.topLevelTypes.length + numberOfStatements);
            int length = this.topLevelTypes.length;
            for (int j = 0; j < length; ++j) {
                typesBySimpleNames.put(this.topLevelTypes[j].sourceName, this.topLevelTypes[j]);
            }
            break;
        }
        int numberOfImports = numberOfStatements + 1;
        for (int i = 0; i < numberOfStatements; ++i) {
            ImportReference importReference = this.referenceContext.imports[i];
            if ((importReference.bits & 0x20000) == 0 || !CharOperation.equals(TypeConstants.JAVA_LANG, importReference.tokens) || importReference.isStatic()) continue;
            --numberOfImports;
            break;
        }
        this.tempImports = new ImportBinding[numberOfImports];
        this.tempImports[0] = this.getDefaultImports()[0];
        this.importPtr = 1;
        CompilerOptions compilerOptions = this.compilerOptions();
        boolean inJdtDebugCompileMode = compilerOptions.enableJdtDebugCompileMode;
        block3: for (int i = 0; i < numberOfStatements; ++i) {
            PackageBinding importedPackage;
            SplitPackageBinding splitPackage;
            ImportReference importReference = this.referenceContext.imports[i];
            char[][] compoundName = importReference.getImportName();
            for (int j = 0; j < this.importPtr; ++j) {
                ImportBinding resolved = this.tempImports[j];
                if (resolved.onDemand != ((importReference.bits & 0x20000) != 0) || resolved.isStatic() != importReference.isStatic() || !CharOperation.equals(compoundName, resolved.compoundName) || !CharOperation.equals(importReference.getSimpleName(), resolved.getSimpleName())) continue;
                this.problemReporter().unusedImport(importReference);
                continue block3;
            }
            if ((importReference.bits & 0x20000) != 0) {
                PackageBinding uniquePackage;
                Binding importBinding = this.findImport(compoundName, compoundName.length);
                if (!importBinding.isValidBinding()) {
                    this.problemReporter().importProblem(importReference, importBinding);
                    continue;
                }
                if (importBinding instanceof PackageBinding && (uniquePackage = ((PackageBinding)importBinding).getVisibleFor(this.module(), false)) instanceof SplitPackageBinding && !inJdtDebugCompileMode) {
                    splitPackage = (SplitPackageBinding)uniquePackage;
                    this.problemReporter().conflictingPackagesFromModules(splitPackage, this.module(), importReference.sourceStart, importReference.sourceEnd);
                    continue;
                }
                if (importReference.isStatic() && importBinding instanceof PackageBinding) {
                    this.problemReporter().cannotImportPackage(importReference);
                    continue;
                }
                this.recordImportBinding(new ImportBinding(compoundName, true, importBinding, importReference));
                continue;
            }
            Binding importBinding = this.findSingleImport(compoundName, 13, importReference.isStatic());
            if (importBinding instanceof SplitPackageBinding && !inJdtDebugCompileMode) {
                SplitPackageBinding splitPackage2 = (SplitPackageBinding)importBinding;
                int sourceEnd = (int)(importReference.sourcePositions[splitPackage2.compoundName.length - 1] & 0xFFFFL);
                this.problemReporter().conflictingPackagesFromModules((SplitPackageBinding)importBinding, this.module(), importReference.sourceStart, sourceEnd);
                continue;
            }
            if (!importBinding.isValidBinding() && importBinding.problemId() != 3) {
                unresolvedFound = true;
                if (!reportUnresolved) continue;
                this.problemReporter().importProblem(importReference, importBinding);
                continue;
            }
            if (importBinding instanceof PackageBinding) {
                this.problemReporter().cannotImportPackage(importReference);
                continue;
            }
            if (this.environment.useModuleSystem && importBinding instanceof ReferenceBinding && (importedPackage = ((ReferenceBinding)importBinding).fPackage) != null) {
                if (!importedPackage.isValidBinding()) {
                    this.problemReporter().importProblem(importReference, importedPackage);
                    continue;
                }
                importedPackage = (PackageBinding)this.findImport(importedPackage.compoundName, false, true);
                if (importedPackage != null) {
                    importedPackage = importedPackage.getVisibleFor(this.module(), true);
                }
                if (importedPackage instanceof SplitPackageBinding && !inJdtDebugCompileMode) {
                    splitPackage = (SplitPackageBinding)importedPackage;
                    int sourceEnd = (int)importReference.sourcePositions[splitPackage.compoundName.length - 1];
                    this.problemReporter().conflictingPackagesFromModules(splitPackage, this.module(), importReference.sourceStart, sourceEnd);
                    continue;
                }
            }
            if (this.checkAndRecordImportBinding(importBinding, typesBySimpleNames, importReference, compoundName) == -1 || !importReference.isStatic()) continue;
            if (importBinding.kind() == 1) {
                this.checkMoreStaticBindings(compoundName, typesBySimpleNames, 12, importReference);
                continue;
            }
            if (importBinding.kind() != 8) continue;
            this.checkMoreStaticBindings(compoundName, typesBySimpleNames, 4, importReference);
        }
        if (this.tempImports.length > this.importPtr) {
            this.tempImports = new ImportBinding[this.importPtr];
            System.arraycopy(this.tempImports, 0, this.tempImports, 0, this.importPtr);
        }
        this.imports = this.tempImports;
        this.tempImports = null;
        int length = this.imports.length;
        this.typeOrPackageCache = new HashtableOfObject(length);
        for (int i = 0; i < length; ++i) {
            ImportBinding binding = this.imports[i];
            if ((binding.onDemand || !(binding.resolvedImport instanceof ReferenceBinding)) && !(binding instanceof ImportConflictBinding)) continue;
            this.typeOrPackageCache.put(binding.getSimpleName(), binding);
        }
        this.skipCachingImports = this.environment.suppressImportErrors && unresolvedFound;
    }

    public void faultInTypes() {
        this.faultInImports();
        if (this.referenceContext.moduleDeclaration != null) {
            this.referenceContext.moduleDeclaration.resolveTypeDirectives(this);
        } else if (this.referenceContext.currentPackage != null) {
            this.referenceContext.currentPackage.checkPackageConflict(this);
        }
        int length = this.topLevelTypes.length;
        for (int i = 0; i < length; ++i) {
            this.topLevelTypes[i].faultInTypesForFieldsAndMethods();
        }
    }

    public Binding findImport(char[][] compoundName, boolean findStaticImports, boolean onDemand) {
        if (onDemand) {
            return this.findImport(compoundName, compoundName.length);
        }
        return this.findSingleImport(compoundName, 13, findStaticImports);
    }

    private Binding findImport(char[][] compoundName, int length) {
        ReferenceBinding type;
        int i;
        Binding binding;
        ModuleBinding module;
        block16: {
            this.recordQualifiedReference(compoundName);
            module = this.module();
            binding = this.environment.getTopLevelPackage(compoundName[0]);
            i = 1;
            if (binding != null) {
                PackageBinding packageBinding = binding;
                while (i < length) {
                    if ((binding = packageBinding.getTypeOrPackage(compoundName[i++], module, i < length)) instanceof ReferenceBinding && binding.problemId() == 30) {
                        return this.environment.convertToRawType((TypeBinding)binding, false);
                    }
                    if (binding == null) break block16;
                    if (!binding.isValidBinding()) {
                        if (binding.problemId() == 3 && packageBinding instanceof SplitPackageBinding) {
                            return packageBinding;
                        }
                        binding = null;
                        break block16;
                    }
                    if (!(binding instanceof PackageBinding)) {
                        PackageBinding visibleFor = packageBinding.getVisibleFor(module, false);
                        if (visibleFor instanceof SplitPackageBinding) {
                            return visibleFor;
                        }
                        break block16;
                    }
                    packageBinding = (PackageBinding)binding;
                }
                if (packageBinding.isValidBinding() && !module.canAccess(packageBinding)) {
                    return new ProblemPackageBinding(compoundName, 30, this.environment);
                }
                return packageBinding;
            }
        }
        if (binding == null) {
            Binding inaccessible;
            if (!module.isUnnamed() && (inaccessible = this.environment.getInaccessibleBinding(compoundName, module)) != null) {
                return inaccessible;
            }
            if (this.compilerOptions().complianceLevel >= 0x300000L) {
                return this.problemType(compoundName, i, null);
            }
            type = this.findType(compoundName[0], this.environment.defaultPackage, this.environment.defaultPackage);
            if (type == null || !type.isValidBinding()) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, i), null, 1);
            }
            i = 1;
        } else {
            type = (ReferenceBinding)binding;
        }
        while (i < length) {
            char[] name;
            if (!(type = (ReferenceBinding)this.environment.convertToRawType(type, false)).canBeSeenBy(this.fPackage)) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, i), type, 2);
            }
            if ((type = type.getMemberType(name = compoundName[i++])) != null) continue;
            return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, i), null, 1);
        }
        if (!type.canBeSeenBy(this.fPackage)) {
            return new ProblemReferenceBinding(compoundName, type, 2);
        }
        return type;
    }

    private Binding findSingleImport(char[][] compoundName, int mask, boolean findStaticImports) {
        if (compoundName.length == 1) {
            if (this.compilerOptions().complianceLevel >= 0x300000L && !this.referenceContext.isModuleInfo()) {
                return new ProblemReferenceBinding(compoundName, null, 1);
            }
            ReferenceBinding typeBinding = this.findType(compoundName[0], this.environment.defaultPackage, this.fPackage);
            if (typeBinding == null) {
                return new ProblemReferenceBinding(compoundName, null, 1);
            }
            return typeBinding;
        }
        if (findStaticImports) {
            return this.findSingleStaticImport(compoundName, mask);
        }
        return this.findImport(compoundName, compoundName.length);
    }

    private Binding findSingleStaticImport(char[][] compoundName, int mask) {
        MethodBinding method;
        FieldBinding field;
        Binding binding = this.findImport(compoundName, compoundName.length - 1);
        if (!binding.isValidBinding()) {
            return binding;
        }
        char[] name = compoundName[compoundName.length - 1];
        if (binding instanceof PackageBinding) {
            Binding temp = ((PackageBinding)binding).getTypeOrPackage(name, this.module(), false);
            if (temp != null && temp instanceof ReferenceBinding) {
                return new ProblemReferenceBinding(compoundName, (ReferenceBinding)temp, 14);
            }
            return binding;
        }
        ReferenceBinding type = (ReferenceBinding)binding;
        FieldBinding fieldBinding = field = (mask & 1) != 0 ? this.findField(type, name, null, true) : null;
        if (field != null) {
            if (field.problemId() == 3 && ((ProblemFieldBinding)field).closestMatch.isStatic()) {
                return field;
            }
            if (field.isValidBinding() && field.isStatic() && field.canBeSeenBy(type, null, this)) {
                return field;
            }
        }
        MethodBinding methodBinding = method = (mask & 8) != 0 ? this.findStaticMethod(type, name) : null;
        if (method != null) {
            return method;
        }
        if ((type = this.findMemberType(name, type)) == null || !type.isStatic()) {
            if (field != null && !field.isValidBinding() && field.problemId() != 1) {
                return field;
            }
            return new ProblemReferenceBinding(compoundName, type, 1);
        }
        if (type.isValidBinding() && !type.canBeSeenBy(this.fPackage)) {
            return new ProblemReferenceBinding(compoundName, type, 2);
        }
        if (type.problemId() == 2) {
            return new ProblemReferenceBinding(compoundName, ((ProblemReferenceBinding)type).closestMatch, 2);
        }
        return type;
    }

    private MethodBinding findStaticMethod(ReferenceBinding currentType, char[] selector) {
        if (!currentType.canBeSeenBy(this)) {
            return null;
        }
        do {
            currentType.initializeForStaticImports();
            MethodBinding[] methods = currentType.getMethods(selector);
            if (methods == Binding.NO_METHODS) continue;
            int i = methods.length;
            while (--i >= 0) {
                MethodBinding method = methods[i];
                if (!method.isStatic() || !method.canBeSeenBy(this.fPackage)) continue;
                return method;
            }
        } while ((currentType = currentType.superclass()) != null);
        return null;
    }

    ImportBinding[] getDefaultImports() {
        if (this.environment.root.defaultImports != null) {
            return this.environment.root.defaultImports;
        }
        Binding importBinding = this.environment.getTopLevelPackage(TypeConstants.JAVA);
        if (importBinding != null) {
            importBinding = importBinding.getTypeOrPackage(TypeConstants.JAVA_LANG[1], this.module(), false);
        }
        if (importBinding == null || !importBinding.isValidBinding()) {
            this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_OBJECT, this.referenceContext, this.environment.missingClassFileLocation, false, null);
            MissingTypeBinding missingObject = this.environment.createMissingType(null, TypeConstants.JAVA_LANG_OBJECT);
            importBinding = missingObject.fPackage;
        }
        this.environment.root.defaultImports = new ImportBinding[]{new ImportBinding(TypeConstants.JAVA_LANG, true, importBinding, null)};
        return this.environment.root.defaultImports;
    }

    public final Binding getImport(char[][] compoundName, boolean onDemand, boolean isStaticImport) {
        if (onDemand) {
            return this.findImport(compoundName, compoundName.length);
        }
        return this.findSingleImport(compoundName, 13, isStaticImport);
    }

    public int nextCaptureID() {
        return this.captureID++;
    }

    @Override
    public ModuleBinding module() {
        if (!this.referenceContext.isModuleInfo() && this.referenceContext.types == null && this.referenceContext.currentPackage == null && this.referenceContext.imports == null) {
            this.environment = this.environment.UnNamedModule.environment;
            return this.environment.UnNamedModule;
        }
        return super.module();
    }

    @Override
    public ProblemReporter problemReporter() {
        ProblemReporter problemReporter = this.referenceContext.problemReporter;
        problemReporter.referenceContext = this.referenceContext;
        return problemReporter;
    }

    void recordQualifiedReference(char[][] qualifiedName) {
        if (this.qualifiedReferences == null) {
            return;
        }
        int length = ((char[][])qualifiedName).length;
        if (length > 1) {
            this.recordRootReference(qualifiedName[0]);
            while (this.qualifiedReferences.add((char[][])qualifiedName)) {
                if (length == 2) {
                    this.recordSimpleReference(qualifiedName[0]);
                    this.recordSimpleReference(qualifiedName[1]);
                    return;
                }
                this.recordSimpleReference(qualifiedName[--length]);
                char[][] cArray = qualifiedName;
                char[][] cArrayArray = new char[length][];
                qualifiedName = cArrayArray;
                System.arraycopy(cArray, 0, cArrayArray, 0, length);
            }
        } else if (length == 1) {
            this.recordRootReference(qualifiedName[0]);
            this.recordSimpleReference(qualifiedName[0]);
        }
    }

    void recordReference(char[][] qualifiedEnclosingName, char[] simpleName) {
        this.recordQualifiedReference(qualifiedEnclosingName);
        if (qualifiedEnclosingName.length == 0) {
            this.recordRootReference(simpleName);
        }
        this.recordSimpleReference(simpleName);
    }

    void recordReference(ReferenceBinding type, char[] simpleName) {
        ReferenceBinding actualType = this.typeToRecord(type);
        if (actualType != null) {
            this.recordReference(actualType.compoundName, simpleName);
        }
    }

    void recordRootReference(char[] simpleName) {
        if (this.rootReferences == null) {
            return;
        }
        this.rootReferences.add(simpleName);
    }

    void recordSimpleReference(char[] simpleName) {
        if (this.simpleNameReferences == null) {
            return;
        }
        this.simpleNameReferences.add(simpleName);
    }

    void recordSuperTypeReference(TypeBinding type) {
        if (this.referencedSuperTypes == null) {
            return;
        }
        ReferenceBinding actualType = this.typeToRecord(type);
        if (actualType != null && this.referencedSuperTypesSet.add(new ReferenceBindingSetWrapper(actualType))) {
            this.referencedSuperTypes.add(actualType);
        }
    }

    public void recordTypeConversion(TypeBinding superType, TypeBinding subType) {
        this.recordSuperTypeReference(subType);
    }

    void recordTypeReference(TypeBinding type) {
        if (this.referencedTypes == null) {
            return;
        }
        ReferenceBinding actualType = this.typeToRecord(type);
        if (actualType != null) {
            this.referencedTypes.add(new ReferenceBindingSetWrapper(actualType));
        }
    }

    void recordTypeReferences(TypeBinding[] types) {
        if (this.referencedTypes == null) {
            return;
        }
        if (types == null || types.length == 0) {
            return;
        }
        int max = types.length;
        for (int i = 0; i < max; ++i) {
            ReferenceBinding actualType = this.typeToRecord(types[i]);
            if (actualType == null) continue;
            this.referencedTypes.add(new ReferenceBindingSetWrapper(actualType));
        }
    }

    Binding resolveSingleImport(ImportBinding importBinding, int mask) {
        if (importBinding.resolvedImport == null) {
            importBinding.resolvedImport = this.findSingleImport(importBinding.compoundName, mask, importBinding.isStatic());
            if (!importBinding.resolvedImport.isValidBinding() || importBinding.resolvedImport instanceof PackageBinding) {
                if (importBinding.resolvedImport.problemId() == 3) {
                    return importBinding.resolvedImport;
                }
                if (this.imports != null) {
                    ImportBinding[] newImports = new ImportBinding[this.imports.length - 1];
                    int n = 0;
                    int max = this.imports.length;
                    for (int i = 0; i < max; ++i) {
                        if (this.imports[i] == importBinding) continue;
                        newImports[n++] = this.imports[i];
                    }
                    this.imports = newImports;
                }
                return null;
            }
        }
        return importBinding.resolvedImport;
    }

    public void storeDependencyInfo() {
        for (int i = 0; i < this.referencedSuperTypes.size; ++i) {
            ReferenceBinding[] interfaces;
            ReferenceBinding superclass;
            ReferenceBinding enclosing;
            ReferenceBinding type = (ReferenceBinding)this.referencedSuperTypes.elementAt(i);
            this.referencedTypes.add(new ReferenceBindingSetWrapper(type));
            if (!type.isLocalType() && (enclosing = type.enclosingType()) != null) {
                this.recordSuperTypeReference(enclosing);
            }
            if ((superclass = type.superclass()) != null) {
                this.recordSuperTypeReference(superclass);
            }
            if ((interfaces = type.superInterfaces()) == null) continue;
            int length = interfaces.length;
            for (int j = 0; j < length; ++j) {
                this.recordSuperTypeReference(interfaces[j]);
            }
        }
        for (ReferenceBindingSetWrapper wrapper : this.referencedTypes) {
            ReferenceBinding type = wrapper.referenceBinding;
            if (type.isLocalType()) continue;
            this.recordQualifiedReference(type.isMemberType() ? CharOperation.splitOn('.', type.readableName()) : type.compoundName);
        }
        int size = this.qualifiedReferences.size;
        char[][][] qualifiedRefs = new char[size][][];
        for (int i = 0; i < size; ++i) {
            qualifiedRefs[i] = this.qualifiedReferences.elementAt(i);
        }
        this.referenceContext.compilationResult.qualifiedReferences = qualifiedRefs;
        size = this.simpleNameReferences.size;
        char[][] simpleRefs = new char[size][];
        for (int i = 0; i < size; ++i) {
            simpleRefs[i] = this.simpleNameReferences.elementAt(i);
        }
        this.referenceContext.compilationResult.simpleNameReferences = simpleRefs;
        size = this.rootReferences.size;
        char[][] rootRefs = new char[size][];
        for (int i = 0; i < size; ++i) {
            rootRefs[i] = this.rootReferences.elementAt(i);
        }
        this.referenceContext.compilationResult.rootReferences = rootRefs;
    }

    public String toString() {
        return "--- CompilationUnit Scope : " + new String(this.referenceContext.getFileName());
    }

    private ReferenceBinding typeToRecord(TypeBinding type) {
        if (type == null) {
            return null;
        }
        while (type.isArrayType()) {
            type = ((ArrayBinding)type).leafComponentType();
        }
        switch (type.kind()) {
            case 132: 
            case 516: 
            case 4100: 
            case 8196: 
            case 32772: 
            case 65540: {
                return null;
            }
            case 260: 
            case 1028: {
                type = type.erasure();
            }
        }
        ReferenceBinding refType = (ReferenceBinding)type;
        if (refType.isLocalType()) {
            return null;
        }
        return refType;
    }

    public void verifyMethods(MethodVerifier verifier) {
        int length = this.topLevelTypes.length;
        for (int i = 0; i < length; ++i) {
            this.topLevelTypes[i].verifyMethods(verifier);
        }
    }

    private void recordImportBinding(ImportBinding bindingToAdd) {
        if (this.tempImports.length == this.importPtr) {
            this.tempImports = new ImportBinding[this.importPtr + 1];
            System.arraycopy(this.tempImports, 0, this.tempImports, 0, this.importPtr);
        }
        this.tempImports[this.importPtr++] = bindingToAdd;
    }

    private void checkMoreStaticBindings(char[][] compoundName, HashtableOfType typesBySimpleNames, int mask, ImportReference importReference) {
        Binding importBinding = this.findSingleStaticImport(compoundName, mask);
        if (!importBinding.isValidBinding()) {
            if (importBinding.problemId() == 3) {
                this.checkAndRecordImportBinding(importBinding, typesBySimpleNames, importReference, compoundName);
            }
        } else {
            this.checkAndRecordImportBinding(importBinding, typesBySimpleNames, importReference, compoundName);
        }
        if ((mask & 8) != 0 && importBinding.kind() == 8) {
            this.checkMoreStaticBindings(compoundName, typesBySimpleNames, mask &= 0xFFFFFFF7, importReference);
        }
    }

    private int checkAndRecordImportBinding(Binding importBinding, HashtableOfType typesBySimpleNames, ImportReference importReference, char[][] compoundName) {
        ReferenceBinding conflictingType = null;
        if (importBinding instanceof MethodBinding && (!(conflictingType = (ReferenceBinding)this.getType(compoundName, compoundName.length)).isValidBinding() || importReference.isStatic() && !conflictingType.isStatic())) {
            conflictingType = null;
        }
        char[] name = importReference.getSimpleName();
        if (importBinding instanceof ReferenceBinding || conflictingType != null) {
            ReferenceBinding existingType;
            ReferenceBinding typeToCheck;
            ReferenceBinding referenceBinding = conflictingType == null ? (ReferenceBinding)importBinding : conflictingType;
            ReferenceBinding referenceBinding2 = typeToCheck = referenceBinding.problemId() == 3 ? ((ProblemReferenceBinding)referenceBinding).closestMatch : referenceBinding;
            if (importReference.isTypeUseDeprecated(typeToCheck, this)) {
                this.problemReporter().deprecatedType(typeToCheck, importReference);
            }
            if ((existingType = typesBySimpleNames.get(name)) != null) {
                int j;
                if (TypeBinding.equalsEquals(existingType, referenceBinding)) {
                    for (int j2 = 0; j2 < this.importPtr; ++j2) {
                        ImportBinding resolved = this.tempImports[j2];
                        if (resolved instanceof ImportConflictBinding) {
                            ImportConflictBinding importConflictBinding = (ImportConflictBinding)resolved;
                            if (!TypeBinding.equalsEquals(importConflictBinding.conflictingTypeBinding, referenceBinding) || importReference.isStatic()) continue;
                            this.problemReporter().duplicateImport(importReference);
                            this.recordImportBinding(new ImportBinding(compoundName, false, importBinding, importReference));
                            continue;
                        }
                        if (resolved.resolvedImport != referenceBinding || importReference.isStatic() == resolved.isStatic()) continue;
                        this.recordImportBinding(new ImportBinding(compoundName, false, importBinding, importReference));
                    }
                    return -1;
                }
                int length = this.topLevelTypes.length;
                for (j = 0; j < length; ++j) {
                    if (!CharOperation.equals(this.topLevelTypes[j].sourceName, existingType.sourceName)) continue;
                    this.problemReporter().conflictingImport(importReference);
                    return -1;
                }
                if (importReference.isStatic() && importBinding instanceof ReferenceBinding && this.compilerOptions().sourceLevel >= 0x340000L) {
                    for (j = 0; j < this.importPtr; ++j) {
                        ImportBinding resolved = this.tempImports[j];
                        if (!resolved.isStatic() || !(resolved.resolvedImport instanceof ReferenceBinding) || importBinding == resolved.resolvedImport || !CharOperation.equals(compoundName[compoundName.length - 1], resolved.compoundName[resolved.compoundName.length - 1])) continue;
                        ReferenceBinding type = (ReferenceBinding)resolved.resolvedImport;
                        resolved.resolvedImport = new ProblemReferenceBinding(new char[][]{name}, type, 3);
                        return -1;
                    }
                }
                this.problemReporter().duplicateImport(importReference);
                return -1;
            }
            typesBySimpleNames.put(name, referenceBinding);
        } else if (importBinding instanceof FieldBinding) {
            for (int j = 0; j < this.importPtr; ++j) {
                ImportBinding resolved = this.tempImports[j];
                if (!resolved.isStatic() || !(resolved.resolvedImport instanceof FieldBinding) || importBinding == resolved.resolvedImport || !CharOperation.equals(name, resolved.compoundName[resolved.compoundName.length - 1])) continue;
                if (this.compilerOptions().sourceLevel >= 0x340000L) {
                    FieldBinding field = (FieldBinding)resolved.resolvedImport;
                    resolved.resolvedImport = new ProblemFieldBinding(field, field.declaringClass, name, 3);
                    return -1;
                }
                this.problemReporter().duplicateImport(importReference);
                return -1;
            }
        }
        if (conflictingType == null) {
            this.recordImportBinding(new ImportBinding(compoundName, false, importBinding, importReference));
        } else {
            this.recordImportBinding(new ImportConflictBinding(compoundName, importBinding, conflictingType, importReference));
        }
        return this.importPtr;
    }

    @Override
    public boolean hasDefaultNullnessFor(int location, int sourceStart) {
        int nonNullByDefaultValue = this.localNonNullByDefaultValue(sourceStart);
        if (nonNullByDefaultValue != 0) {
            return (nonNullByDefaultValue & location) != 0;
        }
        if (this.fPackage != null) {
            return (this.fPackage.getDefaultNullness() & location) != 0;
        }
        return false;
    }

    @Override
    public Binding checkRedundantDefaultNullness(int nullBits, int sourceStart) {
        Binding target = this.localCheckRedundantDefaultNullness(nullBits, sourceStart);
        if (target != null) {
            return target;
        }
        if (this.fPackage != null) {
            return this.fPackage.findDefaultNullnessTarget(n -> n == nullBits);
        }
        return null;
    }

    public void registerInferredInvocation(Invocation invocation) {
        if (this.inferredInvocations == null) {
            this.inferredInvocations = new ArrayList();
        }
        this.inferredInvocations.add(invocation);
    }

    public void cleanUpInferenceContexts() {
        if (this.inferredInvocations == null) {
            return;
        }
        for (Invocation invocation : this.inferredInvocations) {
            invocation.cleanUpInferenceContexts();
        }
        this.inferredInvocations = null;
    }
}

