/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.IntersectionTypeBinding18;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class CaptureBinding18
extends CaptureBinding {
    TypeBinding[] upperBounds;
    private char[] originalName;
    private CaptureBinding18 prototype;
    int recursionLevel = 0;

    public CaptureBinding18(ReferenceBinding contextType, char[] sourceName, char[] originalName, int start, int end, int captureID, LookupEnvironment environment) {
        super(contextType, sourceName, start, end, captureID, environment);
        this.originalName = originalName;
        this.prototype = this;
    }

    private CaptureBinding18(CaptureBinding18 prototype) {
        super(prototype);
        this.sourceName = CharOperation.append(prototype.sourceName, '\'');
        this.originalName = prototype.originalName;
        this.upperBounds = prototype.upperBounds;
        this.prototype = prototype.prototype;
    }

    public boolean setUpperBounds(TypeBinding[] upperBounds, ReferenceBinding javaLangObject) {
        this.upperBounds = upperBounds;
        if (upperBounds.length > 0) {
            this.firstBound = upperBounds[0];
        }
        int numReferenceInterfaces = 0;
        if (!CaptureBinding18.isConsistentIntersection(upperBounds)) {
            return false;
        }
        for (int i = 0; i < upperBounds.length; ++i) {
            TypeBinding aBound = upperBounds[i];
            if (aBound instanceof ReferenceBinding) {
                if (this.superclass == null && aBound.isClass()) {
                    this.superclass = (ReferenceBinding)aBound;
                    continue;
                }
                if (!aBound.isInterface()) continue;
                ++numReferenceInterfaces;
                continue;
            }
            if (!TypeBinding.equalsEquals(aBound.leafComponentType(), this)) continue;
            return false;
        }
        this.superInterfaces = new ReferenceBinding[numReferenceInterfaces];
        int idx = 0;
        for (int i = 0; i < upperBounds.length; ++i) {
            TypeBinding aBound = upperBounds[i];
            if (!aBound.isInterface()) continue;
            this.superInterfaces[idx++] = (ReferenceBinding)aBound;
        }
        if (this.superclass == null) {
            this.superclass = javaLangObject;
        }
        return true;
    }

    @Override
    public void initializeBounds(Scope scope, ParameterizedTypeBinding capturedParameterizedType) {
    }

    @Override
    public TypeBinding clone(TypeBinding enclosingType) {
        return new CaptureBinding18(this);
    }

    @Override
    public MethodBinding[] getMethods(char[] selector) {
        if (this.upperBounds.length == 1 && this.upperBounds[0] instanceof ReferenceBinding) {
            return ((ReferenceBinding)this.upperBounds[0]).getMethods(selector);
        }
        return super.getMethods(selector);
    }

    @Override
    public TypeBinding erasure() {
        if (this.upperBounds != null && this.upperBounds.length > 1) {
            ReferenceBinding[] erasures = new ReferenceBinding[this.upperBounds.length];
            boolean multipleErasures = false;
            for (int i = 0; i < this.upperBounds.length; ++i) {
                erasures[i] = (ReferenceBinding)this.upperBounds[i].erasure();
                if (i <= 0 || !TypeBinding.notEquals(erasures[0], erasures[i])) continue;
                multipleErasures = true;
            }
            if (!multipleErasures) {
                return erasures[0];
            }
            return this.environment.createIntersectionType18(erasures);
        }
        if (this.superclass == null) {
            return this.environment.getType(TypeConstants.JAVA_LANG_OBJECT);
        }
        return super.erasure();
    }

    @Override
    public boolean isEquivalentTo(TypeBinding otherType) {
        if (CaptureBinding18.equalsEquals(this, otherType)) {
            return true;
        }
        if (otherType == null) {
            return false;
        }
        if (this.upperBounds != null) {
            block3: for (int i = 0; i < this.upperBounds.length; ++i) {
                TypeBinding aBound = this.upperBounds[i];
                if (aBound != null && aBound.isArrayType()) {
                    if (aBound.isCompatibleWith(otherType)) continue;
                    return false;
                }
                switch (otherType.kind()) {
                    case 516: 
                    case 8196: {
                        if (((WildcardBinding)otherType).boundCheck(aBound)) continue block3;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean isCompatibleWith(TypeBinding otherType, Scope captureScope) {
        if (TypeBinding.equalsEquals(this, otherType)) {
            return true;
        }
        if (this.inRecursiveFunction) {
            return true;
        }
        this.inRecursiveFunction = true;
        try {
            if (this.upperBounds != null) {
                void var6_10;
                int length = this.upperBounds.length;
                int rightKind = otherType.kind();
                ReferenceBinding[] rightIntersectingTypes = null;
                if (rightKind == 8196 && otherType.boundKind() == 1) {
                    TypeBinding typeBinding = ((WildcardBinding)otherType).allBounds();
                    if (typeBinding instanceof IntersectionTypeBinding18) {
                        rightIntersectingTypes = ((IntersectionTypeBinding18)typeBinding).intersectingTypes;
                    }
                } else if (rightKind == 32772) {
                    rightIntersectingTypes = ((IntersectionTypeBinding18)otherType).intersectingTypes;
                }
                if (rightIntersectingTypes != null) {
                    block6: for (ReferenceBinding required : rightIntersectingTypes) {
                        for (TypeBinding provided : this.upperBounds) {
                            if (provided.isCompatibleWith(required, captureScope)) continue block6;
                        }
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                while (var6_10 < length) {
                    if (this.upperBounds[var6_10].isCompatibleWith(otherType, captureScope)) {
                        boolean bl2 = true;
                        return bl2;
                    }
                    ++var6_10;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.inRecursiveFunction = false;
        }
    }

    @Override
    public TypeBinding findSuperTypeOriginatingFrom(TypeBinding otherType) {
        if (this.upperBounds != null && this.upperBounds.length > 1) {
            for (int i = 0; i < this.upperBounds.length; ++i) {
                TypeBinding candidate = this.upperBounds[i].findSuperTypeOriginatingFrom(otherType);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return super.findSuperTypeOriginatingFrom(otherType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    TypeBinding substituteInferenceVariable(InferenceVariable var, TypeBinding substituteType) {
        if (this.inRecursiveFunction) {
            return this;
        }
        this.inRecursiveFunction = true;
        try {
            boolean haveSubstitution = false;
            ReferenceBinding currentSuperclass = this.superclass;
            if (currentSuperclass != null) {
                currentSuperclass = (ReferenceBinding)currentSuperclass.substituteInferenceVariable(var, substituteType);
                haveSubstitution |= TypeBinding.notEquals(currentSuperclass, this.superclass);
            }
            ReferenceBinding[] currentSuperInterfaces = null;
            if (this.superInterfaces != null) {
                int length = this.superInterfaces.length;
                if (haveSubstitution) {
                    currentSuperInterfaces = new ReferenceBinding[length];
                    System.arraycopy(this.superInterfaces, 0, currentSuperInterfaces, 0, length);
                }
                for (int i = 0; i < length; ++i) {
                    ReferenceBinding currentSuperInterface = this.superInterfaces[i];
                    if (currentSuperInterface == null || !TypeBinding.notEquals(currentSuperInterface = (ReferenceBinding)currentSuperInterface.substituteInferenceVariable(var, substituteType), this.superInterfaces[i])) continue;
                    if (currentSuperInterfaces == null) {
                        currentSuperInterfaces = new ReferenceBinding[length];
                        System.arraycopy(this.superInterfaces, 0, currentSuperInterfaces, 0, length);
                    }
                    currentSuperInterfaces[i] = currentSuperInterface;
                    haveSubstitution = true;
                }
            }
            TypeBinding[] currentUpperBounds = null;
            if (this.upperBounds != null) {
                int length = this.upperBounds.length;
                if (haveSubstitution) {
                    currentUpperBounds = new TypeBinding[length];
                    System.arraycopy(this.upperBounds, 0, currentUpperBounds, 0, length);
                }
                for (int i = 0; i < length; ++i) {
                    TypeBinding currentBound = this.upperBounds[i];
                    if (currentBound == null || !TypeBinding.notEquals(currentBound = currentBound.substituteInferenceVariable(var, substituteType), this.upperBounds[i])) continue;
                    if (currentUpperBounds == null) {
                        currentUpperBounds = new TypeBinding[length];
                        System.arraycopy(this.upperBounds, 0, currentUpperBounds, 0, length);
                    }
                    currentUpperBounds[i] = currentBound;
                    haveSubstitution = true;
                }
            }
            TypeBinding currentFirstBound = null;
            if (this.firstBound != null) {
                currentFirstBound = this.firstBound.substituteInferenceVariable(var, substituteType);
                haveSubstitution |= TypeBinding.notEquals(this.firstBound, currentFirstBound);
            }
            if (haveSubstitution) {
                final CaptureBinding18 newCapture = (CaptureBinding18)this.clone(this.enclosingType());
                newCapture.tagBits = this.tagBits;
                Substitution substitution = new Substitution(){

                    @Override
                    public TypeBinding substitute(TypeVariableBinding typeVariable) {
                        return typeVariable == CaptureBinding18.this ? newCapture : typeVariable;
                    }

                    @Override
                    public boolean isRawSubstitution() {
                        return false;
                    }

                    @Override
                    public LookupEnvironment environment() {
                        return CaptureBinding18.this.environment;
                    }
                };
                if (currentFirstBound != null) {
                    newCapture.firstBound = Scope.substitute(substitution, currentFirstBound);
                }
                newCapture.superclass = (ReferenceBinding)Scope.substitute(substitution, currentSuperclass);
                newCapture.superInterfaces = Scope.substitute(substitution, currentSuperInterfaces);
                newCapture.upperBounds = Scope.substitute(substitution, currentUpperBounds);
                CaptureBinding18 captureBinding18 = newCapture;
                return captureBinding18;
            }
            CaptureBinding18 captureBinding18 = this;
            return captureBinding18;
        }
        finally {
            this.inRecursiveFunction = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProperType(boolean admitCapture18) {
        if (!admitCapture18) {
            return false;
        }
        if (this.inRecursiveFunction) {
            return true;
        }
        this.inRecursiveFunction = true;
        try {
            if (this.lowerBound != null && !this.lowerBound.isProperType(admitCapture18)) {
                boolean bl = false;
                return bl;
            }
            if (this.upperBounds != null) {
                for (int i = 0; i < this.upperBounds.length; ++i) {
                    if (this.upperBounds[i].isProperType(admitCapture18)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            this.inRecursiveFunction = false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] readableName() {
        if (this.lowerBound == null && this.firstBound != null) {
            if (this.prototype.recursionLevel < 2) {
                try {
                    ++this.prototype.recursionLevel;
                    if (this.upperBounds != null && this.upperBounds.length > 1) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(this.upperBounds[0].readableName());
                        for (int i = 1; i < this.upperBounds.length; ++i) {
                            sb.append('&').append(this.upperBounds[i].readableName());
                        }
                        int len = sb.length();
                        char[] name = new char[len];
                        sb.getChars(0, len, name, 0);
                        char[] cArray = name;
                        return cArray;
                    }
                    char[] cArray = this.firstBound.readableName();
                    return cArray;
                }
                finally {
                    --this.prototype.recursionLevel;
                }
            }
            return this.originalName;
        }
        return super.readableName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] shortReadableName() {
        if (this.lowerBound == null && this.firstBound != null) {
            if (this.prototype.recursionLevel < 2) {
                try {
                    ++this.prototype.recursionLevel;
                    if (this.upperBounds != null && this.upperBounds.length > 1) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(this.upperBounds[0].shortReadableName());
                        for (int i = 1; i < this.upperBounds.length; ++i) {
                            sb.append('&').append(this.upperBounds[i].shortReadableName());
                        }
                        int len = sb.length();
                        char[] name = new char[len];
                        sb.getChars(0, len, name, 0);
                        char[] cArray = name;
                        return cArray;
                    }
                    char[] cArray = this.firstBound.shortReadableName();
                    return cArray;
                }
                finally {
                    --this.prototype.recursionLevel;
                }
            }
            return this.originalName;
        }
        return super.shortReadableName();
    }

    @Override
    public TypeBinding uncapture(Scope scope) {
        return this;
    }

    @Override
    public char[] computeUniqueKey(boolean isLeaf) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(TypeConstants.CAPTURE18);
        buffer.append('{').append(this.end).append('#').append(this.captureID).append('}');
        buffer.append(';');
        int length = buffer.length();
        char[] uniqueKey = new char[length];
        buffer.getChars(0, length, uniqueKey, 0);
        return uniqueKey;
    }
}

