/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExportsStatement;
import org.eclipse.jdt.internal.compiler.ast.ModuleReference;
import org.eclipse.jdt.internal.compiler.ast.OpensStatement;
import org.eclipse.jdt.internal.compiler.ast.PackageVisibilityStatement;
import org.eclipse.jdt.internal.compiler.ast.ProvidesStatement;
import org.eclipse.jdt.internal.compiler.ast.RequiresStatement;
import org.eclipse.jdt.internal.compiler.ast.UsesStatement;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.ModuleScope;
import org.eclipse.jdt.internal.compiler.lookup.PlainPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;

public class ModuleDeclaration
extends ASTNode
implements ReferenceContext {
    public ExportsStatement[] exports;
    public RequiresStatement[] requires;
    public UsesStatement[] uses;
    public ProvidesStatement[] services;
    public OpensStatement[] opens;
    public Annotation[] annotations;
    public int exportsCount;
    public int requiresCount;
    public int usesCount;
    public int servicesCount;
    public int opensCount;
    public SourceModuleBinding binding;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public int bodyStart;
    public int bodyEnd;
    public int modifiersSourceStart;
    public ModuleScope scope;
    public char[][] tokens;
    public char[] moduleName;
    public long[] sourcePositions;
    public int modifiers = 0;
    boolean ignoreFurtherInvestigation;
    boolean hasResolvedModuleDirectives;
    boolean hasResolvedPackageDirectives;
    boolean hasResolvedTypeDirectives;
    CompilationResult compilationResult;

    public ModuleDeclaration(CompilationResult compilationResult, char[][] tokens, long[] positions) {
        this.compilationResult = compilationResult;
        this.exportsCount = 0;
        this.requiresCount = 0;
        this.tokens = tokens;
        this.moduleName = CharOperation.concatWith(tokens, '.');
        this.sourcePositions = positions;
        this.sourceEnd = (int)(positions[positions.length - 1] & 0xFFFFFFFFFFFFFFFFL);
        this.sourceStart = (int)(positions[0] >>> 32);
    }

    public ModuleBinding setBinding(SourceModuleBinding sourceModuleBinding) {
        this.binding = sourceModuleBinding;
        return sourceModuleBinding;
    }

    public void checkAndSetModifiers() {
        int effectiveModifiers;
        int realModifiers = this.modifiers & 0xFFFF;
        int expectedModifiers = 4128;
        if ((realModifiers & ~expectedModifiers) != 0) {
            this.scope.problemReporter().illegalModifierForModule(this);
            realModifiers &= expectedModifiers;
        }
        this.modifiers = this.binding.modifiers = (effectiveModifiers = 0x8000 | realModifiers);
    }

    public boolean isOpen() {
        return (this.modifiers & 0x20) != 0;
    }

    public void createScope(Scope parentScope) {
        this.scope = new ModuleScope(parentScope, this);
    }

    public void generateCode() {
        block4: {
            if ((this.bits & 0x2000) != 0) {
                return;
            }
            this.bits |= 0x2000;
            if (this.ignoreFurtherInvestigation) {
                return;
            }
            try {
                LookupEnvironment env = this.scope.environment();
                ClassFile classFile = env.classFilePool.acquireForModule(this.binding, env.globalOptions);
                classFile.initializeForModule(this.binding);
                classFile.addModuleAttributes(this.binding, this.annotations, this.scope.referenceCompilationUnit());
                this.scope.referenceCompilationUnit().compilationResult.record(this.binding.moduleName, classFile);
            }
            catch (AbortType e) {
                if (this.binding != null) break block4;
                return;
            }
        }
    }

    public void resolveModuleDirectives(CompilationUnitScope cuScope) {
        if (this.binding == null) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
        if (this.hasResolvedModuleDirectives) {
            return;
        }
        this.hasResolvedModuleDirectives = true;
        HashSet<ModuleBinding> requiredModules = new HashSet<ModuleBinding>();
        HashSet<ModuleBinding> requiredTransitiveModules = new HashSet<ModuleBinding>();
        for (int i = 0; i < this.requiresCount; ++i) {
            Collection<ModuleBinding> deps;
            RequiresStatement ref = this.requires[i];
            if (ref == null || ref.resolve(cuScope) == null) continue;
            if (!requiredModules.add(ref.resolvedBinding)) {
                cuScope.problemReporter().duplicateModuleReference(8389909, ref.module);
            }
            if (ref.isTransitive()) {
                requiredTransitiveModules.add(ref.resolvedBinding);
            }
            if (!(deps = ref.resolvedBinding.dependencyGraphCollector().get()).contains(this.binding)) continue;
            cuScope.problemReporter().cyclicModuleDependency(this.binding, ref.module);
            requiredModules.remove(ref.module.binding);
        }
        this.binding.setRequires(requiredModules.toArray(new ModuleBinding[requiredModules.size()]), requiredTransitiveModules.toArray(new ModuleBinding[requiredTransitiveModules.size()]));
        if (this.exports != null) {
            for (ExportsStatement exportsStatement : this.exports) {
                if (!exportsStatement.isQualified()) continue;
                for (ModuleReference moduleReference : exportsStatement.targets) {
                    moduleReference.resolve(cuScope);
                }
            }
        }
        if (this.opens != null) {
            for (OpensStatement opensStatement : this.opens) {
                if (!opensStatement.isQualified()) continue;
                for (ModuleReference moduleReference : opensStatement.targets) {
                    moduleReference.resolve(cuScope);
                }
            }
        }
    }

    public void resolvePackageDirectives(CompilationUnitScope cuScope) {
        if (this.binding == null) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
        if (this.hasResolvedPackageDirectives) {
            return;
        }
        this.hasResolvedPackageDirectives = true;
        HashSet<PlainPackageBinding> exportedPkgs = new HashSet<PlainPackageBinding>();
        for (int i = 0; i < this.exportsCount; ++i) {
            ExportsStatement ref = this.exports[i];
            if (ref == null || !ref.resolve(cuScope)) continue;
            if (!exportedPkgs.add(ref.resolvedPackage)) {
                cuScope.problemReporter().invalidPackageReference(8389910, ref);
            }
            char[][] targets = null;
            if (ref.targets != null) {
                targets = new char[ref.targets.length][];
                for (int j = 0; j < targets.length; ++j) {
                    targets[j] = ref.targets[j].moduleName;
                }
            }
            this.binding.addResolvedExport(ref.resolvedPackage, targets);
        }
        HashtableOfObject openedPkgs = new HashtableOfObject();
        for (int i = 0; i < this.opensCount; ++i) {
            OpensStatement ref = this.opens[i];
            if (this.isOpen()) {
                cuScope.problemReporter().invalidOpensStatement(ref, this);
                continue;
            }
            if (openedPkgs.containsKey(ref.pkgName)) {
                cuScope.problemReporter().invalidPackageReference(8389921, ref);
            } else {
                openedPkgs.put(ref.pkgName, ref);
                ref.resolve(cuScope);
            }
            char[][] targets = null;
            if (ref.targets != null) {
                targets = new char[ref.targets.length][];
                for (int j = 0; j < targets.length; ++j) {
                    targets[j] = ref.targets[j].moduleName;
                }
            }
            this.binding.addResolvedOpens(ref.resolvedPackage, targets);
        }
    }

    public void resolveTypeDirectives(CompilationUnitScope cuScope) {
        if (this.binding == null) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
        if (this.hasResolvedTypeDirectives) {
            return;
        }
        this.hasResolvedTypeDirectives = true;
        ASTNode.resolveAnnotations((BlockScope)this.scope, this.annotations, this.binding);
        HashSet<TypeBinding> allTypes = new HashSet<TypeBinding>();
        for (int i = 0; i < this.usesCount; ++i) {
            TypeBinding serviceBinding = this.uses[i].serviceInterface.resolveType(this.scope);
            if (serviceBinding == null || !serviceBinding.isValidBinding()) continue;
            if (!(serviceBinding.isClass() || serviceBinding.isInterface() || serviceBinding.isAnnotationType())) {
                cuScope.problemReporter().invalidServiceRef(8389924, this.uses[i].serviceInterface);
            }
            if (allTypes.add(this.uses[i].serviceInterface.resolvedType)) continue;
            cuScope.problemReporter().duplicateTypeReference(8389911, this.uses[i].serviceInterface);
        }
        this.binding.setUses(allTypes.toArray(new TypeBinding[allTypes.size()]));
        HashSet<TypeBinding> interfaces = new HashSet<TypeBinding>();
        for (int i = 0; i < this.servicesCount; ++i) {
            this.services[i].resolve(this.scope);
            TypeBinding infBinding = this.services[i].serviceInterface.resolvedType;
            if (infBinding == null || !infBinding.isValidBinding()) continue;
            if (!interfaces.add(this.services[i].serviceInterface.resolvedType)) {
                cuScope.problemReporter().duplicateTypeReference(8389912, this.services[i].serviceInterface);
            }
            this.binding.setImplementations(infBinding, this.services[i].getResolvedImplementations());
        }
        this.binding.setServices(interfaces.toArray(new TypeBinding[interfaces.size()]));
    }

    public void analyseCode(CompilationUnitScope skope) {
        this.analyseModuleGraph(skope);
        this.analyseReferencedPackages(skope);
    }

    private void analyseReferencedPackages(CompilationUnitScope skope) {
        if (this.exports != null) {
            this.analyseSomeReferencedPackages(this.exports, skope);
        }
        if (this.opens != null) {
            this.analyseSomeReferencedPackages(this.opens, skope);
        }
    }

    private void analyseSomeReferencedPackages(PackageVisibilityStatement[] stats, CompilationUnitScope skope) {
        for (PackageVisibilityStatement stat : stats) {
            PlainPackageBinding pb = stat.resolvedPackage;
            if (pb == null || pb.hasCompilationUnit(true)) continue;
            for (ModuleBinding req : this.binding.getAllRequiredModules()) {
                for (PlainPackageBinding exported : req.getExports()) {
                    if (!CharOperation.equals(pb.compoundName, exported.compoundName)) continue;
                    skope.problemReporter().exportingForeignPackage(stat, req);
                    return;
                }
            }
            skope.problemReporter().invalidPackageReference(8389919, stat);
        }
    }

    public void analyseModuleGraph(CompilationUnitScope skope) {
        if (this.requires != null) {
            HashMap<String, Set<ModuleBinding>> pack2mods = new HashMap<String, Set<ModuleBinding>>();
            for (ModuleBinding requiredModule : this.binding.getAllRequiredModules()) {
                for (PlainPackageBinding exportedPackage : requiredModule.getExports()) {
                    if (!this.binding.canAccess(exportedPackage)) continue;
                    String packName = String.valueOf(exportedPackage.readableName());
                    HashSet<ModuleBinding> mods = (HashSet<ModuleBinding>)pack2mods.get(packName);
                    if (mods == null) {
                        mods = new HashSet<ModuleBinding>();
                        pack2mods.put(packName, mods);
                    }
                    mods.add(requiredModule);
                }
            }
            for (RequiresStatement requiresStat : this.requires) {
                ModuleBinding requiredModule = requiresStat.resolvedBinding;
                if (requiredModule == null) continue;
                if (requiredModule.isDeprecated()) {
                    skope.problemReporter().deprecatedModule(requiresStat.module, requiredModule);
                }
                this.analyseOneDependency(requiresStat, requiredModule, skope, pack2mods);
                if (!requiresStat.isTransitive()) continue;
                for (ModuleBinding secondLevelModule : requiredModule.getAllRequiredModules()) {
                    this.analyseOneDependency(requiresStat, secondLevelModule, skope, pack2mods);
                }
            }
        }
    }

    private void analyseOneDependency(RequiresStatement requiresStat, ModuleBinding requiredModule, CompilationUnitScope skope, Map<String, Set<ModuleBinding>> pack2mods) {
        for (PlainPackageBinding pack : requiredModule.getExports()) {
            Set<ModuleBinding> mods = pack2mods.get(String.valueOf(pack.readableName()));
            if (mods == null || mods.size() <= 1) continue;
            CompilerOptions compilerOptions = skope.compilerOptions();
            boolean inJdtDebugCompileMode = compilerOptions.enableJdtDebugCompileMode;
            if (inJdtDebugCompileMode) continue;
            skope.problemReporter().conflictingPackagesFromModules(pack, mods, requiresStat.sourceStart, requiresStat.sourceEnd);
        }
    }

    public void traverse(ASTVisitor visitor, CompilationUnitScope unitScope) {
        visitor.visit(this, unitScope);
    }

    public StringBuffer printHeader(int indent, StringBuffer output) {
        if (this.annotations != null) {
            for (int i = 0; i < this.annotations.length; ++i) {
                this.annotations[i].print(indent, output);
                if (i == this.annotations.length - 1) continue;
                output.append(" ");
            }
            output.append('\n');
        }
        if (this.isOpen()) {
            output.append("open ");
        }
        output.append("module ");
        output.append(CharOperation.charToString(this.moduleName));
        return output;
    }

    public StringBuffer printBody(int indent, StringBuffer output) {
        int i;
        output.append(" {");
        if (this.requires != null) {
            for (i = 0; i < this.requiresCount; ++i) {
                output.append('\n');
                ModuleDeclaration.printIndent(indent + 1, output);
                this.requires[i].print(0, output);
            }
        }
        if (this.exports != null) {
            for (i = 0; i < this.exportsCount; ++i) {
                output.append('\n');
                this.exports[i].print(indent + 1, output);
            }
        }
        if (this.opens != null) {
            for (i = 0; i < this.opensCount; ++i) {
                output.append('\n');
                this.opens[i].print(indent + 1, output);
            }
        }
        if (this.uses != null) {
            for (i = 0; i < this.usesCount; ++i) {
                output.append('\n');
                this.uses[i].print(indent + 1, output);
            }
        }
        if (this.servicesCount != 0) {
            for (i = 0; i < this.servicesCount; ++i) {
                output.append('\n');
                this.services[i].print(indent + 1, output);
            }
        }
        output.append('\n');
        return ModuleDeclaration.printIndent(indent, output).append('}');
    }

    @Override
    public StringBuffer print(int indent, StringBuffer output) {
        ModuleDeclaration.printIndent(indent, output);
        this.printHeader(0, output);
        return this.printBody(indent, output);
    }

    @Override
    public void abort(int abortLevel, CategorizedProblem problem) {
        switch (abortLevel) {
            case 2: {
                throw new AbortCompilation(this.compilationResult, problem);
            }
            case 4: {
                throw new AbortCompilationUnit(this.compilationResult, problem);
            }
            case 16: {
                throw new AbortMethod(this.compilationResult, problem);
            }
        }
        throw new AbortType(this.compilationResult, problem);
    }

    @Override
    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    @Override
    public CompilationUnitDeclaration getCompilationUnitDeclaration() {
        return this.scope.referenceCompilationUnit();
    }

    @Override
    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    @Override
    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    @Override
    public void tagAsHavingIgnoredMandatoryErrors(int problemId) {
    }

    public String getModuleVersion() {
        if (this.scope != null) {
            LookupEnvironment env = this.scope.environment().root;
            return env.moduleVersion;
        }
        return null;
    }
}

