/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.codeassist.CompletionElementNotifier;
import org.eclipse.jdt.internal.codeassist.CompletionEngine;
import org.eclipse.jdt.internal.codeassist.CompletionUnitStructureRequestor;
import org.eclipse.jdt.internal.codeassist.InternalCompletionContext;
import org.eclipse.jdt.internal.codeassist.complete.CompletionNodeDetector;
import org.eclipse.jdt.internal.codeassist.complete.CompletionParser;
import org.eclipse.jdt.internal.codeassist.impl.AssistCompilationUnit;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.env.ITypeAnnotationWalker;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SignatureWrapper;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.eclipse.jdt.internal.core.CompilationUnitElementInfo;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.LocalVariable;
import org.eclipse.jdt.internal.core.util.Util;

public class InternalExtendedCompletionContext {
    private static Util.BindingsToNodesMap EmptyNodeMap = new Util.BindingsToNodesMap(){

        @Override
        public ASTNode get(Binding binding) {
            return null;
        }
    };
    private InternalCompletionContext completionContext;
    private ITypeRoot typeRoot;
    private CompilationUnitDeclaration compilationUnitDeclaration;
    private LookupEnvironment lookupEnvironment;
    private Scope assistScope;
    private ASTNode assistNode;
    private ASTNode assistNodeParent;
    private WorkingCopyOwner owner;
    private CompletionParser parser;
    private boolean hasComputedVisibleElementBindings;
    private ObjectVector visibleLocalVariables;
    private ObjectVector visibleFields;
    private ObjectVector visibleMethods;
    private boolean hasComputedEnclosingJavaElements;
    private Map<Binding, JavaElement> bindingsToHandles;
    private Map<ASTNode, JavaElement> nodesWithProblemsToHandles;
    private ICompilationUnit compilationUnit;

    public InternalExtendedCompletionContext(InternalCompletionContext completionContext, ITypeRoot typeRoot, CompilationUnitDeclaration compilationUnitDeclaration, LookupEnvironment lookupEnvironment, Scope assistScope, ASTNode assistNode, ASTNode assistNodeParent, WorkingCopyOwner owner, CompletionParser parser) {
        this.completionContext = completionContext;
        this.typeRoot = typeRoot;
        this.compilationUnitDeclaration = compilationUnitDeclaration;
        this.lookupEnvironment = lookupEnvironment;
        this.assistScope = assistScope;
        this.assistNode = assistNode;
        this.assistNodeParent = assistNodeParent;
        this.owner = owner;
        this.parser = parser;
    }

    private void computeEnclosingJavaElements() {
        this.hasComputedEnclosingJavaElements = true;
        if (this.typeRoot == null) {
            return;
        }
        if (this.typeRoot.getElementType() == 5) {
            ICompilationUnit original = (ICompilationUnit)this.typeRoot;
            HashMap<JavaElement, Binding> handleToBinding = new HashMap<JavaElement, Binding>();
            HashMap<Binding, JavaElement> bindingToHandle = new HashMap<Binding, JavaElement>();
            HashMap<ASTNode, JavaElement> nodeWithProblemToHandle = new HashMap<ASTNode, JavaElement>();
            HashMap<AssistCompilationUnit, CompilationUnitElementInfo> handleToInfo = new HashMap<AssistCompilationUnit, CompilationUnitElementInfo>();
            AssistCompilationUnit handle = new AssistCompilationUnit(original, this.owner, handleToBinding, handleToInfo);
            CompilationUnitElementInfo info = new CompilationUnitElementInfo();
            handleToInfo.put(handle, info);
            CompletionUnitStructureRequestor structureRequestor = new CompletionUnitStructureRequestor(handle, info, this.parser, this.assistNode, handleToBinding, bindingToHandle, nodeWithProblemToHandle, handleToInfo);
            CompletionElementNotifier notifier = new CompletionElementNotifier(structureRequestor, true, this.assistNode);
            notifier.notifySourceElementRequestor(this.compilationUnitDeclaration, this.compilationUnitDeclaration.sourceStart, this.compilationUnitDeclaration.sourceEnd, false, this.parser.sourceEnds, new HashMap());
            this.bindingsToHandles = bindingToHandle;
            this.nodesWithProblemsToHandles = nodeWithProblemToHandle;
            this.compilationUnit = handle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeVisibleElementBindings() {
        block14: {
            CompilationUnitDeclaration previousUnitBeingCompleted = this.lookupEnvironment.unitBeingCompleted;
            this.lookupEnvironment.unitBeingCompleted = this.compilationUnitDeclaration;
            try {
                this.hasComputedVisibleElementBindings = true;
                Scope scope = this.assistScope;
                ASTNode astNode = this.assistNode;
                boolean notInJavadoc = this.completionContext.javadoc == 0;
                this.visibleLocalVariables = new ObjectVector();
                this.visibleFields = new ObjectVector();
                this.visibleMethods = new ObjectVector();
                ReferenceContext referenceContext = scope.referenceContext();
                if (referenceContext instanceof AbstractMethodDeclaration || referenceContext instanceof LambdaExpression) {
                    this.searchVisibleVariablesAndMethods(scope, this.visibleLocalVariables, this.visibleFields, this.visibleMethods, notInJavadoc);
                    break block14;
                }
                if (!(referenceContext instanceof TypeDeclaration)) break block14;
                TypeDeclaration typeDeclaration = (TypeDeclaration)referenceContext;
                FieldDeclaration[] fields = typeDeclaration.fields;
                if (fields == null) break block14;
                for (int i = 0; i < fields.length; ++i) {
                    if (fields[i] instanceof Initializer) {
                        Initializer initializer = (Initializer)fields[i];
                        if (initializer.block.sourceStart > astNode.sourceStart || astNode.sourceStart >= initializer.bodyEnd) continue;
                        this.searchVisibleVariablesAndMethods(scope, this.visibleLocalVariables, this.visibleFields, this.visibleMethods, notInJavadoc);
                    } else {
                        FieldDeclaration fieldDeclaration = fields[i];
                        if (fieldDeclaration.initialization == null || fieldDeclaration.binding == null) continue;
                        boolean isInsideInitializer = false;
                        if (fieldDeclaration.initialization.sourceEnd > 0) {
                            if (fieldDeclaration.initialization.sourceStart <= astNode.sourceStart && astNode.sourceEnd <= fieldDeclaration.initialization.sourceEnd) {
                                isInsideInitializer = true;
                            }
                        } else {
                            CompletionNodeDetector detector = new CompletionNodeDetector(this.assistNode, fieldDeclaration.initialization);
                            if (detector.containsCompletionNode()) {
                                isInsideInitializer = true;
                            }
                        }
                        if (!isInsideInitializer) continue;
                        this.searchVisibleVariablesAndMethods(scope, this.visibleLocalVariables, this.visibleFields, this.visibleMethods, notInJavadoc);
                        if (this.visibleFields.size > 0 && this.visibleFields.contains(fieldDeclaration.binding)) {
                            this.visibleFields.remove(fieldDeclaration.binding);
                        }
                        int count = 0;
                        while (count < this.visibleFields.size) {
                            FieldBinding visibleField = (FieldBinding)this.visibleFields.elementAt(count);
                            if (visibleField.id > fieldDeclaration.binding.id) {
                                this.visibleFields.remove(visibleField);
                                continue;
                            }
                            ++count;
                        }
                    }
                    break;
                }
            }
            finally {
                this.lookupEnvironment.unitBeingCompleted = previousUnitBeingCompleted;
            }
        }
    }

    public IJavaElement getEnclosingElement() {
        try {
            if (!this.hasComputedEnclosingJavaElements) {
                this.computeEnclosingJavaElements();
            }
            if (this.compilationUnit == null) {
                return null;
            }
            IJavaElement enclosingElement = this.compilationUnit.getElementAt(this.completionContext.offset);
            return enclosingElement == null ? this.compilationUnit : enclosingElement;
        }
        catch (JavaModelException e) {
            Util.log((Throwable)((Object)e), "Cannot compute enclosing element");
            return null;
        }
    }

    private JavaElement getJavaElement(LocalVariableBinding binding) {
        ReferenceContext referenceContext;
        LocalDeclaration local = binding.declaration;
        JavaElement parent = null;
        ReferenceContext referenceContext2 = referenceContext = binding.declaringScope.isLambdaSubscope() ? binding.declaringScope.namedMethodScope().referenceContext() : binding.declaringScope.referenceContext();
        if (referenceContext instanceof AbstractMethodDeclaration) {
            AbstractMethodDeclaration methodDeclaration = (AbstractMethodDeclaration)referenceContext;
            parent = this.getJavaElementOfCompilationUnit(methodDeclaration, methodDeclaration.binding);
        } else if (referenceContext instanceof TypeDeclaration) {
            TypeDeclaration typeDeclaration = (TypeDeclaration)referenceContext;
            JavaElement type = this.getJavaElementOfCompilationUnit(typeDeclaration, typeDeclaration.binding);
            parent = Util.getUnresolvedJavaElement(local.sourceStart, local.sourceEnd, type);
        }
        if (parent == null) {
            return null;
        }
        return new LocalVariable(parent, new String(local.name), local.declarationSourceStart, local.declarationSourceEnd, local.sourceStart, local.sourceEnd, local.type == null ? Signature.createTypeSignature(binding.type.signableName(), true) : Util.typeSignature(local.type), binding.declaration.annotations, local.modifiers, local.getKind() == 5);
    }

    private JavaElement getJavaElementOfCompilationUnit(Binding binding) {
        if (!this.hasComputedEnclosingJavaElements) {
            this.computeEnclosingJavaElements();
        }
        if (this.bindingsToHandles == null) {
            return null;
        }
        return this.bindingsToHandles.get(binding);
    }

    private JavaElement getJavaElementOfCompilationUnit(ASTNode node, Binding binding) {
        if (!this.hasComputedEnclosingJavaElements) {
            this.computeEnclosingJavaElements();
        }
        if (binding != null) {
            if (this.bindingsToHandles == null) {
                return null;
            }
            return this.bindingsToHandles.get(binding);
        }
        if (this.nodesWithProblemsToHandles == null) {
            return null;
        }
        return this.nodesWithProblemsToHandles.get(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypeBinding getTypeFromSignature(String typeSignature, Scope scope) {
        AbstractMethodDeclaration methodDeclaration;
        TypeParameter[] typeParameters;
        TypeBinding assignableTypeBinding = null;
        TypeVariableBinding[] typeVariables = Binding.NO_TYPE_VARIABLES;
        ReferenceContext referenceContext = scope.referenceContext();
        if (referenceContext instanceof AbstractMethodDeclaration && (typeParameters = (methodDeclaration = (AbstractMethodDeclaration)referenceContext).typeParameters()) != null && typeParameters.length > 0) {
            int length = typeParameters.length;
            int count = 0;
            typeVariables = new TypeVariableBinding[length];
            for (int i = 0; i < length; ++i) {
                if (typeParameters[i].binding == null) continue;
                typeVariables[count++] = typeParameters[i].binding;
            }
            if (count != length) {
                TypeVariableBinding[] typeVariableBindingArray = typeVariables;
                typeVariables = new TypeVariableBinding[count];
                System.arraycopy(typeVariableBindingArray, 0, typeVariables, 0, count);
            }
        }
        CompilationUnitDeclaration previousUnitBeingCompleted = this.lookupEnvironment.unitBeingCompleted;
        this.lookupEnvironment.unitBeingCompleted = this.compilationUnitDeclaration;
        try {
            SignatureWrapper wrapper = new SignatureWrapper(this.replacePackagesDot(typeSignature.toCharArray()));
            assignableTypeBinding = this.lookupEnvironment.getTypeFromTypeSignature(wrapper, typeVariables, this.assistScope.enclosingClassScope().referenceContext.binding, null, ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER);
            assignableTypeBinding = BinaryTypeBinding.resolveType(assignableTypeBinding, this.lookupEnvironment, true);
        }
        catch (AbortCompilation e) {
            assignableTypeBinding = null;
        }
        finally {
            this.lookupEnvironment.unitBeingCompleted = previousUnitBeingCompleted;
        }
        return assignableTypeBinding;
    }

    private char[] replacePackagesDot(char[] signature) {
        boolean replace = true;
        int length = signature.length;
        block5: for (int i = 0; i < length; ++i) {
            switch (signature[i]) {
                case '.': {
                    if (!replace) continue block5;
                    signature[i] = 47;
                    continue block5;
                }
                case '<': {
                    replace = true;
                    continue block5;
                }
                case '>': {
                    replace = false;
                }
            }
        }
        return signature;
    }

    public IJavaElement[] getVisibleElements(String typeSignature) {
        Binding binding;
        int i;
        if (this.assistScope == null) {
            return new IJavaElement[0];
        }
        if (!this.hasComputedVisibleElementBindings) {
            this.computeVisibleElementBindings();
        }
        TypeBinding assignableTypeBinding = null;
        if (typeSignature != null && (assignableTypeBinding = this.getTypeFromSignature(typeSignature, this.assistScope)) == null) {
            return new IJavaElement[0];
        }
        int length = this.visibleLocalVariables.size() + this.visibleFields.size() + this.visibleMethods.size();
        if (length == 0) {
            return new IJavaElement[0];
        }
        IJavaElement[] result = new IJavaElement[length];
        int elementCount = 0;
        int size = this.visibleLocalVariables.size();
        if (size > 0) {
            for (i = 0; i < size; ++i) {
                try {
                    JavaElement localVariable;
                    binding = (LocalVariableBinding)this.visibleLocalVariables.elementAt(i);
                    if (binding.type == null || assignableTypeBinding != null && !binding.type.isCompatibleWith(assignableTypeBinding) || (localVariable = this.getJavaElement((LocalVariableBinding)binding)) == null) continue;
                    result[elementCount++] = localVariable;
                    continue;
                }
                catch (AbortCompilation e) {
                    Util.logRepeatedMessage(e.getKey(), e);
                }
            }
        }
        if ((size = this.visibleFields.size()) > 0) {
            for (i = 0; i < size; ++i) {
                try {
                    JavaElement field;
                    binding = (FieldBinding)this.visibleFields.elementAt(i);
                    if (assignableTypeBinding != null && !((FieldBinding)binding).type.isCompatibleWith(assignableTypeBinding)) continue;
                    if (this.assistScope.isDefinedInSameUnit(((FieldBinding)binding).declaringClass)) {
                        field = this.getJavaElementOfCompilationUnit(binding);
                        if (field == null) continue;
                        result[elementCount++] = field;
                        continue;
                    }
                    field = Util.getUnresolvedJavaElement((FieldBinding)binding, this.owner, EmptyNodeMap);
                    if (field == null) continue;
                    result[elementCount++] = field.resolved(binding);
                    continue;
                }
                catch (AbortCompilation e) {
                    Util.logRepeatedMessage(e.getKey(), e);
                }
            }
        }
        if ((size = this.visibleMethods.size()) > 0) {
            for (i = 0; i < size; ++i) {
                try {
                    JavaElement method;
                    binding = (MethodBinding)this.visibleMethods.elementAt(i);
                    if (assignableTypeBinding != null && !((MethodBinding)binding).returnType.isCompatibleWith(assignableTypeBinding)) continue;
                    if (this.assistScope.isDefinedInSameUnit(((MethodBinding)binding).declaringClass)) {
                        method = this.getJavaElementOfCompilationUnit(binding);
                        if (method == null) continue;
                        result[elementCount++] = method;
                        continue;
                    }
                    method = Util.getUnresolvedJavaElement((MethodBinding)binding, this.owner, EmptyNodeMap);
                    if (method == null) continue;
                    result[elementCount++] = method.resolved(binding);
                    continue;
                }
                catch (AbortCompilation e) {
                    Util.logRepeatedMessage(e.getKey(), e);
                }
            }
        }
        if (elementCount != result.length) {
            IJavaElement[] iJavaElementArray = result;
            result = new IJavaElement[elementCount];
            System.arraycopy(iJavaElementArray, 0, result, 0, elementCount);
        }
        return result;
    }

    private void searchVisibleFields(FieldBinding[] fields, ReferenceBinding receiverType, Scope scope, InvocationSite invocationSite, Scope invocationScope, boolean onlyStaticFields, ObjectVector localsFound, ObjectVector fieldsFound) {
        ObjectVector newFieldsFound = new ObjectVector();
        int f = fields.length;
        block0: while (--f >= 0) {
            FieldBinding field = fields[f];
            if (field.isSynthetic() || onlyStaticFields && !field.isStatic() || !field.canBeSeenBy(receiverType, invocationSite, scope)) continue;
            int i = fieldsFound.size;
            while (--i >= 0) {
                FieldBinding otherField = (FieldBinding)fieldsFound.elementAt(i);
                if (!CharOperation.equals(field.name, otherField.name, true)) continue;
                continue block0;
            }
            int l = localsFound.size;
            while (--l >= 0) {
                LocalVariableBinding local = (LocalVariableBinding)localsFound.elementAt(l);
                if (!CharOperation.equals(field.name, local.name, true)) continue;
                continue block0;
            }
            newFieldsFound.add(field);
        }
        fieldsFound.addAll(newFieldsFound);
    }

    private void searchVisibleFields(ReferenceBinding receiverType, Scope scope, InvocationSite invocationSite, Scope invocationScope, boolean onlyStaticFields, boolean notInJavadoc, ObjectVector localsFound, ObjectVector fieldsFound) {
        ReferenceBinding currentType = receiverType;
        ReferenceBinding[] interfacesToVisit = null;
        int nextPosition = 0;
        do {
            FieldBinding[] fields;
            ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
            if (notInJavadoc && itsInterfaces != Binding.NO_SUPERINTERFACES) {
                if (interfacesToVisit == null) {
                    interfacesToVisit = itsInterfaces;
                    nextPosition = interfacesToVisit.length;
                } else {
                    int itsLength = itsInterfaces.length;
                    if (nextPosition + itsLength >= interfacesToVisit.length) {
                        ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                        interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                        System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
                    }
                    block1: for (int a = 0; a < itsLength; ++a) {
                        ReferenceBinding next = itsInterfaces[a];
                        for (int b = 0; b < nextPosition; ++b) {
                            if (TypeBinding.equalsEquals(next, interfacesToVisit[b])) continue block1;
                        }
                        interfacesToVisit[nextPosition++] = next;
                    }
                }
            }
            if ((fields = currentType.availableFields()) != null && fields.length > 0) {
                this.searchVisibleFields(fields, receiverType, scope, invocationSite, invocationScope, onlyStaticFields, localsFound, fieldsFound);
            }
            currentType = currentType.superclass();
        } while (notInJavadoc && currentType != null);
        if (notInJavadoc && interfacesToVisit != null) {
            for (int i = 0; i < nextPosition; ++i) {
                ReferenceBinding[] itsInterfaces;
                ReferenceBinding anInterface = interfacesToVisit[i];
                FieldBinding[] fields = anInterface.availableFields();
                if (fields != null) {
                    this.searchVisibleFields(fields, receiverType, scope, invocationSite, invocationScope, onlyStaticFields, localsFound, fieldsFound);
                }
                if ((itsInterfaces = anInterface.superInterfaces()) == Binding.NO_SUPERINTERFACES) continue;
                int itsLength = itsInterfaces.length;
                if (nextPosition + itsLength >= interfacesToVisit.length) {
                    ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                    interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
                }
                block4: for (int a = 0; a < itsLength; ++a) {
                    ReferenceBinding next = itsInterfaces[a];
                    for (int b = 0; b < nextPosition; ++b) {
                        if (TypeBinding.equalsEquals(next, interfacesToVisit[b])) continue block4;
                    }
                    interfacesToVisit[nextPosition++] = next;
                }
            }
        }
    }

    private void searchVisibleInterfaceMethods(ReferenceBinding[] itsInterfaces, ReferenceBinding receiverType, Scope scope, InvocationSite invocationSite, Scope invocationScope, boolean onlyStaticMethods, ObjectVector methodsFound) {
        if (itsInterfaces != Binding.NO_SUPERINTERFACES) {
            ReferenceBinding[] interfacesToVisit = itsInterfaces;
            int nextPosition = interfacesToVisit.length;
            for (int i = 0; i < nextPosition; ++i) {
                ReferenceBinding currentType = interfacesToVisit[i];
                MethodBinding[] methods = currentType.availableMethods();
                if (methods != null) {
                    this.searchVisibleLocalMethods(methods, receiverType, scope, invocationSite, invocationScope, onlyStaticMethods, methodsFound);
                }
                if ((itsInterfaces = currentType.superInterfaces()) == null || itsInterfaces == Binding.NO_SUPERINTERFACES) continue;
                int itsLength = itsInterfaces.length;
                if (nextPosition + itsLength >= interfacesToVisit.length) {
                    ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                    interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
                }
                block1: for (int a = 0; a < itsLength; ++a) {
                    ReferenceBinding next = itsInterfaces[a];
                    for (int b = 0; b < nextPosition; ++b) {
                        if (TypeBinding.equalsEquals(next, interfacesToVisit[b])) continue block1;
                    }
                    interfacesToVisit[nextPosition++] = next;
                }
            }
        }
    }

    private void searchVisibleLocalMethods(MethodBinding[] methods, ReferenceBinding receiverType, Scope scope, InvocationSite invocationSite, Scope invocationScope, boolean onlyStaticMethods, ObjectVector methodsFound) {
        ObjectVector newMethodsFound = new ObjectVector();
        int f = methods.length;
        block0: while (--f >= 0) {
            MethodBinding method = methods[f];
            if (method.isSynthetic() || method.isDefaultAbstract() || method.isConstructor() || onlyStaticMethods && !method.isStatic() || !method.canBeSeenBy(receiverType, invocationSite, scope)) continue;
            int i = methodsFound.size;
            while (--i >= 0) {
                MethodBinding otherMethod = (MethodBinding)methodsFound.elementAt(i);
                if (method != otherMethod && (!CharOperation.equals(method.selector, otherMethod.selector, true) || !this.lookupEnvironment.methodVerifier().isMethodSubsignature(otherMethod, method))) continue;
                continue block0;
            }
            newMethodsFound.add(method);
        }
        methodsFound.addAll(newMethodsFound);
    }

    private void searchVisibleMethods(ReferenceBinding receiverType, Scope scope, InvocationSite invocationSite, Scope invocationScope, boolean onlyStaticMethods, boolean notInJavadoc, ObjectVector methodsFound) {
        ReferenceBinding currentType = receiverType;
        if (notInJavadoc && receiverType.isInterface()) {
            this.searchVisibleInterfaceMethods(new ReferenceBinding[]{currentType}, receiverType, scope, invocationSite, invocationScope, onlyStaticMethods, methodsFound);
            currentType = scope.getJavaLangObject();
        }
        boolean hasPotentialDefaultAbstractMethods = true;
        while (currentType != null) {
            MethodBinding[] methods = currentType.availableMethods();
            if (methods != null) {
                this.searchVisibleLocalMethods(methods, receiverType, scope, invocationSite, invocationScope, onlyStaticMethods, methodsFound);
            }
            if (notInJavadoc && hasPotentialDefaultAbstractMethods && (currentType.isAbstract() || currentType.isTypeVariable() || currentType.isIntersectionType() || currentType.isEnum())) {
                ReferenceBinding[] superInterfaces = currentType.superInterfaces();
                if (superInterfaces != null && currentType.isIntersectionType()) {
                    for (int i = 0; i < superInterfaces.length; ++i) {
                        superInterfaces[i] = (ReferenceBinding)superInterfaces[i].capture(invocationScope, invocationSite.sourceStart(), invocationSite.sourceEnd());
                    }
                }
                this.searchVisibleInterfaceMethods(superInterfaces, receiverType, scope, invocationSite, invocationScope, onlyStaticMethods, methodsFound);
            } else {
                hasPotentialDefaultAbstractMethods = false;
            }
            if (currentType.isParameterizedType()) {
                currentType = ((ParameterizedTypeBinding)currentType).genericType().superclass();
                continue;
            }
            currentType = currentType.superclass();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void searchVisibleVariablesAndMethods(Scope scope, ObjectVector localsFound, ObjectVector fieldsFound, ObjectVector methodsFound, boolean notInJavadoc) {
        MethodScope methodScope;
        InvocationSite invocationSite = CompletionEngine.FakeInvocationSite;
        boolean staticsOnly = false;
        Scope currentScope = scope;
        block10: while (true) {
            switch (currentScope.kind) {
                case 2: {
                    methodScope = (MethodScope)currentScope;
                    staticsOnly |= methodScope.isStatic | methodScope.isConstructorCall;
                }
                case 1: {
                    BlockScope blockScope = (BlockScope)currentScope;
                    block11: for (LocalVariableBinding local : blockScope.locals) {
                        if (local == null) break;
                        if (local.isSecret() || local.declaration.initialization != null) continue;
                        for (int f = 0; f < localsFound.size; ++f) {
                            LocalVariableBinding otherLocal = (LocalVariableBinding)localsFound.elementAt(f);
                            if (CharOperation.equals(otherLocal.name, local.name, true)) continue block11;
                        }
                        localsFound.add(local);
                    }
                    break;
                }
                case 4: {
                    break block10;
                }
            }
            currentScope = currentScope.parent;
        }
        staticsOnly = false;
        currentScope = scope;
        block13: while (true) {
            switch (currentScope.kind) {
                case 2: {
                    methodScope = (MethodScope)currentScope;
                    staticsOnly |= methodScope.isStatic | methodScope.isConstructorCall;
                    break;
                }
                case 3: {
                    ClassScope classScope = (ClassScope)currentScope;
                    SourceTypeBinding enclosingType = classScope.referenceContext.binding;
                    this.searchVisibleFields(enclosingType, classScope, invocationSite, scope, staticsOnly, notInJavadoc, localsFound, fieldsFound);
                    this.searchVisibleMethods(enclosingType, classScope, invocationSite, scope, staticsOnly, notInJavadoc, methodsFound);
                    staticsOnly |= enclosingType.isStatic();
                    break;
                }
                case 4: {
                    break block13;
                }
            }
            currentScope = currentScope.parent;
        }
        ImportBinding[] importBindings = scope.compilationUnitScope().imports;
        int i = 0;
        while (i < importBindings.length) {
            Binding binding;
            ImportBinding importBinding = importBindings[i];
            if (importBinding.isValidBinding() && importBinding.isStatic() && (binding = importBinding.resolvedImport) != null && binding.isValidBinding()) {
                if (importBinding.onDemand) {
                    if ((binding.kind() & 4) != 0) {
                        this.searchVisibleFields((ReferenceBinding)binding, scope, invocationSite, scope, staticsOnly, notInJavadoc, localsFound, fieldsFound);
                        this.searchVisibleMethods((ReferenceBinding)binding, scope, invocationSite, scope, staticsOnly, notInJavadoc, methodsFound);
                    }
                } else if ((binding.kind() & 1) != 0) {
                    this.searchVisibleFields(new FieldBinding[]{(FieldBinding)binding}, ((FieldBinding)binding).declaringClass, scope, invocationSite, scope, staticsOnly, localsFound, fieldsFound);
                } else if ((binding.kind() & 8) != 0) {
                    MethodBinding methodBinding = (MethodBinding)binding;
                    this.searchVisibleLocalMethods(methodBinding.declaringClass.getMethods(methodBinding.selector), methodBinding.declaringClass, scope, invocationSite, scope, true, methodsFound);
                }
            }
            ++i;
        }
        return;
    }

    public boolean canUseDiamond(String[] parameterTypes, char[] fullyQualifiedTypeName) {
        Binding guessedType = null;
        char[][] cn = CharOperation.splitOn('.', fullyQualifiedTypeName);
        Scope scope = this.assistScope;
        if (scope.compilerOptions().sourceLevel < 0x330000L) {
            return false;
        }
        char[][] expectedTypekeys = this.completionContext.getExpectedTypesKeys();
        if (expectedTypekeys == null || expectedTypekeys.length == 0) {
            return true;
        }
        TypeReference ref = cn.length == 1 ? new SingleTypeReference(cn[0], 0L) : new QualifiedTypeReference(cn, new long[cn.length]);
        switch (scope.kind) {
            case 1: 
            case 2: {
                guessedType = ref.resolveType((BlockScope)scope);
                break;
            }
            case 3: {
                guessedType = ref.resolveType((ClassScope)scope);
            }
        }
        if (guessedType != null && guessedType.isValidBinding()) {
            guessedType = ((TypeBinding)guessedType).erasure();
            TypeVariableBinding[] typeVars = ((TypeBinding)guessedType).typeVariables();
            for (int i = 0; i < parameterTypes.length; ++i) {
                for (int j = 0; j < typeVars.length; ++j) {
                    if (!CharOperation.equals(parameterTypes[i].toCharArray(), typeVars[j].sourceName)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public ASTNode getCompletionNode() {
        return this.assistNode;
    }

    public ASTNode getCompletionNodeParent() {
        return this.assistNodeParent;
    }

    public ObjectVector getVisibleLocalVariables() {
        if (!this.hasComputedVisibleElementBindings) {
            this.computeVisibleElementBindings();
        }
        return this.visibleLocalVariables;
    }

    public ObjectVector getVisibleFields() {
        if (!this.hasComputedVisibleElementBindings) {
            this.computeVisibleElementBindings();
        }
        return this.visibleFields;
    }

    public ObjectVector getVisibleMethods() {
        if (!this.hasComputedVisibleElementBindings) {
            this.computeVisibleElementBindings();
        }
        return this.visibleMethods;
    }
}

