/***************************************************************************
* $Id$
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.trinitydesktop.qt.*;

public class Main {

public static void main(String[] args)
{
    if ( args.length > 0 && args[0].equals("-m") ) {
	TQApplication.setColorSpec( TQApplication.ManyColor );
    }
    else if ( args.length > 1 && args[1].equals("-n") ) {
	TQApplication.setColorSpec( TQApplication.NormalColor );
    }
    else {
	TQApplication.setColorSpec( TQApplication.CustomColor );
    }

    TQApplication.setFont( new TQFont("Helvetica", 12) );
    TQApplication a = new TQApplication( args );

    ImageIconProvider iip = new ImageIconProvider();
    TQFileDialog.setIconProvider( iip );

    if ( args.length == 0 ) {
	// Create a window which looks after its own existence.
	ImageViewer w =
	    new ImageViewer(null, "new window", Qt.WDestructiveClose | Qt.WResizeNoErase );
	w.setCaption("Qt Example - Image Viewer");
	w.show();
    } else {
	for ( int i=0; i<args.length; i++ ) {
	    // Create a window which looks after its own existence.
	    ImageViewer w =
		new ImageViewer(null, args[i], Qt.WDestructiveClose | Qt.WResizeNoErase );
	    w.setCaption("Qt Example - Image Viewer");
	    w.loadImage( args[i] );
	    w.show();
	}
    }

    TQObject.connect(Qt.qApp(), Qt.TQ_SIGNAL("lastWindowClosed()"), Qt.qApp(), Qt.TQ_SLOT("quit()"));

    a.exec();
    return;
}

	static {
		qtjava.initialize();
	}
}
