/*
 * playlist.h
 *
 * Copyright (C) 2003-2005 Jürgen Kofler <kaffeine@gmx.net>
 * Copyright (C) 2005-2006 Christophe Thommeret <hftom@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef PLAYLIST_H
#define PLAYLIST_H

#include <kdialogbase.h>
#include <tdediroperator.h>
#include <tdefileiconview.h>
#include <tdeaction.h>
#include <kstdaction.h>

#include <tqwidget.h>
#include <tqptrlist.h>
#include <tqvbox.h>
#include <tqsplitter.h>
#include <tqpainter.h>
#include <tqtoolbutton.h>

#include "urllistview.h"
#include "kaffeineinput.h"

class UrlListView;
class MRL;
class KURL;
class TQListViewItem;
class TQString;
class TQLabel;
class TQColor;
class TQDropEvent;
class TQPixmap;
class KLineEdit;
class KComboBox;
class KURLComboBox;
class TDEConfig;
class KPushButton;
class GoogleFetcher;



class GalleryDialog : public KDialogBase
{
	TQ_OBJECT
  
public:
	GalleryDialog( TQWidget *parent, GoogleFetcher *goog );
protected slots:
	void slotOk();
	void slotNext();
private:
	TQFrame *imageFrame;
	GoogleFetcher *google;
	TQTimer next;
	TQHBox *hbox;
};



class RollTitle : public TQLabel
{
	TQ_OBJECT
  

public:
	RollTitle( TQWidget *parent );
	void setTitle( MRL mrl );

private:
	void setTitle( TQString t );
	TQTimer titleTimer;
	TQPixmap titlePix;
	TQColor back, fore;
	int titleOffset;
	TQString title;

protected:
	void paintEvent ( TQPaintEvent * );

private slots:
	void rollTitle();
};



class CoverFrame : public TQFrame
{
	TQ_OBJECT
  

public:
	CoverFrame( TQWidget *parent );
	~CoverFrame();
	void setCoverPixmap( const TQString &path );

protected:
	void mousePressEvent( TQMouseEvent *e );

private:
	void popup( const TQPixmap &pix ) const;
	TQString imagePath;
	TQPixmap noCoverPix;

signals:
	void changeCurrentCover();
	void gallery();
};



class PlayList : public KaffeineInput
{
	TQ_OBJECT
  

public:
	PlayList(TQWidget *parent, TQObject *objParent, const char *name=0);
	~PlayList();

	// Reimplemented from KaffeineInput
public:
	TQWidget *wantPlayerWindow();
	TQWidget *inputMainWidget();
	void mergeMeta(const MRL&);
	bool nextTrack( MRL& );
	bool previousTrack( MRL& );
	bool currentTrack( MRL& );
	bool trackNumber( int, MRL& );
	bool playbackFinished( MRL& );
	void getTargets( TQStringList &uiNames, TQStringList &iconNames, TQStringList &targetNames );
	void togglePanel();
	bool execTarget( const TQString& );
	void saveConfig();
	bool showPlayer() {return !m_showPlayer->isChecked();}
	//***************************************

public:
	MRL getCurrent();  /* get current playlist entry */
	MRL getNext();
	MRL getEntryWithNumber(int number);
	void setCurrentEntry(TQListViewItem*, bool playIcon = true);

	TQListViewItem* getLast();
	TQListViewItem* getFirst();
	TQListViewItem* findByURL(const TQString&);

	/* insert a KURL(list) after a specific item */
	void add(const TQString& url, TQListViewItem* after);
	void add(const TQStringList& urls, TQListViewItem* after);
	void add(const TQValueList<MRL>&, TQListViewItem* after);

	bool isQueueMode() { return m_queue.count(); }

	void setPlaylist(const TQString& name, bool clear = false);
	void nextPlaylist();
	void removeCurrentPlaylist();
	void saveCurrentPlaylist();
	TQString queryCurrentPlaylist();
	void loadConfig(TDEConfig*);
	void saveConfig(TDEConfig*);
	void clearList();

	void setEndless(bool);
	void setRandom(bool);

	void useAlternateEncoding(bool);
	void setAlternateEncoding(const TQString&);

	void setFileFilter(const TQString& filter);
	void savePlaylist(const TQString&);
	void loadPlaylist(const TQString&);

	void exportM3UPlaylist(const TQString&);
	void exportPLSPlaylist(const TQString&);

	const bool getReadMetaOnLoading() const { return m_metaOnLoading; }

	TQVBox *mainWidget;
	TQVBox *playerBox;

public slots:
	void slotToggleShuffle();

protected:
	void closeEvent(TQCloseEvent*);

private slots:
	void slotNewList();
	void slotSetReadMetaOnLoading(bool read) { m_metaOnLoading = read; }
	void slotSetAlternateColor(const TQColor&);
	void slotPlayDirect(TQListViewItem* item);  /* doubleclick */
	void slotDropEvent(TQDropEvent*, TQListViewItem*);
	void slotPreDropEvent();
	void slotCut();
	void slotPaste();
	void slotCopy();
	void slotSelectAll();
	void slotPlaylistFromSelected();
	void slotAddToQueue(MRL);
	void slotRemoveSelected();
	void slotFindText(const TQString&);
	void slotSort(int);
	void slotPlaylistActivated(int);
	void slotNewPlaylistName(const TQString&);
	void slotRepeat();
	void slotShuffle();
	void slotAutoCover();
	void slotShowPlayer();
	void slotPlaylistLoad();
	void slotPlaylistSaveAs();
	void slotPlaylistRemove();
	void setCover( TQString s1, TQString s2, bool forceFetch=false );
	void chooseCurrentCover();
	void showGallery();
	void startPlaylist();
	void fileSelected( const KFileItem* );
	void setBrowserURL( const TQString& );
	void setBrowserURL( const KURL& );
	void browserURLChanged( const KURL& );
	void slotClearList();
	void resetSearch();

private:
	TQListViewItem* insertItem(TQListViewItem* after, const MRL&);
	void updateStatus();
	void createRandomList();
	void getMetaInfo(MRL& mrl, const TQString& mimeName);
	void setupActions();
	/* helpers */
	static TQString msToTimeString(int);
	static int timeStringToMs(const TQString&);
	static bool endsWith(TQString, TQString, bool);
	static bool startsWith(TQString, TQString, bool);

private:
	TQColor m_altCol;
	KComboBox* m_playlistSelector;
	TQToolButton *searchBtn;
	KLineEdit* m_playlistFilter;
	int m_nextPlaylistNumber;
	TQString m_playlistDirectory;
	int m_currentPlaylist;
	KURLComboBox *browserComb;

	TQSplitter *hSplit, *vSplit;
	TQVBox *panel;
	TQWidget *playlist;
	KDirOperator *fileBrowser;
	KFileIconView *view;
	CoverFrame *coverFrame;
	GoogleFetcher *google;
	TQString coverImageFormat;
	RollTitle *roller;

	TDEToggleAction *m_repeat, *m_shuffle, *m_autoCover, *m_showPlayer;

	TQValueList<MRL> m_queue;

	uint m_playTime;
	uint m_playTimeVisible;
	uint m_countVisible;

	bool m_searchSelection;
	bool m_metaOnLoading;
	bool m_sortAscending;

	UrlListView* m_list;
	TQListViewItem* m_currentEntry;
	MRL m_currentEntryMRL;

	TQString m_fileFilter;
	TQString m_metaInfoString;
	TQString m_lastPlaylist;

	TQPtrList<TQListViewItem> m_randomList;
	int m_currentRandomListEntry;

	TQPixmap m_isCurrentEntry;
	TQPixmap m_cdPixmap;

	bool m_endless;
	bool m_random;
	bool m_cover;

	bool m_useAlternateEncoding;
	TQString m_alternateEncoding;

signals:
	void signalRequestForAudioCD(const TQString&);
	void signalRequestForDVD(const TQString&);
	void signalRequestForVCD(const TQString&);
};

class TQListBox;
class TQStringList;

class SubtitleChooser : public KDialogBase
{
	TQ_OBJECT
  
public:
	SubtitleChooser(TQStringList, TQString, TQWidget *parent=0, const char *name = 0);
	virtual ~SubtitleChooser();

	TQString getSelection();

private:
	TQListBox *table;
};

class MovieChooser : public KDialogBase
{
	TQ_OBJECT
  
public:
	MovieChooser(TQStringList, TQString, TQWidget *parent=0, const char *name = 0);
	virtual ~MovieChooser();

	TQString getSelection();

private:
	TQListBox *table;
};

#endif /* PLAYLIST_H */
