// (c) 2004 Max Howell (max.howell@methylblue.com)
// See COPYING file for licensing information

#ifndef CODEINELISTVIEW_CPP
#define CODEINELISTVIEW_CPP

#include <tdelistview.h>

namespace Codeine
{
   class ListView : public TDEListView
   {
   public:
      ListView( TQWidget *parent ) : TDEListView( parent )
      {
         addColumn( TQString::null, 0 );
         addColumn( TQString::null );

         setResizeMode( LastColumn );
         setMargin( 2 );
         setSorting( -1 );
         setSizePolicy( TQSizePolicy::Minimum, TQSizePolicy::Minimum );
         setAllColumnsShowFocus( true );
         setItemMargin( 3 );
      }

      virtual TQSize sizeHint() const
      {
         const TQSize sh = TDEListView::sizeHint();

         return TQSize( sh.width(),
            childCount() == 0
               ? 50
               : TQMIN( sh.height(), childCount() * (firstChild()->height()) + margin() * 2 + 4 + reinterpret_cast<TQWidget*>(header())->height() ) );
      }
   };
}

#endif
