/***************************************************************************
 *   Copyright (C) 2013 by Timothy Pearson                                 *
 *   kb9vqf@pearsoncomputing.net                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <tdelocale.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <knuminput.h>
#include <tdeactionselector.h>
#include <tqlistbox.h>
#include <kpushbutton.h>
#include <tqpixmap.h>
#include <tqiconset.h>
#include <tqlabel.h>
#include <kurlrequester.h>
#include <kcombobox.h>
#include <tqradiobutton.h>
#include <tqcheckbox.h>
#include <kdatetimewidget.h>
#include <kiconloader.h>

#include "libtdeldap.h"
#include "multimasterreplicationconfigdlg.h"

MultiMasterReplicationConfigDialog::MultiMasterReplicationConfigDialog(LDAPMasterReplicationMapping multimasterreplication, TQString realmName, TQWidget* parent, const char* name)
	: KDialogBase(parent, name, true, i18n("LDAP Multi-Master Replication Properties"), Ok|Cancel, Ok, true), m_replicationProperties(multimasterreplication), m_ldapconfig(parent), m_realmName(realmName)
{
	m_base = new LDAPMultiMasterReplicationConfigBase(this);
	setMainWidget(m_base);

	m_base->detailsIcon->setPixmap(SmallIcon("system.png"));

	m_base->realmNameLabel->setText("."+realmName.lower());

	connect(m_base->masterName, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(processLockouts()));

	m_base->masterUID->setValue(m_replicationProperties.id);

	TQString shortMasterName = m_replicationProperties.fqdn;
	if (shortMasterName.endsWith("." + m_realmName.lower())) {
		shortMasterName.truncate(shortMasterName.length() - TQString("." + m_realmName).length());
	}
	m_base->masterName->setText(shortMasterName);
	m_base->masterName->setFocus();

	processLockouts();
}

void MultiMasterReplicationConfigDialog::slotOk() {
	m_replicationProperties.fqdn = m_base->masterName->text() + "." + m_realmName.lower();
	m_replicationProperties.id = m_base->masterUID->value();

	accept();
}

void MultiMasterReplicationConfigDialog::processLockouts() {
	if (m_base->masterName->text() == "") {
		enableButton(KDialogBase::Ok, false);
	}
	else {
		enableButton(KDialogBase::Ok, true);
	}
}

LDAPMasterReplicationMapping MultiMasterReplicationConfigDialog::replicationProperties() {
	return m_replicationProperties;
}

#include "multimasterreplicationconfigdlg.moc"
