/***************************************************************************
 *   Copyright (C) 2006-2012 by Thomas Schweitzer                          *
 *   thomas-schweitzer(at)arcor.de                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2.0 as   *
 *   published by the Free Software Foundation.                            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program in the file LICENSE.GPL; if not, write to the *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef UIGUIINIFILEPARSER_H
#define UIGUIINIFILEPARSER_H

#include <tqmap.h>
#include <tqstring.h>
#include <tqstringlist.h>

class TQStringList;
class TQVariant;


class UiGuiIniFileParser
{
	public:
		UiGuiIniFileParser(void);
		UiGuiIniFileParser(const TQString &iniFileName);
		~UiGuiIniFileParser(void);

		TQVariant    value(const TQString &keyName, const TQString &defaultValue = TQString::null);
		TQStringList childGroups();

	protected:
		void init();

	private:
		void parseIniFile();

		TQString m_iniFileName;
		TQStringList m_sections;
		TQMap<TQString, TQVariant> m_keyValueMap;
};

#endif
