#ifndef _KPROCESS_H_
#define _KPROCESS_H_

#include <tqdir.h>
#include "common/global/global.h"
#include "common/common/synchronous.h"
#if [[[TQT_VERSION IS DEPRECATED]]]<0x040000
class TQProcess;
#else
class Q3Process;
#endif

class TDEProcess : public TQObject
{
TQ_OBJECT
  
public:
  TDEProcess(TQObject *parent = 0, const char *name = 0);
  void clearArguments() { _arguments.clear(); }
  TDEProcess &operator<< (const TQString &arg) { _arguments += arg; return *this; }
  TDEProcess &operator<< (const TQStringList &args) { _arguments += args; return *this; }
  TQStringList args() const { return _arguments; }
  void setEnvironment(const TQString &name, const TQString &value) { _environment += name + "=" + value; }
  bool start();
  bool writeStdin(const char *buffer, int len);
  bool kill();
  bool kill(int n);
  int exitStatus() const;
  bool isRunning() const;
  void setWorkingDirectory(const TQDir &dir);
  void setUseShell(bool useShell);

signals:
  void processExited(TDEProcess *process);
  void receivedStdout(TDEProcess *process, char *buffer, int len);
  void receivedStderr(TDEProcess *process, char *buffer, int len);

private slots:
  void processExitedSlot();
  void readyReadStdoutSlot();
  void readyReadStderrSlot();

private:
#if [[[TQT_VERSION IS DEPRECATED]]]<0x040000
  TQProcess *_process;
#else
  Q3Process  *_process;
#endif
  TQStringList _arguments,_environment;
};

#endif
