/***************************************************************************
 *   Copyright (C) 2006 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef COFF_ARCHIVE_H
#define COFF_ARCHIVE_H

#include "coff.h"

namespace Coff
{
//----------------------------------------------------------------------------
class Member
{
public:
  Member(const TQByteArray &data, uint &offset, Log::Base &log);
  TQString name() const { return _name; }
  uint nbBytes() const { return _nbBytes; }

private:
  TQString _name;
  uint    _nbBytes;
};

//----------------------------------------------------------------------------
class Archive : public Base
{
public:
  Archive(const PURL::Url &url);
  virtual ~Archive();
  virtual bool parse(Log::Base &log);
  const TQMap<TQString, Member *>members() const { return _members; }
  const TQMap<TQString, Member *>symbols() const { return _symbols; }

  virtual Log::KeyList information() const;
  Log::KeyList membersInformation() const;
  Log::KeyList symbolsInformation() const;

private:
  TQMap<TQString, Member *> _members; // name -> Member *
  TQMap<uint, Member *>    _offsets; // offset -> Member *
  TQMap<TQString, Member *> _symbols; // name -> Member *

  bool readSymbols(const TQByteArray &data, uint offset, Log::Base &log);
};

} // namespace

#endif
