/***************************************************************************
 *   Copyright (C) 2005 by David Saxton                                    *
 *   david@bluehaze.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef RECENTFILESACTION_H
#define RECENTFILESACTION_H

#include <tdeactionclasses.h>

/**
Taken mainly from tdelibs/tdeui/tdeactionclasses.[cpp/h], author Michael Koch.
Adapted to work around strange bug occuring.
*/
class RecentFilesAction : public TDESelectAction
{
	TQ_OBJECT
  
	public:
		RecentFilesAction( const TQString & configGroupName, const TQString & text, const TQObject * receiver, const char* slot, TQObject* parent, const char * name );
		
		~RecentFilesAction();
		
		/**
		 *  Loads the recent files entries from a given TDEConfig object.
		 *  You can provide the name of the group used to load the entries.
		 *  If the groupname is empty, entries are load from a group called 'RecentFiles'
		 *
		 *  This method does not effect the active group of TDEConfig.
		 */
		void loadEntries();
		/**
		 *  Saves the current recent files entries to a given TDEConfig object.
		 *  You can provide the name of the group used to load the entries.
		 *  If the groupname is empty, entries are saved to a group called 'RecentFiles'
		 *
		 *  This method does not effect the active group of TDEConfig.
		 */
		void saveEntries();
		/**
		 *  Add URL to recent files list.
		 *
		 *  @param url The URL of the file
		 */
		void addURL( const KURL& url );
		
	signals:
		/**
		 *  This signal gets emited when the user selects an URL.
		 *
		 *  @param url The URL thats the user selected.
		 */
		void urlSelected( const KURL& url );
		
	protected slots:
		void itemSelected( const TQString& string );
		void menuAboutToShow();
		void menuItemActivated( int id );
		void slotClicked();
		virtual void slotActivated(int);
		virtual void slotActivated(const TQString& );
		virtual void slotActivated();

	protected:
		unsigned m_maxItems;
		TDEPopupMenu * m_popup;
		TQString m_configGroupName;
};

#endif
