/*
    meanwhileprotocl.h - the meanwhile protocol definition

    Copyright (c) 2005      by Jeremy Kerr <jk@ozlabs.org>
    Copyright (c) 2003-2004 by Sivaram Gottimukkala  <suppandi@gmail.com>

    Kopete    (c) 2002-2004 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#ifndef MEANWHILEPROTOCOL_H
#define MEANWHILEPROTOCOL_H

#include <kopeteprotocol.h>

#include "kopetecontact.h"
#include "kopetemetacontact.h"
#include "kopeteonlinestatus.h"
#include "kopeteonlinestatusmanager.h"
#include "addcontactpage.h"

#include <kdebug.h>
#define MEANWHILE_DEBUG 14200
#define HERE kdDebug(MEANWHILE_DEBUG) << k_funcinfo << endl
#define mwDebug() kdDebug(MEANWHILE_DEBUG)

class MeanwhileAccount;
class MeanwhileEditAccountWidget;
class MeanwhileAddContactPage;

class MeanwhileProtocol : public Kopete::Protocol
{
    TQ_OBJECT
  
public:
    MeanwhileProtocol(TQObject *parent, const char *name,
            const TQStringList &args);

    ~MeanwhileProtocol();

    virtual AddContactPage *createAddContactWidget(TQWidget *parent,
            Kopete::Account *account);

    virtual KopeteEditAccountWidget *createEditAccountWidget(
            Kopete::Account *account, TQWidget *parent);

    virtual Kopete::Account *createNewAccount(const TQString &accountId);

    virtual Kopete::Contact *deserializeContact(
            Kopete::MetaContact *metaContact,
            const TQMap<TQString,TQString> &serializedData,
            const TQMap<TQString, TQString> &addressBookData);

    const Kopete::OnlineStatus accountOfflineStatus();

    const Kopete::OnlineStatus lookupStatus(
            enum Kopete::OnlineStatusManager::Categories cats);

    const Kopete::OnlineStatus statusOffline;
    const Kopete::OnlineStatus statusOnline;
    const Kopete::OnlineStatus statusAway;
    const Kopete::OnlineStatus statusBusy;
    const Kopete::OnlineStatus statusIdle;
    const Kopete::OnlineStatus statusAccountOffline;

    Kopete::ContactPropertyTmpl statusMessage;
    Kopete::ContactPropertyTmpl awayMessage;

};

#endif
