/***************************************************************************
                           debuggerbreakpoint.h
                           --------------------
    begin                : 2004-04-04
    copyright            : (C) 2004 Thiago Silva

 ***************************************************************************/

/****************************************************************************
 *                                                                          *
 *   This program is free software; you can redistribute it and/or modify   *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                    *
 *                                                                          *
 ***************************************************************************/

#ifndef DEBUGGERBREAKPOINT_H
#define DEBUGGERBREAKPOINT_H
#include <tqstring.h>


class DebuggerBreakpoint
{
  public:
    enum Types
    {
      LineBreakpoint = 0,
      ConditionalTrue,
      ConditionalChange
    };
  
    enum States
    {
      Undefined = 0,
      Unfulfilled,
      Fulfilled,
      Error
    };
    
    DebuggerBreakpoint();
    DebuggerBreakpoint(const DebuggerBreakpoint& bp);
    DebuggerBreakpoint(const DebuggerBreakpoint* bp);
    DebuggerBreakpoint(const TQString& filePath, int line); // Line BP
    DebuggerBreakpoint(const DebuggerBreakpoint::Types type,                   // Any kind
                       const TQString& conditionExpr, const TQString& filePath = "", 
                       const TQString& inClass = "", const TQString& inFunction = "");

    virtual ~DebuggerBreakpoint();

    virtual void setFunction(const TQString& filePath);
    virtual void setClass(const TQString& filePath);
    virtual void setFilePath(const TQString& filePath);
    virtual void setLine(int line);
    virtual void setCondition(const TQString& expression);
    virtual void setState(int state);
    virtual void setType(Types type);
    virtual void setValue(const TQString& value);
    virtual void setKey(const TQString& value);

    virtual const TQString& filePath() const;
    virtual const TQString& inClass() const;
    virtual const TQString& inFunction() const;
    virtual int line() const;
    virtual const TQString& condition() const;
    virtual int state() const;
    virtual DebuggerBreakpoint::Types type() const;
    virtual const TQString& value() const;
    virtual const TQString& key() const;

    bool operator == (DebuggerBreakpoint) const;

  protected:
    TQString m_filePath;
    TQString m_class;
    TQString m_function;
    int     m_line;
    TQString m_conditionExpr;
    int     m_state;
    Types   m_type;
    TQString m_value;
    TQString m_key;
};

#endif
