//
// C++ Interface: toolbox
//
// Description: 
//
//
// Author: Andras Mantia <amantia@kdewebdev.org>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef TOOLBOX_H
#define TOOLBOX_H

#include <tqtoolbox.h>
#include <kommanderwidget.h>

/**
	@author Andras Mantia <amantia@kdewebdev.org>
*/

class TDE_EXPORT ToolBox : public TQToolBox, public KommanderWidget
{
  TQ_OBJECT
  
  TQ_PROPERTY(TQString populationText READ populationText WRITE setPopulationText DESIGNABLE false)
  TQ_PROPERTY(TQStringList associations READ associatedText WRITE setAssociatedText DESIGNABLE false)
  TQ_PROPERTY(bool KommanderWidget READ isKommanderWidget)
public:
  ToolBox(TQWidget *parent = 0, const char *name = 0);

  ~ToolBox();

  virtual bool isKommanderWidget() const;
  virtual TQString currentState() const;
  virtual bool isFunctionSupported(int function);
  virtual TQString handleDCOP(int function, const TQStringList& args);
  virtual TQStringList associatedText() const;
  virtual void setAssociatedText(const TQStringList&);
  virtual TQString populationText() const;
  virtual void setPopulationText(const TQString&);

public slots:
  virtual void populate();

signals:
  void widgetOpened();
  void contextMenuRequested(int xpos, int ypos);
protected:
  void showEvent(TQShowEvent *e);
  void contextMenuEvent( TQContextMenuEvent * e );
  TQString addWidget(const TQString& widgetName, const TQString &label);

};

#endif
