 /*
    This file is part of tdepim.

    Copyright (C) 2004-05 Reinhold Kainhofer <reinhold@kainhofer.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef KCAL_BLOGGINGCALENDARADAPTOR_H
#define KCAL_BLOGGINGCALENDARADAPTOR_H

#include "calendaradaptor.h"
#include "groupwareuploadjob.h"
#include "API_Blog.h"
#include <kurl.h>

namespace TDEIO {
class Job;
}

namespace KCal {

class BloggingUploadItem : public KPIM::GroupwareUploadItem
{
  public:
    BloggingUploadItem( KBlog::APIBlog *api, CalendarAdaptor *adaptor, KCal::Incidence *incidence, UploadType type );
    virtual ~BloggingUploadItem();
    virtual TDEIO::TransferJob *createUploadNewJob(
            KPIM::GroupwareDataAdaptor *adaptor, const KURL &baseurl );
    virtual TDEIO::TransferJob *createUploadJob(
            KPIM::GroupwareDataAdaptor *adaptor, const KURL &url );

  protected:
    BloggingUploadItem( UploadType type ) : KPIM::GroupwareUploadItem( type ) {}
    KBlog::BlogPosting *mPosting;
    KBlog::APIBlog *mAPI;
};

class BloggingCalendarAdaptor : public CalendarAdaptor
{
TQ_OBJECT
  
  public:
    BloggingCalendarAdaptor();
    TQValueList<KPIM::FolderLister::ContentType> supportedTypes()
    {
      TQValueList<KPIM::FolderLister::ContentType> types;
      types << KPIM::FolderLister::Journal;
      return types;
    }

    TQCString identifier() const { return "KCalResourceBlogging"; }
    long flags() const { return GWResNeedsLogon; }

    void setBaseURL( const KURL &url );
    void setUser( const TQString &user );
    void setPassword( const TQString &password );
    // We don't want to set the username / pw for the URL!
    void setUserPassword( KURL &url );

    KBlog::APIBlog *api() const;
    void setAPI( KBlog::APIBlog *api );

    TDEIO::Job *createLoginJob( const KURL &url, const TQString &user,
                              const TQString &password  );
    TDEIO::Job *createListFoldersJob( const KURL &url );
    TDEIO::TransferJob *createListItemsJob( const KURL &url );
    TDEIO::TransferJob *createDownloadJob( const KURL &url,
                                    KPIM::FolderLister::ContentType ctype );
    TDEIO::Job *createRemoveJob( const KURL &url, KPIM::GroupwareUploadItem *deleteItem );

    bool interpretLoginJob( TDEIO::Job *job );
    void interpretListFoldersJob( TDEIO::Job *job, KPIM::FolderLister * );
    bool interpretListItemsJob( TDEIO::Job *job, const TQString &jobData );
    bool interpretDownloadItemsJob( TDEIO::Job *job, const TQString &jobData );

  public slots:
    void slotFolderInfoRetrieved( const TQString &id, const TQString &name );
    void slotUserInfoRetrieved( const TQString &nick, const TQString &user,
                            const TQString &email );

  protected:
    KPIM::GroupwareUploadItem *newUploadItem( KCal::Incidence*it,
                                  KPIM::GroupwareUploadItem::UploadType type );

    KBlog::APIBlog *mAPI;
    bool mAuthenticated;
    static TQString mAppID;
};

}

#endif
