import org.trinitydesktop.qt.*;

public class LCDRange extends TQVBox {
	private TQSlider slider;
	
	public LCDRange(TQWidget parent, String name) {
		super(parent, name);
		TQLCDNumber lcd = new TQLCDNumber(2, this, "lcd");
		slider = new TQSlider(Horizontal, this, "slider");
		slider.setRange(0, 99);
		slider.setValue(0);
		
		connect(slider, TQ_SIGNAL("valueChanged(int)"),
						lcd, TQ_SLOT("display(int)"));
		connect(slider, TQ_SIGNAL("valueChanged(int)"),
						TQ_SIGNAL("valueChanged(int)"));
	}
	public LCDRange(TQWidget parent) {
		this(parent, null);
	}

	public int value() {
		return slider.value();
	}

	public void setValue(int value) {
		slider.setValue(value);
	}
}
