/***************************************************************************
 *   Copyright (C) 2012 by Timothy Pearson                                 *
 *   kb9vqf@pearsoncomputing.net                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PRIMARYREALMWIZARD_H
#define PRIMARYREALMWIZARD_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tdeapplication.h>
#include <kwizard.h>

#include "ldapcontroller.h"

/** prototypes */
class KLanguageCombo;
class PrimaryRealmIntroPage;
class PrimaryRealmConfigPage;
class PrimaryCertConfigPage;
class PrimaryRealmFinishPage;

/** PrimaryRealmWizard is the base class of the project */
class PrimaryRealmWizard : public KWizard {
	TQ_OBJECT
public:
	/** construtor */
	PrimaryRealmWizard(LDAPController* controller, TQString fqdn, LDAPCertConfig certinfo, TQWidget* parent=0, const char *name=0);
	/** destructor */
	~PrimaryRealmWizard();

	virtual void next();
	virtual void back();

public slots: // Public slots
	/** calls all save functions after resetting all fields to Trinity default */
	void setDefaults();
	/** the cancel button is connected to the reject() slot of TQDialog,
	*  so we have to reimplement this here to add a dialogbox to
	*  ask if we really want to quit the wizard.
	*/
	void reject();
	/** maybe call a dialog that the wizard has finished.
	* Calls applySettings() to save the current selection.
	*/
	void accept();
	/** We need this to use it in a TQTimer */
	void slotNext();

private:
	void setPosition();

private:
	PrimaryRealmIntroPage* intropage;
	PrimaryRealmConfigPage* realmpage;
	PrimaryCertConfigPage* certpage;
	PrimaryRealmFinishPage* finishpage;
	bool realm_dirty;
	LDAPController* m_controller;
	LDAPRealmConfig m_realmconfig;
	TQString m_fqdn;
	LDAPCertConfig m_certconfig;

protected: // Protected methods
	// the close button on the titlebar sets e->accept() which we don't want.
	virtual void closeEvent(TQCloseEvent*);
	bool askClose();
};

#endif
