#ifndef _MP_DCOPINTERFACE_H_
#define _MP_DCOPINTERFACE_H_
//=============================================================================
//
//   File : mp_dcopinterface.h
//   Created on Sun 27 Mar 2005 16:56:21 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2005 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "kvi_settings.h"

#ifdef COMPILE_TDE_SUPPORT

#include "mp_interface.h"

class KviMediaPlayerDCOPInterface : public KviMediaPlayerInterface
{
public:
	KviMediaPlayerDCOPInterface(const KviTQCString &szAppId);
	~KviMediaPlayerDCOPInterface();
protected:
	KviTQCString m_szAppId;
protected:
	bool ensureAppRunning(const TQString &szApp);
	bool findRunningApp(const TQString &szApp);
	bool startApp(const TQString &szApp,int iWaitMSecs = 0);
	int detectApp(const TQString &szApp,bool bStart,int iScoreWhenFound,int iScoreWhenStarted);
	bool simpleDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc);
	bool intDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc,int iVal);
	bool boolDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc,bool bVal);
	bool stringDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc,TQString szVal);
	bool floatDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc,float fVal);
	bool stringRetDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc,TQString &ret);
	bool intRetDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc,int &ret);
	bool boolRetDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc,bool &ret);
};

#endif //COMPILE_TDE_SUPPORT

#endif //!_MP_DCOPINTERFACE_H_
