/***************************************************************************
                          spy.cpp  -  description
                             -------------------
    begin                : Tue May  1 02:59:33 BST 2001
    copyright            : (C) 2001 by Richard Moore
    email                : rich@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tdelistviewsearchline.h>
#include <tdelocale.h>

#include <tqlabel.h>
#include <tqlayout.h>
#include <tqlistview.h>
#include <tqsplitter.h>
#include <ktabwidget.h>
#include <tqvbox.h>

#include "navview.h"
#include "propsview.h"
#include "sigslotview.h"
#include "receiversview.h"
#include "classinfoview.h"
#include "spy.h"

extern "C"
{
  KDE_EXPORT void* init_libkspy()
  {
    tqWarning( "KSpy: Initialising...\n" );
    Spy *s = new Spy();
    s->show();

    return 0;
  }
}

Spy::Spy( TQWidget *parent, const char *name )
  : TQWidget( parent, name )
{
  TQVBoxLayout *layout = new TQVBoxLayout( this, 11, 6 );

  TQSplitter *div = new TQSplitter( this );
  layout->addWidget( div );

  TQVBox *leftPane = new TQVBox( div );

  TDEListViewSearchLine *searchLine = new TDEListViewSearchLine( leftPane, "search line" );
  mNavView = new NavView( leftPane, "navigation view" );
  searchLine->setListView( mNavView );

  KTabWidget *tabs = new KTabWidget( div );

  mPropsView = new PropsView( tabs, "properties view" );
  tabs->addTab( mPropsView, i18n( "Properties" ) );

  mSigSlotView = new SigSlotView( tabs, "signals and slots view" );
  tabs->addTab( mSigSlotView, i18n( "Signals && Slots" ) );

  mReceiversView = new ReceiversView( tabs, "receivers view" );
  tabs->addTab( mReceiversView, i18n( "Receivers" ) );

  mClassInfoView = new ClassInfoView( tabs, "class info view" );
  tabs->addTab( mClassInfoView, i18n( "Class Info" ) );

  mNavView->buildTree();

  connect( mNavView, TQ_SIGNAL( selected( TQObject * ) ),
           mPropsView, TQ_SLOT( setTarget( TQObject * ) ) );
  connect( mNavView, TQ_SIGNAL( selected( TQObject * ) ),
           mSigSlotView, TQ_SLOT( setTarget( TQObject * ) ) );
  connect( mNavView, TQ_SIGNAL( selected( TQObject * ) ),
           mReceiversView, TQ_SLOT( setTarget( TQObject * ) ) );
  connect( mNavView, TQ_SIGNAL( selected( TQObject * ) ),
           mClassInfoView, TQ_SLOT( setTarget( TQObject * ) ) );
}

Spy::~Spy()
{
}


void Spy::setTarget( TQWidget *target )
{
  mTarget = target;
  mPropsView->buildList( mTarget );
  mSigSlotView->buildList( mTarget );
  mReceiversView->buildList( mTarget );
  mClassInfoView->buildList( mTarget );
}

void Spy::keyPressEvent( TQKeyEvent *event )
{
  if ( event->key() == TQt::Key_Up ) {
    event->accept();
    TQApplication::postEvent( mNavView, new TQKeyEvent( TQEvent::KeyPress, TQt::Key_Up, 0, 0 ) );
  } else if ( event->key() == TQt::Key_Down ) {
    event->accept();
    TQApplication::postEvent( mNavView, new TQKeyEvent( TQEvent::KeyPress, TQt::Key_Down, 0, 0 ) );
  } else if ( event->key() == TQt::Key_Return ) {
    event->accept();
    mNavView->expandVisibleTree();
  }
}

#include "spy.moc"
