/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  In addition, as a special exception, the copyright holders give
  permission to link the code of this program with any edition of
  the TQt library by Trolltech AS, Norway (or with modified versions
  of TQt that use the same license as TQt), and distribute linked
  combinations including the two.  You must obey the GNU General
  Public License in all respects for all of the code used other than
  TQt. If you modify this file, you may extend this exception to
  your version of the file, but you are not obligated to do so.  If
  you do not wish to do so, delete this exception statement from
  your version.

**************************************************************************** */
#ifndef DICTIONARYMENU_H
#define DICTIONARYMENU_H

#include <tqintdict.h>
#include <tqobject.h>
#include <tqstringlist.h>
#include <tqguardedptr.h>
#include <kdemacros.h>

class TQSignalMapper;
class TDEPopupMenu;
class TDEActionCollection;

class KDE_EXPORT DictionaryMenu : public TQObject
{
   TQ_OBJECT
  

public:
   DictionaryMenu(TDEPopupMenu *menu, TDEActionCollection *collection, TQObject *parent=0);
   ~DictionaryMenu();
   
   void add(const TQString& name,const TQString& id);

   /**
    * Adds an item to this menu and to the keyboard accelerator.
    * If key contains %1 it is replaced with a number 1-9 
    */
   void add(const TQString& name,const TQString& id, const TQString& key);

   void clear();
   
signals:
   void activated(const TQString moduleId);
   
private slots:
   void activated(int);
   
private:
   TQGuardedPtr<TDEPopupMenu> popup;
   TQGuardedPtr<TDEActionCollection> actionCollection;
   TQIntDict<TQString> num2id;
   TQIntDict<TQString> accel2id;
   TQSignalMapper* dictionaryMapper;
   
   uint maxId;
};

#endif

