/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2001 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>
		2001-2005 by Stanislav Visnovsky
			    <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  In addition, as a special exception, the copyright holders give
  permission to link the code of this program with any edition of
  the TQt library by Trolltech AS, Norway (or with modified versions
  of TQt that use the same license as TQt), and distribute linked
  combinations including the two.  You must obey the GNU General
  Public License in all respects for all of the code used other than
  TQt. If you modify this file, you may extend this exception to
  your version of the file, but you are not obligated to do so.  If
  you do not wish to do so, delete this exception statement from
  your version.

**************************************************************************** */
#ifndef PROJECTPREFWIDGETS_H
#define PROJECTPREFWIDGETS_H

#include <ktabctl.h>
#include <tqptrlist.h>
#include "projectsettings.h"


class KLineEdit;
class TQLineEdit;
class TQCheckBox;
class TQComboBox;
class TQListBox;
class TQRadioButton;
class TQSpinBox;
class CmdEdit;
class TDEFontChooser;
class KColorButton;
class KComboBox;
class KSpellConfig;
class KURLRequester;
class TQPushButton;
class TQGroupBox;
class TDEListEditor;
class ToolSelectionWidget;
class KIntNumInput;
class KURLRequester;

struct ModuleInfo;

class KDE_EXPORT SavePreferences : public KTabCtl
{
   TQ_OBJECT
  
public:
   SavePreferences(TQWidget* parent=0);
   void defaults(const KBabel::SaveSettings& settings);
   void setAutoSaveVisible(const bool on);

private:
   TQCheckBox* _lastButton;
   TQCheckBox* _revisionButton;
   TQCheckBox* _languageButton;
   TQCheckBox* _charsetButton;
   TQCheckBox* _encodingButton;
   TQCheckBox* _projectButton;

   TQCheckBox* _updateButton;
   TQCheckBox* _autoCheckButton;
   TQCheckBox* _saveObsoleteButton;

   TQComboBox* _encodingBox;
   TQCheckBox* _oldEncodingButton;

   TQRadioButton* _defaultDateButton;
   TQRadioButton* _localDateButton;
   TQRadioButton* _customDateButton;
   TQLineEdit* _dateFormatEdit;
   
   TQLineEdit* _projectEdit;

   TQRadioButton* _removeFSFButton;
   TQRadioButton* _updateFSFButton;
   TQRadioButton* _nochangeFSFButton;
   TQCheckBox* _translatorCopyrightButton;

   TQCheckBox* _descriptionButton;
   TQLineEdit* _descriptionEdit;
   
   KIntNumInput * _autoSaveDelay;
   TQGroupBox * _autoSaveBox;

private slots:
   void customDateActivated(bool on);
};


class IdentityPreferences : public TQWidget
{
    TQ_OBJECT
  
public:
    IdentityPreferences(TQWidget *parent = 0, const TQString& project = "");
    virtual bool eventFilter(TQObject *, TQEvent*);
    void defaults(const KBabel::IdentitySettings& settings);

private slots:
    void checkTestPluralButton();
    void testPluralForm();
    void lookupGnuPluralFormHeader();
    
private:
   TQLineEdit* _nameEdit;
   TQLineEdit* _localNameEdit;
   TQLineEdit* _mailEdit;
   TQLineEdit* _langEdit;
   TQLineEdit* _langCodeEdit;
   TQLineEdit* _listEdit;

   TQLineEdit* _timezoneEdit;
   TQSpinBox *_pluralFormsBox;
   TQPushButton *_testPluralButton;
   TQCheckBox* _checkPluralArgumentBox;
   TQLineEdit* _gnuPluralFormHeaderEdit;
   TQPushButton *_testGnuPluralFormButton;
};


class MiscPreferences : public TQWidget
{
   TQ_OBJECT
  
public:
    MiscPreferences(TQWidget *parent=0);
    void defaults(const KBabel::MiscSettings& settings);

private slots:
   void regExpButtonClicked();
   
private:
   void setContextInfo(TQString reg);
   TQString contextInfo() const;
   
   KLineEdit *contextInfoEdit;
   KLineEdit *accelMarkerEdit;
   
   TQDialog *_regExpEditDialog;
   TQPushButton *_regExpButton;

   TQRadioButton* bzipButton;
   TQRadioButton* gzipButton;
   TQCheckBox* compressSingle;
};

class SpellPreferences : public TQWidget
{
    TQ_OBJECT
  
public: 
    SpellPreferences(TQWidget *parent=0);
    
    void mergeSettings(KBabel::SpellcheckSettings& set) const;
    void updateWidgets(const KBabel::SpellcheckSettings& settings);
    void defaults(const KBabel::SpellcheckSettings& settings);

signals:
    void settingsChanged();

private:
    KSpellConfig* spellConfig;
    TQCheckBox* remIgnoredBtn;
    TQCheckBox* onFlyBtn;
    KURLRequester* ignoreURLEdit;

};

class CatmanPreferences : public TQWidget
{
    TQ_OBJECT
  
public:
    CatmanPreferences(TQWidget *parent = 0);
    void defaults(const KBabel::CatManSettings& settings);

private:
    KURLRequester* _poDirEdit;
    KURLRequester* _potDirEdit;

    TQCheckBox* _openWindowButton;

    TQCheckBox* _killButton;
    TQCheckBox* _indexButton;
    TQCheckBox* m_msgfmtButton;
};

class DirCommandsPreferences : public TQWidget
{
    TQ_OBJECT
  
public:
    DirCommandsPreferences(TQWidget *parent = 0);
    virtual ~DirCommandsPreferences();

    void mergeSettings(KBabel::CatManSettings& settings) const;
    void updateWidgets(const KBabel::CatManSettings&);
    void defaults(const KBabel::CatManSettings& settings);

signals:
    void settingsChanged();

private:
    CmdEdit* _dirCmdEdit;
};

class FileCommandsPreferences : public TQWidget
{
    TQ_OBJECT
  
public:
    FileCommandsPreferences(TQWidget *parent = 0);
    virtual ~FileCommandsPreferences();

    void mergeSettings(KBabel::CatManSettings& settings) const;
    void updateWidgets(const KBabel::CatManSettings& settings);
    void defaults(const KBabel::CatManSettings& settings);

signals:
    void settingsChanged();

private:
    CmdEdit* _fileCmdEdit;
};

class ViewPreferences : public TQWidget
{
    TQ_OBJECT
  
public:
    ViewPreferences(TQWidget *parent = 0);
    void defaults(const KBabel::CatManSettings& settings);

private:
    TQCheckBox* _flagColumnCheckbox;
    TQCheckBox* _fuzzyColumnCheckbox;
    TQCheckBox* _untranslatedColumnCheckbox;
    TQCheckBox* _totalColumnCheckbox;
    TQCheckBox* _cvsColumnCheckbox;
    TQCheckBox* _revisionColumnCheckbox;
    TQCheckBox* _translatorColumnCheckbox;
};

/**
* This class implements preference widget for source context
*
* @short Class for setting preferences for source context
* @author Stanislav Visnovsky <visnovsky@kde.org>
*/
class SourceContextPreferences : public TQWidget
{
    TQ_OBJECT
  
public:
    SourceContextPreferences(TQWidget* parent=0); 
    virtual ~SourceContextPreferences();
    
    void mergeSettings(KBabel::SourceContextSettings& settings) const;
    void updateWidgets(const KBabel::SourceContextSettings& settings);
    void defaults(const KBabel::SourceContextSettings& settings);

    virtual bool eventFilter(TQObject *, TQEvent*);
    
signals:
    void itemsChanged ();

private:
    KURLRequester* _coderootEdit;
    TDEListEditor* _pathsEditor;
};

#endif // PROJECTPREFWIDGETS_H
