//---------------------------------------------------------------------------
//
//             kPPP: A pppd front end for the KDE project
//
//---------------------------------------------------------------------------
//
// (c) 1997-1998 Bernd Johannes Wuebben <wuebben@kde.org>
// (c) 1997-1999 Mario Weilguni <mweilguni@kde.org>
// (c) 1998-1999 Harri Porten <porten@kde.org>
//
// derived from Jay Painters "ezppp"
//
//---------------------------------------------------------------------------
//
//  $Id$
//
//---------------------------------------------------------------------------
//
//  This program is free software; you can redistribute it and-or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Library General Public License for more details.
//
//  You should have received a copy of the GNU Library General Public
//  License along with this program; if not, write to the Free
//  Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
//---------------------------------------------------------------------------


#include <tqcombobox.h>
#include <tqlabel.h>
#include <kurllabel.h>
#include <tqlayout.h>
#include <tqlistview.h>
#include <tqdir.h>
#include <tqregexp.h>
#include <tqwmatrix.h>
#include <tqcheckbox.h>
#include <kdialog.h>
#include <kstandarddirs.h>
#include <tdelocale.h>
#include <kiconloader.h>
#include <krun.h>

#include "acctselect.h"
#include "pppdata.h"


AccountingSelector::AccountingSelector(TQWidget *parent, bool _isnewaccount, const char *name)
  :  TQWidget(parent, name),
    isnewaccount(_isnewaccount)
{
  TQVBoxLayout *l1 = new TQVBoxLayout(parent, 0, KDialog::spacingHint());

  enable_accounting = new TQCheckBox(i18n("&Enable accounting"), parent);
  l1->addWidget(enable_accounting, 1);
  connect(enable_accounting, TQ_SIGNAL(toggled(bool)), this, TQ_SLOT(enableItems(bool)));

  // insert the tree widget
  tl = new TQListView(parent, "treewidget");

  connect(tl, TQ_SIGNAL(selectionChanged(TQListViewItem*)), this,
          TQ_SLOT(slotSelectionChanged(TQListViewItem*)));
  tl->setMinimumSize(220, 200);
  l1->addWidget(tl, 1);

  KURLLabel *up = new KURLLabel(parent);
  up->setText(i18n("Check for rule updates"));
  up->setURL("http://developer.kde.org/~kppp/rules.html");
  connect(up, TQ_SIGNAL(leftClickedURL(const TQString&)), TQ_SLOT(openURL(const TQString&)));

  l1->addWidget(up, 1);

  // label to display the currently selected ruleset
  TQHBoxLayout *l11 = new TQHBoxLayout;
  l1->addSpacing(10);
  l1->addLayout(l11);
  TQLabel *lsel = new TQLabel(i18n("Selected:"), parent);
  selected = new TQLabel(parent);
  selected->setFrameStyle(TQFrame::Sunken | TQFrame::WinPanel);
  selected->setLineWidth(1);
  selected->setFixedHeight(selected->sizeHint().height() + 16);
  l11->addWidget(lsel, 0);
  l11->addSpacing(10);
  l11->addWidget(selected, 1);

  // volume accounting
  l1->addStretch(1);
  TQHBoxLayout *l12 = new TQHBoxLayout;
  l1->addLayout(l12);
  TQLabel *usevol_l = new TQLabel(i18n("Volume accounting:"), parent);
  use_vol = new TQComboBox(parent);
  use_vol->insertItem(i18n("No Accounting"), 0);
  use_vol->insertItem(i18n("Bytes In"), 1);
  use_vol->insertItem(i18n("Bytes Out"), 2);
  use_vol->insertItem(i18n("Bytes In & Out"), 3);
  use_vol->setCurrentItem(gpppdata.VolAcctEnabled());
  l12->addWidget(usevol_l);
  l12->addWidget(use_vol);

  // load the pmfolder pixmap from KDEdir
  pmfolder = UserIcon("folder");

  // scale the pixmap
  if(pmfolder.width() > 0) {
    TQWMatrix wm;
    wm.scale(16.0/pmfolder.width(), 16.0/pmfolder.width());
    pmfolder = pmfolder.xForm(wm);
  }

  // load the pmfolder pixmap from KDEdir
  pmfile = UserIcon("phone");

  // scale the pixmap
  if(pmfile.width() > 0) {
    TQWMatrix wm;
    wm.scale(16.0/pmfile.width(), 16.0/pmfile.width());
    pmfile = pmfile.xForm(wm);
  }

  enable_accounting->setChecked(gpppdata.AcctEnabled());

  setupTreeWidget();

  l1->activate();
}


TQString AccountingSelector::fileNameToName(TQString s) {

  s.replace('_', " ");
  return KURL::decode_string(s);

}


TQString AccountingSelector::nameToFileName(TQString s) {

  s.replace(' ', "_");
  return s;

}

TQListViewItem *AccountingSelector::findByName(TQString name)
{
  TQListViewItem *ch = tl->firstChild();
  while(ch) {
    if(ch->text(0) == name)
      return ch;
    ch = ch->nextSibling();
  }
  return 0;
}


void AccountingSelector::insertDir(TQDir d, TQListViewItem *root) {

  TQListViewItem* tli = 0;

  // sanity check
  if(!d.exists() || !d.isReadable())
    return;


  // set up filter
  d.setNameFilter("*.rst");
  d.setFilter(TQDir::Files);
  d.setSorting(TQDir::Name);

  // read the list of files
  const TQFileInfoList *list = d.entryInfoList();
  TQFileInfoListIterator it( *list );
  TQFileInfo *fi;

  // traverse the list and insert into the widget
  while((fi = it.current())) {
    ++it;

    TQString samename = fi->fileName();

    TQListViewItem *i = findByName(samename);

    // skip this file if already in tree
    if(i)
      continue;

    // check if this is the file we should mark
    TQString name = fileNameToName(fi->baseName(true));
    if(root)
      tli = new TQListViewItem(root, name);
    else
      tli = new TQListViewItem(tl, name);

    tli->setPixmap(0, pmfile);

    // check if this is the item we are searching for
    // (only in "Edit"-mode, not in "New"-mode
    if(!isnewaccount && !edit_s.isEmpty() &&
       (edit_s == TQString(fi->filePath()).right(edit_s.length()))) {
      edit_item = tli;
    }
  }

  // set up a filter for the directories
  d.setFilter(TQDir::Dirs);
  d.setNameFilter("*");
  const TQFileInfoList *dlist = d.entryInfoList();
  TQFileInfoListIterator dit(*dlist);

  while((fi = dit.current())) {
    // skip "." and ".." directories
    if(fi->fileName().left(1) != ".") {
      // convert to human-readable name
      TQString name = fileNameToName(fi->fileName());

      // if the tree already has an item with this name,
      // skip creation and use this one, otherwise
      // create a new entry
      TQListViewItem *i = findByName(name);
      if(!i) {
        TQListViewItem* item;

        if(root)
          item = new TQListViewItem(root, name);
        else
          item = new TQListViewItem(tl, name);

        item->setPixmap(0, pmfolder);

	insertDir(TQDir(fi->filePath()), item);
      } else
	insertDir(TQDir(fi->filePath()), i);
    }
    ++dit;
  }
}


void AccountingSelector::setupTreeWidget() {
  // search the item
  edit_item = 0;
  if(!isnewaccount) {
    edit_s = gpppdata.accountingFile();
  }
  else
    edit_s = "";

  tl->addColumn( i18n("Available Rules") );
  tl->setColumnWidth(0, 205);
  tl->setRootIsDecorated(true);

  // look in ~/.trinity/share/apps/kppp/Rules and $TDEDIR/share/apps/kppp/Rules
  TQStringList dirs = TDEGlobal::dirs()->resourceDirs("appdata");
  for (TQStringList::ConstIterator it = dirs.begin();
       it != dirs.end(); it++) {
    insertDir(TQDir((*it) + "Rules"), 0);
  }

  // when mode is "Edit", then hightlight the
  // appropriate item
  if(!isnewaccount && edit_item) {
    tl->setSelected(edit_item, true);
    tl->setOpen(edit_item->parent(), true);
    tl->ensureItemVisible(edit_item);
  }

  enableItems(enable_accounting->isChecked());
}


void AccountingSelector::enableItems(bool enabled) {

  tl->setEnabled(enabled);

  if(!enabled || (!tl->currentItem()))
    selected->setText(i18n("(none)"));
  else {
    TQListViewItem* i = tl->currentItem();
    TQString s;
    while(i) {
      s = "/" + i->text(0) + s;
      i = i->parent();
    }
    selected->setText(s.mid(1));

    s += ".rst";
    edit_s = nameToFileName(s);
  }
}


void AccountingSelector::slotSelectionChanged(TQListViewItem* i) {

  if(!i || i->childCount())
    return;

  if(!enable_accounting->isChecked())
    return;

  enableItems(true);
}


bool AccountingSelector::save() {

  if(enable_accounting->isChecked()) {
    gpppdata.setAccountingFile(edit_s);
    gpppdata.setAcctEnabled(true);
  } else {
    gpppdata.setAccountingFile("");
    gpppdata.setAcctEnabled(false);
  }

  gpppdata.setVolAcctEnabled(use_vol->currentItem());

  return true;
}

void AccountingSelector::openURL(const TQString &url) {
  new KRun( KURL( url ) );
}

#include "acctselect.moc"

