/***************************************************************************
 *   This file is part of TDevelop                                         *
 *   Copyright (C) 2007 The KDevelop Authors <kdevelop-devel@kdevelop.org>                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/

#include "commitdlg.h"
#include <tqevent.h>
#include <ktextedit.h>

CommitDlg::CommitDlg( TQWidget* parent )
    : CommitDlgBase( parent )
{
    textMessage->installEventFilter(this);
}

bool CommitDlg::eventFilter( TQObject* obj, TQEvent* ev )
{
    if( ev->type() == TQEvent::KeyPress )
    {
        TQKeyEvent* k = static_cast<TQKeyEvent*>(ev);
        if( ( k->key() == TQt::Key_Return || k->key() == TQt::Key_Enter ) && k->state() == TQt::ControlButton )
        {
            accept();
            return true;
        }
    }
    return false;
}

#include "commitdlg.moc"
