%{CPP_TEMPLATE}

#include <stdlib.h>
#include <tqcheckbox.h>
#include <tqcolor.h>
#include <tdeapplication.h>
#include <tdelocale.h>
#include <kpushbutton.h>
#include <tdeconfig.h>
#include <tdeglobal.h>
#include "%{APPNAMELC}.h"
#include "%{APPNAMELC}ui.h"

//! libtdescreensaver interface
extern "C"
{
    const char *kss_applicationName = "%{APPNAMELC}.kss";
    const char *kss_description = I18N_NOOP( "%{APPNAME}" );
    const char *kss_version = "2.2.0";

    %{APPNAME} *kss_create( WId id )
    {
        TDEGlobal::locale()->insertCatalogue("%{APPNAMELC}");
        return new %{APPNAME}( id );
    }

    TQDialog *kss_setup()
    {
        TDEGlobal::locale()->insertCatalogue("%{APPNAMELC}");
        return new %{APPNAME}Setup();
    }
}

//-----------------------------------------------------------------------------
//! dialog to setup screen saver parameters
%{APPNAME}Setup::%{APPNAME}Setup( TQWidget *parent, const char *name )
        : %{APPNAME}UI( parent, name, TRUE )
{
    /// @todo
    //Connect your signals and slots here to configure the screen saver.
    connect( OkayPushButton, TQ_SIGNAL( released() ),
             TQ_SLOT( slotOkPressed() ) );
    connect( CancelPushButton, TQ_SIGNAL( released() ),
             TQ_SLOT( slotCancelPressed() ) );
}


//! read settings from config file
void %{APPNAME}Setup::readSettings()
{
    TDEConfig *config = TDEGlobal::config();
    config->setGroup( "Settings" );
    /// @todo
    // Add your config options here...
    CheckBox1->setChecked(config->readBoolEntry( "somesetting", false ));
}


//! Ok pressed - save settings and exit
void %{APPNAME}Setup::slotOkPressed()
{
    TDEConfig *config = TDEGlobal::config();
    config->setGroup( "Settings" );
    /// @todo
    // Add your config options here.
    config->writeEntry( "somesetting", CheckBox1->isChecked() );
    config->sync();

    accept();
}

void %{APPNAME}Setup::slotCancelPressed()
{
    reject();
}
//-----------------------------------------------------------------------------


%{APPNAME}::%{APPNAME}( WId id ) : KScreenSaver( id )
{
    readSettings();
    blank();
}

%{APPNAME}::~%{APPNAME}()
{}


//! read configuration settings from config file
void %{APPNAME}::readSettings()
{
    TDEConfig *config = TDEGlobal::config();
    config->setGroup( "Settings" );
    /// @todo
    // Add your config options here...
    bool somesetting = config->readBoolEntry( "somesetting", false );
}


void %{APPNAME}::blank()
{
    /// @todo
    //Add your code to render the screen.
    setBackgroundColor( TQColor(black)  );
    //
    erase();
}
