#ifndef TABLEEDITOR_H
#define TABLEEDITOR_H

#include "tableeditor.h"
#include <tqmap.h>

class TQListBoxItem;
class TQTable;
class FormWindow;

class TableEditor : public TableEditorBase
{
    TQ_OBJECT
  

public:
    TableEditor( TQWidget* parent = 0, TQWidget *editWidget = 0, FormWindow *fw = 0,
		 const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~TableEditor();

protected slots:
    void columnDownClicked();
    void columnTextChanged( const TQString & );
    void columnUpClicked();
    void currentColumnChanged( TQListBoxItem * );
    void currentFieldChanged( const TQString & );
    void currentRowChanged( TQListBoxItem * );
    void deleteColumnClicked();
    void deleteRowClicked();
    void newColumnClicked();
    void newRowClicked();
    void okClicked();
    void rowDownClicked();
    void rowTextChanged( const TQString & );
    void rowUpClicked();
    void applyClicked();
    void chooseRowPixmapClicked();
    void deleteRowPixmapClicked();
    void chooseColPixmapClicked();
    void deleteColPixmapClicked();

private:
    void readFromTable();
    void readColumns();
    void readRows();
    void saveFieldMap();
    void restoreFieldMap();

private:
    TQTable *editTable;
    FormWindow *formWindow;
    TQMap<int, TQString> fieldMap;
    TQMap<TQListBoxItem*, TQString> tmpFieldMap;

};

#endif // TABLEEDITOR_H
