/*

    Copyright (C) 1999 Stefan Westerfeld
                       stefan@space.twc.de
                  2003 Arnold Krille
                       arnold@arnoldarts.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    */

#include "audiomanager.h"
#include "choosebusdlg.h"

#include <tqtimer.h>
#include <tqlayout.h>

#include <tdelocale.h>
#include <tdelistview.h>
#include <kiconloader.h>

using namespace std;

/*
 * as this is an 1:1 port of an old arts-0.3.4.1 artsbuilable visual widget,
 * you'll see some porting artefacts, and it's not elegance itself ;)
 */
Gui_AUDIO_MANAGER::Gui_AUDIO_MANAGER( TQWidget* parent, const char* name ) : Template_ArtsView( parent,name )
{
	this->setCaption( i18n( "Audio Manager" ) );
	this->setIcon( MainBarIcon( "artsaudiomanager", 32 ) );
	//printf("constructor\n");
	ParentWidget = 0;
	listview = 0;
	inDialog = false;
	proxy = new GuiAudioManagerProxy(this);

	AudioManager = Arts::Reference("global:Arts_AudioManager");
	changes = AudioManager.changes()-1;
	setParent(this,0);
	tick();
	show();

	TQTimer *updatetimer = new TQTimer(this);
	updatetimer->start(500);
	TQObject::connect(updatetimer,TQ_SIGNAL(timeout()),this,TQ_SLOT(tick()));
}

Gui_AUDIO_MANAGER::~Gui_AUDIO_MANAGER()
{
	if(listview) delete listview;
	delete proxy;
}

#if 0
void Gui_AUDIO_MANAGER::widgetDestroyed(TQWidget *widget)
{
	assert(widget == listview);
	listview = 0;
}
#endif

void Gui_AUDIO_MANAGER::setParent(TQWidget *parent, TQBoxLayout * /*layout*/)
{
/************************************************************************
 * From Gui_INSTRUMENT_MAPPER:
 *
 * I am still not sure wether this kind of putting yourself into a parent
 * widget (with own layout etc.) is a good idea (there may not even be
 * a singe call to setParent, because there is no parent).
 *
 * But the "how to write aRts widgets"-stuff will need some experiments,
 * so lets try that method...
 *
 * ----
 *
 * But perhaps here (since only one widget Listview is used) something
 * else would be appropriate. Check that. FIXME
 ************************************************************************/

	TQVBoxLayout *mainlayout = new TQVBoxLayout(parent);
	/*TQHBoxLayout *contentslayout = new TQHBoxLayout;*/

// list

	listview = new TDEListView(parent);

	listview->addColumn(i18n("Title"),175);
	listview->addColumn(i18n("Type"),50);
	listview->addColumn(i18n("Bus"),75);

	listview->setMinimumSize(300,100);

	TQObject::connect(listview,TQ_SIGNAL(executed(TQListViewItem *)),proxy,
								TQ_SLOT(edit(TQListViewItem *)));

	mainlayout->addWidget(listview);

	mainlayout->activate();
	//mainlayout->freeze();
	ParentWidget = parent;
}

void Gui_AUDIO_MANAGER::tick()
{
	unsigned long newChanges = AudioManager.changes();
	if(inDialog) return;
	if(changes == newChanges) return;

	changes = newChanges;

	listview->clear();
	vector<Arts::AudioManagerInfo> *acs = AudioManager.clients();

	unsigned long c;
	for(c=0;c<acs->size();c++)
	{
		//char status[2][10] = {"init","running"};
		TQString description = TQString::fromUtf8( (*acs)[c].title.c_str() );
		TQString type;
		if((*acs)[c].direction == Arts::amPlay)
			type = i18n("play");
		else
			type = i18n("record");
		TQString destination = TQString::fromUtf8( (*acs)[c].destination.c_str() );
		long ID = (*acs)[c].ID;

		(void)new AudioManagerItem(listview, description, type, destination, ID);
	}
	delete acs;
	//Widget->show();
}

void Gui_AUDIO_MANAGER::edit(TQListViewItem *item)
{
	AudioManagerItem *ai = (AudioManagerItem *)item;
	ChooseBusDlg *cd = new ChooseBusDlg(0);
	assert(cd);

	inDialog = true;
	int accept = cd->exec();
	inDialog = false;

	if( accept == TQDialog::Accepted )
	{
		TQString result = cd->result();
		if(!result.isNull())
		{
			//lukas: I hope UTF-8 is OK here...
			AudioManager.setDestination(ai->ID(),result.utf8().data());
			// refresh:
			changes = 0;
			tick();
		}
	}
	delete cd;
}

GuiAudioManagerProxy::GuiAudioManagerProxy(Gui_AUDIO_MANAGER *gim)
{
	this->gim = gim;
}

void GuiAudioManagerProxy::edit(TQListViewItem *item)
{
	gim->edit(item);
}

AudioManagerItem::AudioManagerItem(TQListView *parent, TQString a,
         TQString b, TQString c, long ID) :TQListViewItem(parent,a,b,c)
{
	_ID = ID;
}

long AudioManagerItem::ID()
{
	return _ID;
}

AudioManagerItem::~AudioManagerItem()
{
	//
}
#include "audiomanager.moc"
