/* This file is part of the KDE project
   Copyright (C) 2000 David Faure <faure@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include "kshellcmdplugin.h"
#include <kinputdialog.h>
#include <tdemessagebox.h>
#include <konq_dirpart.h>
#include <kprocess.h>
#include <tdeapplication.h>
#include "kshellcmddialog.h"
#include <kgenericfactory.h>
#include <tdeio/netaccess.h>

KShellCmdPlugin::KShellCmdPlugin( TQObject* parent, const char* name,
	                          const TQStringList & )
    : KParts::Plugin( parent, name )
{
    if (!kapp->authorize("shell_access"))
       return;

    new TDEAction( i18n( "&Execute Shell Command..." ), "system-run", CTRL+Key_E, this,
                 TQT_SLOT( slotExecuteShellCommand() ), actionCollection(), "executeshellcommand" );
}

void KShellCmdPlugin::slotExecuteShellCommand()
{
   KonqDirPart * part = tqt_dynamic_cast<KonqDirPart *>(parent());
   if ( !part )
   {
      KMessageBox::sorry(0L, "KShellCmdPlugin::slotExecuteShellCommand: Program error, please report a bug.");
      return;
   }
   KURL url = TDEIO::NetAccess::mostLocalURL(part->url(),NULL);
   if ( !url.isLocalFile() )
   {
      KMessageBox::sorry(part->widget(),i18n("Executing shell commands works only on local directories."));
      return;
   }
   TQString path;
   if ( part->currentItem() )
   {
      // Putting the complete path to the selected file isn't really necessary,
      // since we'll cd to the directory first. But we do need to get the 
      // complete relative path.
      path = KURL::relativePath( url.path(), 
                                 part->currentItem()->url().path() );
   }
   else
   {
      path = url.path();
   }
   bool ok;
   TQString cmd = KInputDialog::getText( i18n("Execute Shell Command"),
      i18n( "Execute shell command in current directory:" ),
      TDEProcess::quote( path ), &ok, part->widget() );
   if ( ok )
   {
      TQString chDir;
      chDir="cd ";
      chDir+=TDEProcess::quote(part->url().path());
      chDir+="; ";
      chDir+=cmd;

      KShellCommandDialog *shellCmdDialog=new KShellCommandDialog(i18n("Output from command: \"%1\"").arg(cmd),chDir,part->widget(),true);
      shellCmdDialog->resize(500,300);
      shellCmdDialog->executeCommand();
      delete shellCmdDialog;
   }
}

typedef KGenericFactory<KShellCmdPlugin> KonqShellCmdPluginFactory;
K_EXPORT_COMPONENT_FACTORY( konq_shellcmdplugin, KonqShellCmdPluginFactory( "kshellcmdplugin" ) )

#include "kshellcmdplugin.moc"

