#include <tqcombobox.h>
#include <tqframe.h>
#include <tqvgroupbox.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqspinbox.h>
#include <tqstring.h>
#include <tqstringlist.h>

#include <kcolorbutton.h>
#include <kdebug.h>
#include <klineedit.h>
#include <klineeditdlg.h>
#include <tdelistbox.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <kpushbutton.h>
#include <kseparator.h>

#include "group.h"

GroupEditor::GroupEditor(ConfigEstateGroupList *newList, TQWidget *parent)
	: KDialogBase(KDialogBase::Plain, i18n("Group Editor"), Ok|Apply|Cancel, Ok, parent, "Group Editor", false, true), mylist(*newList)
{
	setWFlags(WDestructiveClose);
	list = newList;

	TQFrame *page = plainPage();
	TQHBoxLayout *hlayout = new TQHBoxLayout(page, marginHint(), spacingHint());

	groups = new TDEListBox(page);
	hlayout->addWidget(groups);
	connect(groups, TQT_SIGNAL(highlighted(TQListBoxItem *)), this, TQT_SLOT(updateSettings(TQListBoxItem *)));
	TQStringList newgroups;
	for (ConfigEstateGroupList::Iterator it = list->begin(); it != list->end(); ++it)
		newgroups.append((*it).name());
	groups->insertStringList(newgroups);
	connect(groups, TQT_SIGNAL(selectionChanged()), this, TQT_SLOT(selectionChanged()));

	TQVBoxLayout *vlayout = new TQVBoxLayout(hlayout, spacingHint());
	colorGroupBox = new TQVGroupBox(i18n("&Colors"), page);
	vlayout->addWidget(colorGroupBox);

	(void) new TQLabel(i18n("Foreground:"), colorGroupBox);
	fgButton = new KColorButton(colorGroupBox, "Foreground Button");
	connect(fgButton, TQT_SIGNAL(changed(const TQColor &)), this, TQT_SLOT(fgChanged(const TQColor &)));
	connect(fgButton, TQT_SIGNAL(changed(const TQColor &)), this, TQT_SIGNAL(changed()));

	(void) new TQLabel(i18n("Background:"), colorGroupBox);
	bgButton = new KColorButton(colorGroupBox, "Background Button");
	connect(bgButton, TQT_SIGNAL(changed(const TQColor &)), this, TQT_SLOT(bgChanged(const TQColor &)));
	connect(bgButton, TQT_SIGNAL(changed(const TQColor &)), this, TQT_SIGNAL(changed()));

	pricesGroupBox = new TQVGroupBox(i18n("&Prices"), page);
	vlayout->addWidget(pricesGroupBox);

	pricesWidget = new TQWidget(pricesGroupBox);
	TQGridLayout *pricesLayout = new TQGridLayout(pricesWidget, 2, 2, 0, spacingHint());
	pricesLayout->addWidget(new TQLabel(i18n("House price:"), pricesWidget), 0, 0);
	pricesLayout->addWidget(housePrice = new TQSpinBox(0, 3000, 25, pricesWidget), 0, 1);
	housePrice->setSpecialValueText(i18n("None"));
	housePrice->setSuffix(i18n("$"));
	connect(housePrice, TQT_SIGNAL(valueChanged(int)), this, TQT_SLOT(housePriceChanged(int)));

	pricesLayout->addWidget(new TQLabel(i18n("Global price:"), pricesWidget), 1, 0);
	pricesLayout->addWidget(globalPrice = new TQSpinBox(0, 3000, 25, pricesWidget), 1, 1);
	globalPrice->setSpecialValueText(i18n("None"));
	globalPrice->setSuffix(i18n("$"));
	connect(globalPrice, TQT_SIGNAL(valueChanged(int)), this, TQT_SLOT(globalPriceChanged(int)));

	dynamicGroupBox = new TQVGroupBox(i18n("&Dynamic Rent"), page);
	vlayout->addWidget(dynamicGroupBox);

	mathWidget = new TQWidget(dynamicGroupBox);
	TQGridLayout *mathLayout = new TQGridLayout(mathWidget, 2, 2, 0, spacingHint());
	mathLayout->addWidget(new TQLabel(i18n("Add rent variable:"), mathWidget), 0, 0);
	mathLayout->addWidget(new TQLabel(i18n("Expression:"), mathWidget), 1, 0);

	TQComboBox *rentVarCombo = new TQComboBox(mathWidget);
	TQStringList vars;
	vars << "DICE";
	vars << "HOUSES";
	vars << "GROUPOWNED";
	rentVarCombo->insertStringList(vars);
	mathLayout->addWidget(rentVarCombo, 0, 1);

	rentMathEdit = new KLineEdit(mathWidget);
	connect(rentMathEdit, TQT_SIGNAL(textChanged(const TQString &)), this, TQT_SLOT(rentMathChanged(const TQString &)));
	connect(rentVarCombo, TQT_SIGNAL(activated(const TQString &)), rentMathEdit, TQT_SLOT(insert(const TQString &)));
	mathLayout->addWidget(rentMathEdit, 1, 1);

	TQHBoxLayout *buttonlayout = new TQHBoxLayout(vlayout, spacingHint());
	KPushButton *addB = new KPushButton(i18n("&Add..."), page);
	buttonlayout->addWidget(addB);
	connect(addB, TQT_SIGNAL(clicked()), this, TQT_SLOT(add()));

	removeB = new KPushButton(i18n("&Remove"), page);
	buttonlayout->addWidget(removeB);
	connect(removeB, TQT_SIGNAL(clicked()), this, TQT_SLOT(remove()));

	selectionChanged();
}

void GroupEditor::add()
{
	bool ok;
	TQString name = KLineEditDlg::getText(i18n("Add Group"), i18n("Enter the name of the new group:"), TQString(), &ok, this);
	if (ok)
	{
		for (ConfigEstateGroupList::Iterator it =  mylist.begin(); it != mylist.end(); ++it)
		{
			if ((*it).name() == name)
			{
				KMessageBox::information(this, i18n("That group is already on the list."));
				return;
			}
		}

		mylist.append(ConfigEstateGroup(name));
		groups->insertItem(name);

		emit changed();
	}
}

void GroupEditor::remove()
{
	TQString curText = groups->currentText();
	if (!curText.isNull())
	{
		groups->removeItem(groups->currentItem());
		for (ConfigEstateGroupList::Iterator it =  mylist.begin(); it != mylist.end(); ++it)
		{
			if ((*it).name() == curText)
			{
				mylist.remove(it);
				break;
			}
		}

		emit changed();
	}
}

void GroupEditor::updateSettings(TQListBoxItem *item)
{
	if (!mylist.size())
		return;

	if (!item)
		return;

	for (ConfigEstateGroupList::Iterator it =  mylist.begin(); it != mylist.end() ; ++it)
	{
		if ((*it).name() == item->text())
		{
			fgButton->setColor((*it).fgColor());
			bgButton->setColor((*it).bgColor());
			housePrice->setValue((*it).housePrice());
			globalPrice->setValue((*it).globalPrice());
			rentMathEdit->setText((*it).rentMath());
			break;
		}
	}
}

ConfigEstateGroup *GroupEditor::currentGroup()
{
	TQListBoxItem *item = groups->item(groups->currentItem());
	if (!item)
		return 0;

	for (ConfigEstateGroupList::Iterator it =  mylist.begin(); it != mylist.end(); ++it)
		if ((*it).name() == item->text())
			return &(*it);

	return 0;
}

void GroupEditor::fgChanged(const TQColor &color)
{
	ConfigEstateGroup *group = currentGroup();
	if (group)
		group->setFgColor(color);
}

void GroupEditor::bgChanged(const TQColor &color)
{
	ConfigEstateGroup *group = currentGroup();
	if (group)
		group->setBgColor(color);
}

void GroupEditor::housePriceChanged(int newValue)
{
	ConfigEstateGroup *group = currentGroup();
	if (group)
		group->setHousePrice(newValue);
}

void GroupEditor::globalPriceChanged(int newValue)
{
	ConfigEstateGroup *group = currentGroup();
	if (group)
		group->setGlobalPrice(newValue);
}

void GroupEditor::rentMathChanged(const TQString &newValue)
{
	ConfigEstateGroup *group = currentGroup();
	if (group)
	{
		group->setRentMath(newValue);
	}
}

void GroupEditor::slotApply()
{
	*list = mylist;

	KDialogBase::slotApply();

	emit update();
}

void GroupEditor::slotOk()
{
	slotApply();

	KDialogBase::slotOk();
}

void GroupEditor::selectionChanged()
{
	bool issel = groups->currentItem() >= 0;
	colorGroupBox->setEnabled(issel);
	pricesGroupBox->setEnabled(issel);
	dynamicGroupBox->setEnabled(issel);
	removeB->setEnabled(issel);
}

#include "group.moc"
